#include <xdkwrl/nodes/nurbsgroup.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of NurbsGroup
//************************************************************
/*! \class wrl::NurbsGroup
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude nurbsgroup.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  tessellationScale = 1.0f;
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  \endcode
  */
wrl::NurbsGroup::NurbsGroup(const char* name)
 : Node(name)
{

  tessellationScale = 1.0f;
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::NurbsGroup::~NurbsGroup()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - children
 *  - tessellationScale
 *  - bboxCenter
 *  - bboxSize
 */
wrl::Node::FieldHandle
wrl::NurbsGroup::field(const std::string& n)
{
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  if(n==std::string("tessellationScale"))
  {
    return Node::field(n,sfFloat,(void*) &tessellationScale);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children
 *  - 1 : tessellationScale
 *  - 2 : bboxCenter
 *  - 3 : bboxSize
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::NurbsGroup::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("children",mfNode,&children);
  case 1: return Node::field("tessellationScale",sfFloat,&tessellationScale);
  case 2: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 3: return Node::field("bboxSize",sfVec3f,&bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addChildren
 *  - removeChildren
 *  - set_children
 *  - set_tessellationScale
 */
wrl::Node::EventInHandle
wrl::NurbsGroup::eventIn(const std::string& n)
{
  if(n==std::string("addChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &addChildren);
  }
  if(n==std::string("removeChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeChildren);
  }
  if(n==std::string("set_children"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_children);
  }
  if(n==std::string("set_tessellationScale"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_tessellationScale);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addChildren
 *  - 1 : removeChildren
 *  - 2 : set_children
 *  - 3 : set_tessellationScale

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::NurbsGroup::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addChildren",mfNode,&addChildren);
  case 1: return Node::eventIn("removeChildren",mfNode,&removeChildren);
  case 2: return Node::eventIn("set_children",mfNode,&set_children);
  case 3: return Node::eventIn("set_tessellationScale",sfFloat,&set_tessellationScale);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - children_changed
 *  - tessellationScale_changed
 */
wrl::Node::EventOutHandle
wrl::NurbsGroup::eventOut(const std::string& n)
{
  if(n==std::string("children_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &children_changed);
  }
  if(n==std::string("tessellationScale_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &tessellationScale_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children_changed
 *  - 1 : tessellationScale_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::NurbsGroup::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("children_changed",mfNode,&children_changed);
  case 1: return Node::eventOut("tessellationScale_changed",sfFloat,&tessellationScale_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::NurbsGroup::duplicate() const
{
  NurbsGroup* n = new NurbsGroup(name());
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  n->tessellationScale = tessellationScale;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
wrl::Node* 
wrl::NurbsGroup::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  NurbsGroup* n = new NurbsGroup(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->tessellationScale = tessellationScale;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
bool
wrl::NurbsGroup::isSetToDefaultValue(unsigned int i) const
{

  static const SFFloat tessellationScaleDV_(1.0f);
  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  switch (i)
  {
  case 0: return children == MFNode();
  case 1: return tessellationScale == tessellationScaleDV_;
  case 2: return bboxCenter == bboxCenterDV_;
  case 3: return bboxSize == bboxSizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
