#include <xdkwrl/nodes/normal.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Normal
//************************************************************
/*! \class wrl::Normal
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude normal.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::Normal::Normal(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::Normal::~Normal()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - vector
 */
wrl::Node::FieldHandle
wrl::Normal::field(const std::string& n)
{
  if(n==std::string("vector"))
  {
    return Node::field(n,mfVec3f,(void*) &vector);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : vector
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Normal::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("vector",mfVec3f,&vector);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_vector
 */
wrl::Node::EventInHandle
wrl::Normal::eventIn(const std::string& n)
{
  if(n==std::string("set_vector"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_vector);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Normal::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_vector",mfVec3f,&set_vector);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - vector_changed
 */
wrl::Node::EventOutHandle
wrl::Normal::eventOut(const std::string& n)
{
  if(n==std::string("vector_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &vector_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : vector_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Normal::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("vector_changed",mfVec3f,&vector_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Normal::duplicate() const
{
  Normal* n = new Normal(name());
  n->vector = vector;
  return n;
}
wrl::Node* 
wrl::Normal::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Normal* n = new Normal(name());
  nodeMap[this] = n;  n->vector = vector;
  return n;
}
bool
wrl::Normal::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return vector == MFVec3f();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
