#include <xdkwrl/nodes/navigationinfo.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of NavigationInfo
//************************************************************
/*! \class wrl::NavigationInfo
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude navigationinfo.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
      avatarSize.push_back(SFFloat(0.25f));
    avatarSize.push_back(SFFloat(1.6f));
    avatarSize.push_back(SFFloat(0.75f));
  headlight = true;
  speed = 1.0f;
  
  visibilityLimit = 0.0f;
  \endcode
  */
wrl::NavigationInfo::NavigationInfo(const char* name)
 : Node(name)
{
      avatarSize.push_back(SFFloat(0.25f));
    avatarSize.push_back(SFFloat(1.6f));
    avatarSize.push_back(SFFloat(0.75f));
  headlight = true;
  speed = 1.0f;
  
  visibilityLimit = 0.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::NavigationInfo::~NavigationInfo()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - avatarSize
 *  - headlight
 *  - speed
 *  - type
 *  - visibilityLimit
 */
wrl::Node::FieldHandle
wrl::NavigationInfo::field(const std::string& n)
{
  if(n==std::string("avatarSize"))
  {
    return Node::field(n,mfFloat,(void*) &avatarSize);
  }
  if(n==std::string("headlight"))
  {
    return Node::field(n,sfBool,(void*) &headlight);
  }
  if(n==std::string("speed"))
  {
    return Node::field(n,sfFloat,(void*) &speed);
  }
  if(n==std::string("type"))
  {
    return Node::field(n,mfString,(void*) &type);
  }
  if(n==std::string("visibilityLimit"))
  {
    return Node::field(n,sfFloat,(void*) &visibilityLimit);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : avatarSize
 *  - 1 : headlight
 *  - 2 : speed
 *  - 3 : type
 *  - 4 : visibilityLimit
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::NavigationInfo::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("avatarSize",mfFloat,&avatarSize);
  case 1: return Node::field("headlight",sfBool,&headlight);
  case 2: return Node::field("speed",sfFloat,&speed);
  case 3: return Node::field("type",mfString,&type);
  case 4: return Node::field("visibilityLimit",sfFloat,&visibilityLimit);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_bind
 *  - set_avatarSize
 *  - set_headlight
 *  - set_speed
 *  - set_type
 *  - set_visibilityLimit
 */
wrl::Node::EventInHandle
wrl::NavigationInfo::eventIn(const std::string& n)
{
  if(n==std::string("set_bind"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_bind);
  }
  if(n==std::string("set_avatarSize"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_avatarSize);
  }
  if(n==std::string("set_headlight"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_headlight);
  }
  if(n==std::string("set_speed"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_speed);
  }
  if(n==std::string("set_type"))
  {
    return Node::eventIn(n,mfString,(void*) &set_type);
  }
  if(n==std::string("set_visibilityLimit"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_visibilityLimit);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_bind
 *  - 1 : set_avatarSize
 *  - 2 : set_headlight
 *  - 3 : set_speed
 *  - 4 : set_type
 *  - 5 : set_visibilityLimit

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::NavigationInfo::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_bind",sfBool,&set_bind);
  case 1: return Node::eventIn("set_avatarSize",mfFloat,&set_avatarSize);
  case 2: return Node::eventIn("set_headlight",sfBool,&set_headlight);
  case 3: return Node::eventIn("set_speed",sfFloat,&set_speed);
  case 4: return Node::eventIn("set_type",mfString,&set_type);
  case 5: return Node::eventIn("set_visibilityLimit",sfFloat,&set_visibilityLimit);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - isBound
 *  - avatarSize_changed
 *  - headlight_changed
 *  - speed_changed
 *  - type_changed
 *  - visibilityLimit_changed
 */
wrl::Node::EventOutHandle
wrl::NavigationInfo::eventOut(const std::string& n)
{
  if(n==std::string("isBound"))
  {
    return Node::eventOut(n,sfBool,(void*) &isBound);
  }
  if(n==std::string("avatarSize_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &avatarSize_changed);
  }
  if(n==std::string("headlight_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &headlight_changed);
  }
  if(n==std::string("speed_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &speed_changed);
  }
  if(n==std::string("type_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &type_changed);
  }
  if(n==std::string("visibilityLimit_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &visibilityLimit_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : isBound
 *  - 1 : avatarSize_changed
 *  - 2 : headlight_changed
 *  - 3 : speed_changed
 *  - 4 : type_changed
 *  - 5 : visibilityLimit_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::NavigationInfo::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("isBound",sfBool,&isBound);
  case 1: return Node::eventOut("avatarSize_changed",mfFloat,&avatarSize_changed);
  case 2: return Node::eventOut("headlight_changed",sfBool,&headlight_changed);
  case 3: return Node::eventOut("speed_changed",sfFloat,&speed_changed);
  case 4: return Node::eventOut("type_changed",mfString,&type_changed);
  case 5: return Node::eventOut("visibilityLimit_changed",sfFloat,&visibilityLimit_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::NavigationInfo::duplicate() const
{
  NavigationInfo* n = new NavigationInfo(name());
  n->avatarSize = avatarSize;
  n->headlight = headlight;
  n->speed = speed;
  n->type = type;
  n->visibilityLimit = visibilityLimit;
  return n;
}
wrl::Node* 
wrl::NavigationInfo::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  NavigationInfo* n = new NavigationInfo(name());
  nodeMap[this] = n;  n->avatarSize = avatarSize;
  n->headlight = headlight;
  n->speed = speed;
  n->type = type;
  n->visibilityLimit = visibilityLimit;
  return n;
}
bool
wrl::NavigationInfo::isSetToDefaultValue(unsigned int i) const
{
  static MFFloat avatarSizeDV_;
  if (avatarSizeDV_.empty())
  {
    avatarSizeDV_.push_back(SFFloat(0.25f));
    avatarSizeDV_.push_back(SFFloat(1.6f));
    avatarSizeDV_.push_back(SFFloat(0.75f));
  }
  static const SFBool headlightDV_(true);
  static const SFFloat speedDV_(1.0f);
  static MFString typeDV_;
  if (typeDV_.empty())
  {
  }
  static const SFFloat visibilityLimitDV_(0.0f);
  switch (i)
  {
  case 0: return avatarSize == avatarSizeDV_;
  case 1: return headlight == headlightDV_;
  case 2: return speed == speedDV_;
  case 3: return type == typeDV_;
  case 4: return visibilityLimit == visibilityLimitDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
