#include <xdkwrl/nodes/movietexture.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of MovieTexture
//************************************************************
/*! \class wrl::MovieTexture
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude movietexture.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  loop = false;
  speed = 1.0f;
  startTime.setNbSeconds(0);
  stopTime.setNbSeconds(0);
  repeatS = true;
  repeatT = true;
  \endcode
  */
wrl::MovieTexture::MovieTexture(const char* name)
 : Node(name)
{
  loop = false;
  speed = 1.0f;
  startTime.setNbSeconds(0);
  stopTime.setNbSeconds(0);
  repeatS = true;
  repeatT = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::MovieTexture::~MovieTexture()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - loop
 *  - speed
 *  - startTime
 *  - stopTime
 *  - url
 *  - repeatS
 *  - repeatT
 */
wrl::Node::FieldHandle
wrl::MovieTexture::field(const std::string& n)
{
  if(n==std::string("loop"))
  {
    return Node::field(n,sfBool,(void*) &loop);
  }
  if(n==std::string("speed"))
  {
    return Node::field(n,sfFloat,(void*) &speed);
  }
  if(n==std::string("startTime"))
  {
    return Node::field(n,sfTime,(void*) &startTime);
  }
  if(n==std::string("stopTime"))
  {
    return Node::field(n,sfTime,(void*) &stopTime);
  }
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  if(n==std::string("repeatS"))
  {
    return Node::field(n,sfBool,(void*) &repeatS);
  }
  if(n==std::string("repeatT"))
  {
    return Node::field(n,sfBool,(void*) &repeatT);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : loop
 *  - 1 : speed
 *  - 2 : startTime
 *  - 3 : stopTime
 *  - 4 : url
 *  - 5 : repeatS
 *  - 6 : repeatT
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::MovieTexture::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("loop",sfBool,&loop);
  case 1: return Node::field("speed",sfFloat,&speed);
  case 2: return Node::field("startTime",sfTime,&startTime);
  case 3: return Node::field("stopTime",sfTime,&stopTime);
  case 4: return Node::field("url",mfString,&url);
  case 5: return Node::field("repeatS",sfBool,&repeatS);
  case 6: return Node::field("repeatT",sfBool,&repeatT);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_loop
 *  - set_speed
 *  - set_startTime
 *  - set_stopTime
 *  - set_url
 */
wrl::Node::EventInHandle
wrl::MovieTexture::eventIn(const std::string& n)
{
  if(n==std::string("set_loop"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_loop);
  }
  if(n==std::string("set_speed"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_speed);
  }
  if(n==std::string("set_startTime"))
  {
    return Node::eventIn(n,sfTime,(void*) &set_startTime);
  }
  if(n==std::string("set_stopTime"))
  {
    return Node::eventIn(n,sfTime,(void*) &set_stopTime);
  }
  if(n==std::string("set_url"))
  {
    return Node::eventIn(n,mfString,(void*) &set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::MovieTexture::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_loop",sfBool,&set_loop);
  case 1: return Node::eventIn("set_speed",sfFloat,&set_speed);
  case 2: return Node::eventIn("set_startTime",sfTime,&set_startTime);
  case 3: return Node::eventIn("set_stopTime",sfTime,&set_stopTime);
  case 4: return Node::eventIn("set_url",mfString,&set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - duration_changed
 *  - isActive
 *  - loop_changed
 *  - speed_changed
 *  - startTime_changed
 *  - stopTime_changed
 *  - url_changed
 */
wrl::Node::EventOutHandle
wrl::MovieTexture::eventOut(const std::string& n)
{
  if(n==std::string("duration_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &duration_changed);
  }
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("loop_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &loop_changed);
  }
  if(n==std::string("speed_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &speed_changed);
  }
  if(n==std::string("startTime_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &startTime_changed);
  }
  if(n==std::string("stopTime_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &stopTime_changed);
  }
  if(n==std::string("url_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &url_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : duration_changed
 *  - 1 : isActive
 *  - 2 : loop_changed
 *  - 3 : speed_changed
 *  - 4 : startTime_changed
 *  - 5 : stopTime_changed
 *  - 6 : url_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::MovieTexture::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("duration_changed",sfTime,&duration_changed);
  case 1: return Node::eventOut("isActive",sfBool,&isActive);
  case 2: return Node::eventOut("loop_changed",sfBool,&loop_changed);
  case 3: return Node::eventOut("speed_changed",sfFloat,&speed_changed);
  case 4: return Node::eventOut("startTime_changed",sfTime,&startTime_changed);
  case 5: return Node::eventOut("stopTime_changed",sfTime,&stopTime_changed);
  case 6: return Node::eventOut("url_changed",mfString,&url_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::MovieTexture::duplicate() const
{
  MovieTexture* n = new MovieTexture(name());
  n->loop = loop;
  n->speed = speed;
  n->startTime = startTime;
  n->stopTime = stopTime;
  n->url = url;
  n->repeatS = repeatS;
  n->repeatT = repeatT;
  return n;
}
wrl::Node* 
wrl::MovieTexture::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  MovieTexture* n = new MovieTexture(name());
  nodeMap[this] = n;  n->loop = loop;
  n->speed = speed;
  n->startTime = startTime;
  n->stopTime = stopTime;
  n->url = url;
  n->repeatS = repeatS;
  n->repeatT = repeatT;
  return n;
}
bool
wrl::MovieTexture::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool loopDV_(false);
  static const SFFloat speedDV_(1.0f);
  static const SFTime startTimeDV_(0);
  static const SFTime stopTimeDV_(0);
  static const SFBool repeatSDV_(true);
  static const SFBool repeatTDV_(true);
  switch (i)
  {
  case 0: return loop == loopDV_;
  case 1: return speed == speedDV_;
  case 2: return startTime == startTimeDV_;
  case 3: return stopTime == stopTimeDV_;
  case 4: return url == MFString();
  case 5: return repeatS == repeatSDV_;
  case 6: return repeatT == repeatTDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
