#include <xdkwrl/nodes/material.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Material
//************************************************************
/*! \class wrl::Material
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude material.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  ambientIntensity = 0.2f;
  diffuseColor.setRGB(0.8f,0.8f,0.8f);
  emissiveColor.setRGB(0.0f,0.0f,0.0f);
  shininess = 0.2f;
  specularColor.setRGB(0.0f,0.0f,0.0f);
  transparency = 0.0f;
  \endcode
  */
wrl::Material::Material(const char* name)
 : Node(name)
{
  ambientIntensity = 0.2f;
  diffuseColor.setRGB(0.8f,0.8f,0.8f);
  emissiveColor.setRGB(0.0f,0.0f,0.0f);
  shininess = 0.2f;
  specularColor.setRGB(0.0f,0.0f,0.0f);
  transparency = 0.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Material::~Material()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - ambientIntensity
 *  - diffuseColor
 *  - emissiveColor
 *  - shininess
 *  - specularColor
 *  - transparency
 */
wrl::Node::FieldHandle
wrl::Material::field(const std::string& n)
{
  if(n==std::string("ambientIntensity"))
  {
    return Node::field(n,sfFloat,(void*) &ambientIntensity);
  }
  if(n==std::string("diffuseColor"))
  {
    return Node::field(n,sfColor,(void*) &diffuseColor);
  }
  if(n==std::string("emissiveColor"))
  {
    return Node::field(n,sfColor,(void*) &emissiveColor);
  }
  if(n==std::string("shininess"))
  {
    return Node::field(n,sfFloat,(void*) &shininess);
  }
  if(n==std::string("specularColor"))
  {
    return Node::field(n,sfColor,(void*) &specularColor);
  }
  if(n==std::string("transparency"))
  {
    return Node::field(n,sfFloat,(void*) &transparency);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : ambientIntensity
 *  - 1 : diffuseColor
 *  - 2 : emissiveColor
 *  - 3 : shininess
 *  - 4 : specularColor
 *  - 5 : transparency
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Material::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("ambientIntensity",sfFloat,&ambientIntensity);
  case 1: return Node::field("diffuseColor",sfColor,&diffuseColor);
  case 2: return Node::field("emissiveColor",sfColor,&emissiveColor);
  case 3: return Node::field("shininess",sfFloat,&shininess);
  case 4: return Node::field("specularColor",sfColor,&specularColor);
  case 5: return Node::field("transparency",sfFloat,&transparency);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_ambientIntensity
 *  - set_diffuseColor
 *  - set_emissiveColor
 *  - set_shininess
 *  - set_specularColor
 *  - set_transparency
 */
wrl::Node::EventInHandle
wrl::Material::eventIn(const std::string& n)
{
  if(n==std::string("set_ambientIntensity"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_ambientIntensity);
  }
  if(n==std::string("set_diffuseColor"))
  {
    return Node::eventIn(n,sfColor,(void*) &set_diffuseColor);
  }
  if(n==std::string("set_emissiveColor"))
  {
    return Node::eventIn(n,sfColor,(void*) &set_emissiveColor);
  }
  if(n==std::string("set_shininess"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_shininess);
  }
  if(n==std::string("set_specularColor"))
  {
    return Node::eventIn(n,sfColor,(void*) &set_specularColor);
  }
  if(n==std::string("set_transparency"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_transparency);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Material::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_ambientIntensity",sfFloat,&set_ambientIntensity);
  case 1: return Node::eventIn("set_diffuseColor",sfColor,&set_diffuseColor);
  case 2: return Node::eventIn("set_emissiveColor",sfColor,&set_emissiveColor);
  case 3: return Node::eventIn("set_shininess",sfFloat,&set_shininess);
  case 4: return Node::eventIn("set_specularColor",sfColor,&set_specularColor);
  case 5: return Node::eventIn("set_transparency",sfFloat,&set_transparency);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - ambientIntensity_changed
 *  - diffuseColor_changed
 *  - emissiveColor_changed
 *  - shininess_changed
 *  - specularColor_changed
 *  - transparency_changed
 */
wrl::Node::EventOutHandle
wrl::Material::eventOut(const std::string& n)
{
  if(n==std::string("ambientIntensity_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &ambientIntensity_changed);
  }
  if(n==std::string("diffuseColor_changed"))
  {
    return Node::eventOut(n,sfColor,(void*) &diffuseColor_changed);
  }
  if(n==std::string("emissiveColor_changed"))
  {
    return Node::eventOut(n,sfColor,(void*) &emissiveColor_changed);
  }
  if(n==std::string("shininess_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &shininess_changed);
  }
  if(n==std::string("specularColor_changed"))
  {
    return Node::eventOut(n,sfColor,(void*) &specularColor_changed);
  }
  if(n==std::string("transparency_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &transparency_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : ambientIntensity_changed
 *  - 1 : diffuseColor_changed
 *  - 2 : emissiveColor_changed
 *  - 3 : shininess_changed
 *  - 4 : specularColor_changed
 *  - 5 : transparency_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Material::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("ambientIntensity_changed",sfFloat,&ambientIntensity_changed);
  case 1: return Node::eventOut("diffuseColor_changed",sfColor,&diffuseColor_changed);
  case 2: return Node::eventOut("emissiveColor_changed",sfColor,&emissiveColor_changed);
  case 3: return Node::eventOut("shininess_changed",sfFloat,&shininess_changed);
  case 4: return Node::eventOut("specularColor_changed",sfColor,&specularColor_changed);
  case 5: return Node::eventOut("transparency_changed",sfFloat,&transparency_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Material::duplicate() const
{
  Material* n = new Material(name());
  n->ambientIntensity = ambientIntensity;
  n->diffuseColor = diffuseColor;
  n->emissiveColor = emissiveColor;
  n->shininess = shininess;
  n->specularColor = specularColor;
  n->transparency = transparency;
  return n;
}
wrl::Node* 
wrl::Material::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Material* n = new Material(name());
  nodeMap[this] = n;  n->ambientIntensity = ambientIntensity;
  n->diffuseColor = diffuseColor;
  n->emissiveColor = emissiveColor;
  n->shininess = shininess;
  n->specularColor = specularColor;
  n->transparency = transparency;
  return n;
}
bool
wrl::Material::isSetToDefaultValue(unsigned int i) const
{
  static const SFFloat ambientIntensityDV_(0.2f);
  static const SFColor diffuseColorDV_(0.8f,0.8f,0.8f);
  static const SFColor emissiveColorDV_(0.0f,0.0f,0.0f);
  static const SFFloat shininessDV_(0.2f);
  static const SFColor specularColorDV_(0.0f,0.0f,0.0f);
  static const SFFloat transparencyDV_(0.0f);
  switch (i)
  {
  case 0: return ambientIntensity == ambientIntensityDV_;
  case 1: return diffuseColor == diffuseColorDV_;
  case 2: return emissiveColor == emissiveColorDV_;
  case 3: return shininess == shininessDV_;
  case 4: return specularColor == specularColorDV_;
  case 5: return transparency == transparencyDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
