#include <xdkwrl/nodes/lod.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of LOD
//************************************************************
/*! \class wrl::LOD
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude lod.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  center.setXYZ(0.0f,0.0f,0.0f);
  \endcode
  */
wrl::LOD::LOD(const char* name)
 : Node(name)
{

  center.setXYZ(0.0f,0.0f,0.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::LOD::~LOD()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - level
 *  - center
 *  - range
 */
wrl::Node::FieldHandle
wrl::LOD::field(const std::string& n)
{
  if(n==std::string("level"))
  {
    return Node::field(n,mfNode,(void*) &level);
  }
  if(n==std::string("center"))
  {
    return Node::field(n,sfVec3f,(void*) &center);
  }
  if(n==std::string("range"))
  {
    return Node::field(n,mfFloat,(void*) &range);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : level
 *  - 1 : center
 *  - 2 : range
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::LOD::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("level",mfNode,&level);
  case 1: return Node::field("center",sfVec3f,&center);
  case 2: return Node::field("range",mfFloat,&range);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_level
 */
wrl::Node::EventInHandle
wrl::LOD::eventIn(const std::string& n)
{
  if(n==std::string("set_level"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_level);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::LOD::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_level",mfNode,&set_level);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - level_changed
 */
wrl::Node::EventOutHandle
wrl::LOD::eventOut(const std::string& n)
{
  if(n==std::string("level_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &level_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : level_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::LOD::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("level_changed",mfNode,&level_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::LOD::duplicate() const
{
  LOD* n = new LOD(name());
  for (MFNode::const_iterator iter = level.begin();
       iter != level.end();++iter)
  {
     n->level.push_back(SFNode((*iter)->duplicate()));
  }
  n->center = center;
  n->range = range;
  return n;
}
wrl::Node* 
wrl::LOD::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  LOD* n = new LOD(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = level.begin();
       iter != level.end();++iter)
  {
     n->level.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->center = center;
  n->range = range;
  return n;
}
bool
wrl::LOD::isSetToDefaultValue(unsigned int i) const
{

  static const SFVec3f centerDV_(0.0f,0.0f,0.0f);
  switch (i)
  {
  case 0: return level == MFNode();
  case 1: return center == centerDV_;
  case 2: return range == MFFloat();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
