#include <xdkwrl/nodes/inlineloadcontrol.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of InlineLoadControl
//************************************************************
/*! \class wrl::InlineLoadControl
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude inlineloadcontrol.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  load = true;
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  \endcode
  */
wrl::InlineLoadControl::InlineLoadControl(const char* name)
 : Node(name)
{
  load = true;
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::InlineLoadControl::~InlineLoadControl()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - load
 *  - url
 *  - bboxCenter
 *  - bboxSize
 */
wrl::Node::FieldHandle
wrl::InlineLoadControl::field(const std::string& n)
{
  if(n==std::string("load"))
  {
    return Node::field(n,sfBool,(void*) &load);
  }
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : load
 *  - 1 : url
 *  - 2 : bboxCenter
 *  - 3 : bboxSize
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::InlineLoadControl::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("load",sfBool,&load);
  case 1: return Node::field("url",mfString,&url);
  case 2: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 3: return Node::field("bboxSize",sfVec3f,&bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_load
 *  - set_url
 */
wrl::Node::EventInHandle
wrl::InlineLoadControl::eventIn(const std::string& n)
{
  if(n==std::string("set_load"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_load);
  }
  if(n==std::string("set_url"))
  {
    return Node::eventIn(n,mfString,(void*) &set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::InlineLoadControl::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_load",sfBool,&set_load);
  case 1: return Node::eventIn("set_url",mfString,&set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - children
 *  - load_changed
 *  - url_changed
 */
wrl::Node::EventOutHandle
wrl::InlineLoadControl::eventOut(const std::string& n)
{
  if(n==std::string("children"))
  {
    return Node::eventOut(n,mfNode,(void*) &children);
  }
  if(n==std::string("load_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &load_changed);
  }
  if(n==std::string("url_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &url_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children
 *  - 1 : load_changed
 *  - 2 : url_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::InlineLoadControl::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("children",mfNode,&children);
  case 1: return Node::eventOut("load_changed",sfBool,&load_changed);
  case 2: return Node::eventOut("url_changed",mfString,&url_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::InlineLoadControl::duplicate() const
{
  InlineLoadControl* n = new InlineLoadControl(name());
  n->load = load;
  n->url = url;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
wrl::Node* 
wrl::InlineLoadControl::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  InlineLoadControl* n = new InlineLoadControl(name());
  nodeMap[this] = n;  n->load = load;
  n->url = url;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
bool
wrl::InlineLoadControl::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool loadDV_(true);
  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  switch (i)
  {
  case 0: return load == loadDV_;
  case 1: return url == MFString();
  case 2: return bboxCenter == bboxCenterDV_;
  case 3: return bboxSize == bboxSizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
