#include <xdkwrl/nodes/indexedlineset.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of IndexedLineSet
//************************************************************
/*! \class wrl::IndexedLineSet
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude indexedlineset.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  colorPerVertex = true;
  \endcode
  */
wrl::IndexedLineSet::IndexedLineSet(const char* name)
 : Node(name)
{

  colorPerVertex = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::IndexedLineSet::~IndexedLineSet()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - color
 *  - coord
 *  - colorIndex
 *  - colorPerVertex
 *  - coordIndex
 */
wrl::Node::FieldHandle
wrl::IndexedLineSet::field(const std::string& n)
{
  if(n==std::string("color"))
  {
    return Node::field(n,sfNode,(void*) &color);
  }
  if(n==std::string("coord"))
  {
    return Node::field(n,sfNode,(void*) &coord);
  }
  if(n==std::string("colorIndex"))
  {
    return Node::field(n,mfInt32,(void*) &colorIndex);
  }
  if(n==std::string("colorPerVertex"))
  {
    return Node::field(n,sfBool,(void*) &colorPerVertex);
  }
  if(n==std::string("coordIndex"))
  {
    return Node::field(n,mfInt32,(void*) &coordIndex);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color
 *  - 1 : coord
 *  - 2 : colorIndex
 *  - 3 : colorPerVertex
 *  - 4 : coordIndex
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::IndexedLineSet::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("color",sfNode,&color);
  case 1: return Node::field("coord",sfNode,&coord);
  case 2: return Node::field("colorIndex",mfInt32,&colorIndex);
  case 3: return Node::field("colorPerVertex",sfBool,&colorPerVertex);
  case 4: return Node::field("coordIndex",mfInt32,&coordIndex);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_colorIndex
 *  - set_coordIndex
 *  - set_color
 *  - set_coord
 */
wrl::Node::EventInHandle
wrl::IndexedLineSet::eventIn(const std::string& n)
{
  if(n==std::string("set_colorIndex"))
  {
    return Node::eventIn(n,mfInt32,(void*) &set_colorIndex);
  }
  if(n==std::string("set_coordIndex"))
  {
    return Node::eventIn(n,mfInt32,(void*) &set_coordIndex);
  }
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_color);
  }
  if(n==std::string("set_coord"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_coord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_colorIndex
 *  - 1 : set_coordIndex
 *  - 2 : set_color
 *  - 3 : set_coord

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::IndexedLineSet::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_colorIndex",mfInt32,&set_colorIndex);
  case 1: return Node::eventIn("set_coordIndex",mfInt32,&set_coordIndex);
  case 2: return Node::eventIn("set_color",sfNode,&set_color);
  case 3: return Node::eventIn("set_coord",sfNode,&set_coord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - color_changed
 *  - coord_changed
 */
wrl::Node::EventOutHandle
wrl::IndexedLineSet::eventOut(const std::string& n)
{
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &color_changed);
  }
  if(n==std::string("coord_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &coord_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color_changed
 *  - 1 : coord_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::IndexedLineSet::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("color_changed",sfNode,&color_changed);
  case 1: return Node::eventOut("coord_changed",sfNode,&coord_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::IndexedLineSet::duplicate() const
{
  IndexedLineSet* n = new IndexedLineSet(name());
  if (color != NULL)
  {
    n->color = color->duplicate();
  }
  else
  {
    n->color = NULL;
  }
  if (coord != NULL)
  {
    n->coord = coord->duplicate();
  }
  else
  {
    n->coord = NULL;
  }
  n->colorIndex = colorIndex;
  n->colorPerVertex = colorPerVertex;
  n->coordIndex = coordIndex;
  return n;
}
wrl::Node* 
wrl::IndexedLineSet::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  IndexedLineSet* n = new IndexedLineSet(name());
  nodeMap[this] = n;  if (color != NULL)
  {
    n->color = color->duplicate(nodeMap);
  }
  else
  {
    n->color = NULL;
  }
  if (coord != NULL)
  {
    n->coord = coord->duplicate(nodeMap);
  }
  else
  {
    n->coord = NULL;
  }
  n->colorIndex = colorIndex;
  n->colorPerVertex = colorPerVertex;
  n->coordIndex = coordIndex;
  return n;
}
bool
wrl::IndexedLineSet::isSetToDefaultValue(unsigned int i) const
{

  static const SFBool colorPerVertexDV_(true);
  switch (i)
  {
  case 0: return color == SFNode();
  case 1: return coord == SFNode();
  case 2: return colorIndex == MFInt32();
  case 3: return colorPerVertex == colorPerVertexDV_;
  case 4: return coordIndex == MFInt32();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
