#include <xdkwrl/nodes/imagetexture.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of ImageTexture
//************************************************************
/*! \class wrl::ImageTexture
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude imagetexture.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  repeatS = true;
  repeatT = true;
  \endcode
  */
wrl::ImageTexture::ImageTexture(const char* name)
 : Node(name)
{

  repeatS = true;
  repeatT = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::ImageTexture::~ImageTexture()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - url
 *  - repeatS
 *  - repeatT
 */
wrl::Node::FieldHandle
wrl::ImageTexture::field(const std::string& n)
{
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  if(n==std::string("repeatS"))
  {
    return Node::field(n,sfBool,(void*) &repeatS);
  }
  if(n==std::string("repeatT"))
  {
    return Node::field(n,sfBool,(void*) &repeatT);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : url
 *  - 1 : repeatS
 *  - 2 : repeatT
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::ImageTexture::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("url",mfString,&url);
  case 1: return Node::field("repeatS",sfBool,&repeatS);
  case 2: return Node::field("repeatT",sfBool,&repeatT);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_url
 */
wrl::Node::EventInHandle
wrl::ImageTexture::eventIn(const std::string& n)
{
  if(n==std::string("set_url"))
  {
    return Node::eventIn(n,mfString,(void*) &set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::ImageTexture::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_url",mfString,&set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - url_changed
 */
wrl::Node::EventOutHandle
wrl::ImageTexture::eventOut(const std::string& n)
{
  if(n==std::string("url_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &url_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : url_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::ImageTexture::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("url_changed",mfString,&url_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::ImageTexture::duplicate() const
{
  ImageTexture* n = new ImageTexture(name());
  n->url = url;
  n->repeatS = repeatS;
  n->repeatT = repeatT;
  return n;
}
wrl::Node* 
wrl::ImageTexture::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  ImageTexture* n = new ImageTexture(name());
  nodeMap[this] = n;  n->url = url;
  n->repeatS = repeatS;
  n->repeatT = repeatT;
  return n;
}
bool
wrl::ImageTexture::isSetToDefaultValue(unsigned int i) const
{

  static const SFBool repeatSDV_(true);
  static const SFBool repeatTDV_(true);
  switch (i)
  {
  case 0: return url == MFString();
  case 1: return repeatS == repeatSDV_;
  case 2: return repeatT == repeatTDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
