#include <xdkwrl/nodes/geopositioninterpolator.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoPositionInterpolator
//************************************************************
/*! \class wrl::GeoPositionInterpolator
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geopositioninterpolator.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  
  \endcode
  */
wrl::GeoPositionInterpolator::GeoPositionInterpolator(const char* name)
 : Node(name)
{

  }
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoPositionInterpolator::~GeoPositionInterpolator()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - geoOrigin
 *  - geoSystem
 *  - key
 *  - keyValue
 */
wrl::Node::FieldHandle
wrl::GeoPositionInterpolator::field(const std::string& n)
{
  if(n==std::string("geoOrigin"))
  {
    return Node::field(n,sfNode,(void*) &geoOrigin);
  }
  if(n==std::string("geoSystem"))
  {
    return Node::field(n,mfString,(void*) &geoSystem);
  }
  if(n==std::string("key"))
  {
    return Node::field(n,mfFloat,(void*) &key);
  }
  if(n==std::string("keyValue"))
  {
    return Node::field(n,mfString,(void*) &keyValue);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : geoOrigin
 *  - 1 : geoSystem
 *  - 2 : key
 *  - 3 : keyValue
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoPositionInterpolator::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("geoOrigin",sfNode,&geoOrigin);
  case 1: return Node::field("geoSystem",mfString,&geoSystem);
  case 2: return Node::field("key",mfFloat,&key);
  case 3: return Node::field("keyValue",mfString,&keyValue);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_fraction
 */
wrl::Node::EventInHandle
wrl::GeoPositionInterpolator::eventIn(const std::string& n)
{
  if(n==std::string("set_fraction"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_fraction);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_fraction

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoPositionInterpolator::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_fraction",sfFloat,&set_fraction);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - geovalue_changed
 *  - value_changed
 */
wrl::Node::EventOutHandle
wrl::GeoPositionInterpolator::eventOut(const std::string& n)
{
  if(n==std::string("geovalue_changed"))
  {
    return Node::eventOut(n,sfString,(void*) &geovalue_changed);
  }
  if(n==std::string("value_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &value_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : geovalue_changed
 *  - 1 : value_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoPositionInterpolator::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("geovalue_changed",sfString,&geovalue_changed);
  case 1: return Node::eventOut("value_changed",sfVec3f,&value_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoPositionInterpolator::duplicate() const
{
  GeoPositionInterpolator* n = new GeoPositionInterpolator(name());
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate();
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->key = key;
  n->keyValue = keyValue;
  return n;
}
wrl::Node* 
wrl::GeoPositionInterpolator::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoPositionInterpolator* n = new GeoPositionInterpolator(name());
  nodeMap[this] = n;  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate(nodeMap);
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->key = key;
  n->keyValue = keyValue;
  return n;
}
bool
wrl::GeoPositionInterpolator::isSetToDefaultValue(unsigned int i) const
{

  static MFString geoSystemDV_;
  if (geoSystemDV_.empty())
  {
  }
  switch (i)
  {
  case 0: return geoOrigin == SFNode();
  case 1: return geoSystem == geoSystemDV_;
  case 2: return key == MFFloat();
  case 3: return keyValue == MFString();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
