#include <xdkwrl/nodes/geometadata.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoMetadata
//************************************************************
/*! \class wrl::GeoMetadata
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geometadata.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::GeoMetadata::GeoMetadata(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoMetadata::~GeoMetadata()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - data
 *  - summary
 *  - url
 */
wrl::Node::FieldHandle
wrl::GeoMetadata::field(const std::string& n)
{
  if(n==std::string("data"))
  {
    return Node::field(n,mfNode,(void*) &data);
  }
  if(n==std::string("summary"))
  {
    return Node::field(n,mfString,(void*) &summary);
  }
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : data
 *  - 1 : summary
 *  - 2 : url
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoMetadata::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("data",mfNode,&data);
  case 1: return Node::field("summary",mfString,&summary);
  case 2: return Node::field("url",mfString,&url);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_data
 *  - set_summary
 *  - set_url
 */
wrl::Node::EventInHandle
wrl::GeoMetadata::eventIn(const std::string& n)
{
  if(n==std::string("set_data"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_data);
  }
  if(n==std::string("set_summary"))
  {
    return Node::eventIn(n,mfString,(void*) &set_summary);
  }
  if(n==std::string("set_url"))
  {
    return Node::eventIn(n,mfString,(void*) &set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoMetadata::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_data",mfNode,&set_data);
  case 1: return Node::eventIn("set_summary",mfString,&set_summary);
  case 2: return Node::eventIn("set_url",mfString,&set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - data_changed
 *  - summary_changed
 *  - url_changed
 */
wrl::Node::EventOutHandle
wrl::GeoMetadata::eventOut(const std::string& n)
{
  if(n==std::string("data_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &data_changed);
  }
  if(n==std::string("summary_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &summary_changed);
  }
  if(n==std::string("url_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &url_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : data_changed
 *  - 1 : summary_changed
 *  - 2 : url_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoMetadata::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("data_changed",mfNode,&data_changed);
  case 1: return Node::eventOut("summary_changed",mfString,&summary_changed);
  case 2: return Node::eventOut("url_changed",mfString,&url_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoMetadata::duplicate() const
{
  GeoMetadata* n = new GeoMetadata(name());
  for (MFNode::const_iterator iter = data.begin();
       iter != data.end();++iter)
  {
     n->data.push_back(SFNode((*iter)->duplicate()));
  }
  n->summary = summary;
  n->url = url;
  return n;
}
wrl::Node* 
wrl::GeoMetadata::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoMetadata* n = new GeoMetadata(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = data.begin();
       iter != data.end();++iter)
  {
     n->data.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->summary = summary;
  n->url = url;
  return n;
}
bool
wrl::GeoMetadata::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return data == MFNode();
  case 1: return summary == MFString();
  case 2: return url == MFString();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
