#include <xdkwrl/nodes/geolod.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoLOD
//************************************************************
/*! \class wrl::GeoLOD
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geolod.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  center = string("");
  
  range = 10.0f;
  \endcode
  */
wrl::GeoLOD::GeoLOD(const char* name)
 : Node(name)
{
  center = string("");
  
  range = 10.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoLOD::~GeoLOD()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - center
 *  - child1Url
 *  - child2Url
 *  - child3Url
 *  - child4Url
 *  - geoOrigin
 *  - geoSystem
 *  - range
 *  - rootUrl
 *  - rootNode
 */
wrl::Node::FieldHandle
wrl::GeoLOD::field(const std::string& n)
{
  if(n==std::string("center"))
  {
    return Node::field(n,sfString,(void*) &center);
  }
  if(n==std::string("child1Url"))
  {
    return Node::field(n,mfString,(void*) &child1Url);
  }
  if(n==std::string("child2Url"))
  {
    return Node::field(n,mfString,(void*) &child2Url);
  }
  if(n==std::string("child3Url"))
  {
    return Node::field(n,mfString,(void*) &child3Url);
  }
  if(n==std::string("child4Url"))
  {
    return Node::field(n,mfString,(void*) &child4Url);
  }
  if(n==std::string("geoOrigin"))
  {
    return Node::field(n,sfNode,(void*) &geoOrigin);
  }
  if(n==std::string("geoSystem"))
  {
    return Node::field(n,mfString,(void*) &geoSystem);
  }
  if(n==std::string("range"))
  {
    return Node::field(n,sfFloat,(void*) &range);
  }
  if(n==std::string("rootUrl"))
  {
    return Node::field(n,mfString,(void*) &rootUrl);
  }
  if(n==std::string("rootNode"))
  {
    return Node::field(n,mfNode,(void*) &rootNode);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : center
 *  - 1 : child1Url
 *  - 2 : child2Url
 *  - 3 : child3Url
 *  - 4 : child4Url
 *  - 5 : geoOrigin
 *  - 6 : geoSystem
 *  - 7 : range
 *  - 8 : rootUrl
 *  - 9 : rootNode
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoLOD::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("center",sfString,&center);
  case 1: return Node::field("child1Url",mfString,&child1Url);
  case 2: return Node::field("child2Url",mfString,&child2Url);
  case 3: return Node::field("child3Url",mfString,&child3Url);
  case 4: return Node::field("child4Url",mfString,&child4Url);
  case 5: return Node::field("geoOrigin",sfNode,&geoOrigin);
  case 6: return Node::field("geoSystem",mfString,&geoSystem);
  case 7: return Node::field("range",sfFloat,&range);
  case 8: return Node::field("rootUrl",mfString,&rootUrl);
  case 9: return Node::field("rootNode",mfNode,&rootNode);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::GeoLOD::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoLOD::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - children
 */
wrl::Node::EventOutHandle
wrl::GeoLOD::eventOut(const std::string& n)
{
  if(n==std::string("children"))
  {
    return Node::eventOut(n,mfNode,(void*) &children);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoLOD::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("children",mfNode,&children);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoLOD::duplicate() const
{
  GeoLOD* n = new GeoLOD(name());
  n->center = center;
  n->child1Url = child1Url;
  n->child2Url = child2Url;
  n->child3Url = child3Url;
  n->child4Url = child4Url;
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate();
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->range = range;
  n->rootUrl = rootUrl;
  for (MFNode::const_iterator iter = rootNode.begin();
       iter != rootNode.end();++iter)
  {
     n->rootNode.push_back(SFNode((*iter)->duplicate()));
  }
  return n;
}
wrl::Node* 
wrl::GeoLOD::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoLOD* n = new GeoLOD(name());
  nodeMap[this] = n;  n->center = center;
  n->child1Url = child1Url;
  n->child2Url = child2Url;
  n->child3Url = child3Url;
  n->child4Url = child4Url;
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate(nodeMap);
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->range = range;
  n->rootUrl = rootUrl;
  for (MFNode::const_iterator iter = rootNode.begin();
       iter != rootNode.end();++iter)
  {
     n->rootNode.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  return n;
}
bool
wrl::GeoLOD::isSetToDefaultValue(unsigned int i) const
{
  static const SFString centerDV_("");
  static MFString geoSystemDV_;
  if (geoSystemDV_.empty())
  {
  }
  static const SFFloat rangeDV_(10.0f);
  switch (i)
  {
  case 0: return center == centerDV_;
  case 1: return child1Url == MFString();
  case 2: return child2Url == MFString();
  case 3: return child3Url == MFString();
  case 4: return child4Url == MFString();
  case 5: return geoOrigin == SFNode();
  case 6: return geoSystem == geoSystemDV_;
  case 7: return range == rangeDV_;
  case 8: return rootUrl == MFString();
  case 9: return rootNode == MFNode();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
