#include <xdkwrl/nodes/geolocation.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoLocation
//************************************************************
/*! \class wrl::GeoLocation
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geolocation.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  geoCoords = string("");
  
  \endcode
  */
wrl::GeoLocation::GeoLocation(const char* name)
 : Node(name)
{
  geoCoords = string("");
  }
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoLocation::~GeoLocation()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - geoCoords
 *  - children
 *  - geoOrigin
 *  - geoSystem
 */
wrl::Node::FieldHandle
wrl::GeoLocation::field(const std::string& n)
{
  if(n==std::string("geoCoords"))
  {
    return Node::field(n,sfString,(void*) &geoCoords);
  }
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  if(n==std::string("geoOrigin"))
  {
    return Node::field(n,sfNode,(void*) &geoOrigin);
  }
  if(n==std::string("geoSystem"))
  {
    return Node::field(n,mfString,(void*) &geoSystem);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : geoCoords
 *  - 1 : children
 *  - 2 : geoOrigin
 *  - 3 : geoSystem
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoLocation::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("geoCoords",sfString,&geoCoords);
  case 1: return Node::field("children",mfNode,&children);
  case 2: return Node::field("geoOrigin",sfNode,&geoOrigin);
  case 3: return Node::field("geoSystem",mfString,&geoSystem);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_geoCoords
 */
wrl::Node::EventInHandle
wrl::GeoLocation::eventIn(const std::string& n)
{
  if(n==std::string("set_geoCoords"))
  {
    return Node::eventIn(n,sfString,(void*) &set_geoCoords);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoLocation::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_geoCoords",sfString,&set_geoCoords);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - geoCoords_changed
 */
wrl::Node::EventOutHandle
wrl::GeoLocation::eventOut(const std::string& n)
{
  if(n==std::string("geoCoords_changed"))
  {
    return Node::eventOut(n,sfString,(void*) &geoCoords_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : geoCoords_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoLocation::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("geoCoords_changed",sfString,&geoCoords_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoLocation::duplicate() const
{
  GeoLocation* n = new GeoLocation(name());
  n->geoCoords = geoCoords;
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate();
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  return n;
}
wrl::Node* 
wrl::GeoLocation::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoLocation* n = new GeoLocation(name());
  nodeMap[this] = n;  n->geoCoords = geoCoords;
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate(nodeMap);
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  return n;
}
bool
wrl::GeoLocation::isSetToDefaultValue(unsigned int i) const
{
  static const SFString geoCoordsDV_("");
  static MFString geoSystemDV_;
  if (geoSystemDV_.empty())
  {
  }
  switch (i)
  {
  case 0: return geoCoords == geoCoordsDV_;
  case 1: return children == MFNode();
  case 2: return geoOrigin == SFNode();
  case 3: return geoSystem == geoSystemDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
