#include <xdkwrl/nodes/geocoordinate.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of GeoCoordinate
//************************************************************
/*! \class wrl::GeoCoordinate
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude geocoordinate.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  
  \endcode
  */
wrl::GeoCoordinate::GeoCoordinate(const char* name)
 : Node(name)
{

  }
/*!
 * Virtual destructor, does nothing
 */
wrl::GeoCoordinate::~GeoCoordinate()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - geoOrigin
 *  - geoSystem
 *  - point
 */
wrl::Node::FieldHandle
wrl::GeoCoordinate::field(const std::string& n)
{
  if(n==std::string("geoOrigin"))
  {
    return Node::field(n,sfNode,(void*) &geoOrigin);
  }
  if(n==std::string("geoSystem"))
  {
    return Node::field(n,mfString,(void*) &geoSystem);
  }
  if(n==std::string("point"))
  {
    return Node::field(n,mfString,(void*) &point);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : geoOrigin
 *  - 1 : geoSystem
 *  - 2 : point
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::GeoCoordinate::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("geoOrigin",sfNode,&geoOrigin);
  case 1: return Node::field("geoSystem",mfString,&geoSystem);
  case 2: return Node::field("point",mfString,&point);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::GeoCoordinate::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::GeoCoordinate::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::GeoCoordinate::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::GeoCoordinate::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::GeoCoordinate::duplicate() const
{
  GeoCoordinate* n = new GeoCoordinate(name());
  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate();
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->point = point;
  return n;
}
wrl::Node* 
wrl::GeoCoordinate::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  GeoCoordinate* n = new GeoCoordinate(name());
  nodeMap[this] = n;  if (geoOrigin != NULL)
  {
    n->geoOrigin = geoOrigin->duplicate(nodeMap);
  }
  else
  {
    n->geoOrigin = NULL;
  }
  n->geoSystem = geoSystem;
  n->point = point;
  return n;
}
bool
wrl::GeoCoordinate::isSetToDefaultValue(unsigned int i) const
{

  static MFString geoSystemDV_;
  if (geoSystemDV_.empty())
  {
  }
  switch (i)
  {
  case 0: return geoOrigin == SFNode();
  case 1: return geoSystem == geoSystemDV_;
  case 2: return point == MFString();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
