#include <xdkwrl/nodes/fontstyle.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of FontStyle
//************************************************************
/*! \class wrl::FontStyle
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude fontstyle.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  
  horizontal = true;
  
  language = string("");
  leftToRight = true;
  size = 1.0f;
  spacing = 1.0f;
  style = string("PLAIN");
  topToBottom = true;
  \endcode
  */
wrl::FontStyle::FontStyle(const char* name)
 : Node(name)
{
  
  horizontal = true;
  
  language = string("");
  leftToRight = true;
  size = 1.0f;
  spacing = 1.0f;
  style = string("PLAIN");
  topToBottom = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::FontStyle::~FontStyle()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - family
 *  - horizontal
 *  - justify
 *  - language
 *  - leftToRight
 *  - size
 *  - spacing
 *  - style
 *  - topToBottom
 */
wrl::Node::FieldHandle
wrl::FontStyle::field(const std::string& n)
{
  if(n==std::string("family"))
  {
    return Node::field(n,mfString,(void*) &family);
  }
  if(n==std::string("horizontal"))
  {
    return Node::field(n,sfBool,(void*) &horizontal);
  }
  if(n==std::string("justify"))
  {
    return Node::field(n,mfString,(void*) &justify);
  }
  if(n==std::string("language"))
  {
    return Node::field(n,sfString,(void*) &language);
  }
  if(n==std::string("leftToRight"))
  {
    return Node::field(n,sfBool,(void*) &leftToRight);
  }
  if(n==std::string("size"))
  {
    return Node::field(n,sfFloat,(void*) &size);
  }
  if(n==std::string("spacing"))
  {
    return Node::field(n,sfFloat,(void*) &spacing);
  }
  if(n==std::string("style"))
  {
    return Node::field(n,sfString,(void*) &style);
  }
  if(n==std::string("topToBottom"))
  {
    return Node::field(n,sfBool,(void*) &topToBottom);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : family
 *  - 1 : horizontal
 *  - 2 : justify
 *  - 3 : language
 *  - 4 : leftToRight
 *  - 5 : size
 *  - 6 : spacing
 *  - 7 : style
 *  - 8 : topToBottom
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::FontStyle::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("family",mfString,&family);
  case 1: return Node::field("horizontal",sfBool,&horizontal);
  case 2: return Node::field("justify",mfString,&justify);
  case 3: return Node::field("language",sfString,&language);
  case 4: return Node::field("leftToRight",sfBool,&leftToRight);
  case 5: return Node::field("size",sfFloat,&size);
  case 6: return Node::field("spacing",sfFloat,&spacing);
  case 7: return Node::field("style",sfString,&style);
  case 8: return Node::field("topToBottom",sfBool,&topToBottom);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::FontStyle::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::FontStyle::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::FontStyle::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::FontStyle::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::FontStyle::duplicate() const
{
  FontStyle* n = new FontStyle(name());
  n->family = family;
  n->horizontal = horizontal;
  n->justify = justify;
  n->language = language;
  n->leftToRight = leftToRight;
  n->size = size;
  n->spacing = spacing;
  n->style = style;
  n->topToBottom = topToBottom;
  return n;
}
wrl::Node* 
wrl::FontStyle::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  FontStyle* n = new FontStyle(name());
  nodeMap[this] = n;  n->family = family;
  n->horizontal = horizontal;
  n->justify = justify;
  n->language = language;
  n->leftToRight = leftToRight;
  n->size = size;
  n->spacing = spacing;
  n->style = style;
  n->topToBottom = topToBottom;
  return n;
}
bool
wrl::FontStyle::isSetToDefaultValue(unsigned int i) const
{
  static MFString familyDV_;
  if (familyDV_.empty())
  {
  }
  static const SFBool horizontalDV_(true);
  static MFString justifyDV_;
  if (justifyDV_.empty())
  {
  }
  static const SFString languageDV_("");
  static const SFBool leftToRightDV_(true);
  static const SFFloat sizeDV_(1.0f);
  static const SFFloat spacingDV_(1.0f);
  static const SFString styleDV_("PLAIN");
  static const SFBool topToBottomDV_(true);
  switch (i)
  {
  case 0: return family == familyDV_;
  case 1: return horizontal == horizontalDV_;
  case 2: return justify == justifyDV_;
  case 3: return language == languageDV_;
  case 4: return leftToRight == leftToRightDV_;
  case 5: return size == sizeDV_;
  case 6: return spacing == spacingDV_;
  case 7: return style == styleDV_;
  case 8: return topToBottom == topToBottomDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
