#include <xdkwrl/nodes/fog.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Fog
//************************************************************
/*! \class wrl::Fog
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude fog.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  color.setRGB(1.0f,1.0f,1.0f);
  fogType = string("LINEAR");
  visibilityRange = 0.0f;
  \endcode
  */
wrl::Fog::Fog(const char* name)
 : Node(name)
{
  color.setRGB(1.0f,1.0f,1.0f);
  fogType = string("LINEAR");
  visibilityRange = 0.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Fog::~Fog()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - color
 *  - fogType
 *  - visibilityRange
 */
wrl::Node::FieldHandle
wrl::Fog::field(const std::string& n)
{
  if(n==std::string("color"))
  {
    return Node::field(n,sfColor,(void*) &color);
  }
  if(n==std::string("fogType"))
  {
    return Node::field(n,sfString,(void*) &fogType);
  }
  if(n==std::string("visibilityRange"))
  {
    return Node::field(n,sfFloat,(void*) &visibilityRange);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color
 *  - 1 : fogType
 *  - 2 : visibilityRange
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Fog::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("color",sfColor,&color);
  case 1: return Node::field("fogType",sfString,&fogType);
  case 2: return Node::field("visibilityRange",sfFloat,&visibilityRange);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_bind
 *  - set_color
 *  - set_fogType
 *  - set_visibilityRange
 */
wrl::Node::EventInHandle
wrl::Fog::eventIn(const std::string& n)
{
  if(n==std::string("set_bind"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_bind);
  }
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfColor,(void*) &set_color);
  }
  if(n==std::string("set_fogType"))
  {
    return Node::eventIn(n,sfString,(void*) &set_fogType);
  }
  if(n==std::string("set_visibilityRange"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_visibilityRange);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_bind
 *  - 1 : set_color
 *  - 2 : set_fogType
 *  - 3 : set_visibilityRange

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Fog::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_bind",sfBool,&set_bind);
  case 1: return Node::eventIn("set_color",sfColor,&set_color);
  case 2: return Node::eventIn("set_fogType",sfString,&set_fogType);
  case 3: return Node::eventIn("set_visibilityRange",sfFloat,&set_visibilityRange);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - isBound
 *  - color_changed
 *  - fogType_changed
 *  - visibilityRange_changed
 */
wrl::Node::EventOutHandle
wrl::Fog::eventOut(const std::string& n)
{
  if(n==std::string("isBound"))
  {
    return Node::eventOut(n,sfBool,(void*) &isBound);
  }
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfColor,(void*) &color_changed);
  }
  if(n==std::string("fogType_changed"))
  {
    return Node::eventOut(n,sfString,(void*) &fogType_changed);
  }
  if(n==std::string("visibilityRange_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &visibilityRange_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : isBound
 *  - 1 : color_changed
 *  - 2 : fogType_changed
 *  - 3 : visibilityRange_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Fog::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("isBound",sfBool,&isBound);
  case 1: return Node::eventOut("color_changed",sfColor,&color_changed);
  case 2: return Node::eventOut("fogType_changed",sfString,&fogType_changed);
  case 3: return Node::eventOut("visibilityRange_changed",sfFloat,&visibilityRange_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Fog::duplicate() const
{
  Fog* n = new Fog(name());
  n->color = color;
  n->fogType = fogType;
  n->visibilityRange = visibilityRange;
  return n;
}
wrl::Node* 
wrl::Fog::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Fog* n = new Fog(name());
  nodeMap[this] = n;  n->color = color;
  n->fogType = fogType;
  n->visibilityRange = visibilityRange;
  return n;
}
bool
wrl::Fog::isSetToDefaultValue(unsigned int i) const
{
  static const SFColor colorDV_(1.0f,1.0f,1.0f);
  static const SFString fogTypeDV_("LINEAR");
  static const SFFloat visibilityRangeDV_(0.0f);
  switch (i)
  {
  case 0: return color == colorDV_;
  case 1: return fogType == fogTypeDV_;
  case 2: return visibilityRange == visibilityRangeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
