#include <xdkwrl/nodes/extrusion.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Extrusion
//************************************************************
/*! \class wrl::Extrusion
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude extrusion.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  beginCap = true;
  ccw = true;
  convex = true;
  creaseAngle = 0.0f;
      crossSection.push_back(SFVec2f(1.0f,1.0f));
    crossSection.push_back(SFVec2f(1.0f,-1.0f));
    crossSection.push_back(SFVec2f(-1.0f,-1.0f));
    crossSection.push_back(SFVec2f(-1.0f,1.0f));
    crossSection.push_back(SFVec2f(1.0f,1.0f));
  endCap = true;
      orientation.push_back(SFRotation(0.0f,0.0f,1.0f,0.0f));
      scale.push_back(SFVec2f(1.0f,1.0f));
  solid = true;
      spine.push_back(SFVec3f(0.0f,0.0f,0.0f));
    spine.push_back(SFVec3f(0.0f,1.0f,0.0f));
  \endcode
  */
wrl::Extrusion::Extrusion(const char* name)
 : Node(name)
{
  beginCap = true;
  ccw = true;
  convex = true;
  creaseAngle = 0.0f;
      crossSection.push_back(SFVec2f(1.0f,1.0f));
    crossSection.push_back(SFVec2f(1.0f,-1.0f));
    crossSection.push_back(SFVec2f(-1.0f,-1.0f));
    crossSection.push_back(SFVec2f(-1.0f,1.0f));
    crossSection.push_back(SFVec2f(1.0f,1.0f));
  endCap = true;
      orientation.push_back(SFRotation(0.0f,0.0f,1.0f,0.0f));
      scale.push_back(SFVec2f(1.0f,1.0f));
  solid = true;
      spine.push_back(SFVec3f(0.0f,0.0f,0.0f));
    spine.push_back(SFVec3f(0.0f,1.0f,0.0f));}
/*!
 * Virtual destructor, does nothing
 */
wrl::Extrusion::~Extrusion()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - beginCap
 *  - ccw
 *  - convex
 *  - creaseAngle
 *  - crossSection
 *  - endCap
 *  - orientation
 *  - scale
 *  - solid
 *  - spine
 */
wrl::Node::FieldHandle
wrl::Extrusion::field(const std::string& n)
{
  if(n==std::string("beginCap"))
  {
    return Node::field(n,sfBool,(void*) &beginCap);
  }
  if(n==std::string("ccw"))
  {
    return Node::field(n,sfBool,(void*) &ccw);
  }
  if(n==std::string("convex"))
  {
    return Node::field(n,sfBool,(void*) &convex);
  }
  if(n==std::string("creaseAngle"))
  {
    return Node::field(n,sfFloat,(void*) &creaseAngle);
  }
  if(n==std::string("crossSection"))
  {
    return Node::field(n,mfVec2f,(void*) &crossSection);
  }
  if(n==std::string("endCap"))
  {
    return Node::field(n,sfBool,(void*) &endCap);
  }
  if(n==std::string("orientation"))
  {
    return Node::field(n,mfRotation,(void*) &orientation);
  }
  if(n==std::string("scale"))
  {
    return Node::field(n,mfVec2f,(void*) &scale);
  }
  if(n==std::string("solid"))
  {
    return Node::field(n,sfBool,(void*) &solid);
  }
  if(n==std::string("spine"))
  {
    return Node::field(n,mfVec3f,(void*) &spine);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : beginCap
 *  - 1 : ccw
 *  - 2 : convex
 *  - 3 : creaseAngle
 *  - 4 : crossSection
 *  - 5 : endCap
 *  - 6 : orientation
 *  - 7 : scale
 *  - 8 : solid
 *  - 9 : spine
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Extrusion::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("beginCap",sfBool,&beginCap);
  case 1: return Node::field("ccw",sfBool,&ccw);
  case 2: return Node::field("convex",sfBool,&convex);
  case 3: return Node::field("creaseAngle",sfFloat,&creaseAngle);
  case 4: return Node::field("crossSection",mfVec2f,&crossSection);
  case 5: return Node::field("endCap",sfBool,&endCap);
  case 6: return Node::field("orientation",mfRotation,&orientation);
  case 7: return Node::field("scale",mfVec2f,&scale);
  case 8: return Node::field("solid",sfBool,&solid);
  case 9: return Node::field("spine",mfVec3f,&spine);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_crossSection
 *  - set_orientation
 *  - set_scale
 *  - set_spine
 */
wrl::Node::EventInHandle
wrl::Extrusion::eventIn(const std::string& n)
{
  if(n==std::string("set_crossSection"))
  {
    return Node::eventIn(n,mfVec2f,(void*) &set_crossSection);
  }
  if(n==std::string("set_orientation"))
  {
    return Node::eventIn(n,mfRotation,(void*) &set_orientation);
  }
  if(n==std::string("set_scale"))
  {
    return Node::eventIn(n,mfVec2f,(void*) &set_scale);
  }
  if(n==std::string("set_spine"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_spine);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_crossSection
 *  - 1 : set_orientation
 *  - 2 : set_scale
 *  - 3 : set_spine

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Extrusion::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_crossSection",mfVec2f,&set_crossSection);
  case 1: return Node::eventIn("set_orientation",mfRotation,&set_orientation);
  case 2: return Node::eventIn("set_scale",mfVec2f,&set_scale);
  case 3: return Node::eventIn("set_spine",mfVec3f,&set_spine);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::Extrusion::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Extrusion::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::Extrusion::duplicate() const
{
  Extrusion* n = new Extrusion(name());
  n->beginCap = beginCap;
  n->ccw = ccw;
  n->convex = convex;
  n->creaseAngle = creaseAngle;
  n->crossSection = crossSection;
  n->endCap = endCap;
  n->orientation = orientation;
  n->scale = scale;
  n->solid = solid;
  n->spine = spine;
  return n;
}
wrl::Node* 
wrl::Extrusion::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Extrusion* n = new Extrusion(name());
  nodeMap[this] = n;  n->beginCap = beginCap;
  n->ccw = ccw;
  n->convex = convex;
  n->creaseAngle = creaseAngle;
  n->crossSection = crossSection;
  n->endCap = endCap;
  n->orientation = orientation;
  n->scale = scale;
  n->solid = solid;
  n->spine = spine;
  return n;
}
bool
wrl::Extrusion::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool beginCapDV_(true);
  static const SFBool ccwDV_(true);
  static const SFBool convexDV_(true);
  static const SFFloat creaseAngleDV_(0.0f);
  static MFVec2f crossSectionDV_;
  if (crossSectionDV_.empty())
  {
    crossSectionDV_.push_back(SFVec2f(1.0f,1.0f));
    crossSectionDV_.push_back(SFVec2f(1.0f,-1.0f));
    crossSectionDV_.push_back(SFVec2f(-1.0f,-1.0f));
    crossSectionDV_.push_back(SFVec2f(-1.0f,1.0f));
    crossSectionDV_.push_back(SFVec2f(1.0f,1.0f));
  }
  static const SFBool endCapDV_(true);
  static MFRotation orientationDV_;
  if (orientationDV_.empty())
  {
    orientationDV_.push_back(SFRotation(0.0f,0.0f,1.0f,0.0f));
  }
  static MFVec2f scaleDV_;
  if (scaleDV_.empty())
  {
    scaleDV_.push_back(SFVec2f(1.0f,1.0f));
  }
  static const SFBool solidDV_(true);
  static MFVec3f spineDV_;
  if (spineDV_.empty())
  {
    spineDV_.push_back(SFVec3f(0.0f,0.0f,0.0f));
    spineDV_.push_back(SFVec3f(0.0f,1.0f,0.0f));
  }
  switch (i)
  {
  case 0: return beginCap == beginCapDV_;
  case 1: return ccw == ccwDV_;
  case 2: return convex == convexDV_;
  case 3: return creaseAngle == creaseAngleDV_;
  case 4: return crossSection == crossSectionDV_;
  case 5: return endCap == endCapDV_;
  case 6: return orientation == orientationDV_;
  case 7: return scale == scaleDV_;
  case 8: return solid == solidDV_;
  case 9: return spine == spineDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
