#include <xdkwrl/nodes/directionallight.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of DirectionalLight
//************************************************************
/*! \class wrl::DirectionalLight
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude directionallight.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  ambientIntensity = 0.0f;
  color.setRGB(1.0f,1.0f,1.0f);
  direction.setXYZ(0.0f,0.0f,-1.0f);
  intensity = 1.0f;
  on = true;
  \endcode
  */
wrl::DirectionalLight::DirectionalLight(const char* name)
 : Node(name)
{
  ambientIntensity = 0.0f;
  color.setRGB(1.0f,1.0f,1.0f);
  direction.setXYZ(0.0f,0.0f,-1.0f);
  intensity = 1.0f;
  on = true;}
/*!
 * Virtual destructor, does nothing
 */
wrl::DirectionalLight::~DirectionalLight()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - ambientIntensity
 *  - color
 *  - direction
 *  - intensity
 *  - on
 */
wrl::Node::FieldHandle
wrl::DirectionalLight::field(const std::string& n)
{
  if(n==std::string("ambientIntensity"))
  {
    return Node::field(n,sfFloat,(void*) &ambientIntensity);
  }
  if(n==std::string("color"))
  {
    return Node::field(n,sfColor,(void*) &color);
  }
  if(n==std::string("direction"))
  {
    return Node::field(n,sfVec3f,(void*) &direction);
  }
  if(n==std::string("intensity"))
  {
    return Node::field(n,sfFloat,(void*) &intensity);
  }
  if(n==std::string("on"))
  {
    return Node::field(n,sfBool,(void*) &on);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : ambientIntensity
 *  - 1 : color
 *  - 2 : direction
 *  - 3 : intensity
 *  - 4 : on
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::DirectionalLight::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("ambientIntensity",sfFloat,&ambientIntensity);
  case 1: return Node::field("color",sfColor,&color);
  case 2: return Node::field("direction",sfVec3f,&direction);
  case 3: return Node::field("intensity",sfFloat,&intensity);
  case 4: return Node::field("on",sfBool,&on);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_ambientIntensity
 *  - set_color
 *  - set_direction
 *  - set_intensity
 *  - set_on
 */
wrl::Node::EventInHandle
wrl::DirectionalLight::eventIn(const std::string& n)
{
  if(n==std::string("set_ambientIntensity"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_ambientIntensity);
  }
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfColor,(void*) &set_color);
  }
  if(n==std::string("set_direction"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_direction);
  }
  if(n==std::string("set_intensity"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_intensity);
  }
  if(n==std::string("set_on"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_on);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::DirectionalLight::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_ambientIntensity",sfFloat,&set_ambientIntensity);
  case 1: return Node::eventIn("set_color",sfColor,&set_color);
  case 2: return Node::eventIn("set_direction",sfVec3f,&set_direction);
  case 3: return Node::eventIn("set_intensity",sfFloat,&set_intensity);
  case 4: return Node::eventIn("set_on",sfBool,&set_on);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - ambientIntensity_changed
 *  - color_changed
 *  - direction_changed
 *  - intensity_changed
 *  - on_changed
 */
wrl::Node::EventOutHandle
wrl::DirectionalLight::eventOut(const std::string& n)
{
  if(n==std::string("ambientIntensity_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &ambientIntensity_changed);
  }
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfColor,(void*) &color_changed);
  }
  if(n==std::string("direction_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &direction_changed);
  }
  if(n==std::string("intensity_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &intensity_changed);
  }
  if(n==std::string("on_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &on_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : ambientIntensity_changed
 *  - 1 : color_changed
 *  - 2 : direction_changed
 *  - 3 : intensity_changed
 *  - 4 : on_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::DirectionalLight::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("ambientIntensity_changed",sfFloat,&ambientIntensity_changed);
  case 1: return Node::eventOut("color_changed",sfColor,&color_changed);
  case 2: return Node::eventOut("direction_changed",sfVec3f,&direction_changed);
  case 3: return Node::eventOut("intensity_changed",sfFloat,&intensity_changed);
  case 4: return Node::eventOut("on_changed",sfBool,&on_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::DirectionalLight::duplicate() const
{
  DirectionalLight* n = new DirectionalLight(name());
  n->ambientIntensity = ambientIntensity;
  n->color = color;
  n->direction = direction;
  n->intensity = intensity;
  n->on = on;
  return n;
}
wrl::Node* 
wrl::DirectionalLight::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  DirectionalLight* n = new DirectionalLight(name());
  nodeMap[this] = n;  n->ambientIntensity = ambientIntensity;
  n->color = color;
  n->direction = direction;
  n->intensity = intensity;
  n->on = on;
  return n;
}
bool
wrl::DirectionalLight::isSetToDefaultValue(unsigned int i) const
{
  static const SFFloat ambientIntensityDV_(0.0f);
  static const SFColor colorDV_(1.0f,1.0f,1.0f);
  static const SFVec3f directionDV_(0.0f,0.0f,-1.0f);
  static const SFFloat intensityDV_(1.0f);
  static const SFBool onDV_(true);
  switch (i)
  {
  case 0: return ambientIntensity == ambientIntensityDV_;
  case 1: return color == colorDV_;
  case 2: return direction == directionDV_;
  case 3: return intensity == intensityDV_;
  case 4: return on == onDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
