#include <xdkwrl/nodes/contour2d.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Contour2D
//************************************************************
/*! \class wrl::Contour2D
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude contour2d.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::Contour2D::Contour2D(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::Contour2D::~Contour2D()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - children
 */
wrl::Node::FieldHandle
wrl::Contour2D::field(const std::string& n)
{
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Contour2D::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("children",mfNode,&children);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addChildren
 *  - removeChildren
 *  - set_children
 */
wrl::Node::EventInHandle
wrl::Contour2D::eventIn(const std::string& n)
{
  if(n==std::string("addChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &addChildren);
  }
  if(n==std::string("removeChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeChildren);
  }
  if(n==std::string("set_children"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_children);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addChildren
 *  - 1 : removeChildren
 *  - 2 : set_children

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Contour2D::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addChildren",mfNode,&addChildren);
  case 1: return Node::eventIn("removeChildren",mfNode,&removeChildren);
  case 2: return Node::eventIn("set_children",mfNode,&set_children);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - children_changed
 */
wrl::Node::EventOutHandle
wrl::Contour2D::eventOut(const std::string& n)
{
  if(n==std::string("children_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &children_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : children_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Contour2D::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("children_changed",mfNode,&children_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Contour2D::duplicate() const
{
  Contour2D* n = new Contour2D(name());
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  return n;
}
wrl::Node* 
wrl::Contour2D::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Contour2D* n = new Contour2D(name());
  nodeMap[this] = n;  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  return n;
}
bool
wrl::Contour2D::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return children == MFNode();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
