#include <xdkwrl/nodes/color.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Color
//************************************************************
/*! \class wrl::Color
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude color.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::Color::Color(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::Color::~Color()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - color
 */
wrl::Node::FieldHandle
wrl::Color::field(const std::string& n)
{
  if(n==std::string("color"))
  {
    return Node::field(n,mfColor,(void*) &color);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Color::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("color",mfColor,&color);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_color
 */
wrl::Node::EventInHandle
wrl::Color::eventIn(const std::string& n)
{
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,mfColor,(void*) &set_color);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Color::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_color",mfColor,&set_color);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - color_changed
 */
wrl::Node::EventOutHandle
wrl::Color::eventOut(const std::string& n)
{
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,mfColor,(void*) &color_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Color::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("color_changed",mfColor,&color_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Color::duplicate() const
{
  Color* n = new Color(name());
  n->color = color;
  return n;
}
wrl::Node* 
wrl::Color::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Color* n = new Color(name());
  nodeMap[this] = n;  n->color = color;
  return n;
}
bool
wrl::Color::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return color == MFColor();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
