#include <xdkwrl/nodes/billboard.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Billboard
//************************************************************
/*! \class wrl::Billboard
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude billboard.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  axisOfRotation.setXYZ(0.0f,1.0f,0.0f);
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  \endcode
  */
wrl::Billboard::Billboard(const char* name)
 : Node(name)
{
  axisOfRotation.setXYZ(0.0f,1.0f,0.0f);
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::Billboard::~Billboard()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - axisOfRotation
 *  - children
 *  - bboxCenter
 *  - bboxSize
 */
wrl::Node::FieldHandle
wrl::Billboard::field(const std::string& n)
{
  if(n==std::string("axisOfRotation"))
  {
    return Node::field(n,sfVec3f,(void*) &axisOfRotation);
  }
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : axisOfRotation
 *  - 1 : children
 *  - 2 : bboxCenter
 *  - 3 : bboxSize
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Billboard::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("axisOfRotation",sfVec3f,&axisOfRotation);
  case 1: return Node::field("children",mfNode,&children);
  case 2: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 3: return Node::field("bboxSize",sfVec3f,&bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addChildren
 *  - removeChildren
 *  - set_axisOfRotation
 *  - set_children
 */
wrl::Node::EventInHandle
wrl::Billboard::eventIn(const std::string& n)
{
  if(n==std::string("addChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &addChildren);
  }
  if(n==std::string("removeChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeChildren);
  }
  if(n==std::string("set_axisOfRotation"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_axisOfRotation);
  }
  if(n==std::string("set_children"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_children);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addChildren
 *  - 1 : removeChildren
 *  - 2 : set_axisOfRotation
 *  - 3 : set_children

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Billboard::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addChildren",mfNode,&addChildren);
  case 1: return Node::eventIn("removeChildren",mfNode,&removeChildren);
  case 2: return Node::eventIn("set_axisOfRotation",sfVec3f,&set_axisOfRotation);
  case 3: return Node::eventIn("set_children",mfNode,&set_children);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - axisOfRotation_changed
 *  - children_changed
 */
wrl::Node::EventOutHandle
wrl::Billboard::eventOut(const std::string& n)
{
  if(n==std::string("axisOfRotation_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &axisOfRotation_changed);
  }
  if(n==std::string("children_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &children_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : axisOfRotation_changed
 *  - 1 : children_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Billboard::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("axisOfRotation_changed",sfVec3f,&axisOfRotation_changed);
  case 1: return Node::eventOut("children_changed",mfNode,&children_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Billboard::duplicate() const
{
  Billboard* n = new Billboard(name());
  n->axisOfRotation = axisOfRotation;
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
wrl::Node* 
wrl::Billboard::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Billboard* n = new Billboard(name());
  nodeMap[this] = n;  n->axisOfRotation = axisOfRotation;
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
bool
wrl::Billboard::isSetToDefaultValue(unsigned int i) const
{
  static const SFVec3f axisOfRotationDV_(0.0f,1.0f,0.0f);
  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  switch (i)
  {
  case 0: return axisOfRotation == axisOfRotationDV_;
  case 1: return children == MFNode();
  case 2: return bboxCenter == bboxCenterDV_;
  case 3: return bboxSize == bboxSizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
