#include <xdkwrl/nodes/audioclip.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of AudioClip
//************************************************************
/*! \class wrl::AudioClip
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude audioclip.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  description = string("");
  loop = false;
  pitch = 1.0f;
  startTime.setNbSeconds(0);
  stopTime.setNbSeconds(0);
  \endcode
  */
wrl::AudioClip::AudioClip(const char* name)
 : Node(name)
{
  description = string("");
  loop = false;
  pitch = 1.0f;
  startTime.setNbSeconds(0);
  stopTime.setNbSeconds(0);}
/*!
 * Virtual destructor, does nothing
 */
wrl::AudioClip::~AudioClip()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - description
 *  - loop
 *  - pitch
 *  - startTime
 *  - stopTime
 *  - url
 */
wrl::Node::FieldHandle
wrl::AudioClip::field(const std::string& n)
{
  if(n==std::string("description"))
  {
    return Node::field(n,sfString,(void*) &description);
  }
  if(n==std::string("loop"))
  {
    return Node::field(n,sfBool,(void*) &loop);
  }
  if(n==std::string("pitch"))
  {
    return Node::field(n,sfFloat,(void*) &pitch);
  }
  if(n==std::string("startTime"))
  {
    return Node::field(n,sfTime,(void*) &startTime);
  }
  if(n==std::string("stopTime"))
  {
    return Node::field(n,sfTime,(void*) &stopTime);
  }
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : description
 *  - 1 : loop
 *  - 2 : pitch
 *  - 3 : startTime
 *  - 4 : stopTime
 *  - 5 : url
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::AudioClip::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("description",sfString,&description);
  case 1: return Node::field("loop",sfBool,&loop);
  case 2: return Node::field("pitch",sfFloat,&pitch);
  case 3: return Node::field("startTime",sfTime,&startTime);
  case 4: return Node::field("stopTime",sfTime,&stopTime);
  case 5: return Node::field("url",mfString,&url);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_description
 *  - set_loop
 *  - set_pitch
 *  - set_startTime
 *  - set_stopTime
 *  - set_url
 */
wrl::Node::EventInHandle
wrl::AudioClip::eventIn(const std::string& n)
{
  if(n==std::string("set_description"))
  {
    return Node::eventIn(n,sfString,(void*) &set_description);
  }
  if(n==std::string("set_loop"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_loop);
  }
  if(n==std::string("set_pitch"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_pitch);
  }
  if(n==std::string("set_startTime"))
  {
    return Node::eventIn(n,sfTime,(void*) &set_startTime);
  }
  if(n==std::string("set_stopTime"))
  {
    return Node::eventIn(n,sfTime,(void*) &set_stopTime);
  }
  if(n==std::string("set_url"))
  {
    return Node::eventIn(n,mfString,(void*) &set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::AudioClip::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_description",sfString,&set_description);
  case 1: return Node::eventIn("set_loop",sfBool,&set_loop);
  case 2: return Node::eventIn("set_pitch",sfFloat,&set_pitch);
  case 3: return Node::eventIn("set_startTime",sfTime,&set_startTime);
  case 4: return Node::eventIn("set_stopTime",sfTime,&set_stopTime);
  case 5: return Node::eventIn("set_url",mfString,&set_url);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - duration_changed
 *  - isActive
 *  - description_changed
 *  - loop_changed
 *  - pitch_changed
 *  - startTime_changed
 *  - stopTime_changed
 *  - url_changed
 */
wrl::Node::EventOutHandle
wrl::AudioClip::eventOut(const std::string& n)
{
  if(n==std::string("duration_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &duration_changed);
  }
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("description_changed"))
  {
    return Node::eventOut(n,sfString,(void*) &description_changed);
  }
  if(n==std::string("loop_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &loop_changed);
  }
  if(n==std::string("pitch_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &pitch_changed);
  }
  if(n==std::string("startTime_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &startTime_changed);
  }
  if(n==std::string("stopTime_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &stopTime_changed);
  }
  if(n==std::string("url_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &url_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : duration_changed
 *  - 1 : isActive
 *  - 2 : description_changed
 *  - 3 : loop_changed
 *  - 4 : pitch_changed
 *  - 5 : startTime_changed
 *  - 6 : stopTime_changed
 *  - 7 : url_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::AudioClip::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("duration_changed",sfTime,&duration_changed);
  case 1: return Node::eventOut("isActive",sfBool,&isActive);
  case 2: return Node::eventOut("description_changed",sfString,&description_changed);
  case 3: return Node::eventOut("loop_changed",sfBool,&loop_changed);
  case 4: return Node::eventOut("pitch_changed",sfFloat,&pitch_changed);
  case 5: return Node::eventOut("startTime_changed",sfTime,&startTime_changed);
  case 6: return Node::eventOut("stopTime_changed",sfTime,&stopTime_changed);
  case 7: return Node::eventOut("url_changed",mfString,&url_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::AudioClip::duplicate() const
{
  AudioClip* n = new AudioClip(name());
  n->description = description;
  n->loop = loop;
  n->pitch = pitch;
  n->startTime = startTime;
  n->stopTime = stopTime;
  n->url = url;
  return n;
}
wrl::Node* 
wrl::AudioClip::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  AudioClip* n = new AudioClip(name());
  nodeMap[this] = n;  n->description = description;
  n->loop = loop;
  n->pitch = pitch;
  n->startTime = startTime;
  n->stopTime = stopTime;
  n->url = url;
  return n;
}
bool
wrl::AudioClip::isSetToDefaultValue(unsigned int i) const
{
  static const SFString descriptionDV_("");
  static const SFBool loopDV_(false);
  static const SFFloat pitchDV_(1.0f);
  static const SFTime startTimeDV_(0);
  static const SFTime stopTimeDV_(0);
  switch (i)
  {
  case 0: return description == descriptionDV_;
  case 1: return loop == loopDV_;
  case 2: return pitch == pitchDV_;
  case 3: return startTime == startTimeDV_;
  case 4: return stopTime == stopTimeDV_;
  case 5: return url == MFString();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
