#ifndef XDKWRL_SCRIPT_H
#define XDKWRL_SCRIPT_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <map>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Script
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Script : public DeclaredNode
  {
     public:
       Script(const char* name="");
       virtual ~Script() {};
       virtual FieldHandle field(const std::string& n);
       virtual unsigned int nbFields() const;
       virtual FieldHandle field(unsigned int i);
       virtual bool isSetToDefaultValue(unsigned int i) const;
       inline const char* typeName() const;
       virtual Node* duplicate() const;
       virtual Node* duplicate(std::map<const Node*,Node*>&) const;
    
       MFString   url;
       SFBool     directOutput;
       SFBool     mustEvaluate;

       virtual bool isDeclaredField(const std::string& n) const;
       virtual bool isDeclaredField(unsigned int i) const;
  };
  //************************************************************
  // Implementation of Script
  //************************************************************
  inline const char*
  Script::typeName() const
  {
    return "Script";
  }
};
#endif // XDKWRL_SCRIPT_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../src/xdkwrl/")
// End:
