#ifndef XDKWRL_TRANSFORM_H
#define XDKWRL_TRANSFORM_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Transform
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Transform : public Node
  {
   public:
     Transform(const char* name="");
     virtual ~Transform();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       center.setXYZ(0.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    center;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     children;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       rotation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
       \endcode
       */
       SFRotation rotation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       scale.setXYZ(1.0f,1.0f,1.0f);
       \endcode
       */
       SFVec3f    scale;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       scaleOrientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
       \endcode
       */
       SFRotation scaleOrientation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       translation.setXYZ(0.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    translation;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       bboxCenter.setXYZ(0.0f,0.0f,0.0f);
        \endcode
       */
       SFVec3f    bboxCenter;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
        \endcode
       */
       SFVec3f    bboxSize;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     addChildren;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     removeChildren;
      /*!
       * Set event associated to exposedField center
       */
       EventIn<SFVec3f>    set_center;
      /*!
       * Set event associated to exposedField children
       */
       EventIn<MFNode>     set_children;
      /*!
       * Set event associated to exposedField rotation
       */
       EventIn<SFRotation> set_rotation;
      /*!
       * Set event associated to exposedField scale
       */
       EventIn<SFVec3f>    set_scale;
      /*!
       * Set event associated to exposedField scaleOrientation
       */
       EventIn<SFRotation> set_scaleOrientation;
      /*!
       * Set event associated to exposedField translation
       */
       EventIn<SFVec3f>    set_translation;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField center
       */
       EventOut<SFVec3f>    center_changed;
      /*!
       * Changed event associated to exposedField children
       */
       EventOut<MFNode>     children_changed;
      /*!
       * Changed event associated to exposedField rotation
       */
       EventOut<SFRotation> rotation_changed;
      /*!
       * Changed event associated to exposedField scale
       */
       EventOut<SFVec3f>    scale_changed;
      /*!
       * Changed event associated to exposedField scaleOrientation
       */
       EventOut<SFRotation> scaleOrientation_changed;
      /*!
       * Changed event associated to exposedField translation
       */
       EventOut<SFVec3f>    translation_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Transform
//************************************************************
/*!
 * Returns <code>"Transform"</code>. Useful for printing.
 */
inline const char*
wrl::Transform::typeName() const
{
  return "Transform";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Transform::nbFields() const
{
   return 8;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Transform::nbEventsIn() const
{
   return 2;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Transform::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_TRANSFORM_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
