#ifndef XDKWRL_SHAPE_H
#define XDKWRL_SHAPE_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfnode.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Shape
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Shape : public Node
  {
   public:
     Shape(const char* name="");
     virtual ~Shape();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     appearance;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     geometry;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField appearance
       */
       EventIn<SFNode>     set_appearance;
      /*!
       * Set event associated to exposedField geometry
       */
       EventIn<SFNode>     set_geometry;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField appearance
       */
       EventOut<SFNode>     appearance_changed;
      /*!
       * Changed event associated to exposedField geometry
       */
       EventOut<SFNode>     geometry_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Shape
//************************************************************
/*!
 * Returns <code>"Shape"</code>. Useful for printing.
 */
inline const char*
wrl::Shape::typeName() const
{
  return "Shape";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Shape::nbFields() const
{
   return 2;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Shape::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Shape::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_SHAPE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
