#ifndef XDKWRL_MOVIETEXTURE_H
#define XDKWRL_MOVIETEXTURE_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sftime.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of MovieTexture
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API MovieTexture : public Node
  {
   public:
     MovieTexture(const char* name="");
     virtual ~MovieTexture();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       loop = false;
       \endcode
       */
       SFBool     loop;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       speed = 1.0f;
       \endcode
       */
       SFFloat    speed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       startTime.setNbSeconds(0);
       \endcode
       */
       SFTime     startTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       stopTime.setNbSeconds(0);
       \endcode
       */
       SFTime     stopTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFString default value
       */
       MFString   url;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       repeatS = true;
        \endcode
       */
       SFBool     repeatS;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       repeatT = true;
        \endcode
       */
       SFBool     repeatT;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField loop
       */
       EventIn<SFBool>     set_loop;
      /*!
       * Set event associated to exposedField speed
       */
       EventIn<SFFloat>    set_speed;
      /*!
       * Set event associated to exposedField startTime
       */
       EventIn<SFTime>     set_startTime;
      /*!
       * Set event associated to exposedField stopTime
       */
       EventIn<SFTime>     set_stopTime;
      /*!
       * Set event associated to exposedField url
       */
       EventIn<MFString>   set_url;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     duration_changed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isActive;
      /*!
       * Changed event associated to exposedField loop
       */
       EventOut<SFBool>     loop_changed;
      /*!
       * Changed event associated to exposedField speed
       */
       EventOut<SFFloat>    speed_changed;
      /*!
       * Changed event associated to exposedField startTime
       */
       EventOut<SFTime>     startTime_changed;
      /*!
       * Changed event associated to exposedField stopTime
       */
       EventOut<SFTime>     stopTime_changed;
      /*!
       * Changed event associated to exposedField url
       */
       EventOut<MFString>   url_changed;
  //!@}
  };
};
//************************************************************
// Implementation of MovieTexture
//************************************************************
/*!
 * Returns <code>"MovieTexture"</code>. Useful for printing.
 */
inline const char*
wrl::MovieTexture::typeName() const
{
  return "MovieTexture";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::MovieTexture::nbFields() const
{
   return 7;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::MovieTexture::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::MovieTexture::nbEventsOut() const
{
   return 2;
}
#endif // XDKWRL_MOVIETEXTURE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
