#ifndef XDKWRL_MATERIAL_H
#define XDKWRL_MATERIAL_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Material
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Material : public Node
  {
   public:
     Material(const char* name="");
     virtual ~Material();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       ambientIntensity = 0.2f;
       \endcode
       */
       SFFloat    ambientIntensity;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       diffuseColor.setRGB(0.8f,0.8f,0.8f);
       \endcode
       */
       SFColor    diffuseColor;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       emissiveColor.setRGB(0.0f,0.0f,0.0f);
       \endcode
       */
       SFColor    emissiveColor;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       shininess = 0.2f;
       \endcode
       */
       SFFloat    shininess;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       specularColor.setRGB(0.0f,0.0f,0.0f);
       \endcode
       */
       SFColor    specularColor;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       transparency = 0.0f;
       \endcode
       */
       SFFloat    transparency;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField ambientIntensity
       */
       EventIn<SFFloat>    set_ambientIntensity;
      /*!
       * Set event associated to exposedField diffuseColor
       */
       EventIn<SFColor>    set_diffuseColor;
      /*!
       * Set event associated to exposedField emissiveColor
       */
       EventIn<SFColor>    set_emissiveColor;
      /*!
       * Set event associated to exposedField shininess
       */
       EventIn<SFFloat>    set_shininess;
      /*!
       * Set event associated to exposedField specularColor
       */
       EventIn<SFColor>    set_specularColor;
      /*!
       * Set event associated to exposedField transparency
       */
       EventIn<SFFloat>    set_transparency;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField ambientIntensity
       */
       EventOut<SFFloat>    ambientIntensity_changed;
      /*!
       * Changed event associated to exposedField diffuseColor
       */
       EventOut<SFColor>    diffuseColor_changed;
      /*!
       * Changed event associated to exposedField emissiveColor
       */
       EventOut<SFColor>    emissiveColor_changed;
      /*!
       * Changed event associated to exposedField shininess
       */
       EventOut<SFFloat>    shininess_changed;
      /*!
       * Changed event associated to exposedField specularColor
       */
       EventOut<SFColor>    specularColor_changed;
      /*!
       * Changed event associated to exposedField transparency
       */
       EventOut<SFFloat>    transparency_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Material
//************************************************************
/*!
 * Returns <code>"Material"</code>. Useful for printing.
 */
inline const char*
wrl::Material::typeName() const
{
  return "Material";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Material::nbFields() const
{
   return 6;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Material::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Material::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_MATERIAL_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
