#ifndef XDKWRL_INDEXEDLINESET_H
#define XDKWRL_INDEXEDLINESET_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfint32.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfnode.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of IndexedLineSet
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API IndexedLineSet : public Node
  {
   public:
     IndexedLineSet(const char* name="");
     virtual ~IndexedLineSet();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     color;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     coord;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFInt32 default value
       */
       MFInt32    colorIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       colorPerVertex = true;
        \endcode
       */
       SFBool     colorPerVertex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFInt32 default value
       */
       MFInt32    coordIndex;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFInt32>    set_colorIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFInt32>    set_coordIndex;
      /*!
       * Set event associated to exposedField color
       */
       EventIn<SFNode>     set_color;
      /*!
       * Set event associated to exposedField coord
       */
       EventIn<SFNode>     set_coord;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField color
       */
       EventOut<SFNode>     color_changed;
      /*!
       * Changed event associated to exposedField coord
       */
       EventOut<SFNode>     coord_changed;
  //!@}
  };
};
//************************************************************
// Implementation of IndexedLineSet
//************************************************************
/*!
 * Returns <code>"IndexedLineSet"</code>. Useful for printing.
 */
inline const char*
wrl::IndexedLineSet::typeName() const
{
  return "IndexedLineSet";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::IndexedLineSet::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::IndexedLineSet::nbEventsIn() const
{
   return 2;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::IndexedLineSet::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_INDEXEDLINESET_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
