#ifndef XDKWRL_GEOELEVATIONGRID_H
#define XDKWRL_GEOELEVATIONGRID_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfstring.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of GeoElevationGrid
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API GeoElevationGrid : public Node
  {
   public:
     GeoElevationGrid(const char* name="");
     virtual ~GeoElevationGrid();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     color;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     normal;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     texCoord;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       ccw = true;
        \endcode
       */
       SFBool     ccw;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       colorPerVertex = true;
        \endcode
       */
       SFBool     colorPerVertex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       creaseAngle = 0.0f;
        \endcode
       */
       SFFloat    creaseAngle;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     geoOrigin;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
        \endcode
       */
       MFString   geoSystem;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       geoGridOrigin = string("0 0 0");
        \endcode
       */
       SFString   geoGridOrigin;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    height;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       normalPerVertex = true;
        \endcode
       */
       SFBool     normalPerVertex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       solid = true;
        \endcode
       */
       SFBool     solid;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       xDimension = 0;
        \endcode
       */
       SFInt32    xDimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       xSpacing = string("1.0");
        \endcode
       */
       SFString   xSpacing;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       yScale = 1.0f;
        \endcode
       */
       SFFloat    yScale;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       zDimension = 0;
        \endcode
       */
       SFInt32    zDimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       zSpacing = string("1.0");
        \endcode
       */
       SFString   zSpacing;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFFloat>    set_height;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFFloat>    set_yScale;
      /*!
       * Set event associated to exposedField color
       */
       EventIn<SFNode>     set_color;
      /*!
       * Set event associated to exposedField normal
       */
       EventIn<SFNode>     set_normal;
      /*!
       * Set event associated to exposedField texCoord
       */
       EventIn<SFNode>     set_texCoord;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField color
       */
       EventOut<SFNode>     color_changed;
      /*!
       * Changed event associated to exposedField normal
       */
       EventOut<SFNode>     normal_changed;
      /*!
       * Changed event associated to exposedField texCoord
       */
       EventOut<SFNode>     texCoord_changed;
  //!@}
  };
};
//************************************************************
// Implementation of GeoElevationGrid
//************************************************************
/*!
 * Returns <code>"GeoElevationGrid"</code>. Useful for printing.
 */
inline const char*
wrl::GeoElevationGrid::typeName() const
{
  return "GeoElevationGrid";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::GeoElevationGrid::nbFields() const
{
   return 17;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::GeoElevationGrid::nbEventsIn() const
{
   return 2;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::GeoElevationGrid::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_GEOELEVATIONGRID_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
