#ifndef XDKWRL_FOG_H
#define XDKWRL_FOG_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfstring.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Fog
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Fog : public Node
  {
   public:
     Fog(const char* name="");
     virtual ~Fog();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       color.setRGB(1.0f,1.0f,1.0f);
       \endcode
       */
       SFColor    color;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       fogType = string("LINEAR");
       \endcode
       */
       SFString   fogType;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       visibilityRange = 0.0f;
       \endcode
       */
       SFFloat    visibilityRange;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFBool>     set_bind;
      /*!
       * Set event associated to exposedField color
       */
       EventIn<SFColor>    set_color;
      /*!
       * Set event associated to exposedField fogType
       */
       EventIn<SFString>   set_fogType;
      /*!
       * Set event associated to exposedField visibilityRange
       */
       EventIn<SFFloat>    set_visibilityRange;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isBound;
      /*!
       * Changed event associated to exposedField color
       */
       EventOut<SFColor>    color_changed;
      /*!
       * Changed event associated to exposedField fogType
       */
       EventOut<SFString>   fogType_changed;
      /*!
       * Changed event associated to exposedField visibilityRange
       */
       EventOut<SFFloat>    visibilityRange_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Fog
//************************************************************
/*!
 * Returns <code>"Fog"</code>. Useful for printing.
 */
inline const char*
wrl::Fog::typeName() const
{
  return "Fog";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Fog::nbFields() const
{
   return 3;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Fog::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Fog::nbEventsOut() const
{
   return 1;
}
#endif // XDKWRL_FOG_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
