#ifndef XDKWRL_COORDINATEDEFORMER_H
#define XDKWRL_COORDINATEDEFORMER_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of CoordinateDeformer
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API CoordinateDeformer : public Node
  {
   public:
     CoordinateDeformer(const char* name="");
     virtual ~CoordinateDeformer();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     children;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFVec3f default value
       */
       MFVec3f    controlPoint;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     inputCoord;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     inputTransform;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     outputCoord;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    weight;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       bboxCenter.setXYZ(0.0f,0.0f,0.0f);
        \endcode
       */
       SFVec3f    bboxCenter;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
        \endcode
       */
       SFVec3f    bboxSize;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       uDimension = 0;
        \endcode
       */
       SFInt32    uDimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    uKnot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       uOrder = 2;
        \endcode
       */
       SFInt32    uOrder;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       vDimension = 0;
        \endcode
       */
       SFInt32    vDimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    vKnot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       vOrder = 2;
        \endcode
       */
       SFInt32    vOrder;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       wDimension = 0;
        \endcode
       */
       SFInt32    wDimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    wKnot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       wOrder = 2;
        \endcode
       */
       SFInt32    wOrder;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     addChildren;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     removeChildren;
      /*!
       * Set event associated to exposedField children
       */
       EventIn<MFNode>     set_children;
      /*!
       * Set event associated to exposedField controlPoint
       */
       EventIn<MFVec3f>    set_controlPoint;
      /*!
       * Set event associated to exposedField inputCoord
       */
       EventIn<MFNode>     set_inputCoord;
      /*!
       * Set event associated to exposedField inputTransform
       */
       EventIn<MFNode>     set_inputTransform;
      /*!
       * Set event associated to exposedField outputCoord
       */
       EventIn<MFNode>     set_outputCoord;
      /*!
       * Set event associated to exposedField weight
       */
       EventIn<MFFloat>    set_weight;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField children
       */
       EventOut<MFNode>     children_changed;
      /*!
       * Changed event associated to exposedField controlPoint
       */
       EventOut<MFVec3f>    controlPoint_changed;
      /*!
       * Changed event associated to exposedField inputCoord
       */
       EventOut<MFNode>     inputCoord_changed;
      /*!
       * Changed event associated to exposedField inputTransform
       */
       EventOut<MFNode>     inputTransform_changed;
      /*!
       * Changed event associated to exposedField outputCoord
       */
       EventOut<MFNode>     outputCoord_changed;
      /*!
       * Changed event associated to exposedField weight
       */
       EventOut<MFFloat>    weight_changed;
  //!@}
  };
};
//************************************************************
// Implementation of CoordinateDeformer
//************************************************************
/*!
 * Returns <code>"CoordinateDeformer"</code>. Useful for printing.
 */
inline const char*
wrl::CoordinateDeformer::typeName() const
{
  return "CoordinateDeformer";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::CoordinateDeformer::nbFields() const
{
   return 17;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::CoordinateDeformer::nbEventsIn() const
{
   return 2;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::CoordinateDeformer::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_COORDINATEDEFORMER_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
