#ifndef XDKWRL_COLORINTERPOLATOR_H
#define XDKWRL_COLORINTERPOLATOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfcolor.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of ColorInterpolator
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API ColorInterpolator : public Node
  {
   public:
     ColorInterpolator(const char* name="");
     virtual ~ColorInterpolator();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    key;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFColor default value
       */
       MFColor    keyValue;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFFloat>    set_fraction;
      /*!
       * Set event associated to exposedField key
       */
       EventIn<MFFloat>    set_key;
      /*!
       * Set event associated to exposedField keyValue
       */
       EventIn<MFColor>    set_keyValue;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFColor>    value_changed;
      /*!
       * Changed event associated to exposedField key
       */
       EventOut<MFFloat>    key_changed;
      /*!
       * Changed event associated to exposedField keyValue
       */
       EventOut<MFColor>    keyValue_changed;
  //!@}
  };
};
//************************************************************
// Implementation of ColorInterpolator
//************************************************************
/*!
 * Returns <code>"ColorInterpolator"</code>. Useful for printing.
 */
inline const char*
wrl::ColorInterpolator::typeName() const
{
  return "ColorInterpolator";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::ColorInterpolator::nbFields() const
{
   return 2;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::ColorInterpolator::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::ColorInterpolator::nbEventsOut() const
{
   return 1;
}
#endif // XDKWRL_COLORINTERPOLATOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
