#ifndef XDKWRL_SFVEC2F_H
#define XDKWRL_SFVEC2F_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  SFVec2f
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a 2 coordinates (X,Y) vector. Below is included the
   * documentation for this field type from the ISO standard.   
   * \htmlinclude sfvec2f.html
   */
  class XDKWRL_API SFVec2f 
  {
  public:
    inline SFVec2f();
    inline SFVec2f(const float* c);
    inline SFVec2f(const float x,const float y);
    inline operator const float*() const;
    inline operator float*();
    inline float x() const;
    inline float y() const;
    inline void setXY(const float x,const float y);
    inline void setX(const float);
    inline void setY(const float);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    inline bool operator==(const SFVec2f& c) const;
    friend std::ostream& operator<<(std::ostream& s,const SFVec2f& f);
  protected:
  private:
    float x_;
    float y_;
  };
  //************************************************************
  // Implementation of SFVec2f
  //************************************************************
  inline
  SFVec2f::SFVec2f()
    : x_(0.0f),y_(0.0f)
  {
  }
  inline
  SFVec2f::SFVec2f(const float* c)
    : x_(c[0]),y_(c[1])
  {    
  }
  inline
  SFVec2f::SFVec2f(const float x,const float y)
    : x_(x),y_(y)
  {    
  }    
  inline
  SFVec2f::operator const float*() const
  {
    return &x_;
  }
  inline
  SFVec2f::operator float*()
  {
    return &x_;
  }
  inline float
  SFVec2f::x() const
  {
    return x_;
  }
  inline float
  SFVec2f::y() const
  {
    return y_;
  }
  inline void
  SFVec2f::setX(const float x)
  {
    x_ = x;
  }
  inline void
  SFVec2f::setY(const float y)
  {
    y_ = y;
  }
  inline void
  SFVec2f::setXY(const float x,const float y)
  {
    x_ = x;
    y_ = y;
  }  
  inline bool
  SFVec2f::operator==(const SFVec2f& c) const
  {
    return x_ == c.x_ && y_ == c.y_;
  }
  inline const char*
  SFVec2f::typeName()
  {
    return "SFVec2f";
  }
  inline FieldTypeId
  SFVec2f::typeId()
  {
    return sfVec2f;
  }  
};

#endif // XDKWRL_SFVEC2F_H
