#ifndef XDKWRL_MFVEC3F_H
#define XDKWRL_MFVEC3F_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFVec3f
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFVec3f is a container of SFVec3f. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFVec3f mf;
   mf.push_back(SFVec3f(0.0f,0.0f));  
   mf.push_front(SFVec3f(1.0f,0.0f));
   mf[0].setX(1.0f);
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sfvec3f.html
   */
  class XDKWRL_API MFVec3f : public std::deque<SFVec3f>
  {
  public:
    inline MFVec3f();
    template <class T>
    inline MFVec3f(T first,T last);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFVec3f& f);
  };
  //************************************************************
  // Implementation of MFVec3f
  //************************************************************
  inline MFVec3f::MFVec3f()
  {
  }
  template <class T>  
  inline MFVec3f::MFVec3f(T first,T last)
    : std::deque<SFVec3f>(first,last)
  {
  }
  inline const char*
  MFVec3f::typeName()
  {
    return "MFVec3f";
  }
  inline FieldTypeId
  MFVec3f::typeId()
  {
    return mfVec3f;
  }  
}

#endif // XDKWRL_MFVEC3F_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
