#ifndef XDKWRL_MFINT32_H
#define XDKWRL_MFINT32_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFInt32
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFInt32 is a container of SFInt32. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFInt32 mf;
   mf.push_back(SFInt32(1));  // push_back (1); would fail since
   mf.push_front(SFInt32(2)); // constructor SFInt32(int) is explicit
   mf[0] = 3; // Valid since SFInt32 has operator=(int)
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sfint32.html
   */
  class XDKWRL_API MFInt32 : public std::deque<SFInt32>
  {
  public:
    inline MFInt32();
    template <class T>
    inline MFInt32(T first,T last);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFInt32& f);
  };
  //************************************************************
  // Implementation of MFInt32
  //************************************************************
  inline
  MFInt32::MFInt32()
  {
  }
  template <class T>
  inline
  MFInt32::MFInt32(T first,T last)
    : std::deque<SFInt32>(first,last)
  {
  }
  inline const char*
  MFInt32::typeName()
  {
    return "MFInt32";
  }
  inline FieldTypeId
  MFInt32::typeId()
  {
    return mfInt32;
  }  
}

#endif // XDKWRL_MFINT32_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
