#ifndef XDKWRL_MFFLOAT_H
#define XDKWRL_MFFLOAT_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFFloat
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFFloat is a container of SFFloat. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFFloat mf;
   mf.push_back(SFFloat(1.0f));  // push_back (1.0f); would fail since
   mf.push_front(SFFloat(2.0f)); // constructor SFFloat(float) is explicit
   mf[0] = 3.0f; // Valid since SFFloat has operator=(float)
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sffloat.html
   */
  class XDKWRL_API MFFloat : public std::deque<SFFloat>
  {
  public:
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFFloat& f);
  };
  //************************************************************
  // Implementation of MFFloat
  //************************************************************
  inline const char*
  MFFloat::typeName()
  {
    return "MFFloat";
  }
  inline FieldTypeId
  MFFloat::typeId()
  {
    return mfFloat;
  }  
}

#endif // XDKWRL_MFFLOAT_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
