#ifndef XDKWRL_MFCOLOR_H
#define XDKWRL_MFCOLOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFColor
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFColor is a container of SFColor. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFColor mf;
   mf.push_back(SFColor(1.0f,0.0f,0.0f));  // Red
   mf.push_front(SFColor(0.0f,1.0f,0.0f)); // Green
   mf[0].setRGB(0.0f,0.0f,1.0f);           // Blue
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sfcolor.html
   */
  class XDKWRL_API MFColor : public std::deque<SFColor>
  {
  public:
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFColor& f);
  };
  //************************************************************
  // Implementation of MFColor
  //************************************************************
  inline const char*
  MFColor::typeName()
  {
    return "MFColor";
  }
  inline FieldTypeId
  MFColor::typeId()
  {
    return mfColor;
  }
};

#endif // XDKWRL_MFCOLOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
