#include <xdkwrl/scene.h>
#include <xdkwrl/tools/prettyprinter.h>
#include <xdkwrl/tools/argstream.h>

#include <iostream>
#include <fstream>
#include <stdexcept>
#include <deque>

using namespace std;

int
main(int argc,char** argv)
{
	bool verbose;
	bool output; 
	bool slow; 
	deque<string> files;
	argstream as(argc,argv);
	as>>option('v',"verbose",verbose,"")
		>>option('o',"output",output,"")
		>>option('s',"slow",slow,"")
		>>values<string>(back_inserter(files),"files to parse")
		>>help();
	as.defaultErrorHandling();
	try
	{
		for (deque<string>::const_iterator iter = files.begin();
			iter != files.end();++iter)
		{
			wrl::Scene scene;
			scene.load(iter->c_str(),verbose,!slow);
			if (output)
			{
				wrl::PrettyPrinter p(cout);
				p<<scene;
			}
		}
	}
	catch (runtime_error& e)
	{
		cerr <<e.what()<<endl;
	}
}

