/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_k_rda.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t38, t40, t42, t43;
  double t44, t45, t46, t47, t49, t51, t52, t53;
  double t54, t55, t56, t58, t59, t62, t64, t67;
  double t68, t69, t72, t73, t76, t77, t79, t82;
  double t83, t84, t85, t88, t89, t90, t92, t96;
  double t97, t99, t100, t102, t106, tzk0;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = t25 * t25;
  t42 = 0.1e1 / t27 / t26;
  t43 = t40 * t42;
  t44 = sigma[0] * sigma[0];
  t45 = t44 * t31;
  t46 = t34 * t34;
  t47 = t46 * rho[0];
  t49 = 0.1e1 / t22 / t47;
  t51 = t43 * t45 * t49;
  t52 = params->a * t40;
  t53 = t52 * t42;
  t54 = lapl[0] * lapl[0];
  t55 = t54 * t31;
  t56 = t34 * rho[0];
  t58 = 0.1e1 / t22 / t56;
  t59 = t55 * t58;
  t62 = 0.2e1 * t53 * t59 + 0.2e1 * t51;
  t64 = sqrt(t62);
  t67 = 0.1e1 + params->beta1 * t64 / 0.24e2;
  t68 = t67 * t67;
  t69 = 0.1e1 / t68;
  t72 = params->b * t40;
  t73 = t72 * t42;
  t76 = 0.2e1 * t73 * t59 + 0.2e1 * t51;
  t77 = t76 * t76;
  t79 = sqrt(t76);
  t82 = 0.1e1 + params->beta2 * t79 / 0.24e2;
  t83 = t82 * t82;
  t84 = t83 * t83;
  t85 = 0.1e1 / t84;
  t88 = params->c * t25;
  t89 = t88 * t29;
  t90 = lapl[0] * t32;
  t92 = 0.1e1 / t23 / rho[0];
  t96 = t89 * t90 * t92 / 0.24e2 + t38 / 0.24e2;
  t97 = params->A3 * t96;
  t99 = params->beta3 * t96 + 0.1e1;
  t100 = 0.1e1 / t99;
  t102 = 0.5e1 / 0.72e2 * t38 + params->A0 + params->A1 * t62 * t69 / 0.576e3 + params->A2 * t77 * t85 / 0.331776e6 + t97 * t100;
  t106 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t38, t40, t42, t43;
  double t44, t45, t46, t47, t49, t51, t52, t53;
  double t54, t55, t56, t58, t59, t62, t64, t67;
  double t68, t69, t72, t73, t76, t77, t79, t82;
  double t83, t84, t85, t88, t89, t90, t92, t96;
  double t97, t99, t100, t102, t106, tzk0;

  double t108, t113, t115, t117, t119, t122, t124, t125;
  double t128, t132, t134, t135, t139, t142, t146, t147;
  double t149, t150, t158, t159, t161, t162, t163, t164;
  double t166, t171, tvrho0, t174, t175, t177, t178, t179;
  double t180, t184, t185, t186, t189, t190, t191, t192;
  double t193, t196, t199, t200, t204, t207, t211, tvsigma0;
  double t213, t214, t215, t216, t220, t221, t222, t223;
  double t226, t227, t231, t234, t235, t236, t242, t245;
  double t249, tvlapl0, tvtau0;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = t25 * t25;
  t42 = 0.1e1 / t27 / t26;
  t43 = t40 * t42;
  t44 = sigma[0] * sigma[0];
  t45 = t44 * t31;
  t46 = t34 * t34;
  t47 = t46 * rho[0];
  t49 = 0.1e1 / t22 / t47;
  t51 = t43 * t45 * t49;
  t52 = params->a * t40;
  t53 = t52 * t42;
  t54 = lapl[0] * lapl[0];
  t55 = t54 * t31;
  t56 = t34 * rho[0];
  t58 = 0.1e1 / t22 / t56;
  t59 = t55 * t58;
  t62 = 0.2e1 * t53 * t59 + 0.2e1 * t51;
  t64 = sqrt(t62);
  t67 = 0.1e1 + params->beta1 * t64 / 0.24e2;
  t68 = t67 * t67;
  t69 = 0.1e1 / t68;
  t72 = params->b * t40;
  t73 = t72 * t42;
  t76 = 0.2e1 * t73 * t59 + 0.2e1 * t51;
  t77 = t76 * t76;
  t79 = sqrt(t76);
  t82 = 0.1e1 + params->beta2 * t79 / 0.24e2;
  t83 = t82 * t82;
  t84 = t83 * t83;
  t85 = 0.1e1 / t84;
  t88 = params->c * t25;
  t89 = t88 * t29;
  t90 = lapl[0] * t32;
  t92 = 0.1e1 / t23 / rho[0];
  t96 = t89 * t90 * t92 / 0.24e2 + t38 / 0.24e2;
  t97 = params->A3 * t96;
  t99 = params->beta3 * t96 + 0.1e1;
  t100 = 0.1e1 / t99;
  t102 = 0.5e1 / 0.72e2 * t38 + params->A0 + params->A1 * t62 * t69 / 0.576e3 + params->A2 * t77 * t85 / 0.331776e6 + t97 * t100;
  t106 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t108 = t21 / t22;
  t113 = 0.1e1 / t23 / t56;
  t115 = t30 * t33 * t113;
  t117 = t46 * t34;
  t119 = 0.1e1 / t22 / t117;
  t122 = 0.32e2 / 0.3e1 * t43 * t45 * t119;
  t124 = 0.1e1 / t22 / t46;
  t125 = t55 * t124;
  t128 = -t122 - 0.2e2 / 0.3e1 * t53 * t125;
  t132 = params->A1 * t64;
  t134 = 0.1e1 / t68 / t67;
  t135 = t134 * params->beta1;
  t139 = params->A2 * t76;
  t142 = -t122 - 0.2e2 / 0.3e1 * t73 * t125;
  t146 = t79 * t76;
  t147 = params->A2 * t146;
  t149 = 0.1e1 / t84 / t82;
  t150 = t149 * params->beta2;
  t158 = -t115 / 0.9e1 - 0.5e1 / 0.72e2 * t89 * t90 * t36;
  t159 = params->A3 * t158;
  t161 = t99 * t99;
  t162 = 0.1e1 / t161;
  t163 = t162 * params->beta3;
  t164 = t163 * t158;
  t166 = -0.5e1 / 0.27e2 * t115 + params->A1 * t128 * t69 / 0.576e3 - t132 * t135 * t128 / 0.13824e5 + t139 * t85 * t142 / 0.165888e6 - t147 * t150 * t142 / 0.3981312e7 + t159 * t100 - t97 * t164;
  t171 = my_piecewise3(t3, 0, t8 * t108 * t102 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t166);
  tvrho0 = 0.2e1 * rho[0] * t171 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t174 = t32 * t36;
  t175 = t30 * t174;
  t177 = params->A1 * t40;
  t178 = t177 * t42;
  t179 = sigma[0] * t31;
  t180 = t49 * t69;
  t184 = t132 * t135;
  t185 = t179 * t49;
  t186 = t43 * t185;
  t189 = t85 * t40;
  t190 = t139 * t189;
  t191 = t42 * sigma[0];
  t192 = t31 * t49;
  t193 = t191 * t192;
  t196 = t147 * t150;
  t199 = params->A3 * t25;
  t200 = t199 * t29;
  t204 = t97 * t163;
  t207 = 0.5e1 / 0.72e2 * t175 + t178 * t179 * t180 / 0.144e3 - t184 * t186 / 0.3456e4 + t190 * t193 / 0.41472e5 - t196 * t186 / 0.995328e6 + t200 * t174 * t100 / 0.24e2 - t204 * t175 / 0.24e2;
  t211 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t207);
  tvsigma0 = 0.2e1 * rho[0] * t211;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t213 = params->A1 * params->a;
  t214 = t213 * t43;
  t215 = lapl[0] * t31;
  t216 = t58 * t69;
  t220 = t135 * params->a;
  t221 = t132 * t220;
  t222 = t215 * t58;
  t223 = t43 * t222;
  t226 = t85 * params->b;
  t227 = t139 * t226;
  t231 = t147 * t150 * params->b;
  t234 = params->A3 * params->c;
  t235 = t234 * t25;
  t236 = t29 * t32;
  t242 = t88 * t236 * t92;
  t245 = t214 * t215 * t216 / 0.144e3 - t221 * t223 / 0.3456e4 + t227 * t223 / 0.41472e5 - t231 * t223 / 0.995328e6 + t235 * t236 * t92 * t100 / 0.24e2 - t204 * t242 / 0.24e2;
  t249 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t245);
  tvlapl0 = 0.2e1 * rho[0] * t249;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t38, t40, t42, t43;
  double t44, t45, t46, t47, t49, t51, t52, t53;
  double t54, t55, t56, t58, t59, t62, t64, t67;
  double t68, t69, t72, t73, t76, t77, t79, t82;
  double t83, t84, t85, t88, t89, t90, t92, t96;
  double t97, t99, t100, t102, t106, tzk0;

  double t108, t113, t115, t117, t119, t122, t124, t125;
  double t128, t132, t134, t135, t139, t142, t146, t147;
  double t149, t150, t158, t159, t161, t162, t163, t164;
  double t166, t171, tvrho0, t174, t175, t177, t178, t179;
  double t180, t184, t185, t186, t189, t190, t191, t192;
  double t193, t196, t199, t200, t204, t207, t211, tvsigma0;
  double t213, t214, t215, t216, t220, t221, t222, t223;
  double t226, t227, t231, t234, t235, t236, t242, t245;
  double t249, tvlapl0, tvtau0;

  double t254, t262, t264, t266, t268, t271, t272, t275;
  double t276, t279, t280, t281, t282, t285, t286, t287;
  double t288, t295, t296, t299, t306, t307, t311, t312;
  double t313, t324, t325, t327, t328, t332, t333, t334;
  double t335, t338, t340, t345, tv2rho20, t351, t352, t354;
  double t358, t359, t360, t361, t362, t363, t367, t368;
  double t373, t376, t377, t380, t381, t382, t383, t384;
  double t388, t389, t393, t394, t403, t404, t405, t409;
  double t411, t416, t421, tv2rhosigma0, t427, t431, t432, t433;
  double t434, t438, t440, t441, t442, t447, t450, t453;
  double t454, t455, t456, t457, t458, t465, t466, t476;
  double t477, t482, t491, t496, tv2rholapl0, tv2rhotau0, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t517;
  double t521, t524, t525, t526, t527, t532, t533, t537;
  double t540, t541, t548, t549, t550, t555, t559, tv2sigma20;
  double t561, t562, t564, t565, t566, t567, t572, t573;
  double t574, t578, t579, t580, t585, t586, t588, t595;
  double t596, t597, t600, t601, t602, t606, t610, tv2sigmalapl0;
  double tv2sigmatau0, t612, t616, t617, t618, t619, t621, t622;
  double t623, t627, t628, t629, t630, t633, t637, t638;
  double t639, t640, t644, t646, t647, t648, t652, t656;
  double t659, t662, t663, t664, t668, t672, t676, tv2lapl20;
  double tv2lapltau0, tv2tau20;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = t25 * t25;
  t42 = 0.1e1 / t27 / t26;
  t43 = t40 * t42;
  t44 = sigma[0] * sigma[0];
  t45 = t44 * t31;
  t46 = t34 * t34;
  t47 = t46 * rho[0];
  t49 = 0.1e1 / t22 / t47;
  t51 = t43 * t45 * t49;
  t52 = params->a * t40;
  t53 = t52 * t42;
  t54 = lapl[0] * lapl[0];
  t55 = t54 * t31;
  t56 = t34 * rho[0];
  t58 = 0.1e1 / t22 / t56;
  t59 = t55 * t58;
  t62 = 0.2e1 * t53 * t59 + 0.2e1 * t51;
  t64 = sqrt(t62);
  t67 = 0.1e1 + params->beta1 * t64 / 0.24e2;
  t68 = t67 * t67;
  t69 = 0.1e1 / t68;
  t72 = params->b * t40;
  t73 = t72 * t42;
  t76 = 0.2e1 * t73 * t59 + 0.2e1 * t51;
  t77 = t76 * t76;
  t79 = sqrt(t76);
  t82 = 0.1e1 + params->beta2 * t79 / 0.24e2;
  t83 = t82 * t82;
  t84 = t83 * t83;
  t85 = 0.1e1 / t84;
  t88 = params->c * t25;
  t89 = t88 * t29;
  t90 = lapl[0] * t32;
  t92 = 0.1e1 / t23 / rho[0];
  t96 = t89 * t90 * t92 / 0.24e2 + t38 / 0.24e2;
  t97 = params->A3 * t96;
  t99 = params->beta3 * t96 + 0.1e1;
  t100 = 0.1e1 / t99;
  t102 = 0.5e1 / 0.72e2 * t38 + params->A0 + params->A1 * t62 * t69 / 0.576e3 + params->A2 * t77 * t85 / 0.331776e6 + t97 * t100;
  t106 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t108 = t21 / t22;
  t113 = 0.1e1 / t23 / t56;
  t115 = t30 * t33 * t113;
  t117 = t46 * t34;
  t119 = 0.1e1 / t22 / t117;
  t122 = 0.32e2 / 0.3e1 * t43 * t45 * t119;
  t124 = 0.1e1 / t22 / t46;
  t125 = t55 * t124;
  t128 = -t122 - 0.2e2 / 0.3e1 * t53 * t125;
  t132 = params->A1 * t64;
  t134 = 0.1e1 / t68 / t67;
  t135 = t134 * params->beta1;
  t139 = params->A2 * t76;
  t142 = -t122 - 0.2e2 / 0.3e1 * t73 * t125;
  t146 = t79 * t76;
  t147 = params->A2 * t146;
  t149 = 0.1e1 / t84 / t82;
  t150 = t149 * params->beta2;
  t158 = -t115 / 0.9e1 - 0.5e1 / 0.72e2 * t89 * t90 * t36;
  t159 = params->A3 * t158;
  t161 = t99 * t99;
  t162 = 0.1e1 / t161;
  t163 = t162 * params->beta3;
  t164 = t163 * t158;
  t166 = -0.5e1 / 0.27e2 * t115 + params->A1 * t128 * t69 / 0.576e3 - t132 * t135 * t128 / 0.13824e5 + t139 * t85 * t142 / 0.165888e6 - t147 * t150 * t142 / 0.3981312e7 + t159 * t100 - t97 * t164;
  t171 = my_piecewise3(t3, 0, t8 * t108 * t102 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t166);
  tvrho0 = 0.2e1 * rho[0] * t171 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t174 = t32 * t36;
  t175 = t30 * t174;
  t177 = params->A1 * t40;
  t178 = t177 * t42;
  t179 = sigma[0] * t31;
  t180 = t49 * t69;
  t184 = t132 * t135;
  t185 = t179 * t49;
  t186 = t43 * t185;
  t189 = t85 * t40;
  t190 = t139 * t189;
  t191 = t42 * sigma[0];
  t192 = t31 * t49;
  t193 = t191 * t192;
  t196 = t147 * t150;
  t199 = params->A3 * t25;
  t200 = t199 * t29;
  t204 = t97 * t163;
  t207 = 0.5e1 / 0.72e2 * t175 + t178 * t179 * t180 / 0.144e3 - t184 * t186 / 0.3456e4 + t190 * t193 / 0.41472e5 - t196 * t186 / 0.995328e6 + t200 * t174 * t100 / 0.24e2 - t204 * t175 / 0.24e2;
  t211 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t207);
  tvsigma0 = 0.2e1 * rho[0] * t211;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t213 = params->A1 * params->a;
  t214 = t213 * t43;
  t215 = lapl[0] * t31;
  t216 = t58 * t69;
  t220 = t135 * params->a;
  t221 = t132 * t220;
  t222 = t215 * t58;
  t223 = t43 * t222;
  t226 = t85 * params->b;
  t227 = t139 * t226;
  t231 = t147 * t150 * params->b;
  t234 = params->A3 * params->c;
  t235 = t234 * t25;
  t236 = t29 * t32;
  t242 = t88 * t236 * t92;
  t245 = t214 * t215 * t216 / 0.144e3 - t221 * t223 / 0.3456e4 + t227 * t223 / 0.41472e5 - t231 * t223 / 0.995328e6 + t235 * t236 * t92 * t100 / 0.24e2 - t204 * t242 / 0.24e2;
  t249 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t245);
  tvlapl0 = 0.2e1 * rho[0] * t249;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t254 = t21 / t22 / rho[0];
  t262 = 0.1e1 / t23 / t46;
  t264 = t30 * t33 * t262;
  t266 = t46 * t56;
  t268 = 0.1e1 / t22 / t266;
  t271 = 0.608e3 / 0.9e1 * t43 * t45 * t268;
  t272 = t55 * t49;
  t275 = t271 + 0.26e3 / 0.9e1 * t53 * t272;
  t276 = params->A1 * t275;
  t279 = t128 * t128;
  t280 = params->A1 * t279;
  t281 = 0.1e1 / t64;
  t282 = t135 * t281;
  t285 = t68 * t68;
  t286 = 0.1e1 / t285;
  t287 = params->A1 * t286;
  t288 = params->beta1 * params->beta1;
  t295 = t142 * t142;
  t296 = params->A2 * t295;
  t299 = params->A2 * t79;
  t306 = t271 + 0.26e3 / 0.9e1 * t73 * t272;
  t307 = t85 * t306;
  t311 = 0.1e1 / t84 / t83;
  t312 = params->beta2 * params->beta2;
  t313 = t311 * t312;
  t324 = 0.11e2 / 0.27e2 * t264 + 0.5e1 / 0.27e2 * t89 * t90 * t113;
  t325 = params->A3 * t324;
  t327 = t158 * t158;
  t328 = params->A3 * t327;
  t332 = 0.1e1 / t161 / t99;
  t333 = params->beta3 * params->beta3;
  t334 = t332 * t333;
  t335 = t334 * t327;
  t338 = t163 * t324;
  t340 = 0.55e2 / 0.81e2 * t264 + t276 * t69 / 0.576e3 - t280 * t282 / 0.9216e4 + t287 * t288 * t279 / 0.221184e6 - t132 * t135 * t275 / 0.13824e5 + t296 * t85 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t299 * t149 * t295 * params->beta2 + t139 * t307 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t139 * t313 * t295 - t147 * t150 * t306 / 0.3981312e7 + t325 * t100 - 0.2e1 * t328 * t163 + 0.2e1 * t97 * t335 - t97 * t338;
  t345 = my_piecewise3(t3, 0, -t8 * t254 * t102 / 0.3e2 + t8 * t108 * t166 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2rho20 = 0.2e1 * rho[0] * t345 + 0.4e1 * t171;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t351 = t32 * t113;
  t352 = t30 * t351;
  t354 = t119 * t69;
  t358 = t191 * t31;
  t359 = t177 * t358;
  t360 = t49 * t134;
  t361 = params->beta1 * t281;
  t362 = t361 * t128;
  t363 = t360 * t362;
  t367 = t287 * t288 * t40;
  t368 = t192 * t128;
  t373 = t43 * t179 * t119;
  t376 = params->A2 * t142;
  t377 = t376 * t189;
  t380 = t149 * t40;
  t381 = t380 * t42;
  t382 = t299 * t381;
  t383 = t49 * params->beta2;
  t384 = t383 * t142;
  t388 = t31 * t119;
  t389 = t191 * t388;
  t393 = t139 * t313 * t40;
  t394 = t192 * t142;
  t403 = t199 * t236;
  t404 = t36 * t162;
  t405 = params->beta3 * t158;
  t409 = t97 * t334;
  t411 = t30 * t174 * t158;
  t416 = -0.5e1 / 0.27e2 * t352 - t178 * t179 * t354 / 0.27e2 - t359 * t363 / 0.2304e4 + t367 * t191 * t368 / 0.55296e5 + t184 * t373 / 0.648e3 + t377 * t193 / 0.41472e5 - 0.7e1 / 0.1990656e7 * t382 * t179 * t384 - t190 * t389 / 0.7776e4 + 0.5e1 / 0.47775744e8 * t393 * t191 * t394 + t196 * t373 / 0.186624e6 - t200 * t351 * t100 / 0.9e1 - t403 * t404 * t405 / 0.12e2 + t409 * t411 / 0.12e2 + t204 * t352 / 0.9e1;
  t421 = my_piecewise3(t3, 0, t8 * t108 * t207 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t416);
  tv2rhosigma0 = 0.2e1 * rho[0] * t421 + 0.2e1 * t211;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t427 = t124 * t69;
  t431 = t43 * lapl[0];
  t432 = t213 * t431;
  t433 = t31 * t58;
  t434 = t433 * t134;
  t438 = t288 * params->a;
  t440 = t287 * t438 * t40;
  t441 = t42 * lapl[0];
  t442 = t433 * t128;
  t447 = t43 * t215 * t124;
  t450 = t376 * t226;
  t453 = t149 * params->b;
  t454 = t453 * t40;
  t455 = t299 * t454;
  t456 = t441 * t31;
  t457 = t58 * params->beta2;
  t458 = t457 * t142;
  t465 = t139 * t313 * params->b;
  t466 = t433 * t142;
  t476 = t234 * t30;
  t477 = t32 * t92;
  t482 = t97 * t334 * params->c;
  t491 = -0.5e1 / 0.216e3 * t214 * t215 * t427 - t432 * t434 * t362 / 0.2304e4 + t440 * t441 * t442 / 0.55296e5 + 0.5e1 / 0.5184e4 * t221 * t447 + t450 * t223 / 0.41472e5 - 0.7e1 / 0.1990656e7 * t455 * t456 * t458 - 0.5e1 / 0.62208e5 * t227 * t447 + 0.5e1 / 0.47775744e8 * t465 * t431 * t466 + 0.5e1 / 0.1492992e7 * t231 * t447 - 0.5e1 / 0.72e2 * t235 * t236 * t36 * t100 - t476 * t477 * t164 / 0.12e2 + t482 * t30 * t477 * t158 / 0.12e2 + 0.5e1 / 0.72e2 * t204 * t88 * t236 * t36;
  t496 = my_piecewise3(t3, 0, t8 * t108 * t245 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t491);
  tv2rholapl0 = 0.2e1 * rho[0] * t496 + 0.2e1 * t249;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t502 = params->A1 * t25;
  t503 = t26 * t26;
  t505 = 0.1e1 / t28 / t503;
  t506 = t505 * t44;
  t507 = t502 * t506;
  t508 = t46 * t46;
  t509 = t508 * t34;
  t511 = 0.1e1 / t23 / t509;
  t512 = t32 * t511;
  t517 = t287 * t288 * t25;
  t521 = t43 * t192;
  t524 = params->A2 * t25;
  t525 = t524 * t505;
  t526 = t44 * t32;
  t527 = t511 * t85;
  t532 = t299 * t149 * t25;
  t533 = t512 * params->beta2;
  t537 = t139 * t85;
  t540 = t139 * t313;
  t541 = t25 * t505;
  t548 = params->A3 * t40;
  t549 = t548 * t42;
  t550 = t192 * t163;
  t555 = t178 * t192 * t69 / 0.144e3 - t507 * t512 * t282 / 0.96e2 + t517 * t506 * t512 / 0.2304e4 - t184 * t521 / 0.3456e4 + t525 * t526 * t527 / 0.1728e4 - 0.7e1 / 0.82944e5 * t532 * t506 * t533 + t537 * t521 / 0.41472e5 + 0.5e1 / 0.1990656e7 * t540 * t541 * t526 * t511 - t196 * t521 / 0.995328e6 - t549 * t550 / 0.144e3 + t409 * t521 / 0.144e3;
  t559 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t555);
  tv2sigma20 = 0.2e1 * rho[0] * t559;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t561 = t541 * lapl[0];
  t562 = t213 * t561;
  t564 = 0.1e1 / t23 / t508;
  t565 = t32 * t564;
  t566 = t565 * t134;
  t567 = t361 * sigma[0];
  t572 = t287 * t438 * t25;
  t573 = t505 * lapl[0];
  t574 = t565 * sigma[0];
  t578 = t505 * sigma[0];
  t579 = t524 * t578;
  t580 = t226 * lapl[0];
  t585 = t299 * t453 * t25;
  t586 = t573 * t32;
  t588 = t564 * params->beta2 * sigma[0];
  t595 = t234 * t43;
  t596 = t31 * t124;
  t597 = t596 * t163;
  t600 = params->c * t40;
  t601 = t42 * t31;
  t602 = t601 * t124;
  t606 = -t562 * t566 * t567 / 0.96e2 + t572 * t573 * t574 / 0.2304e4 + t579 * t565 * t580 / 0.1728e4 - 0.7e1 / 0.82944e5 * t585 * t586 * t588 + 0.5e1 / 0.1990656e7 * t465 * t561 * t574 - t595 * t597 / 0.144e3 + t409 * t600 * t602 / 0.144e3;
  t610 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t606);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t610;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t612 = t213 * t40;
  t616 = params->a * params->a;
  t617 = params->A1 * t616;
  t618 = t541 * t54;
  t619 = t617 * t618;
  t621 = 0.1e1 / t23 / t117;
  t622 = t32 * t621;
  t623 = t622 * t282;
  t627 = t287 * t288 * t616;
  t628 = t54 * t32;
  t629 = t628 * t621;
  t630 = t541 * t629;
  t633 = t601 * t58;
  t637 = params->b * params->b;
  t638 = params->A2 * t637;
  t639 = t638 * t541;
  t640 = t621 * t85;
  t644 = t149 * t637;
  t646 = t299 * t644 * t25;
  t647 = t505 * t54;
  t648 = t622 * params->beta2;
  t652 = t43 * t433;
  t656 = t139 * t313 * t637;
  t659 = t72 * t633;
  t662 = params->c * params->c;
  t663 = params->A3 * t662;
  t664 = t663 * t43;
  t668 = t662 * t40;
  t672 = t612 * t601 * t216 / 0.144e3 - t619 * t623 / 0.96e2 + t627 * t630 / 0.2304e4 - t184 * t52 * t633 / 0.3456e4 + t639 * t628 * t640 / 0.1728e4 - 0.7e1 / 0.82944e5 * t646 * t647 * t648 + t227 * t652 / 0.41472e5 + 0.5e1 / 0.1990656e7 * t656 * t630 - t196 * t659 / 0.995328e6 - t664 * t433 * t163 / 0.144e3 + t409 * t668 * t633 / 0.144e3;
  t676 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t672);
  tv2lapl20 = 0.2e1 * rho[0] * t676;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t38, t40, t42, t43;
  double t44, t45, t46, t47, t49, t51, t52, t53;
  double t54, t55, t56, t58, t59, t62, t64, t67;
  double t68, t69, t72, t73, t76, t77, t79, t82;
  double t83, t84, t85, t88, t89, t90, t92, t96;
  double t97, t99, t100, t102, t106, tzk0;

  double t108, t113, t115, t117, t119, t122, t124, t125;
  double t128, t132, t134, t135, t139, t142, t146, t147;
  double t149, t150, t158, t159, t161, t162, t163, t164;
  double t166, t171, tvrho0, t174, t175, t177, t178, t179;
  double t180, t184, t185, t186, t189, t190, t191, t192;
  double t193, t196, t199, t200, t204, t207, t211, tvsigma0;
  double t213, t214, t215, t216, t220, t221, t222, t223;
  double t226, t227, t231, t234, t235, t236, t242, t245;
  double t249, tvlapl0, tvtau0;

  double t254, t262, t264, t266, t268, t271, t272, t275;
  double t276, t279, t280, t281, t282, t285, t286, t287;
  double t288, t295, t296, t299, t306, t307, t311, t312;
  double t313, t324, t325, t327, t328, t332, t333, t334;
  double t335, t338, t340, t345, tv2rho20, t351, t352, t354;
  double t358, t359, t360, t361, t362, t363, t367, t368;
  double t373, t376, t377, t380, t381, t382, t383, t384;
  double t388, t389, t393, t394, t403, t404, t405, t409;
  double t411, t416, t421, tv2rhosigma0, t427, t431, t432, t433;
  double t434, t438, t440, t441, t442, t447, t450, t453;
  double t454, t455, t456, t457, t458, t465, t466, t476;
  double t477, t482, t491, t496, tv2rholapl0, tv2rhotau0, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t517;
  double t521, t524, t525, t526, t527, t532, t533, t537;
  double t540, t541, t548, t549, t550, t555, t559, tv2sigma20;
  double t561, t562, t564, t565, t566, t567, t572, t573;
  double t574, t578, t579, t580, t585, t586, t588, t595;
  double t596, t597, t600, t601, t602, t606, t610, tv2sigmalapl0;
  double tv2sigmatau0, t612, t616, t617, t618, t619, t621, t622;
  double t623, t627, t628, t629, t630, t633, t637, t638;
  double t639, t640, t644, t646, t647, t648, t652, t656;
  double t659, t662, t663, t664, t668, t672, t676, tv2lapl20;
  double tv2lapltau0, tv2tau20;

  double t681, t692, t694, t699, t700, t702, t703, t704;
  double t705, t709, t714, t715, t716, t722, t725, t726;
  double t729, t733, t734, t735, t741, t742, t743, t749;
  double t756, t759, t761, t765, t767, t770, t772, t775;
  double t776, t779, t780, t781, t789, t790, t791, t792;
  double t798, t802, t805, t806, t811, tv3rho30, t821, t829;
  double t831, t832, t833, t836, t837, t838, t843, t847;
  double t851, t855, t856, t859, t860, t863, t864, t865;
  double t866, t869, t871, t873, t877, t878, t882, t886;
  double t887, t891, t895, t896, t899, t900, t908, t909;
  double t912, t914, t918, t922, t932, t939, t940, t945;
  double t946, t951, tv3rho2sigma0, t964, t968, t970, t972, t981;
  double t985, t986, t990, t997, t1001, t1005, t1006, t1007;
  double t1011, t1020, t1025, t1029, t1032, t1042, t1043, t1065;
  double t1071, t1072, t1077, tv3rho2lapl0, tv3rho2tau0, t1086, t1093, t1095;
  double t1096, t1100, t1103, t1106, t1107, t1108, t1109, t1110;
  double t1111, t1114, t1115, t1123, t1124, t1125, t1130, t1136;
  double t1137, t1138, t1139, t1143, t1144, t1150, t1151, t1152;
  double t1156, t1157, t1158, t1162, t1171, t1172, t1178, t1186;
  double t1187, t1192, tv3rhosigma20, t1198, t1200, t1201, t1207, t1209;
  double t1210, t1211, t1212, t1215, t1216, t1217, t1218, t1219;
  double t1222, t1224, t1225, t1226, t1227, t1228, t1232, t1239;
  double t1240, t1241, t1244, t1246, t1247, t1248, t1253, t1257;
  double t1258, t1260, t1261, t1262, t1271, t1272, t1276, t1279;
  double t1283, t1288, tv3rhosigmalapl0, tv3rhosigmatau0, t1294, t1299, t1304, t1305;
  double t1322, t1328, t1329, t1330, t1331, t1332, t1339, t1340;
  double t1341, t1342, t1354, t1355, t1360, t1365, t1367, t1368;
  double t1369, t1370, t1374, t1375, t1376, t1379, t1380, t1387;
  double t1391, t1395, t1396, t1401, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t1404;
  double t1405, t1409, t1410, t1411, t1412, t1413, t1414, t1415;
  double t1424, t1425, t1435, t1436, t1438, t1441, t1442, t1449;
  double t1453, t1457, t1458, t1459, t1461, t1464, t1465, t1469;
  double t1473, tv3sigma30, t1475, t1476, t1478, t1479, t1480, t1484;
  double t1485, t1489, t1492, t1493, t1498, t1501, t1502, t1503;
  double t1507, t1508, t1510, t1513, t1514, t1515, t1516, t1520;
  double t1524, t1531, t1532, t1534, t1537, t1538, t1542, t1546;
  double tv3sigma2lapl0, tv3sigma2tau0, t1548, t1549, t1553, t1554, t1555, t1556;
  double t1557, t1558, t1562, t1563, t1567, t1568, t1569, t1573;
  double t1576, t1577, t1578, t1579, t1582, t1583, t1584, t1588;
  double t1600, t1601, t1603, t1606, t1607, t1611, t1615, tv3sigmalapl20;
  double tv3sigmalapltau0, tv3sigmatau20, t1617, t1618, t1619, t1623, t1624, t1625;
  double t1626, t1627, t1628, t1629, t1633, t1638, t1639, t1644;
  double t1650, t1651, t1652, t1653, t1654, t1657, t1658, t1665;
  double t1666, t1672, t1673, t1674, t1675, t1680, t1685, t1689;
  double tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = t25 * t25;
  t42 = 0.1e1 / t27 / t26;
  t43 = t40 * t42;
  t44 = sigma[0] * sigma[0];
  t45 = t44 * t31;
  t46 = t34 * t34;
  t47 = t46 * rho[0];
  t49 = 0.1e1 / t22 / t47;
  t51 = t43 * t45 * t49;
  t52 = params->a * t40;
  t53 = t52 * t42;
  t54 = lapl[0] * lapl[0];
  t55 = t54 * t31;
  t56 = t34 * rho[0];
  t58 = 0.1e1 / t22 / t56;
  t59 = t55 * t58;
  t62 = 0.2e1 * t53 * t59 + 0.2e1 * t51;
  t64 = sqrt(t62);
  t67 = 0.1e1 + params->beta1 * t64 / 0.24e2;
  t68 = t67 * t67;
  t69 = 0.1e1 / t68;
  t72 = params->b * t40;
  t73 = t72 * t42;
  t76 = 0.2e1 * t73 * t59 + 0.2e1 * t51;
  t77 = t76 * t76;
  t79 = sqrt(t76);
  t82 = 0.1e1 + params->beta2 * t79 / 0.24e2;
  t83 = t82 * t82;
  t84 = t83 * t83;
  t85 = 0.1e1 / t84;
  t88 = params->c * t25;
  t89 = t88 * t29;
  t90 = lapl[0] * t32;
  t92 = 0.1e1 / t23 / rho[0];
  t96 = t89 * t90 * t92 / 0.24e2 + t38 / 0.24e2;
  t97 = params->A3 * t96;
  t99 = params->beta3 * t96 + 0.1e1;
  t100 = 0.1e1 / t99;
  t102 = 0.5e1 / 0.72e2 * t38 + params->A0 + params->A1 * t62 * t69 / 0.576e3 + params->A2 * t77 * t85 / 0.331776e6 + t97 * t100;
  t106 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t108 = t21 / t22;
  t113 = 0.1e1 / t23 / t56;
  t115 = t30 * t33 * t113;
  t117 = t46 * t34;
  t119 = 0.1e1 / t22 / t117;
  t122 = 0.32e2 / 0.3e1 * t43 * t45 * t119;
  t124 = 0.1e1 / t22 / t46;
  t125 = t55 * t124;
  t128 = -t122 - 0.2e2 / 0.3e1 * t53 * t125;
  t132 = params->A1 * t64;
  t134 = 0.1e1 / t68 / t67;
  t135 = t134 * params->beta1;
  t139 = params->A2 * t76;
  t142 = -t122 - 0.2e2 / 0.3e1 * t73 * t125;
  t146 = t79 * t76;
  t147 = params->A2 * t146;
  t149 = 0.1e1 / t84 / t82;
  t150 = t149 * params->beta2;
  t158 = -t115 / 0.9e1 - 0.5e1 / 0.72e2 * t89 * t90 * t36;
  t159 = params->A3 * t158;
  t161 = t99 * t99;
  t162 = 0.1e1 / t161;
  t163 = t162 * params->beta3;
  t164 = t163 * t158;
  t166 = -0.5e1 / 0.27e2 * t115 + params->A1 * t128 * t69 / 0.576e3 - t132 * t135 * t128 / 0.13824e5 + t139 * t85 * t142 / 0.165888e6 - t147 * t150 * t142 / 0.3981312e7 + t159 * t100 - t97 * t164;
  t171 = my_piecewise3(t3, 0, t8 * t108 * t102 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t166);
  tvrho0 = 0.2e1 * rho[0] * t171 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t174 = t32 * t36;
  t175 = t30 * t174;
  t177 = params->A1 * t40;
  t178 = t177 * t42;
  t179 = sigma[0] * t31;
  t180 = t49 * t69;
  t184 = t132 * t135;
  t185 = t179 * t49;
  t186 = t43 * t185;
  t189 = t85 * t40;
  t190 = t139 * t189;
  t191 = t42 * sigma[0];
  t192 = t31 * t49;
  t193 = t191 * t192;
  t196 = t147 * t150;
  t199 = params->A3 * t25;
  t200 = t199 * t29;
  t204 = t97 * t163;
  t207 = 0.5e1 / 0.72e2 * t175 + t178 * t179 * t180 / 0.144e3 - t184 * t186 / 0.3456e4 + t190 * t193 / 0.41472e5 - t196 * t186 / 0.995328e6 + t200 * t174 * t100 / 0.24e2 - t204 * t175 / 0.24e2;
  t211 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t207);
  tvsigma0 = 0.2e1 * rho[0] * t211;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t213 = params->A1 * params->a;
  t214 = t213 * t43;
  t215 = lapl[0] * t31;
  t216 = t58 * t69;
  t220 = t135 * params->a;
  t221 = t132 * t220;
  t222 = t215 * t58;
  t223 = t43 * t222;
  t226 = t85 * params->b;
  t227 = t139 * t226;
  t231 = t147 * t150 * params->b;
  t234 = params->A3 * params->c;
  t235 = t234 * t25;
  t236 = t29 * t32;
  t242 = t88 * t236 * t92;
  t245 = t214 * t215 * t216 / 0.144e3 - t221 * t223 / 0.3456e4 + t227 * t223 / 0.41472e5 - t231 * t223 / 0.995328e6 + t235 * t236 * t92 * t100 / 0.24e2 - t204 * t242 / 0.24e2;
  t249 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t245);
  tvlapl0 = 0.2e1 * rho[0] * t249;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t254 = t21 / t22 / rho[0];
  t262 = 0.1e1 / t23 / t46;
  t264 = t30 * t33 * t262;
  t266 = t46 * t56;
  t268 = 0.1e1 / t22 / t266;
  t271 = 0.608e3 / 0.9e1 * t43 * t45 * t268;
  t272 = t55 * t49;
  t275 = t271 + 0.26e3 / 0.9e1 * t53 * t272;
  t276 = params->A1 * t275;
  t279 = t128 * t128;
  t280 = params->A1 * t279;
  t281 = 0.1e1 / t64;
  t282 = t135 * t281;
  t285 = t68 * t68;
  t286 = 0.1e1 / t285;
  t287 = params->A1 * t286;
  t288 = params->beta1 * params->beta1;
  t295 = t142 * t142;
  t296 = params->A2 * t295;
  t299 = params->A2 * t79;
  t306 = t271 + 0.26e3 / 0.9e1 * t73 * t272;
  t307 = t85 * t306;
  t311 = 0.1e1 / t84 / t83;
  t312 = params->beta2 * params->beta2;
  t313 = t311 * t312;
  t324 = 0.11e2 / 0.27e2 * t264 + 0.5e1 / 0.27e2 * t89 * t90 * t113;
  t325 = params->A3 * t324;
  t327 = t158 * t158;
  t328 = params->A3 * t327;
  t332 = 0.1e1 / t161 / t99;
  t333 = params->beta3 * params->beta3;
  t334 = t332 * t333;
  t335 = t334 * t327;
  t338 = t163 * t324;
  t340 = 0.55e2 / 0.81e2 * t264 + t276 * t69 / 0.576e3 - t280 * t282 / 0.9216e4 + t287 * t288 * t279 / 0.221184e6 - t132 * t135 * t275 / 0.13824e5 + t296 * t85 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t299 * t149 * t295 * params->beta2 + t139 * t307 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t139 * t313 * t295 - t147 * t150 * t306 / 0.3981312e7 + t325 * t100 - 0.2e1 * t328 * t163 + 0.2e1 * t97 * t335 - t97 * t338;
  t345 = my_piecewise3(t3, 0, -t8 * t254 * t102 / 0.3e2 + t8 * t108 * t166 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2rho20 = 0.2e1 * rho[0] * t345 + 0.4e1 * t171;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t351 = t32 * t113;
  t352 = t30 * t351;
  t354 = t119 * t69;
  t358 = t191 * t31;
  t359 = t177 * t358;
  t360 = t49 * t134;
  t361 = params->beta1 * t281;
  t362 = t361 * t128;
  t363 = t360 * t362;
  t367 = t287 * t288 * t40;
  t368 = t192 * t128;
  t373 = t43 * t179 * t119;
  t376 = params->A2 * t142;
  t377 = t376 * t189;
  t380 = t149 * t40;
  t381 = t380 * t42;
  t382 = t299 * t381;
  t383 = t49 * params->beta2;
  t384 = t383 * t142;
  t388 = t31 * t119;
  t389 = t191 * t388;
  t393 = t139 * t313 * t40;
  t394 = t192 * t142;
  t403 = t199 * t236;
  t404 = t36 * t162;
  t405 = params->beta3 * t158;
  t409 = t97 * t334;
  t411 = t30 * t174 * t158;
  t416 = -0.5e1 / 0.27e2 * t352 - t178 * t179 * t354 / 0.27e2 - t359 * t363 / 0.2304e4 + t367 * t191 * t368 / 0.55296e5 + t184 * t373 / 0.648e3 + t377 * t193 / 0.41472e5 - 0.7e1 / 0.1990656e7 * t382 * t179 * t384 - t190 * t389 / 0.7776e4 + 0.5e1 / 0.47775744e8 * t393 * t191 * t394 + t196 * t373 / 0.186624e6 - t200 * t351 * t100 / 0.9e1 - t403 * t404 * t405 / 0.12e2 + t409 * t411 / 0.12e2 + t204 * t352 / 0.9e1;
  t421 = my_piecewise3(t3, 0, t8 * t108 * t207 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t416);
  tv2rhosigma0 = 0.2e1 * rho[0] * t421 + 0.2e1 * t211;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t427 = t124 * t69;
  t431 = t43 * lapl[0];
  t432 = t213 * t431;
  t433 = t31 * t58;
  t434 = t433 * t134;
  t438 = t288 * params->a;
  t440 = t287 * t438 * t40;
  t441 = t42 * lapl[0];
  t442 = t433 * t128;
  t447 = t43 * t215 * t124;
  t450 = t376 * t226;
  t453 = t149 * params->b;
  t454 = t453 * t40;
  t455 = t299 * t454;
  t456 = t441 * t31;
  t457 = t58 * params->beta2;
  t458 = t457 * t142;
  t465 = t139 * t313 * params->b;
  t466 = t433 * t142;
  t476 = t234 * t30;
  t477 = t32 * t92;
  t482 = t97 * t334 * params->c;
  t491 = -0.5e1 / 0.216e3 * t214 * t215 * t427 - t432 * t434 * t362 / 0.2304e4 + t440 * t441 * t442 / 0.55296e5 + 0.5e1 / 0.5184e4 * t221 * t447 + t450 * t223 / 0.41472e5 - 0.7e1 / 0.1990656e7 * t455 * t456 * t458 - 0.5e1 / 0.62208e5 * t227 * t447 + 0.5e1 / 0.47775744e8 * t465 * t431 * t466 + 0.5e1 / 0.1492992e7 * t231 * t447 - 0.5e1 / 0.72e2 * t235 * t236 * t36 * t100 - t476 * t477 * t164 / 0.12e2 + t482 * t30 * t477 * t158 / 0.12e2 + 0.5e1 / 0.72e2 * t204 * t88 * t236 * t36;
  t496 = my_piecewise3(t3, 0, t8 * t108 * t245 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t491);
  tv2rholapl0 = 0.2e1 * rho[0] * t496 + 0.2e1 * t249;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t502 = params->A1 * t25;
  t503 = t26 * t26;
  t505 = 0.1e1 / t28 / t503;
  t506 = t505 * t44;
  t507 = t502 * t506;
  t508 = t46 * t46;
  t509 = t508 * t34;
  t511 = 0.1e1 / t23 / t509;
  t512 = t32 * t511;
  t517 = t287 * t288 * t25;
  t521 = t43 * t192;
  t524 = params->A2 * t25;
  t525 = t524 * t505;
  t526 = t44 * t32;
  t527 = t511 * t85;
  t532 = t299 * t149 * t25;
  t533 = t512 * params->beta2;
  t537 = t139 * t85;
  t540 = t139 * t313;
  t541 = t25 * t505;
  t548 = params->A3 * t40;
  t549 = t548 * t42;
  t550 = t192 * t163;
  t555 = t178 * t192 * t69 / 0.144e3 - t507 * t512 * t282 / 0.96e2 + t517 * t506 * t512 / 0.2304e4 - t184 * t521 / 0.3456e4 + t525 * t526 * t527 / 0.1728e4 - 0.7e1 / 0.82944e5 * t532 * t506 * t533 + t537 * t521 / 0.41472e5 + 0.5e1 / 0.1990656e7 * t540 * t541 * t526 * t511 - t196 * t521 / 0.995328e6 - t549 * t550 / 0.144e3 + t409 * t521 / 0.144e3;
  t559 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t555);
  tv2sigma20 = 0.2e1 * rho[0] * t559;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t561 = t541 * lapl[0];
  t562 = t213 * t561;
  t564 = 0.1e1 / t23 / t508;
  t565 = t32 * t564;
  t566 = t565 * t134;
  t567 = t361 * sigma[0];
  t572 = t287 * t438 * t25;
  t573 = t505 * lapl[0];
  t574 = t565 * sigma[0];
  t578 = t505 * sigma[0];
  t579 = t524 * t578;
  t580 = t226 * lapl[0];
  t585 = t299 * t453 * t25;
  t586 = t573 * t32;
  t588 = t564 * params->beta2 * sigma[0];
  t595 = t234 * t43;
  t596 = t31 * t124;
  t597 = t596 * t163;
  t600 = params->c * t40;
  t601 = t42 * t31;
  t602 = t601 * t124;
  t606 = -t562 * t566 * t567 / 0.96e2 + t572 * t573 * t574 / 0.2304e4 + t579 * t565 * t580 / 0.1728e4 - 0.7e1 / 0.82944e5 * t585 * t586 * t588 + 0.5e1 / 0.1990656e7 * t465 * t561 * t574 - t595 * t597 / 0.144e3 + t409 * t600 * t602 / 0.144e3;
  t610 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t606);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t610;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t612 = t213 * t40;
  t616 = params->a * params->a;
  t617 = params->A1 * t616;
  t618 = t541 * t54;
  t619 = t617 * t618;
  t621 = 0.1e1 / t23 / t117;
  t622 = t32 * t621;
  t623 = t622 * t282;
  t627 = t287 * t288 * t616;
  t628 = t54 * t32;
  t629 = t628 * t621;
  t630 = t541 * t629;
  t633 = t601 * t58;
  t637 = params->b * params->b;
  t638 = params->A2 * t637;
  t639 = t638 * t541;
  t640 = t621 * t85;
  t644 = t149 * t637;
  t646 = t299 * t644 * t25;
  t647 = t505 * t54;
  t648 = t622 * params->beta2;
  t652 = t43 * t433;
  t656 = t139 * t313 * t637;
  t659 = t72 * t633;
  t662 = params->c * params->c;
  t663 = params->A3 * t662;
  t664 = t663 * t43;
  t668 = t662 * t40;
  t672 = t612 * t601 * t216 / 0.144e3 - t619 * t623 / 0.96e2 + t627 * t630 / 0.2304e4 - t184 * t52 * t633 / 0.3456e4 + t639 * t628 * t640 / 0.1728e4 - 0.7e1 / 0.82944e5 * t646 * t647 * t648 + t227 * t652 / 0.41472e5 + 0.5e1 / 0.1990656e7 * t656 * t630 - t196 * t659 / 0.995328e6 - t664 * t433 * t163 / 0.144e3 + t409 * t668 * t633 / 0.144e3;
  t676 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t672);
  tv2lapl20 = 0.2e1 * rho[0] * t676;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t681 = t21 / t22 / t34;
  t692 = 0.1e1 / t23 / t47;
  t694 = t30 * t33 * t692;
  t699 = -0.154e3 / 0.81e2 * t694 - 0.55e2 / 0.81e2 * t89 * t90 * t262;
  t700 = t163 * t699;
  t702 = t279 * t128;
  t703 = params->A1 * t702;
  t704 = t286 * t288;
  t705 = 0.1e1 / t62;
  t709 = t288 * t128;
  t714 = 0.1e1 / t285 / t67;
  t715 = params->A1 * t714;
  t716 = t288 * params->beta1;
  t722 = 0.1e1 / t22 / t508;
  t725 = 0.13376e5 / 0.27e2 * t43 * t45 * t722;
  t726 = t55 * t119;
  t729 = -t725 - 0.416e4 / 0.27e2 * t53 * t726;
  t733 = t295 * t142;
  t734 = params->A2 * t733;
  t735 = 0.1e1 / t79;
  t741 = 0.1e1 / t84 / t83 / t82;
  t742 = t312 * params->beta2;
  t743 = t741 * t742;
  t749 = -t725 - 0.416e4 / 0.27e2 * t73 * t726;
  t756 = t276 * t134;
  t759 = -t97 * t700 + t703 * t704 * t705 / 0.147456e6 + t287 * t709 * t275 / 0.73728e5 - t715 * t716 * t702 * t281 / 0.2654208e7 - t132 * t135 * t729 / 0.13824e5 - 0.5e1 / 0.5308416e7 * t734 * t150 * t735 - 0.5e1 / 0.1528823808e10 * t299 * t743 * t733 - t147 * t150 * t749 / 0.3981312e7 - 0.77e3 / 0.243e3 * t694 - 0.6e1 * t325 * t164 - t756 * t362 / 0.3072e4;
  t761 = 0.1e1 / t64 / t62;
  t765 = t299 * t149;
  t767 = t142 * params->beta2 * t306;
  t770 = t139 * t311;
  t772 = t312 * t142 * t306;
  t775 = t327 * t158;
  t776 = params->A3 * t775;
  t779 = t97 * t332;
  t780 = t333 * t158;
  t781 = t780 * t324;
  t789 = t161 * t161;
  t790 = 0.1e1 / t789;
  t791 = t333 * params->beta3;
  t792 = t790 * t791;
  t798 = params->A2 * t311;
  t802 = t85 * t749;
  t805 = t703 * t135 * t761 / 0.18432e5 - 0.7e1 / 0.2654208e7 * t765 * t767 + 0.5e1 / 0.63700992e8 * t770 * t772 + 0.6e1 * t776 * t334 + 0.6e1 * t779 * t781 + params->A1 * t729 * t69 / 0.576e3 + params->A3 * t699 * t100 - 0.6e1 * t97 * t792 * t775 + t376 * t307 / 0.55296e5 + 0.5e1 / 0.42467328e8 * t798 * t733 * t312 + t139 * t802 / 0.165888e6;
  t806 = t759 + t805;
  t811 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t681 * t102 - t8 * t254 * t166 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t108 * t340 + 0.3e1 / 0.2e2 * t8 * t24 * t806);
  tv3rho30 = 0.2e1 * rho[0] * t811 + 0.6e1 * t345;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t821 = t32 * t262;
  t829 = t30 * t821;
  t831 = params->beta1 * t761;
  t832 = t831 * t279;
  t833 = t360 * t832;
  t836 = t743 * t40;
  t837 = t299 * t836;
  t838 = t192 * t295;
  t843 = t383 * t735;
  t847 = t383 * t306;
  t851 = t192 * t306;
  t855 = t119 * t134;
  t856 = t855 * t362;
  t859 = t361 * t275;
  t860 = t360 * t859;
  t863 = t49 * t286;
  t864 = t288 * t705;
  t865 = t864 * t279;
  t866 = t863 * t865;
  t869 = t716 * t40;
  t871 = t715 * t869 * t42;
  t873 = t49 * t279 * t281;
  t877 = t119 * params->beta2;
  t878 = t877 * t142;
  t882 = t388 * t142;
  t886 = 0.11e2 / 0.27e2 * t200 * t821 * t100 + 0.19e2 / 0.81e2 * t178 * t179 * t268 * t69 + 0.55e2 / 0.81e2 * t829 + t359 * t833 / 0.4608e4 - 0.5e1 / 0.382205952e9 * t837 * t191 * t838 - 0.5e1 / 0.1327104e7 * t296 * t381 * t179 * t843 - 0.7e1 / 0.1990656e7 * t382 * t179 * t847 + 0.5e1 / 0.47775744e8 * t393 * t191 * t851 + t359 * t856 / 0.216e3 - t359 * t860 / 0.2304e4 + t359 * t866 / 0.36864e5 - t871 * t179 * t873 / 0.663552e6 + 0.7e1 / 0.186624e6 * t382 * t179 * t878 - 0.5e1 / 0.4478976e7 * t393 * t191 * t882;
  t887 = t113 * t162;
  t891 = params->beta3 * t324;
  t895 = params->A2 * t306;
  t896 = t895 * t189;
  t899 = t36 * t332;
  t900 = t333 * t327;
  t908 = t31 * t268;
  t909 = t191 * t908;
  t912 = t97 * t792;
  t914 = t30 * t174 * t327;
  t918 = t43 * t179 * t268;
  t922 = t30 * t351 * t158;
  t932 = t30 * t174 * t324;
  t939 = t798 * t43;
  t940 = t49 * t312;
  t945 = 0.4e1 / 0.9e1 * t403 * t887 * t405 - t403 * t404 * t891 / 0.12e2 + t896 * t193 / 0.41472e5 + t403 * t899 * t900 / 0.4e1 - 0.11e2 / 0.27e2 * t204 * t829 - t377 * t389 / 0.3888e4 + 0.19e2 / 0.23328e5 * t190 * t909 - t912 * t914 / 0.4e1 - 0.19e2 / 0.559872e6 * t196 * t918 - 0.4e1 / 0.9e1 * t409 * t922 - 0.19e2 / 0.1944e4 * t184 * t918 - t367 * t191 * t388 * t128 / 0.5184e4 + t409 * t932 / 0.12e2 + t367 * t191 * t192 * t275 / 0.55296e5 + 0.5e1 / 0.10616832e8 * t939 * t179 * t940 * t295;
  t946 = t886 + t945;
  t951 = my_piecewise3(t3, 0, -t8 * t254 * t207 / 0.3e2 + t8 * t108 * t416 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t946);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t951 + 0.4e1 * t421;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t964 = t433 * t286;
  t968 = t716 * params->a;
  t970 = t715 * t968 * t40;
  t972 = t58 * t279 * t281;
  t981 = t596 * t134;
  t985 = t124 * params->beta2;
  t986 = t985 * t142;
  t990 = t596 * t142;
  t997 = t457 * t306;
  t1001 = t433 * t306;
  t1005 = t743 * params->b;
  t1006 = t299 * t1005;
  t1007 = t433 * t295;
  t1011 = t433 * t275;
  t1020 = t97 * t792 * params->c;
  t1025 = -t432 * t434 * t859 / 0.2304e4 + t432 * t964 * t865 / 0.36864e5 - t970 * t456 * t972 / 0.663552e6 - 0.5e1 / 0.1327104e7 * t296 * t454 * t456 * t457 * t735 + 0.5e1 / 0.1728e4 * t432 * t981 * t362 + 0.35e2 / 0.1492992e7 * t455 * t456 * t986 - 0.25e2 / 0.35831808e8 * t465 * t431 * t990 + t432 * t434 * t832 / 0.4608e4 - 0.7e1 / 0.1990656e7 * t455 * t456 * t997 + 0.5e1 / 0.47775744e8 * t465 * t431 * t1001 - 0.5e1 / 0.382205952e9 * t1006 * t431 * t1007 + t440 * t441 * t1011 / 0.55296e5 + 0.5e1 / 0.27e2 * t235 * t236 * t113 * t100 - t1020 * t30 * t477 * t327 / 0.4e1;
  t1029 = t43 * t215 * t49;
  t1032 = t596 * t128;
  t1042 = t798 * t73;
  t1043 = t58 * t312;
  t1065 = t895 * t226;
  t1071 = -0.5e1 / 0.18e2 * t482 * t411 - 0.65e2 / 0.4478976e7 * t231 * t1029 - 0.5e1 / 0.41472e5 * t440 * t441 * t1032 - 0.65e2 / 0.15552e5 * t221 * t1029 + t482 * t30 * t477 * t324 / 0.12e2 + 0.5e1 / 0.10616832e8 * t1042 * t215 * t1043 * t295 + 0.65e2 / 0.648e3 * t214 * t215 * t180 + t476 * t477 * t335 / 0.4e1 - 0.5e1 / 0.27e2 * t204 * t88 * t236 * t113 - 0.5e1 / 0.31104e5 * t450 * t447 + 0.65e2 / 0.186624e6 * t227 * t1029 - t476 * t477 * t338 / 0.12e2 + t1065 * t223 / 0.41472e5 + 0.5e1 / 0.18e2 * t476 * t174 * t164;
  t1072 = t1025 + t1071;
  t1077 = my_piecewise3(t3, 0, -t8 * t254 * t245 / 0.3e2 + t8 * t108 * t491 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t1072);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t1077 + 0.4e1 * t496;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1086 = t376 * t85;
  t1093 = t508 * t56;
  t1095 = 0.1e1 / t23 / t1093;
  t1096 = t1095 * t85;
  t1100 = t43 * t388;
  t1103 = t388 * t163;
  t1106 = t506 * t32;
  t1107 = t524 * t1106;
  t1108 = t511 * t149;
  t1109 = params->beta2 * t735;
  t1110 = t1109 * t142;
  t1111 = t1108 * t1110;
  t1114 = t32 * t1095;
  t1115 = t1114 * params->beta2;
  t1123 = t743 * t25;
  t1124 = t299 * t1123;
  t1125 = t512 * t142;
  t1130 = t43 * t192 * t158;
  t1136 = -t178 * t388 * t69 / 0.27e2 + t1086 * t521 / 0.41472e5 + t367 * t601 * t49 * t128 / 0.55296e5 - t525 * t526 * t1096 / 0.162e3 - t537 * t1100 / 0.7776e4 + t549 * t1103 / 0.27e2 - 0.5e1 / 0.55296e5 * t1107 * t1111 + 0.7e1 / 0.7776e4 * t532 * t506 * t1115 - 0.5e1 / 0.186624e6 * t540 * t541 * t526 * t1095 - 0.5e1 / 0.15925248e8 * t1124 * t506 * t1125 - t912 * t1130 / 0.48e2 + t507 * t1114 * t282 / 0.9e1;
  t1137 = t502 * t1106;
  t1138 = t511 * t134;
  t1139 = t831 * t128;
  t1143 = t511 * t286;
  t1144 = t864 * t128;
  t1150 = t715 * t716 * t25 * t505;
  t1151 = t511 * t281;
  t1152 = t1151 * t128;
  t1156 = t798 * t541;
  t1157 = t511 * t312;
  t1158 = t1157 * t142;
  t1162 = t299 * t380;
  t1171 = t548 * t601;
  t1172 = t49 * t332;
  t1178 = t177 * t601;
  t1186 = t1137 * t1138 * t1139 / 0.192e3 + t1137 * t1143 * t1144 / 0.1536e4 - t1150 * t526 * t1152 / 0.27648e5 + 0.5e1 / 0.442368e6 * t1156 * t526 * t1158 - 0.7e1 / 0.1990656e7 * t1162 * t601 * t384 + t196 * t1100 / 0.186624e6 + 0.5e1 / 0.47775744e8 * t540 * t43 * t394 + t1171 * t1172 * t780 / 0.48e2 - t409 * t1100 / 0.27e2 - t1178 * t363 / 0.2304e4 - t517 * t506 * t1114 / 0.216e3 + t184 * t1100 / 0.648e3;
  t1187 = t1136 + t1186;
  t1192 = my_piecewise3(t3, 0, t8 * t108 * t555 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1187);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1192 + 0.2e1 * t559;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t1198 = t508 * rho[0];
  t1200 = 0.1e1 / t23 / t1198;
  t1201 = t32 * t1200;
  t1207 = t213 * t25 * t586;
  t1209 = t564 * t286 * t288;
  t1210 = t705 * sigma[0];
  t1211 = t1210 * t128;
  t1212 = t1209 * t1211;
  t1215 = t564 * t134;
  t1216 = t1215 * params->beta1;
  t1217 = t761 * sigma[0];
  t1218 = t1217 * t128;
  t1219 = t1216 * t1218;
  t1222 = t715 * t716;
  t1224 = params->a * t25 * t505;
  t1225 = t1222 * t1224;
  t1226 = t90 * t564;
  t1227 = sigma[0] * t281;
  t1228 = t1227 * t128;
  t1232 = t1201 * sigma[0];
  t1239 = t525 * t574;
  t1240 = t453 * lapl[0];
  t1241 = t1240 * t1110;
  t1244 = params->b * t25;
  t1246 = t798 * t1244 * t505;
  t1247 = t312 * sigma[0];
  t1248 = t1247 * t142;
  t1253 = t1200 * params->beta2 * sigma[0];
  t1257 = t299 * t741;
  t1258 = t742 * params->b;
  t1260 = t1257 * t1258 * t25;
  t1261 = t564 * sigma[0];
  t1262 = t1261 * t142;
  t1271 = t334 * t158;
  t1272 = t596 * t1271;
  t1276 = t43 * t596 * t158;
  t1279 = t601 * t49;
  t1283 = 0.13e2 / 0.144e3 * t562 * t1201 * t134 * t567 + t1207 * t1212 / 0.1536e4 + t1207 * t1219 / 0.192e3 - t1225 * t1226 * t1228 / 0.27648e5 - 0.13e2 / 0.3456e4 * t572 * t573 * t1232 - 0.13e2 / 0.2592e4 * t579 * t1201 * t580 - 0.5e1 / 0.55296e5 * t1239 * t1241 + 0.5e1 / 0.442368e6 * t1246 * t1226 * t1248 + 0.91e2 / 0.124416e6 * t585 * t586 * t1253 - 0.5e1 / 0.15925248e8 * t1260 * t586 * t1262 - 0.65e2 / 0.2985984e7 * t465 * t561 * t1232 + 0.13e2 / 0.432e3 * t595 * t550 + t595 * t1272 / 0.48e2 - t1020 * t1276 / 0.48e2 - 0.13e2 / 0.432e3 * t409 * t600 * t1279;
  t1288 = my_piecewise3(t3, 0, t8 * t108 * t606 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1283);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1288 + 0.2e1 * t610;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1294 = t43 * t596;
  t1299 = t287 * t438;
  t1304 = 0.1e1 / t23 / t266;
  t1305 = t1304 * t85;
  t1322 = t541 * t628 * t1304;
  t1328 = t637 * t25;
  t1329 = t1328 * t505;
  t1330 = t798 * t1329;
  t1331 = t621 * t312;
  t1332 = t1331 * t142;
  t1339 = -0.5e1 / 0.62208e5 * t227 * t1294 + 0.5e1 / 0.216e3 * t664 * t597 + t1299 * t43 * t442 / 0.55296e5 - 0.5e1 / 0.1296e4 * t639 * t628 * t1305 + 0.5e1 / 0.1492992e7 * t196 * t72 * t602 + 0.5e1 / 0.47775744e8 * t465 * t43 * t466 + t664 * t433 * t1271 / 0.48e2 - 0.5e1 / 0.216e3 * t409 * t668 * t602 - 0.5e1 / 0.1728e4 * t627 * t1322 + 0.5e1 / 0.5184e4 * t184 * t52 * t602 + 0.5e1 / 0.442368e6 * t1330 * t628 * t1332 - 0.7e1 / 0.1990656e7 * t455 * t601 * t458;
  t1340 = t43 * t31;
  t1341 = t213 * t1340;
  t1342 = t58 * t134;
  t1354 = t299 * t743 * t637;
  t1355 = t622 * t142;
  t1360 = t97 * t792 * t662;
  t1365 = t716 * t616;
  t1367 = t715 * t1365 * t25;
  t1368 = t647 * t32;
  t1369 = t621 * t281;
  t1370 = t1369 * t128;
  t1374 = t638 * t618;
  t1375 = t622 * t149;
  t1376 = t1375 * t1110;
  t1379 = t32 * t1304;
  t1380 = t1379 * params->beta2;
  t1387 = t622 * t134;
  t1391 = t622 * t286;
  t1395 = -t1341 * t1342 * t362 / 0.2304e4 - 0.5e1 / 0.216e3 * t612 * t601 * t427 + t450 * t652 / 0.41472e5 - 0.25e2 / 0.1492992e7 * t656 * t1322 - 0.5e1 / 0.15925248e8 * t1354 * t618 * t1355 - t1360 * t43 * t433 * t158 / 0.48e2 - t1367 * t1368 * t1370 / 0.27648e5 - 0.5e1 / 0.55296e5 * t1374 * t1376 + 0.35e2 / 0.62208e5 * t646 * t647 * t1380 + 0.5e1 / 0.72e2 * t619 * t1379 * t282 + t619 * t1387 * t1139 / 0.192e3 + t619 * t1391 * t1144 / 0.1536e4;
  t1396 = t1339 + t1395;
  t1401 = my_piecewise3(t3, 0, t8 * t108 * t672 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1396);
  tv3rholapl20 = 0.2e1 * rho[0] * t1401 + 0.2e1 * t676;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1404 = t505 * t32;
  t1405 = t502 * t1404;
  t1409 = t503 * t503;
  t1410 = 0.1e1 / t1409;
  t1411 = params->A1 * t1410;
  t1412 = t44 * sigma[0];
  t1413 = t1411 * t1412;
  t1414 = t508 * t508;
  t1415 = 0.1e1 / t1414;
  t1424 = t1410 * t1412;
  t1425 = t1415 * t281;
  t1435 = params->A2 * t1410;
  t1436 = t1435 * t1412;
  t1438 = t1415 * t149 * t1109;
  t1441 = t798 * t1410;
  t1442 = t1412 * t1415;
  t1449 = t742 * t1410;
  t1453 = t33 * t511;
  t1457 = 0.1e1 / t503;
  t1458 = params->A3 * t1457;
  t1459 = 0.1e1 / t508;
  t1461 = t1459 * t332 * t333;
  t1464 = t97 * t790;
  t1465 = t791 * t1457;
  t1469 = -t1405 * t1138 * t567 / 0.32e2 + t1413 * t1415 * t286 * t864 / 0.32e2 + t1413 * t1415 * t134 * t831 / 0.4e1 - t1222 * t1424 * t1425 / 0.576e3 + t517 * t578 * t512 / 0.768e3 + t525 * t33 * t527 / 0.576e3 - 0.5e1 / 0.1152e4 * t1436 * t1438 + 0.5e1 / 0.9216e4 * t1441 * t1442 * t312 - 0.7e1 / 0.27648e5 * t532 * t578 * t533 - 0.5e1 / 0.331776e6 * t1257 * t1449 * t1442 + 0.5e1 / 0.663552e6 * t540 * t541 * t1453 + t1458 * t1461 / 0.96e2 - t1464 * t1465 * t1459 / 0.96e2;
  t1473 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1469);
  tv3sigma30 = 0.2e1 * rho[0] * t1473;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1475 = t1410 * lapl[0];
  t1476 = t213 * t1475;
  t1478 = 0.1e1 / t508 / t117;
  t1479 = t1478 * t286;
  t1480 = t864 * t44;
  t1484 = t1478 * t134;
  t1485 = t831 * t44;
  t1489 = t565 * t282;
  t1492 = t715 * t968;
  t1493 = t1478 * t44;
  t1498 = t541 * t1226;
  t1501 = t524 * t1404;
  t1502 = t564 * t85;
  t1503 = params->b * lapl[0];
  t1507 = t1435 * t1493;
  t1508 = lapl[0] * params->beta2;
  t1510 = t453 * t1508 * t735;
  t1513 = params->b * t1410;
  t1514 = t798 * t1513;
  t1515 = lapl[0] * t1478;
  t1516 = t312 * t44;
  t1520 = t565 * params->beta2;
  t1524 = t299 * t743;
  t1531 = t234 * t1457;
  t1532 = 0.1e1 / t266;
  t1534 = t1532 * t332 * t333;
  t1537 = t791 * params->c;
  t1538 = t1457 * t1532;
  t1542 = t1476 * t1479 * t1480 / 0.32e2 + t1476 * t1484 * t1485 / 0.4e1 - t562 * t1489 / 0.96e2 - t1492 * t1475 * t1493 * t281 / 0.576e3 + t1299 * t1498 / 0.2304e4 + t1501 * t1502 * t1503 / 0.1728e4 - 0.5e1 / 0.1152e4 * t1507 * t1510 + 0.5e1 / 0.9216e4 * t1514 * t1515 * t1516 - 0.7e1 / 0.82944e5 * t585 * t573 * t1520 - 0.5e1 / 0.331776e6 * t1524 * t1513 * t1515 * t44 + 0.5e1 / 0.1990656e7 * t465 * t1498 + t1531 * t1534 / 0.96e2 - t1464 * t1537 * t1538 / 0.96e2;
  t1546 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1542);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1546;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1548 = t541 * t32;
  t1549 = t213 * t1548;
  t1553 = t1410 * t54;
  t1554 = t617 * t1553;
  t1555 = t508 * t46;
  t1556 = 0.1e1 / t1555;
  t1557 = t1556 * t286;
  t1558 = t864 * sigma[0];
  t1562 = t1556 * t134;
  t1563 = t831 * sigma[0];
  t1567 = t715 * t1365;
  t1568 = t1556 * t281;
  t1569 = t1568 * sigma[0];
  t1573 = t541 * t574;
  t1576 = t638 * t1553;
  t1577 = t1556 * t149;
  t1578 = t1109 * sigma[0];
  t1579 = t1577 * t1578;
  t1582 = t637 * t1410;
  t1583 = t798 * t1582;
  t1584 = t54 * t1556;
  t1588 = t565 * t226;
  t1600 = t663 * t1457;
  t1601 = 0.1e1 / t117;
  t1603 = t1601 * t332 * t333;
  t1606 = t791 * t662;
  t1607 = t1457 * t1601;
  t1611 = -t1549 * t1215 * t567 / 0.96e2 + t1554 * t1557 * t1558 / 0.32e2 + t1554 * t1562 * t1563 / 0.4e1 - t1567 * t1553 * t1569 / 0.576e3 + t1299 * t1573 / 0.2304e4 - 0.5e1 / 0.1152e4 * t1576 * t1579 + 0.5e1 / 0.9216e4 * t1583 * t1584 * t1247 + t579 * t1588 / 0.1728e4 - 0.7e1 / 0.82944e5 * t585 * t1404 * t588 - 0.5e1 / 0.331776e6 * t1524 * t1582 * t1584 * sigma[0] + 0.5e1 / 0.1990656e7 * t465 * t1573 + t1600 * t1603 / 0.96e2 - t1464 * t1606 * t1607 / 0.96e2;
  t1615 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1611);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1615;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1617 = t617 * t1548;
  t1618 = t621 * t134;
  t1619 = t361 * lapl[0];
  t1623 = t616 * params->a;
  t1624 = params->A1 * t1623;
  t1625 = t54 * lapl[0];
  t1626 = t1410 * t1625;
  t1627 = t1624 * t1626;
  t1628 = 0.1e1 / t509;
  t1629 = t1628 * t286;
  t1633 = t1628 * t134;
  t1638 = t715 * t716 * t1623;
  t1639 = t1628 * t281;
  t1644 = t541 * t90 * t621;
  t1650 = t637 * params->b;
  t1651 = params->A2 * t1650;
  t1652 = t1651 * t1626;
  t1653 = t1628 * t149;
  t1654 = t1653 * t1109;
  t1657 = t798 * t1650;
  t1658 = t1628 * t312;
  t1665 = t1650 * t1410;
  t1666 = t1625 * t1628;
  t1672 = t662 * params->c;
  t1673 = params->A3 * t1672;
  t1674 = t1673 * t1457;
  t1675 = 0.1e1 / t47;
  t1680 = t791 * t1672;
  t1685 = -t1617 * t1618 * t1619 / 0.32e2 + t1627 * t1629 * t864 / 0.32e2 + t1627 * t1633 * t831 / 0.4e1 - t1638 * t1626 * t1639 / 0.576e3 + t627 * t1644 / 0.768e3 + t639 * t90 * t640 / 0.576e3 - 0.5e1 / 0.1152e4 * t1652 * t1654 + 0.5e1 / 0.9216e4 * t1657 * t1626 * t1658 - 0.7e1 / 0.27648e5 * t646 * t573 * t648 - 0.5e1 / 0.331776e6 * t1524 * t1665 * t1666 + 0.5e1 / 0.663552e6 * t656 * t1644 + t1674 * t1675 * t332 * t333 / 0.96e2 - t1464 * t1680 * t1457 * t1675 / 0.96e2;
  t1689 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1685);
  tv3lapl30 = 0.2e1 * rho[0] * t1689;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t38, t40, t42, t43;
  double t44, t45, t46, t47, t49, t51, t52, t53;
  double t54, t55, t56, t58, t59, t62, t64, t67;
  double t68, t69, t72, t73, t76, t77, t79, t82;
  double t83, t84, t85, t88, t89, t90, t92, t96;
  double t97, t99, t100, t102, t106, tzk0;

  double t108, t113, t115, t117, t119, t122, t124, t125;
  double t128, t132, t134, t135, t139, t142, t146, t147;
  double t149, t150, t158, t159, t161, t162, t163, t164;
  double t166, t171, tvrho0, t174, t175, t177, t178, t179;
  double t180, t184, t185, t186, t189, t190, t191, t192;
  double t193, t196, t199, t200, t204, t207, t211, tvsigma0;
  double t213, t214, t215, t216, t220, t221, t222, t223;
  double t226, t227, t231, t234, t235, t236, t242, t245;
  double t249, tvlapl0, tvtau0;

  double t254, t262, t264, t266, t268, t271, t272, t275;
  double t276, t279, t280, t281, t282, t285, t286, t287;
  double t288, t295, t296, t299, t306, t307, t311, t312;
  double t313, t324, t325, t327, t328, t332, t333, t334;
  double t335, t338, t340, t345, tv2rho20, t351, t352, t354;
  double t358, t359, t360, t361, t362, t363, t367, t368;
  double t373, t376, t377, t380, t381, t382, t383, t384;
  double t388, t389, t393, t394, t403, t404, t405, t409;
  double t411, t416, t421, tv2rhosigma0, t427, t431, t432, t433;
  double t434, t438, t440, t441, t442, t447, t450, t453;
  double t454, t455, t456, t457, t458, t465, t466, t476;
  double t477, t482, t491, t496, tv2rholapl0, tv2rhotau0, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t517;
  double t521, t524, t525, t526, t527, t532, t533, t537;
  double t540, t541, t548, t549, t550, t555, t559, tv2sigma20;
  double t561, t562, t564, t565, t566, t567, t572, t573;
  double t574, t578, t579, t580, t585, t586, t588, t595;
  double t596, t597, t600, t601, t602, t606, t610, tv2sigmalapl0;
  double tv2sigmatau0, t612, t616, t617, t618, t619, t621, t622;
  double t623, t627, t628, t629, t630, t633, t637, t638;
  double t639, t640, t644, t646, t647, t648, t652, t656;
  double t659, t662, t663, t664, t668, t672, t676, tv2lapl20;
  double tv2lapltau0, tv2tau20;

  double t681, t692, t694, t699, t700, t702, t703, t704;
  double t705, t709, t714, t715, t716, t722, t725, t726;
  double t729, t733, t734, t735, t741, t742, t743, t749;
  double t756, t759, t761, t765, t767, t770, t772, t775;
  double t776, t779, t780, t781, t789, t790, t791, t792;
  double t798, t802, t805, t806, t811, tv3rho30, t821, t829;
  double t831, t832, t833, t836, t837, t838, t843, t847;
  double t851, t855, t856, t859, t860, t863, t864, t865;
  double t866, t869, t871, t873, t877, t878, t882, t886;
  double t887, t891, t895, t896, t899, t900, t908, t909;
  double t912, t914, t918, t922, t932, t939, t940, t945;
  double t946, t951, tv3rho2sigma0, t964, t968, t970, t972, t981;
  double t985, t986, t990, t997, t1001, t1005, t1006, t1007;
  double t1011, t1020, t1025, t1029, t1032, t1042, t1043, t1065;
  double t1071, t1072, t1077, tv3rho2lapl0, tv3rho2tau0, t1086, t1093, t1095;
  double t1096, t1100, t1103, t1106, t1107, t1108, t1109, t1110;
  double t1111, t1114, t1115, t1123, t1124, t1125, t1130, t1136;
  double t1137, t1138, t1139, t1143, t1144, t1150, t1151, t1152;
  double t1156, t1157, t1158, t1162, t1171, t1172, t1178, t1186;
  double t1187, t1192, tv3rhosigma20, t1198, t1200, t1201, t1207, t1209;
  double t1210, t1211, t1212, t1215, t1216, t1217, t1218, t1219;
  double t1222, t1224, t1225, t1226, t1227, t1228, t1232, t1239;
  double t1240, t1241, t1244, t1246, t1247, t1248, t1253, t1257;
  double t1258, t1260, t1261, t1262, t1271, t1272, t1276, t1279;
  double t1283, t1288, tv3rhosigmalapl0, tv3rhosigmatau0, t1294, t1299, t1304, t1305;
  double t1322, t1328, t1329, t1330, t1331, t1332, t1339, t1340;
  double t1341, t1342, t1354, t1355, t1360, t1365, t1367, t1368;
  double t1369, t1370, t1374, t1375, t1376, t1379, t1380, t1387;
  double t1391, t1395, t1396, t1401, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t1404;
  double t1405, t1409, t1410, t1411, t1412, t1413, t1414, t1415;
  double t1424, t1425, t1435, t1436, t1438, t1441, t1442, t1449;
  double t1453, t1457, t1458, t1459, t1461, t1464, t1465, t1469;
  double t1473, tv3sigma30, t1475, t1476, t1478, t1479, t1480, t1484;
  double t1485, t1489, t1492, t1493, t1498, t1501, t1502, t1503;
  double t1507, t1508, t1510, t1513, t1514, t1515, t1516, t1520;
  double t1524, t1531, t1532, t1534, t1537, t1538, t1542, t1546;
  double tv3sigma2lapl0, tv3sigma2tau0, t1548, t1549, t1553, t1554, t1555, t1556;
  double t1557, t1558, t1562, t1563, t1567, t1568, t1569, t1573;
  double t1576, t1577, t1578, t1579, t1582, t1583, t1584, t1588;
  double t1600, t1601, t1603, t1606, t1607, t1611, t1615, tv3sigmalapl20;
  double tv3sigmalapltau0, tv3sigmatau20, t1617, t1618, t1619, t1623, t1624, t1625;
  double t1626, t1627, t1628, t1629, t1633, t1638, t1639, t1644;
  double t1650, t1651, t1652, t1653, t1654, t1657, t1658, t1665;
  double t1666, t1672, t1673, t1674, t1675, t1680, t1685, t1689;
  double tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  double t1714, t1717, t1721, t1725, t1726, t1727, t1728, t1729;
  double t1732, t1733, t1734, t1735, t1738, t1742, t1749, t1750;
  double t1751, t1752, t1757, t1759, t1764, t1765, t1768, t1783;
  double t1784, t1787, t1795, t1798, t1800, t1807, t1832, t1834;
  double t1835, t1843, t1849, t1850, t1858, t1859, t1867, t1868;
  double t1876, t1882, tv4rho40, t1895, t1900, t1901, t1915, t1921;
  double t1932, t1933, t1939, t1956, t1977, t1978, t2010, t2015;
  double t2016, t2020, t2042, t2044, t2065, t2071, t2106, t2120;
  double t2126, t2133, tv4rho3sigma0, t2149, t2183, t2197, t2203, t2213;
  double t2225, t2233, t2244, t2258, t2276, t2283, t2291, t2308;
  double t2309, t2354, t2361, tv4rho3lapl0, tv4rho3tau0, t2383, t2388, t2395;
  double t2399, t2400, t2416, t2424, t2425, t2429, t2449, t2450;
  double t2465, t2479, t2485, t2522, t2570, t2577, tv4rho2sigma20, t2587;
  double t2591, t2617, t2649, t2654, t2659, t2663, t2664, t2680;
  double t2707, t2711, t2725, t2731, tv4rho2sigmalapl0, tv4rho2sigmatau0, t2791, t2796;
  double t2814, t2840, t2851, t2859, t2873, t2889, t2926, t2933;
  double tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20, t2939, t2940, t2941, t2949, t2957;
  double t2964, t2984, t2993, t3000, t3012, t3058, t3064, tv4rhosigma30;
  double t3082, t3088, t3093, t3101, t3111, t3120, t3128, t3134;
  double t3138, t3159, t3160, t3161, t3165, t3185, t3205, t3211;
  double tv4rhosigma2lapl0, tv4rhosigma2tau0, t3243, t3244, t3263, t3275, t3279, t3284;
  double t3285, t3311, t3334, t3340, tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20, t3358;
  double t3365, t3381, t3391, t3401, t3423, t3448, t3466, t3472;
  double tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30, t3475, t3479, t3480, t3486;
  double t3489, t3490, t3543, t3566, t3569, t3574, tv4sigma40, t3576;
  double t3578, t3585, t3586, t3621, t3666, t3670, tv4sigma3lapl0, tv4sigma3tau0;
  double t3675, t3676, t3681, t3685, t3712, t3746, t3750, t3776;
  double t3792, t3797, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20, t3800, t3809, t3811;
  double t3812, t3845, t3865, t3879, t3888, t3892, tv4sigmalapl30, tv4sigmalapl2tau0;
  double tv4sigmalapltau20, tv4sigmatau30, t3898, t3900, t3910, t3912, t3915, t3916;
  double t3917, t3924, t3929, t3931, t3979, t3995, t4000, tv4lapl40;
  double tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30, tv4tau40;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = t25 * t25;
  t42 = 0.1e1 / t27 / t26;
  t43 = t40 * t42;
  t44 = sigma[0] * sigma[0];
  t45 = t44 * t31;
  t46 = t34 * t34;
  t47 = t46 * rho[0];
  t49 = 0.1e1 / t22 / t47;
  t51 = t43 * t45 * t49;
  t52 = params->a * t40;
  t53 = t52 * t42;
  t54 = lapl[0] * lapl[0];
  t55 = t54 * t31;
  t56 = t34 * rho[0];
  t58 = 0.1e1 / t22 / t56;
  t59 = t55 * t58;
  t62 = 0.2e1 * t53 * t59 + 0.2e1 * t51;
  t64 = sqrt(t62);
  t67 = 0.1e1 + params->beta1 * t64 / 0.24e2;
  t68 = t67 * t67;
  t69 = 0.1e1 / t68;
  t72 = params->b * t40;
  t73 = t72 * t42;
  t76 = 0.2e1 * t73 * t59 + 0.2e1 * t51;
  t77 = t76 * t76;
  t79 = sqrt(t76);
  t82 = 0.1e1 + params->beta2 * t79 / 0.24e2;
  t83 = t82 * t82;
  t84 = t83 * t83;
  t85 = 0.1e1 / t84;
  t88 = params->c * t25;
  t89 = t88 * t29;
  t90 = lapl[0] * t32;
  t92 = 0.1e1 / t23 / rho[0];
  t96 = t89 * t90 * t92 / 0.24e2 + t38 / 0.24e2;
  t97 = params->A3 * t96;
  t99 = params->beta3 * t96 + 0.1e1;
  t100 = 0.1e1 / t99;
  t102 = 0.5e1 / 0.72e2 * t38 + params->A0 + params->A1 * t62 * t69 / 0.576e3 + params->A2 * t77 * t85 / 0.331776e6 + t97 * t100;
  t106 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tzk0 = 0.2e1 * t106;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t108 = t21 / t22;
  t113 = 0.1e1 / t23 / t56;
  t115 = t30 * t33 * t113;
  t117 = t46 * t34;
  t119 = 0.1e1 / t22 / t117;
  t122 = 0.32e2 / 0.3e1 * t43 * t45 * t119;
  t124 = 0.1e1 / t22 / t46;
  t125 = t55 * t124;
  t128 = -t122 - 0.2e2 / 0.3e1 * t53 * t125;
  t132 = params->A1 * t64;
  t134 = 0.1e1 / t68 / t67;
  t135 = t134 * params->beta1;
  t139 = params->A2 * t76;
  t142 = -t122 - 0.2e2 / 0.3e1 * t73 * t125;
  t146 = t79 * t76;
  t147 = params->A2 * t146;
  t149 = 0.1e1 / t84 / t82;
  t150 = t149 * params->beta2;
  t158 = -t115 / 0.9e1 - 0.5e1 / 0.72e2 * t89 * t90 * t36;
  t159 = params->A3 * t158;
  t161 = t99 * t99;
  t162 = 0.1e1 / t161;
  t163 = t162 * params->beta3;
  t164 = t163 * t158;
  t166 = -0.5e1 / 0.27e2 * t115 + params->A1 * t128 * t69 / 0.576e3 - t132 * t135 * t128 / 0.13824e5 + t139 * t85 * t142 / 0.165888e6 - t147 * t150 * t142 / 0.3981312e7 + t159 * t100 - t97 * t164;
  t171 = my_piecewise3(t3, 0, t8 * t108 * t102 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t166);
  tvrho0 = 0.2e1 * rho[0] * t171 + 0.2e1 * t106;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t174 = t32 * t36;
  t175 = t30 * t174;
  t177 = params->A1 * t40;
  t178 = t177 * t42;
  t179 = sigma[0] * t31;
  t180 = t49 * t69;
  t184 = t132 * t135;
  t185 = t179 * t49;
  t186 = t43 * t185;
  t189 = t85 * t40;
  t190 = t139 * t189;
  t191 = t42 * sigma[0];
  t192 = t31 * t49;
  t193 = t191 * t192;
  t196 = t147 * t150;
  t199 = params->A3 * t25;
  t200 = t199 * t29;
  t204 = t97 * t163;
  t207 = 0.5e1 / 0.72e2 * t175 + t178 * t179 * t180 / 0.144e3 - t184 * t186 / 0.3456e4 + t190 * t193 / 0.41472e5 - t196 * t186 / 0.995328e6 + t200 * t174 * t100 / 0.24e2 - t204 * t175 / 0.24e2;
  t211 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t207);
  tvsigma0 = 0.2e1 * rho[0] * t211;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t213 = params->A1 * params->a;
  t214 = t213 * t43;
  t215 = lapl[0] * t31;
  t216 = t58 * t69;
  t220 = t135 * params->a;
  t221 = t132 * t220;
  t222 = t215 * t58;
  t223 = t43 * t222;
  t226 = t85 * params->b;
  t227 = t139 * t226;
  t231 = t147 * t150 * params->b;
  t234 = params->A3 * params->c;
  t235 = t234 * t25;
  t236 = t29 * t32;
  t242 = t88 * t236 * t92;
  t245 = t214 * t215 * t216 / 0.144e3 - t221 * t223 / 0.3456e4 + t227 * t223 / 0.41472e5 - t231 * t223 / 0.995328e6 + t235 * t236 * t92 * t100 / 0.24e2 - t204 * t242 / 0.24e2;
  t249 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t245);
  tvlapl0 = 0.2e1 * rho[0] * t249;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t254 = t21 / t22 / rho[0];
  t262 = 0.1e1 / t23 / t46;
  t264 = t30 * t33 * t262;
  t266 = t46 * t56;
  t268 = 0.1e1 / t22 / t266;
  t271 = 0.608e3 / 0.9e1 * t43 * t45 * t268;
  t272 = t55 * t49;
  t275 = t271 + 0.26e3 / 0.9e1 * t53 * t272;
  t276 = params->A1 * t275;
  t279 = t128 * t128;
  t280 = params->A1 * t279;
  t281 = 0.1e1 / t64;
  t282 = t135 * t281;
  t285 = t68 * t68;
  t286 = 0.1e1 / t285;
  t287 = params->A1 * t286;
  t288 = params->beta1 * params->beta1;
  t295 = t142 * t142;
  t296 = params->A2 * t295;
  t299 = params->A2 * t79;
  t306 = t271 + 0.26e3 / 0.9e1 * t73 * t272;
  t307 = t85 * t306;
  t311 = 0.1e1 / t84 / t83;
  t312 = params->beta2 * params->beta2;
  t313 = t311 * t312;
  t324 = 0.11e2 / 0.27e2 * t264 + 0.5e1 / 0.27e2 * t89 * t90 * t113;
  t325 = params->A3 * t324;
  t327 = t158 * t158;
  t328 = params->A3 * t327;
  t332 = 0.1e1 / t161 / t99;
  t333 = params->beta3 * params->beta3;
  t334 = t332 * t333;
  t335 = t334 * t327;
  t338 = t163 * t324;
  t340 = 0.55e2 / 0.81e2 * t264 + t276 * t69 / 0.576e3 - t280 * t282 / 0.9216e4 + t287 * t288 * t279 / 0.221184e6 - t132 * t135 * t275 / 0.13824e5 + t296 * t85 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t299 * t149 * t295 * params->beta2 + t139 * t307 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t139 * t313 * t295 - t147 * t150 * t306 / 0.3981312e7 + t325 * t100 - 0.2e1 * t328 * t163 + 0.2e1 * t97 * t335 - t97 * t338;
  t345 = my_piecewise3(t3, 0, -t8 * t254 * t102 / 0.3e2 + t8 * t108 * t166 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t340);
  tv2rho20 = 0.2e1 * rho[0] * t345 + 0.4e1 * t171;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t351 = t32 * t113;
  t352 = t30 * t351;
  t354 = t119 * t69;
  t358 = t191 * t31;
  t359 = t177 * t358;
  t360 = t49 * t134;
  t361 = params->beta1 * t281;
  t362 = t361 * t128;
  t363 = t360 * t362;
  t367 = t287 * t288 * t40;
  t368 = t192 * t128;
  t373 = t43 * t179 * t119;
  t376 = params->A2 * t142;
  t377 = t376 * t189;
  t380 = t149 * t40;
  t381 = t380 * t42;
  t382 = t299 * t381;
  t383 = t49 * params->beta2;
  t384 = t383 * t142;
  t388 = t31 * t119;
  t389 = t191 * t388;
  t393 = t139 * t313 * t40;
  t394 = t192 * t142;
  t403 = t199 * t236;
  t404 = t36 * t162;
  t405 = params->beta3 * t158;
  t409 = t97 * t334;
  t411 = t30 * t174 * t158;
  t416 = -0.5e1 / 0.27e2 * t352 - t178 * t179 * t354 / 0.27e2 - t359 * t363 / 0.2304e4 + t367 * t191 * t368 / 0.55296e5 + t184 * t373 / 0.648e3 + t377 * t193 / 0.41472e5 - 0.7e1 / 0.1990656e7 * t382 * t179 * t384 - t190 * t389 / 0.7776e4 + 0.5e1 / 0.47775744e8 * t393 * t191 * t394 + t196 * t373 / 0.186624e6 - t200 * t351 * t100 / 0.9e1 - t403 * t404 * t405 / 0.12e2 + t409 * t411 / 0.12e2 + t204 * t352 / 0.9e1;
  t421 = my_piecewise3(t3, 0, t8 * t108 * t207 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t416);
  tv2rhosigma0 = 0.2e1 * rho[0] * t421 + 0.2e1 * t211;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t427 = t124 * t69;
  t431 = t43 * lapl[0];
  t432 = t213 * t431;
  t433 = t31 * t58;
  t434 = t433 * t134;
  t438 = t288 * params->a;
  t440 = t287 * t438 * t40;
  t441 = t42 * lapl[0];
  t442 = t433 * t128;
  t447 = t43 * t215 * t124;
  t450 = t376 * t226;
  t453 = t149 * params->b;
  t454 = t453 * t40;
  t455 = t299 * t454;
  t456 = t441 * t31;
  t457 = t58 * params->beta2;
  t458 = t457 * t142;
  t465 = t139 * t313 * params->b;
  t466 = t433 * t142;
  t476 = t234 * t30;
  t477 = t32 * t92;
  t482 = t97 * t334 * params->c;
  t491 = -0.5e1 / 0.216e3 * t214 * t215 * t427 - t432 * t434 * t362 / 0.2304e4 + t440 * t441 * t442 / 0.55296e5 + 0.5e1 / 0.5184e4 * t221 * t447 + t450 * t223 / 0.41472e5 - 0.7e1 / 0.1990656e7 * t455 * t456 * t458 - 0.5e1 / 0.62208e5 * t227 * t447 + 0.5e1 / 0.47775744e8 * t465 * t431 * t466 + 0.5e1 / 0.1492992e7 * t231 * t447 - 0.5e1 / 0.72e2 * t235 * t236 * t36 * t100 - t476 * t477 * t164 / 0.12e2 + t482 * t30 * t477 * t158 / 0.12e2 + 0.5e1 / 0.72e2 * t204 * t88 * t236 * t36;
  t496 = my_piecewise3(t3, 0, t8 * t108 * t245 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t491);
  tv2rholapl0 = 0.2e1 * rho[0] * t496 + 0.2e1 * t249;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t502 = params->A1 * t25;
  t503 = t26 * t26;
  t505 = 0.1e1 / t28 / t503;
  t506 = t505 * t44;
  t507 = t502 * t506;
  t508 = t46 * t46;
  t509 = t508 * t34;
  t511 = 0.1e1 / t23 / t509;
  t512 = t32 * t511;
  t517 = t287 * t288 * t25;
  t521 = t43 * t192;
  t524 = params->A2 * t25;
  t525 = t524 * t505;
  t526 = t44 * t32;
  t527 = t511 * t85;
  t532 = t299 * t149 * t25;
  t533 = t512 * params->beta2;
  t537 = t139 * t85;
  t540 = t139 * t313;
  t541 = t25 * t505;
  t548 = params->A3 * t40;
  t549 = t548 * t42;
  t550 = t192 * t163;
  t555 = t178 * t192 * t69 / 0.144e3 - t507 * t512 * t282 / 0.96e2 + t517 * t506 * t512 / 0.2304e4 - t184 * t521 / 0.3456e4 + t525 * t526 * t527 / 0.1728e4 - 0.7e1 / 0.82944e5 * t532 * t506 * t533 + t537 * t521 / 0.41472e5 + 0.5e1 / 0.1990656e7 * t540 * t541 * t526 * t511 - t196 * t521 / 0.995328e6 - t549 * t550 / 0.144e3 + t409 * t521 / 0.144e3;
  t559 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t555);
  tv2sigma20 = 0.2e1 * rho[0] * t559;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t561 = t541 * lapl[0];
  t562 = t213 * t561;
  t564 = 0.1e1 / t23 / t508;
  t565 = t32 * t564;
  t566 = t565 * t134;
  t567 = t361 * sigma[0];
  t572 = t287 * t438 * t25;
  t573 = t505 * lapl[0];
  t574 = t565 * sigma[0];
  t578 = t505 * sigma[0];
  t579 = t524 * t578;
  t580 = t226 * lapl[0];
  t585 = t299 * t453 * t25;
  t586 = t573 * t32;
  t588 = t564 * params->beta2 * sigma[0];
  t595 = t234 * t43;
  t596 = t31 * t124;
  t597 = t596 * t163;
  t600 = params->c * t40;
  t601 = t42 * t31;
  t602 = t601 * t124;
  t606 = -t562 * t566 * t567 / 0.96e2 + t572 * t573 * t574 / 0.2304e4 + t579 * t565 * t580 / 0.1728e4 - 0.7e1 / 0.82944e5 * t585 * t586 * t588 + 0.5e1 / 0.1990656e7 * t465 * t561 * t574 - t595 * t597 / 0.144e3 + t409 * t600 * t602 / 0.144e3;
  t610 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t606);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t610;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t612 = t213 * t40;
  t616 = params->a * params->a;
  t617 = params->A1 * t616;
  t618 = t541 * t54;
  t619 = t617 * t618;
  t621 = 0.1e1 / t23 / t117;
  t622 = t32 * t621;
  t623 = t622 * t282;
  t627 = t287 * t288 * t616;
  t628 = t54 * t32;
  t629 = t628 * t621;
  t630 = t541 * t629;
  t633 = t601 * t58;
  t637 = params->b * params->b;
  t638 = params->A2 * t637;
  t639 = t638 * t541;
  t640 = t621 * t85;
  t644 = t149 * t637;
  t646 = t299 * t644 * t25;
  t647 = t505 * t54;
  t648 = t622 * params->beta2;
  t652 = t43 * t433;
  t656 = t139 * t313 * t637;
  t659 = t72 * t633;
  t662 = params->c * params->c;
  t663 = params->A3 * t662;
  t664 = t663 * t43;
  t668 = t662 * t40;
  t672 = t612 * t601 * t216 / 0.144e3 - t619 * t623 / 0.96e2 + t627 * t630 / 0.2304e4 - t184 * t52 * t633 / 0.3456e4 + t639 * t628 * t640 / 0.1728e4 - 0.7e1 / 0.82944e5 * t646 * t647 * t648 + t227 * t652 / 0.41472e5 + 0.5e1 / 0.1990656e7 * t656 * t630 - t196 * t659 / 0.995328e6 - t664 * t433 * t163 / 0.144e3 + t409 * t668 * t633 / 0.144e3;
  t676 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t672);
  tv2lapl20 = 0.2e1 * rho[0] * t676;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t681 = t21 / t22 / t34;
  t692 = 0.1e1 / t23 / t47;
  t694 = t30 * t33 * t692;
  t699 = -0.154e3 / 0.81e2 * t694 - 0.55e2 / 0.81e2 * t89 * t90 * t262;
  t700 = t163 * t699;
  t702 = t279 * t128;
  t703 = params->A1 * t702;
  t704 = t286 * t288;
  t705 = 0.1e1 / t62;
  t709 = t288 * t128;
  t714 = 0.1e1 / t285 / t67;
  t715 = params->A1 * t714;
  t716 = t288 * params->beta1;
  t722 = 0.1e1 / t22 / t508;
  t725 = 0.13376e5 / 0.27e2 * t43 * t45 * t722;
  t726 = t55 * t119;
  t729 = -t725 - 0.416e4 / 0.27e2 * t53 * t726;
  t733 = t295 * t142;
  t734 = params->A2 * t733;
  t735 = 0.1e1 / t79;
  t741 = 0.1e1 / t84 / t83 / t82;
  t742 = t312 * params->beta2;
  t743 = t741 * t742;
  t749 = -t725 - 0.416e4 / 0.27e2 * t73 * t726;
  t756 = t276 * t134;
  t759 = -t97 * t700 + t703 * t704 * t705 / 0.147456e6 + t287 * t709 * t275 / 0.73728e5 - t715 * t716 * t702 * t281 / 0.2654208e7 - t132 * t135 * t729 / 0.13824e5 - 0.5e1 / 0.5308416e7 * t734 * t150 * t735 - 0.5e1 / 0.1528823808e10 * t299 * t743 * t733 - t147 * t150 * t749 / 0.3981312e7 - 0.77e3 / 0.243e3 * t694 - 0.6e1 * t325 * t164 - t756 * t362 / 0.3072e4;
  t761 = 0.1e1 / t64 / t62;
  t765 = t299 * t149;
  t767 = t142 * params->beta2 * t306;
  t770 = t139 * t311;
  t772 = t312 * t142 * t306;
  t775 = t327 * t158;
  t776 = params->A3 * t775;
  t779 = t97 * t332;
  t780 = t333 * t158;
  t781 = t780 * t324;
  t789 = t161 * t161;
  t790 = 0.1e1 / t789;
  t791 = t333 * params->beta3;
  t792 = t790 * t791;
  t798 = params->A2 * t311;
  t802 = t85 * t749;
  t805 = t703 * t135 * t761 / 0.18432e5 - 0.7e1 / 0.2654208e7 * t765 * t767 + 0.5e1 / 0.63700992e8 * t770 * t772 + 0.6e1 * t776 * t334 + 0.6e1 * t779 * t781 + params->A1 * t729 * t69 / 0.576e3 + params->A3 * t699 * t100 - 0.6e1 * t97 * t792 * t775 + t376 * t307 / 0.55296e5 + 0.5e1 / 0.42467328e8 * t798 * t733 * t312 + t139 * t802 / 0.165888e6;
  t806 = t759 + t805;
  t811 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t681 * t102 - t8 * t254 * t166 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t108 * t340 + 0.3e1 / 0.2e2 * t8 * t24 * t806);
  tv3rho30 = 0.2e1 * rho[0] * t811 + 0.6e1 * t345;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t821 = t32 * t262;
  t829 = t30 * t821;
  t831 = params->beta1 * t761;
  t832 = t831 * t279;
  t833 = t360 * t832;
  t836 = t743 * t40;
  t837 = t299 * t836;
  t838 = t192 * t295;
  t843 = t383 * t735;
  t847 = t383 * t306;
  t851 = t192 * t306;
  t855 = t119 * t134;
  t856 = t855 * t362;
  t859 = t361 * t275;
  t860 = t360 * t859;
  t863 = t49 * t286;
  t864 = t288 * t705;
  t865 = t864 * t279;
  t866 = t863 * t865;
  t869 = t716 * t40;
  t871 = t715 * t869 * t42;
  t873 = t49 * t279 * t281;
  t877 = t119 * params->beta2;
  t878 = t877 * t142;
  t882 = t388 * t142;
  t886 = 0.11e2 / 0.27e2 * t200 * t821 * t100 + 0.19e2 / 0.81e2 * t178 * t179 * t268 * t69 + 0.55e2 / 0.81e2 * t829 + t359 * t833 / 0.4608e4 - 0.5e1 / 0.382205952e9 * t837 * t191 * t838 - 0.5e1 / 0.1327104e7 * t296 * t381 * t179 * t843 - 0.7e1 / 0.1990656e7 * t382 * t179 * t847 + 0.5e1 / 0.47775744e8 * t393 * t191 * t851 + t359 * t856 / 0.216e3 - t359 * t860 / 0.2304e4 + t359 * t866 / 0.36864e5 - t871 * t179 * t873 / 0.663552e6 + 0.7e1 / 0.186624e6 * t382 * t179 * t878 - 0.5e1 / 0.4478976e7 * t393 * t191 * t882;
  t887 = t113 * t162;
  t891 = params->beta3 * t324;
  t895 = params->A2 * t306;
  t896 = t895 * t189;
  t899 = t36 * t332;
  t900 = t333 * t327;
  t908 = t31 * t268;
  t909 = t191 * t908;
  t912 = t97 * t792;
  t914 = t30 * t174 * t327;
  t918 = t43 * t179 * t268;
  t922 = t30 * t351 * t158;
  t932 = t30 * t174 * t324;
  t939 = t798 * t43;
  t940 = t49 * t312;
  t945 = 0.4e1 / 0.9e1 * t403 * t887 * t405 - t403 * t404 * t891 / 0.12e2 + t896 * t193 / 0.41472e5 + t403 * t899 * t900 / 0.4e1 - 0.11e2 / 0.27e2 * t204 * t829 - t377 * t389 / 0.3888e4 + 0.19e2 / 0.23328e5 * t190 * t909 - t912 * t914 / 0.4e1 - 0.19e2 / 0.559872e6 * t196 * t918 - 0.4e1 / 0.9e1 * t409 * t922 - 0.19e2 / 0.1944e4 * t184 * t918 - t367 * t191 * t388 * t128 / 0.5184e4 + t409 * t932 / 0.12e2 + t367 * t191 * t192 * t275 / 0.55296e5 + 0.5e1 / 0.10616832e8 * t939 * t179 * t940 * t295;
  t946 = t886 + t945;
  t951 = my_piecewise3(t3, 0, -t8 * t254 * t207 / 0.3e2 + t8 * t108 * t416 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t946);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t951 + 0.4e1 * t421;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t964 = t433 * t286;
  t968 = t716 * params->a;
  t970 = t715 * t968 * t40;
  t972 = t58 * t279 * t281;
  t981 = t596 * t134;
  t985 = t124 * params->beta2;
  t986 = t985 * t142;
  t990 = t596 * t142;
  t997 = t457 * t306;
  t1001 = t433 * t306;
  t1005 = t743 * params->b;
  t1006 = t299 * t1005;
  t1007 = t433 * t295;
  t1011 = t433 * t275;
  t1020 = t97 * t792 * params->c;
  t1025 = -t432 * t434 * t859 / 0.2304e4 + t432 * t964 * t865 / 0.36864e5 - t970 * t456 * t972 / 0.663552e6 - 0.5e1 / 0.1327104e7 * t296 * t454 * t456 * t457 * t735 + 0.5e1 / 0.1728e4 * t432 * t981 * t362 + 0.35e2 / 0.1492992e7 * t455 * t456 * t986 - 0.25e2 / 0.35831808e8 * t465 * t431 * t990 + t432 * t434 * t832 / 0.4608e4 - 0.7e1 / 0.1990656e7 * t455 * t456 * t997 + 0.5e1 / 0.47775744e8 * t465 * t431 * t1001 - 0.5e1 / 0.382205952e9 * t1006 * t431 * t1007 + t440 * t441 * t1011 / 0.55296e5 + 0.5e1 / 0.27e2 * t235 * t236 * t113 * t100 - t1020 * t30 * t477 * t327 / 0.4e1;
  t1029 = t43 * t215 * t49;
  t1032 = t596 * t128;
  t1042 = t798 * t73;
  t1043 = t58 * t312;
  t1065 = t895 * t226;
  t1071 = -0.5e1 / 0.18e2 * t482 * t411 - 0.65e2 / 0.4478976e7 * t231 * t1029 - 0.5e1 / 0.41472e5 * t440 * t441 * t1032 - 0.65e2 / 0.15552e5 * t221 * t1029 + t482 * t30 * t477 * t324 / 0.12e2 + 0.5e1 / 0.10616832e8 * t1042 * t215 * t1043 * t295 + 0.65e2 / 0.648e3 * t214 * t215 * t180 + t476 * t477 * t335 / 0.4e1 - 0.5e1 / 0.27e2 * t204 * t88 * t236 * t113 - 0.5e1 / 0.31104e5 * t450 * t447 + 0.65e2 / 0.186624e6 * t227 * t1029 - t476 * t477 * t338 / 0.12e2 + t1065 * t223 / 0.41472e5 + 0.5e1 / 0.18e2 * t476 * t174 * t164;
  t1072 = t1025 + t1071;
  t1077 = my_piecewise3(t3, 0, -t8 * t254 * t245 / 0.3e2 + t8 * t108 * t491 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t1072);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t1077 + 0.4e1 * t496;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1086 = t376 * t85;
  t1093 = t508 * t56;
  t1095 = 0.1e1 / t23 / t1093;
  t1096 = t1095 * t85;
  t1100 = t43 * t388;
  t1103 = t388 * t163;
  t1106 = t506 * t32;
  t1107 = t524 * t1106;
  t1108 = t511 * t149;
  t1109 = params->beta2 * t735;
  t1110 = t1109 * t142;
  t1111 = t1108 * t1110;
  t1114 = t32 * t1095;
  t1115 = t1114 * params->beta2;
  t1123 = t743 * t25;
  t1124 = t299 * t1123;
  t1125 = t512 * t142;
  t1130 = t43 * t192 * t158;
  t1136 = -t178 * t388 * t69 / 0.27e2 + t1086 * t521 / 0.41472e5 + t367 * t601 * t49 * t128 / 0.55296e5 - t525 * t526 * t1096 / 0.162e3 - t537 * t1100 / 0.7776e4 + t549 * t1103 / 0.27e2 - 0.5e1 / 0.55296e5 * t1107 * t1111 + 0.7e1 / 0.7776e4 * t532 * t506 * t1115 - 0.5e1 / 0.186624e6 * t540 * t541 * t526 * t1095 - 0.5e1 / 0.15925248e8 * t1124 * t506 * t1125 - t912 * t1130 / 0.48e2 + t507 * t1114 * t282 / 0.9e1;
  t1137 = t502 * t1106;
  t1138 = t511 * t134;
  t1139 = t831 * t128;
  t1143 = t511 * t286;
  t1144 = t864 * t128;
  t1150 = t715 * t716 * t25 * t505;
  t1151 = t511 * t281;
  t1152 = t1151 * t128;
  t1156 = t798 * t541;
  t1157 = t511 * t312;
  t1158 = t1157 * t142;
  t1162 = t299 * t380;
  t1171 = t548 * t601;
  t1172 = t49 * t332;
  t1178 = t177 * t601;
  t1186 = t1137 * t1138 * t1139 / 0.192e3 + t1137 * t1143 * t1144 / 0.1536e4 - t1150 * t526 * t1152 / 0.27648e5 + 0.5e1 / 0.442368e6 * t1156 * t526 * t1158 - 0.7e1 / 0.1990656e7 * t1162 * t601 * t384 + t196 * t1100 / 0.186624e6 + 0.5e1 / 0.47775744e8 * t540 * t43 * t394 + t1171 * t1172 * t780 / 0.48e2 - t409 * t1100 / 0.27e2 - t1178 * t363 / 0.2304e4 - t517 * t506 * t1114 / 0.216e3 + t184 * t1100 / 0.648e3;
  t1187 = t1136 + t1186;
  t1192 = my_piecewise3(t3, 0, t8 * t108 * t555 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1187);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1192 + 0.2e1 * t559;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t1198 = t508 * rho[0];
  t1200 = 0.1e1 / t23 / t1198;
  t1201 = t32 * t1200;
  t1207 = t213 * t25 * t586;
  t1209 = t564 * t286 * t288;
  t1210 = t705 * sigma[0];
  t1211 = t1210 * t128;
  t1212 = t1209 * t1211;
  t1215 = t564 * t134;
  t1216 = t1215 * params->beta1;
  t1217 = t761 * sigma[0];
  t1218 = t1217 * t128;
  t1219 = t1216 * t1218;
  t1222 = t715 * t716;
  t1224 = params->a * t25 * t505;
  t1225 = t1222 * t1224;
  t1226 = t90 * t564;
  t1227 = sigma[0] * t281;
  t1228 = t1227 * t128;
  t1232 = t1201 * sigma[0];
  t1239 = t525 * t574;
  t1240 = t453 * lapl[0];
  t1241 = t1240 * t1110;
  t1244 = params->b * t25;
  t1246 = t798 * t1244 * t505;
  t1247 = t312 * sigma[0];
  t1248 = t1247 * t142;
  t1253 = t1200 * params->beta2 * sigma[0];
  t1257 = t299 * t741;
  t1258 = t742 * params->b;
  t1260 = t1257 * t1258 * t25;
  t1261 = t564 * sigma[0];
  t1262 = t1261 * t142;
  t1271 = t334 * t158;
  t1272 = t596 * t1271;
  t1276 = t43 * t596 * t158;
  t1279 = t601 * t49;
  t1283 = 0.13e2 / 0.144e3 * t562 * t1201 * t134 * t567 + t1207 * t1212 / 0.1536e4 + t1207 * t1219 / 0.192e3 - t1225 * t1226 * t1228 / 0.27648e5 - 0.13e2 / 0.3456e4 * t572 * t573 * t1232 - 0.13e2 / 0.2592e4 * t579 * t1201 * t580 - 0.5e1 / 0.55296e5 * t1239 * t1241 + 0.5e1 / 0.442368e6 * t1246 * t1226 * t1248 + 0.91e2 / 0.124416e6 * t585 * t586 * t1253 - 0.5e1 / 0.15925248e8 * t1260 * t586 * t1262 - 0.65e2 / 0.2985984e7 * t465 * t561 * t1232 + 0.13e2 / 0.432e3 * t595 * t550 + t595 * t1272 / 0.48e2 - t1020 * t1276 / 0.48e2 - 0.13e2 / 0.432e3 * t409 * t600 * t1279;
  t1288 = my_piecewise3(t3, 0, t8 * t108 * t606 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1283);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1288 + 0.2e1 * t610;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1294 = t43 * t596;
  t1299 = t287 * t438;
  t1304 = 0.1e1 / t23 / t266;
  t1305 = t1304 * t85;
  t1322 = t541 * t628 * t1304;
  t1328 = t637 * t25;
  t1329 = t1328 * t505;
  t1330 = t798 * t1329;
  t1331 = t621 * t312;
  t1332 = t1331 * t142;
  t1339 = -0.5e1 / 0.62208e5 * t227 * t1294 + 0.5e1 / 0.216e3 * t664 * t597 + t1299 * t43 * t442 / 0.55296e5 - 0.5e1 / 0.1296e4 * t639 * t628 * t1305 + 0.5e1 / 0.1492992e7 * t196 * t72 * t602 + 0.5e1 / 0.47775744e8 * t465 * t43 * t466 + t664 * t433 * t1271 / 0.48e2 - 0.5e1 / 0.216e3 * t409 * t668 * t602 - 0.5e1 / 0.1728e4 * t627 * t1322 + 0.5e1 / 0.5184e4 * t184 * t52 * t602 + 0.5e1 / 0.442368e6 * t1330 * t628 * t1332 - 0.7e1 / 0.1990656e7 * t455 * t601 * t458;
  t1340 = t43 * t31;
  t1341 = t213 * t1340;
  t1342 = t58 * t134;
  t1354 = t299 * t743 * t637;
  t1355 = t622 * t142;
  t1360 = t97 * t792 * t662;
  t1365 = t716 * t616;
  t1367 = t715 * t1365 * t25;
  t1368 = t647 * t32;
  t1369 = t621 * t281;
  t1370 = t1369 * t128;
  t1374 = t638 * t618;
  t1375 = t622 * t149;
  t1376 = t1375 * t1110;
  t1379 = t32 * t1304;
  t1380 = t1379 * params->beta2;
  t1387 = t622 * t134;
  t1391 = t622 * t286;
  t1395 = -t1341 * t1342 * t362 / 0.2304e4 - 0.5e1 / 0.216e3 * t612 * t601 * t427 + t450 * t652 / 0.41472e5 - 0.25e2 / 0.1492992e7 * t656 * t1322 - 0.5e1 / 0.15925248e8 * t1354 * t618 * t1355 - t1360 * t43 * t433 * t158 / 0.48e2 - t1367 * t1368 * t1370 / 0.27648e5 - 0.5e1 / 0.55296e5 * t1374 * t1376 + 0.35e2 / 0.62208e5 * t646 * t647 * t1380 + 0.5e1 / 0.72e2 * t619 * t1379 * t282 + t619 * t1387 * t1139 / 0.192e3 + t619 * t1391 * t1144 / 0.1536e4;
  t1396 = t1339 + t1395;
  t1401 = my_piecewise3(t3, 0, t8 * t108 * t672 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1396);
  tv3rholapl20 = 0.2e1 * rho[0] * t1401 + 0.2e1 * t676;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1404 = t505 * t32;
  t1405 = t502 * t1404;
  t1409 = t503 * t503;
  t1410 = 0.1e1 / t1409;
  t1411 = params->A1 * t1410;
  t1412 = t44 * sigma[0];
  t1413 = t1411 * t1412;
  t1414 = t508 * t508;
  t1415 = 0.1e1 / t1414;
  t1424 = t1410 * t1412;
  t1425 = t1415 * t281;
  t1435 = params->A2 * t1410;
  t1436 = t1435 * t1412;
  t1438 = t1415 * t149 * t1109;
  t1441 = t798 * t1410;
  t1442 = t1412 * t1415;
  t1449 = t742 * t1410;
  t1453 = t33 * t511;
  t1457 = 0.1e1 / t503;
  t1458 = params->A3 * t1457;
  t1459 = 0.1e1 / t508;
  t1461 = t1459 * t332 * t333;
  t1464 = t97 * t790;
  t1465 = t791 * t1457;
  t1469 = -t1405 * t1138 * t567 / 0.32e2 + t1413 * t1415 * t286 * t864 / 0.32e2 + t1413 * t1415 * t134 * t831 / 0.4e1 - t1222 * t1424 * t1425 / 0.576e3 + t517 * t578 * t512 / 0.768e3 + t525 * t33 * t527 / 0.576e3 - 0.5e1 / 0.1152e4 * t1436 * t1438 + 0.5e1 / 0.9216e4 * t1441 * t1442 * t312 - 0.7e1 / 0.27648e5 * t532 * t578 * t533 - 0.5e1 / 0.331776e6 * t1257 * t1449 * t1442 + 0.5e1 / 0.663552e6 * t540 * t541 * t1453 + t1458 * t1461 / 0.96e2 - t1464 * t1465 * t1459 / 0.96e2;
  t1473 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1469);
  tv3sigma30 = 0.2e1 * rho[0] * t1473;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1475 = t1410 * lapl[0];
  t1476 = t213 * t1475;
  t1478 = 0.1e1 / t508 / t117;
  t1479 = t1478 * t286;
  t1480 = t864 * t44;
  t1484 = t1478 * t134;
  t1485 = t831 * t44;
  t1489 = t565 * t282;
  t1492 = t715 * t968;
  t1493 = t1478 * t44;
  t1498 = t541 * t1226;
  t1501 = t524 * t1404;
  t1502 = t564 * t85;
  t1503 = params->b * lapl[0];
  t1507 = t1435 * t1493;
  t1508 = lapl[0] * params->beta2;
  t1510 = t453 * t1508 * t735;
  t1513 = params->b * t1410;
  t1514 = t798 * t1513;
  t1515 = lapl[0] * t1478;
  t1516 = t312 * t44;
  t1520 = t565 * params->beta2;
  t1524 = t299 * t743;
  t1531 = t234 * t1457;
  t1532 = 0.1e1 / t266;
  t1534 = t1532 * t332 * t333;
  t1537 = t791 * params->c;
  t1538 = t1457 * t1532;
  t1542 = t1476 * t1479 * t1480 / 0.32e2 + t1476 * t1484 * t1485 / 0.4e1 - t562 * t1489 / 0.96e2 - t1492 * t1475 * t1493 * t281 / 0.576e3 + t1299 * t1498 / 0.2304e4 + t1501 * t1502 * t1503 / 0.1728e4 - 0.5e1 / 0.1152e4 * t1507 * t1510 + 0.5e1 / 0.9216e4 * t1514 * t1515 * t1516 - 0.7e1 / 0.82944e5 * t585 * t573 * t1520 - 0.5e1 / 0.331776e6 * t1524 * t1513 * t1515 * t44 + 0.5e1 / 0.1990656e7 * t465 * t1498 + t1531 * t1534 / 0.96e2 - t1464 * t1537 * t1538 / 0.96e2;
  t1546 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1542);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1546;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1548 = t541 * t32;
  t1549 = t213 * t1548;
  t1553 = t1410 * t54;
  t1554 = t617 * t1553;
  t1555 = t508 * t46;
  t1556 = 0.1e1 / t1555;
  t1557 = t1556 * t286;
  t1558 = t864 * sigma[0];
  t1562 = t1556 * t134;
  t1563 = t831 * sigma[0];
  t1567 = t715 * t1365;
  t1568 = t1556 * t281;
  t1569 = t1568 * sigma[0];
  t1573 = t541 * t574;
  t1576 = t638 * t1553;
  t1577 = t1556 * t149;
  t1578 = t1109 * sigma[0];
  t1579 = t1577 * t1578;
  t1582 = t637 * t1410;
  t1583 = t798 * t1582;
  t1584 = t54 * t1556;
  t1588 = t565 * t226;
  t1600 = t663 * t1457;
  t1601 = 0.1e1 / t117;
  t1603 = t1601 * t332 * t333;
  t1606 = t791 * t662;
  t1607 = t1457 * t1601;
  t1611 = -t1549 * t1215 * t567 / 0.96e2 + t1554 * t1557 * t1558 / 0.32e2 + t1554 * t1562 * t1563 / 0.4e1 - t1567 * t1553 * t1569 / 0.576e3 + t1299 * t1573 / 0.2304e4 - 0.5e1 / 0.1152e4 * t1576 * t1579 + 0.5e1 / 0.9216e4 * t1583 * t1584 * t1247 + t579 * t1588 / 0.1728e4 - 0.7e1 / 0.82944e5 * t585 * t1404 * t588 - 0.5e1 / 0.331776e6 * t1524 * t1582 * t1584 * sigma[0] + 0.5e1 / 0.1990656e7 * t465 * t1573 + t1600 * t1603 / 0.96e2 - t1464 * t1606 * t1607 / 0.96e2;
  t1615 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1611);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1615;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1617 = t617 * t1548;
  t1618 = t621 * t134;
  t1619 = t361 * lapl[0];
  t1623 = t616 * params->a;
  t1624 = params->A1 * t1623;
  t1625 = t54 * lapl[0];
  t1626 = t1410 * t1625;
  t1627 = t1624 * t1626;
  t1628 = 0.1e1 / t509;
  t1629 = t1628 * t286;
  t1633 = t1628 * t134;
  t1638 = t715 * t716 * t1623;
  t1639 = t1628 * t281;
  t1644 = t541 * t90 * t621;
  t1650 = t637 * params->b;
  t1651 = params->A2 * t1650;
  t1652 = t1651 * t1626;
  t1653 = t1628 * t149;
  t1654 = t1653 * t1109;
  t1657 = t798 * t1650;
  t1658 = t1628 * t312;
  t1665 = t1650 * t1410;
  t1666 = t1625 * t1628;
  t1672 = t662 * params->c;
  t1673 = params->A3 * t1672;
  t1674 = t1673 * t1457;
  t1675 = 0.1e1 / t47;
  t1680 = t791 * t1672;
  t1685 = -t1617 * t1618 * t1619 / 0.32e2 + t1627 * t1629 * t864 / 0.32e2 + t1627 * t1633 * t831 / 0.4e1 - t1638 * t1626 * t1639 / 0.576e3 + t627 * t1644 / 0.768e3 + t639 * t90 * t640 / 0.576e3 - 0.5e1 / 0.1152e4 * t1652 * t1654 + 0.5e1 / 0.9216e4 * t1657 * t1626 * t1658 - 0.7e1 / 0.27648e5 * t646 * t573 * t648 - 0.5e1 / 0.331776e6 * t1524 * t1665 * t1666 + 0.5e1 / 0.663552e6 * t656 * t1644 + t1674 * t1675 * t332 * t333 / 0.96e2 - t1464 * t1680 * t1457 * t1675 / 0.96e2;
  t1689 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1685);
  tv3lapl30 = 0.2e1 * rho[0] * t1689;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1714 = t1109 * t306;
  t1717 = t742 * t295;
  t1721 = t324 * t324;
  t1725 = t279 * t279;
  t1726 = params->A1 * t1725;
  t1727 = t62 * t62;
  t1728 = 0.1e1 / t1727;
  t1729 = t704 * t1728;
  t1732 = t295 * t295;
  t1733 = params->A2 * t1732;
  t1734 = 0.1e1 / t146;
  t1735 = t150 * t1734;
  t1738 = params->A2 * t735;
  t1742 = t295 * t312;
  t1749 = 0.1e1 / t789 / t99;
  t1750 = t333 * t333;
  t1751 = t1749 * t1750;
  t1752 = t327 * t327;
  t1757 = t30 * t33 * t621;
  t1759 = t275 * t275;
  t1764 = 0.1e1 / t64 / t1727;
  t1765 = t135 * t1764;
  t1768 = t306 * t306;
  t1783 = 0.3344e6 / 0.81e2 * t43 * t45 / t22 / t1198;
  t1784 = t55 * t268;
  t1787 = t1783 + 0.7904e5 / 0.81e2 * t53 * t1784;
  t1795 = 0.2618e4 / 0.243e3 * t1757 + 0.77e3 / 0.243e3 * t89 * t90 * t692;
  t1798 = -0.36e2 * t1464 * t791 * t327 * t324 + 0.8e1 * t779 * t333 * t699 * t158 - 0.5e1 / 0.884736e6 * t296 * t149 * t1714 - 0.5e1 / 0.254803968e9 * t1257 * t1717 * t306 + 0.6e1 * t97 * t334 * t1721 - t1726 * t1729 / 0.98304e5 + 0.5e1 / 0.10616832e8 * t1733 * t1735 - 0.25e2 / 0.1528823808e10 * t1738 * t743 * t1732 + 0.5e1 / 0.7077888e7 * t798 * t1742 * t306 - 0.8e1 * t159 * t700 + 0.24e2 * t97 * t1751 * t1752 + 0.1309e5 / 0.729e3 * t1757 - params->A1 * t1759 * t282 / 0.3072e4 - t1726 * t1765 / 0.12288e5 - 0.7e1 / 0.2654208e7 * t299 * t149 * t1768 * params->beta2 + 0.5e1 / 0.63700992e8 * t139 * t313 * t1768 + params->A2 * t1768 * t85 / 0.55296e5 + params->A1 * t1787 * t69 / 0.576e3 + params->A3 * t1795 * t100;
  t1800 = t864 * t275;
  t1807 = params->A1 * t281;
  t1832 = t84 * t84;
  t1834 = params->A2 / t1832;
  t1835 = t312 * t312;
  t1843 = t1783 + 0.7904e5 / 0.81e2 * t73 * t1784;
  t1849 = t714 * t716;
  t1850 = t1849 * t761;
  t1858 = params->A1 / t285 / t68;
  t1859 = t288 * t288;
  t1867 = 0.1e1 / t76;
  t1868 = t313 * t1867;
  t1876 = t280 * t286 * t1800 / 0.24576e5 - t1222 * t279 * t275 * t281 / 0.442368e6 - t1807 * t134 * params->beta1 * t729 * t128 / 0.2304e4 + 0.5e1 / 0.47775744e8 * t770 * t312 * t749 * t142 + t756 * t832 / 0.3072e4 - 0.7e1 / 0.1990656e7 * t765 * params->beta2 * t749 * t142 - 0.24e2 * params->A3 * t1752 * t792 - 0.6e1 * params->A3 * t1721 * t163 + t287 * t288 * t1759 / 0.73728e5 + 0.35e2 / 0.73383542784e11 * t1834 * t1835 * t1732 + t376 * t802 / 0.41472e5 + t139 * t85 * t1843 / 0.165888e6 - t97 * t163 * t1795 - t1726 * t1850 / 0.2654208e7 + t287 * t709 * t729 / 0.55296e5 + 0.5e1 / 0.127401984e9 * t1858 * t1859 * t1725 * t705 - t132 * t135 * t1787 / 0.13824e5 + 0.25e2 / 0.254803968e9 * t1733 * t1868 - t147 * t150 * t1843 / 0.3981312e7 + 0.36e2 * t325 * t335;
  t1882 = my_piecewise3(t3, 0, -0.14e2 / 0.135e3 * t8 * t21 * t58 * t102 + 0.8e1 / 0.45e2 * t8 * t681 * t166 - t8 * t254 * t340 / 0.5e1 + 0.2e1 / 0.5e1 * t8 * t108 * t806 + 0.3e1 / 0.2e2 * t8 * t24 * (t1798 + t1876));
  tv4rho40 = 0.2e1 * rho[0] * t1882 + 0.8e1 * t811;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1895 = t32 * t692;
  t1900 = t761 * t128;
  t1901 = t1900 * t275;
  t1915 = t128 * t281 * t275;
  t1921 = t705 * t275 * t128;
  t1932 = params->beta1 * t1764;
  t1933 = t1932 * t702;
  t1939 = t191 * t192 * t733;
  t1956 = -0.154e3 / 0.81e2 * t200 * t1895 * t100 + t359 * t360 * params->beta1 * t1901 / 0.1536e4 - 0.5e1 / 0.127401984e9 * t837 * t358 * t49 * t142 * t306 - 0.5e1 / 0.442368e6 * t895 * t381 * t185 * t1110 - t871 * t185 * t1915 / 0.221184e6 + t359 * t863 * t288 * t1921 / 0.12288e5 - 0.418e3 / 0.243e3 * t178 * t179 * t722 * t69 - t359 * t855 * t832 / 0.288e3 - t359 * t360 * t1933 / 0.3072e4 - 0.25e2 / 0.382205952e9 * t1738 * t836 * t1939 + 0.5e1 / 0.82944e5 * t1738 * t381 * t179 * t877 * t295 - 0.133e3 / 0.373248e6 * t382 * t179 * t268 * params->beta2 * t142 + 0.95e2 / 0.8957952e7 * t393 * t191 * t908 * t142;
  t1977 = t288 * t1728;
  t1978 = t1977 * t702;
  t2010 = t361 * t729;
  t2015 = t716 * t761;
  t2016 = t2015 * t702;
  t2020 = -0.7e1 / 0.1990656e7 * t382 * t179 * t383 * t749 + 0.5e1 / 0.3538944e7 * t798 * t43 * sigma[0] * t192 * t772 + 0.5e1 / 0.47775744e8 * t393 * t191 * t192 * t749 + t359 * t855 * t859 / 0.144e3 - t359 * t119 * t286 * t865 / 0.2304e4 - t359 * t863 * t1978 / 0.24576e5 + 0.7e1 / 0.124416e6 * t382 * t179 * t877 * t306 - 0.5e1 / 0.2985984e7 * t393 * t191 * t388 * t306 + 0.5e1 / 0.23887872e8 * t837 * t191 * t388 * t295 - 0.3e1 / 0.4e1 * t97 * t792 * t25 * t236 * t36 * t158 * t324 - 0.19e2 / 0.432e3 * t359 * t268 * t134 * t362 + 0.5e1 / 0.2654208e7 * t734 * t381 * t179 * t383 * t1734 - t359 * t360 * t2010 / 0.2304e4 - t359 * t49 * t714 * t2016 / 0.663552e6;
  t2042 = t30 * t1895;
  t2044 = params->A2 * t749;
  t2065 = t776 * t792;
  t2071 = t871 * t179 * t119 * t279 * t281 / 0.41472e5 + 0.5e1 / 0.31850496e8 * t1858 * t1859 * t40 * t42 * t179 * t49 * t702 * t705 + 0.25e2 / 0.63700992e8 * t734 * t311 * t40 * t42 * t179 * t940 * t1867 - 0.77e3 / 0.243e3 * t2042 + t2044 * t189 * t193 / 0.41472e5 + 0.2e1 / 0.3e1 * t403 * t887 * t891 - t403 * t404 * params->beta3 * t699 / 0.12e2 + 0.19e2 / 0.7776e4 * t377 * t909 - 0.209e3 / 0.34992e5 * t190 * t191 * t31 * t722 + 0.154e3 / 0.81e2 * t204 * t2042 - t896 * t389 / 0.2592e4 - t2065 * t175 - 0.22e2 / 0.9e1 * t403 * t262 * t162 * t405;
  t2106 = t43 * t179 * t722;
  t2120 = t97 * t1751;
  t2126 = -0.2e1 * t403 * t113 * t332 * t900 - 0.2e1 / 0.3e1 * t409 * t30 * t351 * t324 + 0.19e2 / 0.10368e5 * t367 * t191 * t908 * t128 - t367 * t191 * t388 * t275 / 0.3456e4 + t409 * t30 * t174 * t699 / 0.12e2 + t367 * t191 * t192 * t729 / 0.55296e5 - 0.5e1 / 0.663552e6 * t939 * t179 * t119 * t312 * t295 + 0.35e2 / 0.18345885696e11 * t1834 * t1835 * t40 * t1939 + 0.209e3 / 0.839808e6 * t196 * t2106 + 0.22e2 / 0.9e1 * t409 * t30 * t821 * t158 + 0.2e1 * t912 * t30 * t351 * t327 + 0.3e1 / 0.4e1 * t403 * t899 * t781 + t2120 * t30 * t174 * t775 + 0.209e3 / 0.2916e4 * t184 * t2106;
  t2133 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t681 * t207 - t8 * t254 * t416 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t108 * t946 + 0.3e1 / 0.2e2 * t8 * t24 * (t1956 + t2020 + t2071 + t2126));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2133 + 0.6e1 * t951;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2149 = t1738 * t454;
  t2183 = t30 * t32;
  t2197 = -t432 * t434 * t1933 / 0.3072e4 + 0.25e2 / 0.663552e6 * t2149 * t456 * t985 * t295 - 0.455e3 / 0.2985984e7 * t455 * t456 * t384 + 0.325e3 / 0.71663616e8 * t465 * t431 * t394 - 0.7e1 / 0.1990656e7 * t455 * t456 * t457 * t749 + 0.5e1 / 0.3538944e7 * t1042 * t222 * t772 + 0.5e1 / 0.47775744e8 * t465 * t431 * t433 * t749 + 0.35e2 / 0.995328e6 * t455 * t456 * t985 * t306 - 0.25e2 / 0.23887872e8 * t465 * t431 * t596 * t306 + 0.25e2 / 0.191102976e9 * t1006 * t431 * t596 * t295 - 0.3e1 / 0.4e1 * t1020 * t2183 * t92 * t158 * t324 - t432 * t964 * t1978 / 0.24576e5 + 0.5e1 / 0.2654208e7 * t734 * t454 * t456 * t457 * t1734;
  t2203 = t433 * t733;
  t2213 = t311 * params->b;
  t2225 = t1859 * params->a;
  t2233 = t1807 * t220;
  t2244 = t612 * t456;
  t2258 = -0.5e1 / 0.18432e5 * t432 * t596 * t286 * t865 - 0.25e2 / 0.382205952e9 * t1738 * t1005 * t431 * t2203 + 0.5e1 / 0.1152e4 * t432 * t981 * t859 - 0.5e1 / 0.2304e4 * t432 * t981 * t832 + 0.25e2 / 0.63700992e8 * t734 * t2213 * t40 * t456 * t1043 * t1867 + 0.5e1 / 0.331776e6 * t970 * t456 * t124 * t279 * t281 + 0.5e1 / 0.31850496e8 * t1858 * t2225 * t40 * t456 * t58 * t702 * t705 - 0.65e2 / 0.3456e4 * t2233 * t431 * t368 - t432 * t434 * t2010 / 0.2304e4 - t432 * t433 * t714 * t2016 / 0.663552e6 + t2244 * t1342 * params->beta1 * t1901 / 0.1536e4 - 0.5e1 / 0.442368e6 * t1738 * t149 * t73 * t222 * t767 - 0.5e1 / 0.27648e5 * t440 * t441 * t596 * t275;
  t2276 = t1835 * params->b;
  t2283 = t97 * t1751 * params->c;
  t2291 = t43 * t215 * t119;
  t2308 = t482 * t30 * t477 * t699 / 0.12e2 - 0.25e2 / 0.5308416e7 * t1042 * t215 * t124 * t312 * t295 + 0.3e1 / 0.4e1 * t234 * t2183 * t92 * t332 * t781 - 0.5e1 / 0.12e2 * t482 * t932 + 0.35e2 / 0.18345885696e11 * t1834 * t2276 * t40 * t441 * t2203 + t2283 * t30 * t477 * t775 + 0.65e2 / 0.82944e5 * t440 * t441 * t368 + 0.65e2 / 0.2916e4 * t221 * t2291 + 0.65e2 / 0.839808e6 * t231 * t2291 + 0.1e2 / 0.9e1 * t482 * t922 + 0.5e1 / 0.4e1 * t1020 * t914 + t440 * t441 * t433 * t729 / 0.55296e5 - 0.55e2 / 0.81e2 * t235 * t236 * t262 * t100;
  t2309 = t58 * t286;
  t2354 = t2244 * t2309 * t288 * t1921 / 0.12288e5 - t1222 * t53 * t222 * t1915 / 0.221184e6 - 0.5e1 / 0.127401984e9 * t1257 * t1258 * t40 * t456 * t58 * t306 * t142 - 0.13e3 / 0.243e3 * t214 * t215 * t354 - t476 * t477 * t700 / 0.12e2 + t2044 * t226 * t223 / 0.41472e5 - 0.1e2 / 0.9e1 * t476 * t351 * t164 - 0.5e1 / 0.20736e5 * t1065 * t447 + 0.65e2 / 0.62208e5 * t450 * t1029 - 0.65e2 / 0.34992e5 * t227 * t2291 + 0.5e1 / 0.12e2 * t476 * t174 * t338 + 0.55e2 / 0.81e2 * t204 * t88 * t236 * t262 - t2065 * t242 - 0.5e1 / 0.4e1 * t476 * t174 * t335;
  t2361 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t681 * t245 - t8 * t254 * t491 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t108 * t1072 + 0.3e1 / 0.2e2 * t8 * t24 * (t2197 + t2258 + t2308 + t2354));
  tv4rho3lapl0 = 0.2e1 * rho[0] * t2361 + 0.6e1 * t1077;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2383 = 0.1e1 / t23 / t1555;
  t2388 = t43 * t908;
  t2395 = t1932 * t279;
  t2399 = params->beta2 * t1734;
  t2400 = t2399 * t295;
  t2416 = t1095 * t134;
  t2424 = 0.19e2 / 0.81e2 * t178 * t908 * t69 + t895 * t85 * t521 / 0.41472e5 - 0.19e2 / 0.81e2 * t549 * t908 * t163 - t1086 * t1100 / 0.3888e4 + 0.35e2 / 0.486e3 * t525 * t526 * t2383 * t85 + 0.19e2 / 0.23328e5 * t537 * t2388 - 0.5e1 / 0.15925248e8 * t1124 * t506 * t512 * t306 - t1137 * t1138 * t2395 / 0.128e3 + 0.5e1 / 0.110592e6 * t1107 * t1108 * t2400 - t1150 * t526 * t1151 * t275 / 0.27648e5 + 0.5e1 / 0.1327104e7 * t1858 * t1859 * t25 * t505 * t526 * t511 * t705 * t279 - t1137 * t2416 * t1139 / 0.9e1 - t1137 * t1095 * t286 * t1144 / 0.72e2;
  t2425 = t831 * t275;
  t2429 = t1977 * t279;
  t2449 = t312 * t1867;
  t2450 = t2449 * t295;
  t2465 = t506 * t512 * t295;
  t2479 = t1137 * t1138 * t2425 / 0.192e3 - t1137 * t1143 * t2429 / 0.1024e4 + t1137 * t1143 * t1800 / 0.1536e4 - t1137 * t511 * t714 * t2015 * t279 / 0.27648e5 + 0.5e1 / 0.2592e4 * t1107 * t1095 * t149 * t1110 - 0.5e1 / 0.55296e5 * t1107 * t1108 * t1714 + 0.25e2 / 0.2654208e7 * t1107 * t511 * t311 * t2450 + 0.5e1 / 0.746496e6 * t1124 * t506 * t1114 * t142 + t1150 * t526 * t1095 * t281 * t128 / 0.1296e4 - 0.25e2 / 0.15925248e8 * t1738 * t1123 * t2465 - t367 * t601 * t119 * t128 / 0.5184e4 + 0.5e1 / 0.10616832e8 * t939 * t192 * t1742 + t1171 * t1172 * t333 * t324 / 0.48e2;
  t2485 = t32 * t2383;
  t2522 = t367 * t601 * t49 * t275 / 0.55296e5 + 0.35e2 / 0.648e3 * t517 * t506 * t2485 - 0.19e2 / 0.1944e4 * t184 * t2388 - 0.19e2 / 0.559872e6 * t196 * t2388 + 0.19e2 / 0.81e2 * t409 * t2388 - 0.2e1 / 0.9e1 * t1171 * t119 * t332 * t780 - t328 * t792 * t521 / 0.12e2 + 0.175e3 / 0.559872e6 * t540 * t541 * t526 * t2383 - 0.5e1 / 0.4478976e7 * t540 * t43 * t882 + 0.5e1 / 0.47775744e8 * t540 * t43 * t851 - 0.5e1 / 0.382205952e9 * t1524 * t43 * t838 - t1178 * t860 / 0.2304e4 - 0.5e1 / 0.20736e5 * t1156 * t526 * t1095 * t312 * t142;
  t2570 = 0.35e2 / 0.764411904e9 * t1834 * t1835 * t25 * t2465 - t912 * t43 * t192 * t324 / 0.48e2 + 0.5e1 / 0.442368e6 * t1156 * t526 * t1157 * t306 - 0.7e1 / 0.1990656e7 * t1162 * t601 * t847 + t1178 * t856 / 0.216e3 - 0.5e1 / 0.1327104e7 * t296 * t380 * t601 * t843 - t715 * t869 * t601 * t873 / 0.663552e6 + 0.7e1 / 0.186624e6 * t1162 * t601 * t878 + t2120 * t43 * t192 * t327 / 0.12e2 + t1178 * t833 / 0.4608e4 + 0.2e1 / 0.9e1 * t912 * t43 * t388 * t158 - 0.35e2 / 0.27e2 * t507 * t2485 * t282 - 0.245e3 / 0.23328e5 * t532 * t506 * t2485 * params->beta2 + t1178 * t866 / 0.36864e5;
  t2577 = my_piecewise3(t3, 0, -t8 * t254 * t555 / 0.3e2 + t8 * t108 * t1187 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (t2424 + t2479 + t2522 + t2570));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2577 + 0.4e1 * t1192;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2587 = t90 * t1200;
  t2591 = t511 * params->beta2;
  t2617 = t1200 * t134;
  t2649 = t1728 * sigma[0];
  t2654 = t1764 * sigma[0];
  t2659 = -0.65e2 / 0.331776e6 * t1246 * t2587 * t1248 - 0.2639e4 / 0.373248e6 * t585 * t586 * t2591 * sigma[0] - 0.377e3 / 0.432e3 * t562 * t512 * t134 * t567 + 0.5e1 / 0.442368e6 * t1246 * t1226 * t1247 * t306 + 0.35e2 / 0.764411904e9 * t1834 * t2276 * t25 * t586 * t1261 * t295 + 0.1885e4 / 0.8957952e7 * t465 * t561 * t1453 + 0.25e2 / 0.2654208e7 * t1239 * t2213 * lapl[0] * t2450 - 0.13e2 / 0.144e3 * t1207 * t2617 * params->beta1 * t1218 - 0.13e2 / 0.1152e4 * t1207 * t1200 * t286 * t288 * t1211 + t1207 * t1209 * t1210 * t275 / 0.1536e4 - t1207 * t564 * t714 * t716 * t1217 * t279 / 0.27648e5 + t1207 * t1216 * t1217 * t275 / 0.192e3 + 0.5e1 / 0.110592e6 * t1239 * t1240 * t2400 + 0.65e2 / 0.11943936e8 * t1260 * t586 * t1200 * sigma[0] * t142 - t1207 * t1209 * t2649 * t279 / 0.1024e4 - t1207 * t1216 * t2654 * t279 / 0.128e3;
  t2663 = params->A2 * t741;
  t2664 = t2663 * params->b;
  t2680 = t1858 * t1859;
  t2707 = t334 * t324;
  t2711 = t792 * t327;
  t2725 = 0.13e2 / 0.20736e5 * t1225 * t2587 * t1228 - 0.25e2 / 0.15925248e8 * t2664 * t561 * t565 * t742 * sigma[0] * t295 * t735 - 0.5e1 / 0.15925248e8 * t1260 * t586 * t1261 * t306 - t1225 * t1226 * t1227 * t275 / 0.27648e5 + 0.5e1 / 0.1327104e7 * t2680 * t1224 * t1226 * t1210 * t279 + 0.65e2 / 0.41472e5 * t525 * t1232 * t1241 - 0.5e1 / 0.55296e5 * t1239 * t1240 * t1714 + 0.13e2 / 0.72e2 * t1020 * t1130 + 0.377e3 / 0.10368e5 * t572 * t573 * t1453 - t1020 * t43 * t596 * t324 / 0.48e2 + t2283 * t43 * t596 * t327 / 0.12e2 - 0.13e2 / 0.81e2 * t595 * t1103 + t595 * t596 * t2707 / 0.48e2 - t595 * t596 * t2711 / 0.12e2 + 0.13e2 / 0.81e2 * t409 * t600 * t601 * t119 + 0.377e3 / 0.7776e4 * t579 * t512 * t580 - 0.13e2 / 0.72e2 * t595 * t192 * t1271;
  t2731 = my_piecewise3(t3, 0, -t8 * t254 * t606 / 0.3e2 + t8 * t108 * t1283 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (t2659 + t2725));
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t2731 + 0.4e1 * t1288;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t2791 = 0.25e2 / 0.5971968e7 * t1354 * t618 * t1379 * t142 + 0.5e1 / 0.10368e5 * t1367 * t1368 * t1304 * t281 * t128 - 0.25e2 / 0.15925248e8 * t2663 * t1329 * t629 * t1717 * t735 + 0.25e2 / 0.20736e5 * t1374 * t1379 * t149 * t1110 + 0.5e1 / 0.110592e6 * t1374 * t1375 * t2400 - t619 * t1387 * t2395 / 0.128e3 - t1367 * t1368 * t621 * t761 * t279 / 0.27648e5 - 0.5e1 / 0.72e2 * t619 * t1379 * t134 * t1139 - 0.5e1 / 0.576e3 * t619 * t1379 * t286 * t1144 + t619 * t1387 * t2425 / 0.192e3 - t619 * t1391 * t2429 / 0.1024e4 + t619 * t1391 * t1800 / 0.1536e4 - 0.5e1 / 0.15925248e8 * t1354 * t618 * t622 * t306;
  t2796 = t1859 * t616;
  t2814 = t43 * t1032;
  t2840 = -t1367 * t1368 * t1369 * t275 / 0.27648e5 + 0.5e1 / 0.1327104e7 * t1858 * t2796 * t25 * t1368 * t621 * t705 * t279 - 0.5e1 / 0.55296e5 * t1374 * t1375 * t1714 + 0.25e2 / 0.2654208e7 * t1374 * t622 * t311 * t2450 + 0.65e2 / 0.648e3 * t612 * t601 * t180 + 0.5e1 / 0.1728e4 * t2233 * t2814 - t970 * t601 * t972 / 0.663552e6 - 0.25e2 / 0.35831808e8 * t465 * t43 * t990 + 0.5e1 / 0.47775744e8 * t465 * t43 * t1001 - 0.5e1 / 0.382205952e9 * t1006 * t43 * t1007 + 0.35e2 / 0.1492992e7 * t455 * t601 * t986 - t1360 * t43 * t433 * t324 / 0.48e2 + 0.5e1 / 0.442368e6 * t1330 * t628 * t1331 * t306;
  t2851 = t1835 * t637;
  t2859 = t97 * t1751 * t662;
  t2873 = t541 * t628 * t564;
  t2889 = -0.7e1 / 0.1990656e7 * t455 * t601 * t997 - t1341 * t1342 * t859 / 0.2304e4 + t1341 * t2309 * t865 / 0.36864e5 + 0.35e2 / 0.764411904e9 * t1834 * t2851 * t25 * t647 * t622 * t295 + t2859 * t43 * t433 * t327 / 0.12e2 - 0.805e3 / 0.186624e6 * t646 * t647 * t1520 - 0.115e3 / 0.216e3 * t619 * t1489 + t1341 * t1342 * t832 / 0.4608e4 + 0.575e3 / 0.4478976e7 * t656 * t2873 + 0.5e1 / 0.36e2 * t1360 * t1276 - 0.25e2 / 0.165888e6 * t1330 * t628 * t1304 * t312 * t142 - 0.5e1 / 0.1327104e7 * t2149 * t601 * t457 * t295 - 0.5e1 / 0.36e2 * t664 * t1272;
  t2926 = 0.115e3 / 0.3888e4 * t639 * t628 * t1502 + 0.65e2 / 0.186624e6 * t227 * t521 - 0.65e2 / 0.648e3 * t664 * t550 + t1065 * t652 / 0.41472e5 - 0.5e1 / 0.31104e5 * t450 * t1294 - 0.65e2 / 0.15552e5 * t184 * t52 * t1279 + t664 * t433 * t2707 / 0.48e2 + t1299 * t43 * t1011 / 0.55296e5 - t664 * t433 * t2711 / 0.12e2 + 0.65e2 / 0.648e3 * t409 * t668 * t1279 + 0.115e3 / 0.5184e4 * t627 * t2873 - 0.5e1 / 0.41472e5 * t1299 * t2814 - 0.65e2 / 0.4478976e7 * t196 * t72 * t1279 + 0.5e1 / 0.10616832e8 * t296 * t313 * t659;
  t2933 = my_piecewise3(t3, 0, -t8 * t254 * t672 / 0.3e2 + t8 * t108 * t1396 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (t2791 + t2840 + t2889 + t2926));
  tv4rho2lapl20 = 0.2e1 * rho[0] * t2933 + 0.4e1 * t1401;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t2939 = t1414 * rho[0];
  t2940 = 0.1e1 / t2939;
  t2941 = t1412 * t2940;
  t2949 = 0.1e1 / t1198;
  t2957 = t524 * t578 * t32;
  t2964 = t502 * t1404 * t511;
  t2984 = t1435 * t1442;
  t2993 = -0.5e1 / 0.576e3 * t1441 * t2941 * t312 - t1458 * t1459 * t792 * t158 / 0.24e2 + t1464 * t1465 * t2949 / 0.12e2 - t1150 * t33 * t1152 / 0.9216e4 - 0.5e1 / 0.18432e5 * t2957 * t1111 - 0.5e1 / 0.5308416e7 * t1124 * t578 * t1125 + t2964 * t135 * t1218 / 0.64e2 + t2964 * t704 * t1211 / 0.512e3 + t1405 * t2416 * t567 / 0.3e1 + 0.7e1 / 0.2592e4 * t532 * t578 * t1115 - 0.5e1 / 0.62208e5 * t540 * t541 * t33 * t1095 + 0.5e1 / 0.147456e6 * t1156 * t33 * t1158 + 0.5e1 / 0.2304e4 * t2984 * t150 * t1734 * t142 + 0.25e2 / 0.55296e5 * t2984 * t313 * t1867 * t142;
  t3000 = t1411 * t1442;
  t3012 = t1859 * t1410;
  t3058 = -0.25e2 / 0.331776e6 * t2663 * t1424 * t1415 * t742 * t735 * t142 - 0.3e1 / 0.64e2 * t3000 * t704 * t1728 * t128 - t3000 * t1849 * t1900 / 0.576e3 - 0.3e1 / 0.8e1 * t3000 * t135 * t1764 * t128 + 0.5e1 / 0.27648e5 * t1858 * t3012 * t1442 * t705 * t128 - t517 * t578 * t1114 / 0.72e2 - t1458 * t2949 * t332 * t333 / 0.12e2 + 0.35e2 / 0.15925248e8 * t1834 * t1835 * t1424 * t1415 * t142 - t525 * t33 * t1096 / 0.54e2 + 0.5e1 / 0.72e2 * t1436 * t2940 * t149 * t1109 + 0.5e1 / 0.20736e5 * t1257 * t1449 * t2941 + t97 * t1749 * t1750 * t1457 * t1459 * t158 / 0.24e2 - t1413 * t2940 * t286 * t864 / 0.2e1 - 0.4e1 * t1413 * t2940 * t134 * t831 + t1222 * t1424 * t2940 * t281 / 0.36e2;
  t3064 = my_piecewise3(t3, 0, t8 * t108 * t1469 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (t2993 + t3058));
  tv4rhosigma30 = 0.2e1 * rho[0] * t3064 + 0.2e1 * t1473;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t3082 = t715 * t968 * t25;
  t3088 = t1404 * t564;
  t3093 = t213 * t1475 * t1478;
  t3101 = t44 * t705;
  t3111 = t761 * t44;
  t3120 = t541 * t2587;
  t3128 = t2399 * t142;
  t3134 = t2449 * t142;
  t3138 = -0.5e1 / 0.15925248e8 * t1006 * t561 * t565 * t142 + t562 * t566 * t1139 / 0.192e3 + t562 * t565 * t286 * t1144 / 0.1536e4 - t3082 * t586 * t564 * t281 * t128 / 0.27648e5 - 0.5e1 / 0.55296e5 * t524 * t3088 * t1241 - 0.3e1 / 0.8e1 * t3093 * t135 * t1764 * t44 * t128 + 0.5e1 / 0.27648e5 * t1858 * t2225 * t1410 * t1515 * t3101 * t128 - 0.3e1 / 0.64e2 * t3093 * t704 * t1728 * t44 * t128 - t3093 * t1849 * t3111 * t128 / 0.576e3 + 0.91e2 / 0.124416e6 * t585 * t573 * t1201 * params->beta2 - 0.65e2 / 0.2985984e7 * t465 * t3120 + 0.13e2 / 0.144e3 * t562 * t1201 * t282 + 0.5e1 / 0.2304e4 * t1435 * t1493 * t149 * t1503 * t3128 + 0.25e2 / 0.55296e5 * t1435 * t1493 * t311 * t1503 * t3134;
  t3159 = t508 * t266;
  t3160 = 0.1e1 / t3159;
  t3161 = t44 * t3160;
  t3165 = lapl[0] * t3160;
  t3185 = t791 * t158;
  t3205 = -0.25e2 / 0.331776e6 * t2663 * t1513 * lapl[0] * t1478 * t742 * t44 * t735 * t142 + 0.5e1 / 0.442368e6 * t1246 * t90 * t564 * t312 * t142 - 0.7e1 / 0.96e2 * t1531 * t1461 + 0.35e2 / 0.15925248e8 * t1834 * t2276 * t1475 * t1493 * t142 + 0.35e2 / 0.576e3 * t1435 * t3161 * t1510 + 0.35e2 / 0.165888e6 * t1524 * t1513 * t3165 * t44 - 0.7e1 / 0.2e1 * t1476 * t3160 * t134 * t1485 + 0.7e1 / 0.288e3 * t1492 * t1475 * t3161 * t281 - 0.13e2 / 0.3456e4 * t1299 * t3120 - 0.7e1 / 0.16e2 * t1476 * t3160 * t286 * t1480 - t1531 * t1532 * t790 * t3185 / 0.24e2 + 0.7e1 / 0.96e2 * t1464 * t1537 * t1457 * t1459 - 0.35e2 / 0.4608e4 * t1514 * t3165 * t1516 + t2120 * params->c * t1457 * t1532 * t158 / 0.24e2 - 0.13e2 / 0.2592e4 * t1501 * t1200 * t85 * t1503;
  t3211 = my_piecewise3(t3, 0, t8 * t108 * t1542 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (t3138 + t3205));
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t3211 + 0.2e1 * t1546;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t3243 = t1553 * t1556;
  t3244 = t638 * t3243;
  t3263 = t617 * t3243;
  t3275 = -0.5e1 / 0.15925248e8 * t1006 * t1548 * t1262 + t1549 * t1219 / 0.192e3 + t1549 * t1212 / 0.1536e4 - t3082 * t3088 * t1228 / 0.27648e5 - 0.5e1 / 0.55296e5 * t2957 * t564 * t149 * params->b * t1110 + 0.13e2 / 0.144e3 * t1549 * t2617 * t567 + 0.5e1 / 0.442368e6 * t1246 * t565 * t1248 + 0.5e1 / 0.27648e5 * t1858 * t2796 * t1410 * t1584 * t1211 + 0.5e1 / 0.2304e4 * t3244 * t150 * t1734 * sigma[0] * t142 + 0.25e2 / 0.55296e5 * t3244 * t313 * t1867 * sigma[0] * t142 - 0.25e2 / 0.331776e6 * t2663 * t1582 * t54 * t1556 * t742 * sigma[0] * t735 * t142 - 0.3e1 / 0.64e2 * t3263 * t704 * t2649 * t128 - t3263 * t1849 * t1218 / 0.576e3 - 0.3e1 / 0.8e1 * t3263 * t135 * t2654 * t128;
  t3279 = t541 * t1232;
  t3284 = t508 * t47;
  t3285 = 0.1e1 / t3284;
  t3311 = t54 * t3285;
  t3334 = 0.91e2 / 0.124416e6 * t585 * t1404 * t1253 - 0.65e2 / 0.2985984e7 * t465 * t3279 - t1600 * t1534 / 0.16e2 + t1567 * t1553 * t3285 * t281 * sigma[0] / 0.48e2 - 0.13e2 / 0.3456e4 * t1299 * t3279 + 0.5e1 / 0.96e2 * t1576 * t3285 * t149 * t1578 - 0.3e1 / 0.8e1 * t1554 * t3285 * t286 * t1558 - 0.3e1 * t1554 * t3285 * t134 * t1563 + 0.35e2 / 0.15925248e8 * t1834 * t2851 * t1553 * t1556 * sigma[0] * t142 + 0.5e1 / 0.27648e5 * t1524 * t1582 * t3311 * sigma[0] - t1600 * t1601 * t790 * t3185 / 0.24e2 + t1464 * t1606 * t1538 / 0.16e2 - 0.5e1 / 0.768e3 * t1583 * t3311 * t1247 - 0.13e2 / 0.2592e4 * t579 * t1201 * t226 + t2120 * t662 * t1457 * t1601 * t158 / 0.24e2;
  t3340 = my_piecewise3(t3, 0, t8 * t108 * t1611 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (t3275 + t3334));
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t3340 + 0.2e1 * t1615;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t3358 = t761 * lapl[0];
  t3365 = t705 * lapl[0];
  t3381 = t541 * t90 * t1304;
  t3391 = 0.1e1 / t1093;
  t3401 = -0.5e1 / 0.96e2 * t1674 * t1603 - t1367 * t586 * t1370 / 0.9216e4 - 0.5e1 / 0.18432e5 * t638 * t561 * t1376 - 0.5e1 / 0.5308416e7 * t1354 * t561 * t1355 + t1617 * t1618 * params->beta1 * t3358 * t128 / 0.64e2 + t1617 * t621 * t286 * t288 * t3365 * t128 / 0.512e3 + 0.5e1 / 0.24e2 * t1617 * t1304 * t134 * t1619 + 0.5e1 / 0.147456e6 * t1330 * t90 * t1332 + 0.35e2 / 0.20736e5 * t646 * t573 * t1380 - 0.25e2 / 0.497664e6 * t656 * t3381 - t1674 * t1675 * t790 * t3185 / 0.24e2 + 0.5e1 / 0.96e2 * t1464 * t1680 * t1607 - 0.25e2 / 0.4608e4 * t1657 * t1626 * t3391 * t312 - t1627 * t1628 * t714 * t2015 * t128 / 0.576e3;
  t3423 = t742 * t735;
  t3448 = t1835 * t1650;
  t3466 = -0.3e1 / 0.8e1 * t1627 * t1633 * t1932 * t128 - 0.5e1 / 0.576e3 * t627 * t3381 + 0.5e1 / 0.27648e5 * t1858 * t1859 * t1623 * t1626 * t1628 * t705 * t128 + 0.5e1 / 0.2304e4 * t1652 * t1653 * t3128 + 0.25e2 / 0.55296e5 * t1652 * t1628 * t311 * t3134 - 0.25e2 / 0.331776e6 * t2663 * t1665 * t1666 * t3423 * t142 - 0.3e1 / 0.64e2 * t1627 * t1629 * t1977 * t128 + 0.25e2 / 0.576e3 * t1652 * t3391 * t149 * t1109 - 0.5e1 / 0.16e2 * t1627 * t3391 * t286 * t864 - 0.5e1 / 0.2e1 * t1627 * t3391 * t134 * t831 + 0.5e1 / 0.288e3 * t1638 * t1626 * t3391 * t281 + 0.35e2 / 0.15925248e8 * t1834 * t3448 * t1626 * t1628 * t142 + 0.25e2 / 0.165888e6 * t1524 * t1665 * t1625 * t3391 + t2120 * t1672 * t1457 * t1675 * t158 / 0.24e2 - 0.5e1 / 0.432e3 * t639 * t90 * t1305;
  t3472 = my_piecewise3(t3, 0, t8 * t108 * t1685 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (t3401 + t3466));
  tv4rholapl30 = 0.2e1 * rho[0] * t3472 + 0.2e1 * t1689;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t3475 = t44 * t1415;
  t3479 = t1411 * t1415;
  t3480 = t135 * t3111;
  t3486 = t44 * t44;
  t3489 = 0.1e1 / t22 / t1414 / t47;
  t3490 = t3486 * t3489;
  t3543 = t541 * t512;
  t3566 = t704 * t3101;
  t3569 = -0.5e1 / 0.55296e5 * t1257 * t1449 * t3475 - t1458 * t511 * t790 * t791 * t25 * t236 / 0.576e3 - t1222 * t1410 * t44 * t1425 / 0.96e2 + t287 * t288 * t3543 / 0.768e3 - 0.7e1 / 0.27648e5 * t532 * t1404 * t2591 + 0.35e2 / 0.3981312e7 * t1834 * t1835 * t1410 * t3490 * t1340 + 0.5e1 / 0.663552e6 * t540 * t3543 + t2120 * t1457 * t511 * t2183 / 0.576e3 - t1405 * t1138 * t361 / 0.32e2 - 0.5e1 / 0.192e3 * t1435 * t44 * t1438 + 0.3e1 / 0.16e2 * t3479 * t3566;
  t3574 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.1536e4 * t1441 * t3475 * t312 + 0.3e1 / 0.2e1 * t3479 * t3480 + t525 * t512 * t85 / 0.576e3 + 0.5e1 / 0.576e3 * t1435 * t3490 * t149 * t2399 * t1340 - 0.25e2 / 0.82944e5 * t2663 * t1410 * t3486 * t3489 * t3423 * t1340 - t1411 * t3490 * t714 * t2015 * t1340 / 0.144e3 - 0.3e1 / 0.16e2 * t1411 * t3490 * t286 * t1977 * t1340 - 0.3e1 / 0.2e1 * t1411 * t3490 * t134 * t1932 * t1340 + 0.5e1 / 0.6912e4 * t1858 * t3012 * t3486 * t3489 * t705 * t1340 + 0.25e2 / 0.13824e5 * t1435 * t3490 * t311 * t2449 * t1340 + t3569));
  tv4sigma40 = 0.2e1 * rho[0] * t3574;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t3576 = t1457 * t1200;
  t3578 = t792 * t2183;
  t3585 = 0.1e1 / t22 / t1414 / t56;
  t3586 = lapl[0] * t3585;
  t3621 = t213 * t1410;
  t3666 = -t234 * t3576 * t3578 / 0.576e3 + 0.35e2 / 0.3981312e7 * t1834 * t2276 * t1410 * t3586 * t1412 * t1340 + 0.5e1 / 0.6912e4 * t2680 * params->a * t1410 * lapl[0] * t3585 * t1412 * t705 * t1340 + 0.25e2 / 0.13824e5 * t1436 * t3585 * t311 * params->b * lapl[0] * t312 * t1867 * t1340 + 0.5e1 / 0.576e3 * t1436 * t3585 * t149 * params->b * t1508 * t1734 * t1340 - 0.25e2 / 0.82944e5 * t2664 * t1475 * t3585 * t742 * t1412 * t735 * t1340 - t3621 * t3586 * t714 * t2015 * t1412 * t1340 / 0.144e3 - 0.3e1 / 0.16e2 * t3621 * t3586 * t286 * t1977 * t1412 * t1340 - 0.3e1 / 0.2e1 * t3621 * t3586 * t134 * t1932 * t1412 * t1340 + t2283 * t3576 * t2183 / 0.576e3 - 0.5e1 / 0.110592e6 * t1524 * t1513 * t1515 * sigma[0] + 0.3e1 / 0.32e2 * t1476 * t1479 * t1558 + 0.3e1 / 0.4e1 * t1476 * t1484 * t1563 - t1492 * t1475 * t1478 * sigma[0] * t281 / 0.192e3 + 0.5e1 / 0.3072e4 * t1514 * t1515 * t1247 - 0.5e1 / 0.384e3 * t1435 * t1478 * t149 * t1503 * t1578;
  t3670 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t3666);
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t3670;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t3675 = 0.1e1 / t22 / t2939;
  t3676 = t54 * t3675;
  t3681 = t1457 * t564;
  t3685 = t617 * t1410;
  t3712 = t638 * t1410;
  t3746 = 0.35e2 / 0.3981312e7 * t1834 * t2851 * t1410 * t3676 * t44 * t1340 + t2859 * t3681 * t2183 / 0.576e3 - t3685 * t3676 * t714 * t2015 * t44 * t1340 / 0.144e3 - 0.3e1 / 0.16e2 * t3685 * t3676 * t286 * t1977 * t44 * t1340 - 0.3e1 / 0.2e1 * t3685 * t3676 * t134 * t1932 * t44 * t1340 + 0.5e1 / 0.6912e4 * t2680 * t616 * t1410 * t54 * t3675 * t705 * t44 * t1340 + 0.25e2 / 0.13824e5 * t3712 * t3676 * t311 * t2449 * t44 * t1340 + 0.5e1 / 0.576e3 * t3712 * t3676 * t149 * t2399 * t44 * t1340 - 0.25e2 / 0.82944e5 * t2663 * t637 * t1553 * t3675 * t742 * t44 * t735 * t1340 - 0.7e1 / 0.82944e5 * t299 * t453 * t541 * t1520 + 0.5e1 / 0.1990656e7 * t540 * t1244 * t3088 - t213 * t541 * t1489 / 0.96e2 - t663 * t3681 * t3578 / 0.576e3;
  t3750 = t1410 * t1478;
  t3776 = t213 * t3750;
  t3792 = -0.5e1 / 0.331776e6 * t1524 * t1513 * t1493 - t1492 * t3750 * t44 * t281 / 0.576e3 - 0.5e1 / 0.1152e4 * t1507 * t453 * t1109 - 0.5e1 / 0.331776e6 * t1524 * t1582 * t1584 + t1554 * t1557 * t864 / 0.32e2 + t1554 * t1562 * t831 / 0.4e1 - t1567 * t1553 * t1568 / 0.576e3 + t1299 * t541 * t565 / 0.2304e4 - 0.5e1 / 0.1152e4 * t1576 * t1577 * t1109 + t3776 * t3480 / 0.4e1 + t3776 * t3566 / 0.32e2 + 0.5e1 / 0.9216e4 * t798 * t637 * t1553 * t1556 * t312 + t525 * t1588 / 0.1728e4 + 0.5e1 / 0.9216e4 * t798 * params->b * t3750 * t1516;
  t3797 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (t3746 + t3792));
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t3797;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t3800 = t617 * t1410 * t1556;
  t3809 = t1624 * t1410;
  t3811 = 0.1e1 / t22 / t3159;
  t3812 = t1625 * t3811;
  t3845 = t1651 * t1410;
  t3865 = lapl[0] * t1556;
  t3879 = t1457 * t1304;
  t3888 = 0.3e1 / 0.32e2 * t3800 * t704 * t3365 * sigma[0] + 0.3e1 / 0.4e1 * t3800 * t135 * t3358 * sigma[0] - t3809 * t3812 * t714 * t2015 * t40 * t358 / 0.144e3 - 0.3e1 / 0.16e2 * t3809 * t3812 * t286 * t1977 * t40 * t358 - 0.3e1 / 0.2e1 * t3809 * t3812 * t134 * t1932 * t40 * t358 + 0.5e1 / 0.6912e4 * t2680 * t1623 * t1410 * t1625 * t3811 * t705 * t40 * t358 - t1567 * t1475 * t1569 / 0.192e3 - 0.5e1 / 0.384e3 * t638 * t1475 * t1579 + 0.25e2 / 0.13824e5 * t3845 * t3812 * t311 * t2449 * t40 * t358 + 0.5e1 / 0.576e3 * t3845 * t3812 * t149 * t2399 * t40 * t358 - 0.25e2 / 0.82944e5 * t2663 * t1650 * t1626 * t3811 * t3423 * t40 * t358 + 0.5e1 / 0.3072e4 * t1583 * t3865 * t1247 + 0.35e2 / 0.3981312e7 * t1834 * t3448 * t1410 * t3812 * t40 * t358 - 0.5e1 / 0.110592e6 * t1524 * t1582 * t3865 * sigma[0] - t1673 * t3879 * t3578 / 0.576e3 + t97 * t1751 * t1672 * t3879 * t2183 / 0.576e3;
  t3892 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t3888);
  tv4sigmalapl30 = 0.2e1 * rho[0] * t3892;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t3898 = t662 * t662;
  t3900 = t1457 * t621;
  t3910 = t616 * t616;
  t3912 = t54 * t54;
  t3915 = 0.1e1 / t22 / t3284;
  t3916 = t1410 * t3912 * t3915;
  t3917 = params->A1 * t3910 * t3916;
  t3924 = t3912 * t3915;
  t3929 = t637 * t637;
  t3931 = params->A2 * t3929 * t3916;
  t3979 = t1624 * t1410 * t1628;
  t3995 = -0.3e1 / 0.16e2 * t3917 * t1729 * t1340 - 0.5e1 / 0.192e3 * t1651 * t1553 * t1654 + 0.5e1 / 0.663552e6 * t540 * t1328 * t1404 * t621 + t97 * t1751 * t3898 * t3900 * t2183 / 0.576e3 - 0.7e1 / 0.27648e5 * t299 * t644 * t541 * t648 + 0.35e2 / 0.3981312e7 * t1834 * t1835 * t3929 * t1410 * t3924 * t1340 - t617 * t541 * t623 / 0.32e2 + 0.3e1 / 0.2e1 * t3979 * t135 * t761 * t54 + t638 * t25 * t1404 * t640 / 0.576e3 + 0.5e1 / 0.1536e4 * t1657 * t1553 * t1658 + 0.3e1 / 0.16e2 * t3979 * t704 * t705 * t54;
  t4000 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (-0.5e1 / 0.55296e5 * t1524 * t1665 * t54 * t1628 - params->A3 * t3898 * t3900 * t3578 / 0.576e3 - t1638 * t1553 * t1639 / 0.96e2 + t627 * t541 * t622 / 0.768e3 - 0.3e1 / 0.2e1 * t3917 * t1765 * t1340 + 0.5e1 / 0.6912e4 * t1858 * t1859 * t3910 * t1410 * t3924 * t705 * t1340 + 0.25e2 / 0.13824e5 * t3931 * t1868 * t1340 + 0.5e1 / 0.576e3 * t3931 * t1735 * t1340 - 0.25e2 / 0.82944e5 * t2663 * t3929 * t1410 * t3912 * t3915 * t742 * t735 * t1340 - t3917 * t1850 * t1340 / 0.144e3 + t3995));
  tv4lapl40 = 0.2e1 * rho[0] * t4000;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t45, t47, t49, t50, t51, t52;
  double t53, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t71, t72, t73, t76, t78;
  double t79, t81, t84, t85, t86, t87, t90, t91;
  double t93, t97, t98, t100, t101, t103, t107, t108;
  double t109, t111, t112, t113, t114, t115, t117, t118;
  double t119, t120, t121, t123, t125, t127, t128, t129;
  double t131, t133, t134, t135, t136, t138, t139, t141;
  double t143, t146, t147, t148, t152, t153, t155, t158;
  double t159, t160, t161, t164, t166, t170, t171, t173;
  double t174, t176, t180, tzk0;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t47 = t33 * t33;
  t49 = 0.1e1 / t35 / t34;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t39 * t39;
  t53 = t52 * rho[0];
  t55 = 0.1e1 / t40 / t53;
  t57 = t50 * t51 * t55;
  t58 = params->a * t47;
  t59 = lapl[0] * lapl[0];
  t60 = t49 * t59;
  t61 = t39 * rho[0];
  t63 = 0.1e1 / t40 / t61;
  t64 = t60 * t63;
  t66 = t58 * t64 + t57;
  t68 = sqrt(t66);
  t71 = 0.1e1 + params->beta1 * t68 / 0.24e2;
  t72 = t71 * t71;
  t73 = 0.1e1 / t72;
  t76 = params->b * t47;
  t78 = t76 * t64 + t57;
  t79 = t78 * t78;
  t81 = sqrt(t78);
  t84 = 0.1e1 + params->beta2 * t81 / 0.24e2;
  t85 = t84 * t84;
  t86 = t85 * t85;
  t87 = 0.1e1 / t86;
  t90 = params->c * t33;
  t91 = t37 * lapl[0];
  t93 = 0.1e1 / t41 / rho[0];
  t97 = t90 * t91 * t93 / 0.24e2 + t45 / 0.24e2;
  t98 = params->A3 * t97;
  t100 = params->beta3 * t97 + 0.1e1;
  t101 = 0.1e1 / t100;
  t103 = 0.5e1 / 0.72e2 * t45 + params->A0 + params->A1 * t66 * t73 / 0.576e3 + params->A2 * t79 * t87 / 0.331776e6 + t98 * t101;
  t107 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t103);
  t108 = rho[1] <= p->dens_threshold;
  t109 = -t18;
  t111 = my_piecewise5(t16, t13, t12, t17, t109 * t9);
  t112 = 0.1e1 + t111;
  t113 = t112 <= p->zeta_threshold;
  t114 = POW_1_3(t112);
  t115 = t114 * t114;
  t117 = my_piecewise3(t113, t25, t115 * t112);
  t118 = t117 * t31;
  t119 = rho[1] * rho[1];
  t120 = POW_1_3(rho[1]);
  t121 = t120 * t120;
  t123 = 0.1e1 / t121 / t119;
  t125 = t38 * sigma[2] * t123;
  t127 = sigma[2] * sigma[2];
  t128 = t119 * t119;
  t129 = t128 * rho[1];
  t131 = 0.1e1 / t120 / t129;
  t133 = t50 * t127 * t131;
  t134 = lapl[1] * lapl[1];
  t135 = t49 * t134;
  t136 = t119 * rho[1];
  t138 = 0.1e1 / t120 / t136;
  t139 = t135 * t138;
  t141 = t58 * t139 + t133;
  t143 = sqrt(t141);
  t146 = 0.1e1 + params->beta1 * t143 / 0.24e2;
  t147 = t146 * t146;
  t148 = 0.1e1 / t147;
  t152 = t76 * t139 + t133;
  t153 = t152 * t152;
  t155 = sqrt(t152);
  t158 = 0.1e1 + params->beta2 * t155 / 0.24e2;
  t159 = t158 * t158;
  t160 = t159 * t159;
  t161 = 0.1e1 / t160;
  t164 = t37 * lapl[1];
  t166 = 0.1e1 / t121 / rho[1];
  t170 = t90 * t164 * t166 / 0.24e2 + t125 / 0.24e2;
  t171 = params->A3 * t170;
  t173 = params->beta3 * t170 + 0.1e1;
  t174 = 0.1e1 / t173;
  t176 = 0.5e1 / 0.72e2 * t125 + params->A0 + params->A1 * t141 * t148 / 0.576e3 + params->A2 * t153 * t161 / 0.331776e6 + t171 * t174;
  t180 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t176);
  tzk0 = t107 + t180;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t45, t47, t49, t50, t51, t52;
  double t53, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t71, t72, t73, t76, t78;
  double t79, t81, t84, t85, t86, t87, t90, t91;
  double t93, t97, t98, t100, t101, t103, t107, t108;
  double t109, t111, t112, t113, t114, t115, t117, t118;
  double t119, t120, t121, t123, t125, t127, t128, t129;
  double t131, t133, t134, t135, t136, t138, t139, t141;
  double t143, t146, t147, t148, t152, t153, t155, t158;
  double t159, t160, t161, t164, t166, t170, t171, t173;
  double t174, t176, t180, tzk0;

  double t181, t182, t183, t185, t188, t189, t193, t194;
  double t197, t199, t201, t203, t205, t208, t210, t211;
  double t214, t218, t220, t221, t225, t228, t232, t233;
  double t235, t236, t244, t245, t247, t248, t249, t250;
  double t252, t257, t258, t260, t263, t264, t268, t271;
  double t273, tvrho0, t277, t280, t281, t286, t288, t291;
  double t292, t297, t299, t301, t303, t306, t308, t309;
  double t312, t316, t318, t319, t323, t326, t330, t331;
  double t333, t334, t342, t343, t345, t346, t347, t348;
  double t350, t355, tvrho1, t360, t361, t362, t366, t367;
  double t370, t373, t376, t377, t378, t381, t382, t386;
  double t390, tvsigma0, tvsigma1, t393, t397, t398, t401, t404;
  double t407, t408, t411, t415, t419, tvsigma2, t420, t421;
  double t422, t427, t431, t432, t433, t434, t440, t441;
  double t442, t446, t447, t450, t454, tvlapl0, t455, t460;
  double t464, t465, t466, t467, t473, t477, t478, t481;
  double t485, tvlapl1, tvtau0, tvtau1;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t47 = t33 * t33;
  t49 = 0.1e1 / t35 / t34;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t39 * t39;
  t53 = t52 * rho[0];
  t55 = 0.1e1 / t40 / t53;
  t57 = t50 * t51 * t55;
  t58 = params->a * t47;
  t59 = lapl[0] * lapl[0];
  t60 = t49 * t59;
  t61 = t39 * rho[0];
  t63 = 0.1e1 / t40 / t61;
  t64 = t60 * t63;
  t66 = t58 * t64 + t57;
  t68 = sqrt(t66);
  t71 = 0.1e1 + params->beta1 * t68 / 0.24e2;
  t72 = t71 * t71;
  t73 = 0.1e1 / t72;
  t76 = params->b * t47;
  t78 = t76 * t64 + t57;
  t79 = t78 * t78;
  t81 = sqrt(t78);
  t84 = 0.1e1 + params->beta2 * t81 / 0.24e2;
  t85 = t84 * t84;
  t86 = t85 * t85;
  t87 = 0.1e1 / t86;
  t90 = params->c * t33;
  t91 = t37 * lapl[0];
  t93 = 0.1e1 / t41 / rho[0];
  t97 = t90 * t91 * t93 / 0.24e2 + t45 / 0.24e2;
  t98 = params->A3 * t97;
  t100 = params->beta3 * t97 + 0.1e1;
  t101 = 0.1e1 / t100;
  t103 = 0.5e1 / 0.72e2 * t45 + params->A0 + params->A1 * t66 * t73 / 0.576e3 + params->A2 * t79 * t87 / 0.331776e6 + t98 * t101;
  t107 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t103);
  t108 = rho[1] <= p->dens_threshold;
  t109 = -t18;
  t111 = my_piecewise5(t16, t13, t12, t17, t109 * t9);
  t112 = 0.1e1 + t111;
  t113 = t112 <= p->zeta_threshold;
  t114 = POW_1_3(t112);
  t115 = t114 * t114;
  t117 = my_piecewise3(t113, t25, t115 * t112);
  t118 = t117 * t31;
  t119 = rho[1] * rho[1];
  t120 = POW_1_3(rho[1]);
  t121 = t120 * t120;
  t123 = 0.1e1 / t121 / t119;
  t125 = t38 * sigma[2] * t123;
  t127 = sigma[2] * sigma[2];
  t128 = t119 * t119;
  t129 = t128 * rho[1];
  t131 = 0.1e1 / t120 / t129;
  t133 = t50 * t127 * t131;
  t134 = lapl[1] * lapl[1];
  t135 = t49 * t134;
  t136 = t119 * rho[1];
  t138 = 0.1e1 / t120 / t136;
  t139 = t135 * t138;
  t141 = t58 * t139 + t133;
  t143 = sqrt(t141);
  t146 = 0.1e1 + params->beta1 * t143 / 0.24e2;
  t147 = t146 * t146;
  t148 = 0.1e1 / t147;
  t152 = t76 * t139 + t133;
  t153 = t152 * t152;
  t155 = sqrt(t152);
  t158 = 0.1e1 + params->beta2 * t155 / 0.24e2;
  t159 = t158 * t158;
  t160 = t159 * t159;
  t161 = 0.1e1 / t160;
  t164 = t37 * lapl[1];
  t166 = 0.1e1 / t121 / rho[1];
  t170 = t90 * t164 * t166 / 0.24e2 + t125 / 0.24e2;
  t171 = params->A3 * t170;
  t173 = params->beta3 * t170 + 0.1e1;
  t174 = 0.1e1 / t173;
  t176 = 0.5e1 / 0.72e2 * t125 + params->A0 + params->A1 * t141 * t148 / 0.576e3 + params->A2 * t153 * t161 / 0.331776e6 + t171 * t174;
  t180 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t176);
  tzk0 = t107 + t180;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t181 = t8 * t8;
  t182 = 0.1e1 / t181;
  t183 = t18 * t182;
  t185 = my_piecewise5(t12, 0, t16, 0, t9 - t183);
  t188 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t185);
  t189 = t188 * t31;
  t193 = 0.1e1 / t30;
  t194 = t29 * t193;
  t197 = t7 * t194 * t103 / 0.1e2;
  t199 = 0.1e1 / t41 / t61;
  t201 = t38 * sigma[0] * t199;
  t203 = t52 * t39;
  t205 = 0.1e1 / t40 / t203;
  t208 = 0.16e2 / 0.3e1 * t50 * t51 * t205;
  t210 = 0.1e1 / t40 / t52;
  t211 = t60 * t210;
  t214 = -t208 - 0.1e2 / 0.3e1 * t58 * t211;
  t218 = params->A1 * t68;
  t220 = 0.1e1 / t72 / t71;
  t221 = t220 * params->beta1;
  t225 = params->A2 * t78;
  t228 = -t208 - 0.1e2 / 0.3e1 * t76 * t211;
  t232 = t81 * t78;
  t233 = params->A2 * t232;
  t235 = 0.1e1 / t86 / t84;
  t236 = t235 * params->beta2;
  t244 = -t201 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t91 * t43;
  t245 = params->A3 * t244;
  t247 = t100 * t100;
  t248 = 0.1e1 / t247;
  t249 = t248 * params->beta3;
  t250 = t249 * t244;
  t252 = -0.5e1 / 0.27e2 * t201 + params->A1 * t214 * t73 / 0.576e3 - t218 * t221 * t214 / 0.13824e5 + t225 * t87 * t228 / 0.165888e6 - t233 * t236 * t228 / 0.3981312e7 + t245 * t101 - t98 * t250;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t103 + t197 + 0.3e1 / 0.2e2 * t7 * t32 * t252);
  t258 = t109 * t182;
  t260 = my_piecewise5(t16, 0, t12, 0, -t9 - t258);
  t263 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t260);
  t264 = t263 * t31;
  t268 = t117 * t193;
  t271 = t7 * t268 * t176 / 0.1e2;
  t273 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t176 + t271);
  tvrho0 = t107 + t180 + t8 * (t257 + t273);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t277 = my_piecewise5(t12, 0, t16, 0, -t9 - t183);
  t280 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t277);
  t281 = t280 * t31;
  t286 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t103 + t197);
  t288 = my_piecewise5(t16, 0, t12, 0, t9 - t258);
  t291 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t288);
  t292 = t291 * t31;
  t297 = 0.1e1 / t121 / t136;
  t299 = t38 * sigma[2] * t297;
  t301 = t128 * t119;
  t303 = 0.1e1 / t120 / t301;
  t306 = 0.16e2 / 0.3e1 * t50 * t127 * t303;
  t308 = 0.1e1 / t120 / t128;
  t309 = t135 * t308;
  t312 = -t306 - 0.1e2 / 0.3e1 * t58 * t309;
  t316 = params->A1 * t143;
  t318 = 0.1e1 / t147 / t146;
  t319 = t318 * params->beta1;
  t323 = params->A2 * t152;
  t326 = -t306 - 0.1e2 / 0.3e1 * t76 * t309;
  t330 = t155 * t152;
  t331 = params->A2 * t330;
  t333 = 0.1e1 / t160 / t158;
  t334 = t333 * params->beta2;
  t342 = -t299 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t164 * t123;
  t343 = params->A3 * t342;
  t345 = t173 * t173;
  t346 = 0.1e1 / t345;
  t347 = t346 * params->beta3;
  t348 = t347 * t342;
  t350 = -0.5e1 / 0.27e2 * t299 + params->A1 * t312 * t148 / 0.576e3 - t316 * t319 * t312 / 0.13824e5 + t323 * t161 * t326 / 0.165888e6 - t331 * t334 * t326 / 0.3981312e7 + t343 * t174 - t171 * t348;
  t355 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t176 + t271 + 0.3e1 / 0.2e2 * t7 * t118 * t350);
  tvrho1 = t107 + t180 + t8 * (t286 + t355);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t360 = params->A1 * t47;
  t361 = t360 * t49;
  t362 = sigma[0] * t55;
  t366 = t218 * t221;
  t367 = t50 * t362;
  t370 = t225 * t87;
  t373 = t233 * t236;
  t376 = params->A3 * t33;
  t377 = t37 * t43;
  t378 = t377 * t101;
  t381 = t98 * t248;
  t382 = params->beta3 * t33;
  t386 = 0.5e1 / 0.72e2 * t38 * t43 + t361 * t362 * t73 / 0.288e3 - t366 * t367 / 0.6912e4 + t370 * t367 / 0.82944e5 - t373 * t367 / 0.1990656e7 + t376 * t378 / 0.24e2 - t381 * t382 * t377 / 0.24e2;
  t390 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t386);
  tvsigma0 = t8 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t393 = sigma[2] * t131;
  t397 = t316 * t319;
  t398 = t50 * t393;
  t401 = t323 * t161;
  t404 = t331 * t334;
  t407 = t37 * t123;
  t408 = t407 * t174;
  t411 = t171 * t346;
  t415 = 0.5e1 / 0.72e2 * t38 * t123 + t361 * t393 * t148 / 0.288e3 - t397 * t398 / 0.6912e4 + t401 * t398 / 0.82944e5 - t404 * t398 / 0.1990656e7 + t376 * t408 / 0.24e2 - t411 * t382 * t407 / 0.24e2;
  t419 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t415);
  tvsigma2 = t8 * t419;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t420 = params->A1 * params->a;
  t421 = t420 * t47;
  t422 = t49 * lapl[0];
  t427 = t422 * t63;
  t431 = t87 * params->b;
  t432 = t225 * t431;
  t433 = lapl[0] * t63;
  t434 = t50 * t433;
  t440 = params->A3 * params->c;
  t441 = t440 * t33;
  t442 = t37 * t93;
  t446 = t98 * t249;
  t447 = t90 * t442;
  t450 = t421 * t422 * t63 * t73 / 0.288e3 - t366 * t58 * t427 / 0.6912e4 + t432 * t434 / 0.82944e5 - t373 * t76 * t427 / 0.1990656e7 + t441 * t442 * t101 / 0.24e2 - t446 * t447 / 0.24e2;
  t454 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t450);
  tvlapl0 = t8 * t454;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t455 = t49 * lapl[1];
  t460 = t455 * t138;
  t464 = t161 * params->b;
  t465 = t323 * t464;
  t466 = lapl[1] * t138;
  t467 = t50 * t466;
  t473 = t37 * t166;
  t477 = t171 * t347;
  t478 = t90 * t473;
  t481 = t421 * t455 * t138 * t148 / 0.288e3 - t397 * t58 * t460 / 0.6912e4 + t465 * t467 / 0.82944e5 - t404 * t76 * t460 / 0.1990656e7 + t441 * t473 * t174 / 0.24e2 - t477 * t478 / 0.24e2;
  t485 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t481);
  tvlapl1 = t8 * t485;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t45, t47, t49, t50, t51, t52;
  double t53, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t71, t72, t73, t76, t78;
  double t79, t81, t84, t85, t86, t87, t90, t91;
  double t93, t97, t98, t100, t101, t103, t107, t108;
  double t109, t111, t112, t113, t114, t115, t117, t118;
  double t119, t120, t121, t123, t125, t127, t128, t129;
  double t131, t133, t134, t135, t136, t138, t139, t141;
  double t143, t146, t147, t148, t152, t153, t155, t158;
  double t159, t160, t161, t164, t166, t170, t171, t173;
  double t174, t176, t180, tzk0;

  double t181, t182, t183, t185, t188, t189, t193, t194;
  double t197, t199, t201, t203, t205, t208, t210, t211;
  double t214, t218, t220, t221, t225, t228, t232, t233;
  double t235, t236, t244, t245, t247, t248, t249, t250;
  double t252, t257, t258, t260, t263, t264, t268, t271;
  double t273, tvrho0, t277, t280, t281, t286, t288, t291;
  double t292, t297, t299, t301, t303, t306, t308, t309;
  double t312, t316, t318, t319, t323, t326, t330, t331;
  double t333, t334, t342, t343, t345, t346, t347, t348;
  double t350, t355, tvrho1, t360, t361, t362, t366, t367;
  double t370, t373, t376, t377, t378, t381, t382, t386;
  double t390, tvsigma0, tvsigma1, t393, t397, t398, t401, t404;
  double t407, t408, t411, t415, t419, tvsigma2, t420, t421;
  double t422, t427, t431, t432, t433, t434, t440, t441;
  double t442, t446, t447, t450, t454, tvlapl0, t455, t460;
  double t464, t465, t466, t467, t473, t477, t478, t481;
  double t485, tvlapl1, tvtau0, tvtau1;

  double t488, t489, t492, t493, t494, t497, t501, t502;
  double t506, t508, t514, t515, t518, t520, t523, t525;
  double t527, t529, t532, t533, t536, t537, t540, t541;
  double t542, t543, t546, t547, t548, t549, t556, t557;
  double t560, t567, t568, t572, t573, t574, t585, t586;
  double t588, t589, t593, t594, t595, t596, t601, t606;
  double t607, t608, t611, t614, t618, t619, t623, t625;
  double t627, t630, t632, tv2rho20, t635, t639, t643, t644;
  double t648, t650, t658, t659, t663, t667, t668, t672;
  double t674, t681, t684, tv2rho21, t689, t694, t698, t699;
  double t705, t706, t711, t715, t716, t726, t728, t730;
  double t732, t735, t736, t739, t740, t743, t744, t745;
  double t746, t749, t750, t751, t758, t759, t762, t769;
  double t770, t774, t775, t786, t787, t789, t790, t794;
  double t795, t796, t801, t806, tv2rho22, t814, t817, t821;
  double t822, t823, t824, t825, t826, t829, t830, t831;
  double t835, t838, t839, t842, t843, t844, t845, t851;
  double t858, t859, t862, t863, t864, t865, t868, t869;
  double t876, t881, tv2rhosigma0, tv2rhosigma1, t888, t890, tv2rhosigma2, t896;
  double tv2rhosigma3, tv2rhosigma4, t903, t907, t908, t909, t910, t911;
  double t915, t916, t920, t923, t924, t927, t928, t929;
  double t930, t936, t943, t944, t947, t948, t949, t952;
  double t953, t960, t965, tv2rhosigma5, t972, t977, t978, t979;
  double t980, t983, t984, t989, t993, t996, t997, t998;
  double t999, t1000, t1004, t1005, t1009, t1019, t1020, t1031;
  double t1036, tv2rholapl0, t1043, t1045, tv2rholapl1, t1051, tv2rholapl2, t1060;
  double t1061, t1062, t1063, t1066, t1071, t1075, t1078, t1079;
  double t1080, t1081, t1082, t1086, t1087, t1091, t1101, t1112;
  double t1117, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t1119, t1120;
  double t1123, t1124, t1126, t1127, t1128, t1129, t1130, t1132;
  double t1133, t1134, t1137, t1138, t1139, t1140, t1143, t1144;
  double t1148, t1149, t1154, t1155, t1159, t1164, t1165, t1170;
  double t1175, t1176, t1180, t1184, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, t1185, t1186, t1189, t1190, t1191, t1192, t1194;
  double t1195, t1196, t1199, t1200, t1201, t1204, t1212, t1213;
  double t1217, t1222, t1230, t1234, t1238, tv2sigma25, t1239, t1240;
  double t1242, t1243, t1244, t1245, t1248, t1250, t1253, t1254;
  double t1255, t1256, t1257, t1261, t1262, t1263, t1264, t1270;
  double t1271, t1272, t1275, t1279, t1283, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1284, t1285, t1287, t1288, t1289, t1290;
  double t1293, t1295, t1298, t1299, t1300, t1301, t1302, t1306;
  double t1307, t1308, t1309, t1315, t1316, t1322, t1326, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1327, t1331;
  double t1332, t1333, t1335, t1336, t1340, t1341, t1348, t1349;
  double t1350, t1351, t1352, t1357, t1362, t1365, t1372, t1373;
  double t1374, t1378, t1379, t1382, t1386, tv2lapl20, tv2lapl21, t1387;
  double t1392, t1393, t1397, t1404, t1405, t1410, t1415, t1427;
  double t1430, t1434, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t47 = t33 * t33;
  t49 = 0.1e1 / t35 / t34;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t39 * t39;
  t53 = t52 * rho[0];
  t55 = 0.1e1 / t40 / t53;
  t57 = t50 * t51 * t55;
  t58 = params->a * t47;
  t59 = lapl[0] * lapl[0];
  t60 = t49 * t59;
  t61 = t39 * rho[0];
  t63 = 0.1e1 / t40 / t61;
  t64 = t60 * t63;
  t66 = t58 * t64 + t57;
  t68 = sqrt(t66);
  t71 = 0.1e1 + params->beta1 * t68 / 0.24e2;
  t72 = t71 * t71;
  t73 = 0.1e1 / t72;
  t76 = params->b * t47;
  t78 = t76 * t64 + t57;
  t79 = t78 * t78;
  t81 = sqrt(t78);
  t84 = 0.1e1 + params->beta2 * t81 / 0.24e2;
  t85 = t84 * t84;
  t86 = t85 * t85;
  t87 = 0.1e1 / t86;
  t90 = params->c * t33;
  t91 = t37 * lapl[0];
  t93 = 0.1e1 / t41 / rho[0];
  t97 = t90 * t91 * t93 / 0.24e2 + t45 / 0.24e2;
  t98 = params->A3 * t97;
  t100 = params->beta3 * t97 + 0.1e1;
  t101 = 0.1e1 / t100;
  t103 = 0.5e1 / 0.72e2 * t45 + params->A0 + params->A1 * t66 * t73 / 0.576e3 + params->A2 * t79 * t87 / 0.331776e6 + t98 * t101;
  t107 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t103);
  t108 = rho[1] <= p->dens_threshold;
  t109 = -t18;
  t111 = my_piecewise5(t16, t13, t12, t17, t109 * t9);
  t112 = 0.1e1 + t111;
  t113 = t112 <= p->zeta_threshold;
  t114 = POW_1_3(t112);
  t115 = t114 * t114;
  t117 = my_piecewise3(t113, t25, t115 * t112);
  t118 = t117 * t31;
  t119 = rho[1] * rho[1];
  t120 = POW_1_3(rho[1]);
  t121 = t120 * t120;
  t123 = 0.1e1 / t121 / t119;
  t125 = t38 * sigma[2] * t123;
  t127 = sigma[2] * sigma[2];
  t128 = t119 * t119;
  t129 = t128 * rho[1];
  t131 = 0.1e1 / t120 / t129;
  t133 = t50 * t127 * t131;
  t134 = lapl[1] * lapl[1];
  t135 = t49 * t134;
  t136 = t119 * rho[1];
  t138 = 0.1e1 / t120 / t136;
  t139 = t135 * t138;
  t141 = t58 * t139 + t133;
  t143 = sqrt(t141);
  t146 = 0.1e1 + params->beta1 * t143 / 0.24e2;
  t147 = t146 * t146;
  t148 = 0.1e1 / t147;
  t152 = t76 * t139 + t133;
  t153 = t152 * t152;
  t155 = sqrt(t152);
  t158 = 0.1e1 + params->beta2 * t155 / 0.24e2;
  t159 = t158 * t158;
  t160 = t159 * t159;
  t161 = 0.1e1 / t160;
  t164 = t37 * lapl[1];
  t166 = 0.1e1 / t121 / rho[1];
  t170 = t90 * t164 * t166 / 0.24e2 + t125 / 0.24e2;
  t171 = params->A3 * t170;
  t173 = params->beta3 * t170 + 0.1e1;
  t174 = 0.1e1 / t173;
  t176 = 0.5e1 / 0.72e2 * t125 + params->A0 + params->A1 * t141 * t148 / 0.576e3 + params->A2 * t153 * t161 / 0.331776e6 + t171 * t174;
  t180 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t176);
  tzk0 = t107 + t180;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t181 = t8 * t8;
  t182 = 0.1e1 / t181;
  t183 = t18 * t182;
  t185 = my_piecewise5(t12, 0, t16, 0, t9 - t183);
  t188 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t185);
  t189 = t188 * t31;
  t193 = 0.1e1 / t30;
  t194 = t29 * t193;
  t197 = t7 * t194 * t103 / 0.1e2;
  t199 = 0.1e1 / t41 / t61;
  t201 = t38 * sigma[0] * t199;
  t203 = t52 * t39;
  t205 = 0.1e1 / t40 / t203;
  t208 = 0.16e2 / 0.3e1 * t50 * t51 * t205;
  t210 = 0.1e1 / t40 / t52;
  t211 = t60 * t210;
  t214 = -t208 - 0.1e2 / 0.3e1 * t58 * t211;
  t218 = params->A1 * t68;
  t220 = 0.1e1 / t72 / t71;
  t221 = t220 * params->beta1;
  t225 = params->A2 * t78;
  t228 = -t208 - 0.1e2 / 0.3e1 * t76 * t211;
  t232 = t81 * t78;
  t233 = params->A2 * t232;
  t235 = 0.1e1 / t86 / t84;
  t236 = t235 * params->beta2;
  t244 = -t201 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t91 * t43;
  t245 = params->A3 * t244;
  t247 = t100 * t100;
  t248 = 0.1e1 / t247;
  t249 = t248 * params->beta3;
  t250 = t249 * t244;
  t252 = -0.5e1 / 0.27e2 * t201 + params->A1 * t214 * t73 / 0.576e3 - t218 * t221 * t214 / 0.13824e5 + t225 * t87 * t228 / 0.165888e6 - t233 * t236 * t228 / 0.3981312e7 + t245 * t101 - t98 * t250;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t103 + t197 + 0.3e1 / 0.2e2 * t7 * t32 * t252);
  t258 = t109 * t182;
  t260 = my_piecewise5(t16, 0, t12, 0, -t9 - t258);
  t263 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t260);
  t264 = t263 * t31;
  t268 = t117 * t193;
  t271 = t7 * t268 * t176 / 0.1e2;
  t273 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t176 + t271);
  tvrho0 = t107 + t180 + t8 * (t257 + t273);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t277 = my_piecewise5(t12, 0, t16, 0, -t9 - t183);
  t280 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t277);
  t281 = t280 * t31;
  t286 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t103 + t197);
  t288 = my_piecewise5(t16, 0, t12, 0, t9 - t258);
  t291 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t288);
  t292 = t291 * t31;
  t297 = 0.1e1 / t121 / t136;
  t299 = t38 * sigma[2] * t297;
  t301 = t128 * t119;
  t303 = 0.1e1 / t120 / t301;
  t306 = 0.16e2 / 0.3e1 * t50 * t127 * t303;
  t308 = 0.1e1 / t120 / t128;
  t309 = t135 * t308;
  t312 = -t306 - 0.1e2 / 0.3e1 * t58 * t309;
  t316 = params->A1 * t143;
  t318 = 0.1e1 / t147 / t146;
  t319 = t318 * params->beta1;
  t323 = params->A2 * t152;
  t326 = -t306 - 0.1e2 / 0.3e1 * t76 * t309;
  t330 = t155 * t152;
  t331 = params->A2 * t330;
  t333 = 0.1e1 / t160 / t158;
  t334 = t333 * params->beta2;
  t342 = -t299 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t164 * t123;
  t343 = params->A3 * t342;
  t345 = t173 * t173;
  t346 = 0.1e1 / t345;
  t347 = t346 * params->beta3;
  t348 = t347 * t342;
  t350 = -0.5e1 / 0.27e2 * t299 + params->A1 * t312 * t148 / 0.576e3 - t316 * t319 * t312 / 0.13824e5 + t323 * t161 * t326 / 0.165888e6 - t331 * t334 * t326 / 0.3981312e7 + t343 * t174 - t171 * t348;
  t355 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t176 + t271 + 0.3e1 / 0.2e2 * t7 * t118 * t350);
  tvrho1 = t107 + t180 + t8 * (t286 + t355);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t360 = params->A1 * t47;
  t361 = t360 * t49;
  t362 = sigma[0] * t55;
  t366 = t218 * t221;
  t367 = t50 * t362;
  t370 = t225 * t87;
  t373 = t233 * t236;
  t376 = params->A3 * t33;
  t377 = t37 * t43;
  t378 = t377 * t101;
  t381 = t98 * t248;
  t382 = params->beta3 * t33;
  t386 = 0.5e1 / 0.72e2 * t38 * t43 + t361 * t362 * t73 / 0.288e3 - t366 * t367 / 0.6912e4 + t370 * t367 / 0.82944e5 - t373 * t367 / 0.1990656e7 + t376 * t378 / 0.24e2 - t381 * t382 * t377 / 0.24e2;
  t390 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t386);
  tvsigma0 = t8 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t393 = sigma[2] * t131;
  t397 = t316 * t319;
  t398 = t50 * t393;
  t401 = t323 * t161;
  t404 = t331 * t334;
  t407 = t37 * t123;
  t408 = t407 * t174;
  t411 = t171 * t346;
  t415 = 0.5e1 / 0.72e2 * t38 * t123 + t361 * t393 * t148 / 0.288e3 - t397 * t398 / 0.6912e4 + t401 * t398 / 0.82944e5 - t404 * t398 / 0.1990656e7 + t376 * t408 / 0.24e2 - t411 * t382 * t407 / 0.24e2;
  t419 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t415);
  tvsigma2 = t8 * t419;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t420 = params->A1 * params->a;
  t421 = t420 * t47;
  t422 = t49 * lapl[0];
  t427 = t422 * t63;
  t431 = t87 * params->b;
  t432 = t225 * t431;
  t433 = lapl[0] * t63;
  t434 = t50 * t433;
  t440 = params->A3 * params->c;
  t441 = t440 * t33;
  t442 = t37 * t93;
  t446 = t98 * t249;
  t447 = t90 * t442;
  t450 = t421 * t422 * t63 * t73 / 0.288e3 - t366 * t58 * t427 / 0.6912e4 + t432 * t434 / 0.82944e5 - t373 * t76 * t427 / 0.1990656e7 + t441 * t442 * t101 / 0.24e2 - t446 * t447 / 0.24e2;
  t454 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t450);
  tvlapl0 = t8 * t454;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t455 = t49 * lapl[1];
  t460 = t455 * t138;
  t464 = t161 * params->b;
  t465 = t323 * t464;
  t466 = lapl[1] * t138;
  t467 = t50 * t466;
  t473 = t37 * t166;
  t477 = t171 * t347;
  t478 = t90 * t473;
  t481 = t421 * t455 * t138 * t148 / 0.288e3 - t397 * t58 * t460 / 0.6912e4 + t465 * t467 / 0.82944e5 - t404 * t76 * t460 / 0.1990656e7 + t441 * t473 * t174 / 0.24e2 - t477 * t478 / 0.24e2;
  t485 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t481);
  tvlapl1 = t8 * t485;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t488 = 0.1e1 / t26;
  t489 = t185 * t185;
  t492 = t181 * t8;
  t493 = 0.1e1 / t492;
  t494 = t18 * t493;
  t497 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t182 + 0.2e1 * t494);
  t501 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t488 * t489 + 0.5e1 / 0.3e1 * t27 * t497);
  t502 = t501 * t31;
  t506 = t188 * t193;
  t508 = t7 * t506 * t103;
  t514 = 0.1e1 / t30 / t8;
  t515 = t29 * t514;
  t518 = t7 * t515 * t103 / 0.3e2;
  t520 = t7 * t194 * t252;
  t523 = 0.1e1 / t41 / t52;
  t525 = t38 * sigma[0] * t523;
  t527 = t52 * t61;
  t529 = 0.1e1 / t40 / t527;
  t532 = 0.304e3 / 0.9e1 * t50 * t51 * t529;
  t533 = t60 * t55;
  t536 = t532 + 0.13e3 / 0.9e1 * t58 * t533;
  t537 = params->A1 * t536;
  t540 = t214 * t214;
  t541 = params->A1 * t540;
  t542 = 0.1e1 / t68;
  t543 = t221 * t542;
  t546 = t72 * t72;
  t547 = 0.1e1 / t546;
  t548 = params->A1 * t547;
  t549 = params->beta1 * params->beta1;
  t556 = t228 * t228;
  t557 = params->A2 * t556;
  t560 = params->A2 * t81;
  t567 = t532 + 0.13e3 / 0.9e1 * t76 * t533;
  t568 = t87 * t567;
  t572 = 0.1e1 / t86 / t85;
  t573 = params->beta2 * params->beta2;
  t574 = t572 * t573;
  t585 = 0.11e2 / 0.27e2 * t525 + 0.5e1 / 0.27e2 * t90 * t91 * t199;
  t586 = params->A3 * t585;
  t588 = t244 * t244;
  t589 = params->A3 * t588;
  t593 = 0.1e1 / t247 / t100;
  t594 = params->beta3 * params->beta3;
  t595 = t593 * t594;
  t596 = t595 * t588;
  t601 = 0.55e2 / 0.81e2 * t525 + t537 * t73 / 0.576e3 - t541 * t543 / 0.9216e4 + t548 * t549 * t540 / 0.221184e6 - t218 * t221 * t536 / 0.13824e5 + t557 * t87 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t560 * t235 * t556 * params->beta2 + t225 * t568 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t225 * t574 * t556 - t233 * t236 * t567 / 0.3981312e7 + t586 * t101 - 0.2e1 * t589 * t249 + 0.2e1 * t98 * t596 - t98 * t249 * t585;
  t606 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t103 + t508 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t252 - t518 + t520 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t601);
  t607 = 0.1e1 / t114;
  t608 = t260 * t260;
  t611 = t109 * t493;
  t614 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t182 + 0.2e1 * t611);
  t618 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t607 * t608 + 0.5e1 / 0.3e1 * t115 * t614);
  t619 = t618 * t31;
  t623 = t263 * t193;
  t625 = t7 * t623 * t176;
  t627 = t117 * t514;
  t630 = t7 * t627 * t176 / 0.3e2;
  t632 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t176 + t625 / 0.5e1 - t630);
  tv2rho20 = 0.2e1 * t257 + 0.2e1 * t273 + t8 * (t606 + t632);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t635 = t488 * t277;
  t639 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t494);
  t643 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t635 * t185 + 0.5e1 / 0.3e1 * t27 * t639);
  t644 = t643 * t31;
  t648 = t280 * t193;
  t650 = t7 * t648 * t103;
  t658 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t103 + t650 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t252 + t508 / 0.1e2 - t518 + t520 / 0.1e2);
  t659 = t607 * t288;
  t663 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t611);
  t667 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t659 * t260 + 0.5e1 / 0.3e1 * t115 * t663);
  t668 = t667 * t31;
  t672 = t291 * t193;
  t674 = t7 * t672 * t176;
  t681 = t7 * t268 * t350;
  t684 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t176 + t674 / 0.1e2 + t625 / 0.1e2 - t630 + 0.3e1 / 0.2e2 * t7 * t264 * t350 + t681 / 0.1e2);
  tv2rho21 = t257 + t273 + t286 + t355 + t8 * (t658 + t684);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t689 = t277 * t277;
  t694 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t182 + 0.2e1 * t494);
  t698 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t488 * t689 + 0.5e1 / 0.3e1 * t27 * t694);
  t699 = t698 * t31;
  t705 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t103 + t650 / 0.5e1 - t518);
  t706 = t288 * t288;
  t711 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t182 + 0.2e1 * t611);
  t715 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t607 * t706 + 0.5e1 / 0.3e1 * t115 * t711);
  t716 = t715 * t31;
  t726 = 0.1e1 / t121 / t128;
  t728 = t38 * sigma[2] * t726;
  t730 = t128 * t136;
  t732 = 0.1e1 / t120 / t730;
  t735 = 0.304e3 / 0.9e1 * t50 * t127 * t732;
  t736 = t135 * t131;
  t739 = t735 + 0.13e3 / 0.9e1 * t58 * t736;
  t740 = params->A1 * t739;
  t743 = t312 * t312;
  t744 = params->A1 * t743;
  t745 = 0.1e1 / t143;
  t746 = t319 * t745;
  t749 = t147 * t147;
  t750 = 0.1e1 / t749;
  t751 = params->A1 * t750;
  t758 = t326 * t326;
  t759 = params->A2 * t758;
  t762 = params->A2 * t155;
  t769 = t735 + 0.13e3 / 0.9e1 * t76 * t736;
  t770 = t161 * t769;
  t774 = 0.1e1 / t160 / t159;
  t775 = t774 * t573;
  t786 = 0.11e2 / 0.27e2 * t728 + 0.5e1 / 0.27e2 * t90 * t164 * t297;
  t787 = params->A3 * t786;
  t789 = t342 * t342;
  t790 = params->A3 * t789;
  t794 = 0.1e1 / t345 / t173;
  t795 = t794 * t594;
  t796 = t795 * t789;
  t801 = 0.55e2 / 0.81e2 * t728 + t740 * t148 / 0.576e3 - t744 * t746 / 0.9216e4 + t751 * t549 * t743 / 0.221184e6 - t316 * t319 * t739 / 0.13824e5 + t759 * t161 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t762 * t333 * t758 * params->beta2 + t323 * t770 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t323 * t775 * t758 - t331 * t334 * t769 / 0.3981312e7 + t787 * t174 - 0.2e1 * t790 * t347 + 0.2e1 * t171 * t796 - t171 * t347 * t786;
  t806 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t176 + t674 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t350 - t630 + t681 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * t801);
  tv2rho22 = 0.2e1 * t286 + 0.2e1 * t355 + t8 * (t705 + t806);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t814 = t7 * t194 * t386 / 0.1e2;
  t817 = sigma[0] * t205;
  t821 = t49 * sigma[0];
  t822 = t360 * t821;
  t823 = t55 * t220;
  t824 = params->beta1 * t542;
  t825 = t824 * t214;
  t826 = t823 * t825;
  t829 = t549 * t47;
  t830 = t548 * t829;
  t831 = t55 * t214;
  t835 = t50 * t817;
  t838 = params->A2 * t228;
  t839 = t838 * t87;
  t842 = t235 * t47;
  t843 = t560 * t842;
  t844 = t55 * params->beta2;
  t845 = t844 * t228;
  t851 = t225 * t574;
  t858 = t37 * t199;
  t859 = t858 * t101;
  t862 = t376 * t37;
  t863 = t43 * t248;
  t864 = params->beta3 * t244;
  t865 = t863 * t864;
  t868 = t98 * t595;
  t869 = t43 * t244;
  t876 = -0.5e1 / 0.27e2 * t38 * t199 - t361 * t817 * t73 / 0.54e2 - t822 * t826 / 0.4608e4 + t830 * t821 * t831 / 0.110592e6 + t366 * t835 / 0.1296e4 + t839 * t367 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t843 * t821 * t845 - t370 * t835 / 0.15552e5 + 0.5e1 / 0.95551488e8 * t851 * t50 * t362 * t228 + t373 * t835 / 0.373248e6 - t376 * t859 / 0.9e1 - t862 * t865 / 0.12e2 + t868 * t38 * t869 / 0.12e2 + t381 * t382 * t858 / 0.9e1;
  t881 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t386 + t814 + 0.3e1 / 0.2e2 * t7 * t32 * t876);
  tv2rhosigma0 = t8 * t881 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t888 = t7 * t268 * t415 / 0.1e2;
  t890 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t415 + t888);
  tv2rhosigma2 = t8 * t890 + t419;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t896 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t386 + t814);
  tv2rhosigma3 = t8 * t896 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t903 = sigma[2] * t303;
  t907 = t49 * sigma[2];
  t908 = t360 * t907;
  t909 = t131 * t318;
  t910 = params->beta1 * t745;
  t911 = t910 * t312;
  t915 = t751 * t829;
  t916 = t131 * t312;
  t920 = t50 * t903;
  t923 = params->A2 * t326;
  t924 = t923 * t161;
  t927 = t333 * t47;
  t928 = t762 * t927;
  t929 = t131 * params->beta2;
  t930 = t929 * t326;
  t936 = t323 * t775;
  t943 = t37 * t297;
  t944 = t943 * t174;
  t947 = t123 * t346;
  t948 = params->beta3 * t342;
  t949 = t947 * t948;
  t952 = t171 * t795;
  t953 = t123 * t342;
  t960 = -0.5e1 / 0.27e2 * t38 * t297 - t361 * t903 * t148 / 0.54e2 - t908 * t909 * t911 / 0.4608e4 + t915 * t907 * t916 / 0.110592e6 + t397 * t920 / 0.1296e4 + t924 * t398 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t928 * t907 * t930 - t401 * t920 / 0.15552e5 + 0.5e1 / 0.95551488e8 * t936 * t50 * t393 * t326 + t404 * t920 / 0.373248e6 - t376 * t944 / 0.9e1 - t862 * t949 / 0.12e2 + t952 * t38 * t953 / 0.12e2 + t411 * t382 * t943 / 0.9e1;
  t965 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t415 + t888 + 0.3e1 / 0.2e2 * t7 * t118 * t960);
  tv2rhosigma5 = t8 * t965 + t419;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t972 = t7 * t194 * t450 / 0.1e2;
  t977 = t50 * lapl[0];
  t978 = t420 * t977;
  t979 = t63 * t220;
  t980 = t979 * t825;
  t983 = t549 * params->a;
  t984 = t548 * t983;
  t989 = t422 * t210;
  t993 = t838 * t431;
  t996 = t235 * params->b;
  t997 = t996 * t47;
  t998 = t560 * t997;
  t999 = t63 * params->beta2;
  t1000 = t999 * t228;
  t1004 = lapl[0] * t210;
  t1005 = t50 * t1004;
  t1009 = t225 * t574 * params->b;
  t1019 = t440 * t38;
  t1020 = t93 * t248;
  t1031 = -0.5e1 / 0.432e3 * t421 * t422 * t210 * t73 - t978 * t980 / 0.4608e4 + t984 * t50 * t433 * t214 / 0.110592e6 + 0.5e1 / 0.10368e5 * t366 * t58 * t989 + t993 * t434 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t998 * t422 * t1000 - 0.5e1 / 0.124416e6 * t432 * t1005 + 0.5e1 / 0.95551488e8 * t1009 * t50 * t433 * t228 + 0.5e1 / 0.2985984e7 * t373 * t76 * t989 - 0.5e1 / 0.72e2 * t441 * t378 - t1019 * t1020 * t864 / 0.12e2 + t868 * t90 * t442 * t244 / 0.12e2 + 0.5e1 / 0.72e2 * t446 * t90 * t377;
  t1036 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t450 + t972 + 0.3e1 / 0.2e2 * t7 * t32 * t1031);
  tv2rholapl0 = t8 * t1036 + t454;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t1043 = t7 * t268 * t481 / 0.1e2;
  t1045 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t481 + t1043);
  tv2rholapl1 = t8 * t1045 + t485;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t1051 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t450 + t972);
  tv2rholapl2 = t8 * t1051 + t454;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t1060 = t50 * lapl[1];
  t1061 = t420 * t1060;
  t1062 = t138 * t318;
  t1063 = t1062 * t911;
  t1066 = t751 * t983;
  t1071 = t455 * t308;
  t1075 = t923 * t464;
  t1078 = t333 * params->b;
  t1079 = t1078 * t47;
  t1080 = t762 * t1079;
  t1081 = t138 * params->beta2;
  t1082 = t1081 * t326;
  t1086 = lapl[1] * t308;
  t1087 = t50 * t1086;
  t1091 = t323 * t775 * params->b;
  t1101 = t166 * t346;
  t1112 = -0.5e1 / 0.432e3 * t421 * t455 * t308 * t148 - t1061 * t1063 / 0.4608e4 + t1066 * t50 * t466 * t312 / 0.110592e6 + 0.5e1 / 0.10368e5 * t397 * t58 * t1071 + t1075 * t467 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t1080 * t455 * t1082 - 0.5e1 / 0.124416e6 * t465 * t1087 + 0.5e1 / 0.95551488e8 * t1091 * t50 * t466 * t326 + 0.5e1 / 0.2985984e7 * t404 * t76 * t1071 - 0.5e1 / 0.72e2 * t441 * t408 - t1019 * t1101 * t948 / 0.12e2 + t952 * t90 * t473 * t342 / 0.12e2 + 0.5e1 / 0.72e2 * t477 * t90 * t407;
  t1117 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t481 + t1043 + 0.3e1 / 0.2e2 * t7 * t118 * t1112);
  tv2rholapl3 = t8 * t1117 + t485;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1119 = t49 * t55;
  t1120 = t1119 * t73;
  t1123 = params->A1 * t33;
  t1124 = t34 * t34;
  t1126 = 0.1e1 / t36 / t1124;
  t1127 = t1126 * t51;
  t1128 = t1123 * t1127;
  t1129 = t52 * t52;
  t1130 = t1129 * t39;
  t1132 = 0.1e1 / t41 / t1130;
  t1133 = t1132 * t220;
  t1134 = t1133 * t824;
  t1137 = t548 * t549;
  t1138 = t33 * t1126;
  t1139 = t51 * t1132;
  t1140 = t1138 * t1139;
  t1143 = t218 * t220;
  t1144 = params->beta1 * t47;
  t1148 = params->A2 * t33;
  t1149 = t1148 * t1126;
  t1154 = t560 * t235 * t33;
  t1155 = t1132 * params->beta2;
  t1159 = t50 * t55;
  t1164 = t233 * t235;
  t1165 = params->beta2 * t47;
  t1170 = params->A3 * t47 * t49;
  t1175 = t98 * t593;
  t1176 = t594 * t47;
  t1180 = t360 * t1120 / 0.288e3 - t1128 * t1134 / 0.384e3 + t1137 * t1140 / 0.9216e4 - t1143 * t1144 * t1119 / 0.6912e4 + t1149 * t1139 * t87 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1154 * t1127 * t1155 + t370 * t1159 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t851 * t1140 - t1164 * t1165 * t1119 / 0.1990656e7 - t1170 * t55 * t248 * params->beta3 / 0.288e3 + t1175 * t1176 * t1119 / 0.288e3;
  t1184 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1180);
  tv2sigma20 = t8 * t1184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1185 = t49 * t131;
  t1186 = t1185 * t148;
  t1189 = t1126 * t127;
  t1190 = t1123 * t1189;
  t1191 = t128 * t128;
  t1192 = t1191 * t119;
  t1194 = 0.1e1 / t121 / t1192;
  t1195 = t1194 * t318;
  t1196 = t1195 * t910;
  t1199 = t751 * t549;
  t1200 = t127 * t1194;
  t1201 = t1138 * t1200;
  t1204 = t316 * t318;
  t1212 = t762 * t333 * t33;
  t1213 = t1194 * params->beta2;
  t1217 = t50 * t131;
  t1222 = t331 * t333;
  t1230 = t171 * t794;
  t1234 = t360 * t1186 / 0.288e3 - t1190 * t1196 / 0.384e3 + t1199 * t1201 / 0.9216e4 - t1204 * t1144 * t1185 / 0.6912e4 + t1149 * t1200 * t161 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1212 * t1189 * t1213 + t401 * t1217 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t936 * t1201 - t1222 * t1165 * t1185 / 0.1990656e7 - t1170 * t131 * t346 * params->beta3 / 0.288e3 + t1230 * t1176 * t1185 / 0.288e3;
  t1238 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1234);
  tv2sigma25 = t8 * t1238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1239 = t1138 * lapl[0];
  t1240 = t420 * t1239;
  t1242 = 0.1e1 / t41 / t1129;
  t1243 = t1242 * t220;
  t1244 = t824 * sigma[0];
  t1245 = t1243 * t1244;
  t1248 = lapl[0] * t1242;
  t1250 = t1138 * t1248 * sigma[0];
  t1253 = t1126 * sigma[0];
  t1254 = t1148 * t1253;
  t1255 = t1242 * t87;
  t1256 = params->b * lapl[0];
  t1257 = t1255 * t1256;
  t1261 = t560 * t996 * t33;
  t1262 = t1126 * lapl[0];
  t1263 = t1242 * params->beta2;
  t1264 = t1263 * sigma[0];
  t1270 = t440 * t47;
  t1271 = t49 * t210;
  t1272 = t1271 * t249;
  t1275 = params->c * t47;
  t1279 = -t1240 * t1245 / 0.384e3 + t984 * t1250 / 0.9216e4 + t1254 * t1257 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1261 * t1262 * t1264 + 0.5e1 / 0.7962624e7 * t1009 * t1250 - t1270 * t1272 / 0.288e3 + t868 * t1275 * t1271 / 0.288e3;
  t1283 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1279);
  tv2sigmalapl0 = t8 * t1283;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1284 = t1138 * lapl[1];
  t1285 = t420 * t1284;
  t1287 = 0.1e1 / t121 / t1191;
  t1288 = t1287 * t318;
  t1289 = t910 * sigma[2];
  t1290 = t1288 * t1289;
  t1293 = lapl[1] * t1287;
  t1295 = t1138 * t1293 * sigma[2];
  t1298 = t1126 * sigma[2];
  t1299 = t1148 * t1298;
  t1300 = t1287 * t161;
  t1301 = params->b * lapl[1];
  t1302 = t1300 * t1301;
  t1306 = t762 * t1078 * t33;
  t1307 = t1126 * lapl[1];
  t1308 = t1287 * params->beta2;
  t1309 = t1308 * sigma[2];
  t1315 = t49 * t308;
  t1316 = t1315 * t347;
  t1322 = -t1285 * t1290 / 0.384e3 + t1066 * t1295 / 0.9216e4 + t1299 * t1302 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1306 * t1307 * t1309 + 0.5e1 / 0.7962624e7 * t1091 * t1295 - t1270 * t1316 / 0.288e3 + t952 * t1275 * t1315 / 0.288e3;
  t1326 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1322);
  tv2sigmalapl5 = t8 * t1326;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1327 = t49 * t63;
  t1331 = params->a * params->a;
  t1332 = params->A1 * t1331;
  t1333 = t1332 * t1138;
  t1335 = 0.1e1 / t41 / t203;
  t1336 = t59 * t1335;
  t1340 = t549 * t1331;
  t1341 = t548 * t1340;
  t1348 = params->b * params->b;
  t1349 = params->A2 * t1348;
  t1350 = t1349 * t33;
  t1351 = t1126 * t59;
  t1352 = t1335 * t87;
  t1357 = t560 * t235 * t1348;
  t1362 = t76 * t1327;
  t1365 = t1348 * t33;
  t1372 = params->c * params->c;
  t1373 = params->A3 * t1372;
  t1374 = t1373 * t47;
  t1378 = t1372 * t47;
  t1379 = t1378 * t1327;
  t1382 = t421 * t1327 * t73 / 0.288e3 - t1333 * t1336 * t543 / 0.384e3 + t1341 * t1138 * t1336 / 0.9216e4 - t366 * t58 * t1327 / 0.6912e4 + t1350 * t1351 * t1352 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1357 * t1138 * t1336 * params->beta2 + t370 * t1362 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t851 * t1365 * t1351 * t1335 - t373 * t1362 / 0.1990656e7 - t1374 * t1327 * t249 / 0.288e3 + t868 * t1379 / 0.288e3;
  t1386 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1382);
  tv2lapl20 = t8 * t1386;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1387 = t49 * t138;
  t1392 = 0.1e1 / t121 / t301;
  t1393 = t134 * t1392;
  t1397 = t751 * t1340;
  t1404 = t1126 * t134;
  t1405 = t1392 * t161;
  t1410 = t762 * t333 * t1348;
  t1415 = t76 * t1387;
  t1427 = t1378 * t1387;
  t1430 = t421 * t1387 * t148 / 0.288e3 - t1333 * t1393 * t746 / 0.384e3 + t1397 * t1138 * t1393 / 0.9216e4 - t397 * t58 * t1387 / 0.6912e4 + t1350 * t1404 * t1405 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1410 * t1138 * t1393 * params->beta2 + t401 * t1415 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t936 * t1365 * t1404 * t1392 - t404 * t1415 / 0.1990656e7 - t1374 * t1387 * t347 / 0.288e3 + t952 * t1427 / 0.288e3;
  t1434 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1430);
  tv2lapl22 = t8 * t1434;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t45, t47, t49, t50, t51, t52;
  double t53, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t71, t72, t73, t76, t78;
  double t79, t81, t84, t85, t86, t87, t90, t91;
  double t93, t97, t98, t100, t101, t103, t107, t108;
  double t109, t111, t112, t113, t114, t115, t117, t118;
  double t119, t120, t121, t123, t125, t127, t128, t129;
  double t131, t133, t134, t135, t136, t138, t139, t141;
  double t143, t146, t147, t148, t152, t153, t155, t158;
  double t159, t160, t161, t164, t166, t170, t171, t173;
  double t174, t176, t180, tzk0;

  double t181, t182, t183, t185, t188, t189, t193, t194;
  double t197, t199, t201, t203, t205, t208, t210, t211;
  double t214, t218, t220, t221, t225, t228, t232, t233;
  double t235, t236, t244, t245, t247, t248, t249, t250;
  double t252, t257, t258, t260, t263, t264, t268, t271;
  double t273, tvrho0, t277, t280, t281, t286, t288, t291;
  double t292, t297, t299, t301, t303, t306, t308, t309;
  double t312, t316, t318, t319, t323, t326, t330, t331;
  double t333, t334, t342, t343, t345, t346, t347, t348;
  double t350, t355, tvrho1, t360, t361, t362, t366, t367;
  double t370, t373, t376, t377, t378, t381, t382, t386;
  double t390, tvsigma0, tvsigma1, t393, t397, t398, t401, t404;
  double t407, t408, t411, t415, t419, tvsigma2, t420, t421;
  double t422, t427, t431, t432, t433, t434, t440, t441;
  double t442, t446, t447, t450, t454, tvlapl0, t455, t460;
  double t464, t465, t466, t467, t473, t477, t478, t481;
  double t485, tvlapl1, tvtau0, tvtau1;

  double t488, t489, t492, t493, t494, t497, t501, t502;
  double t506, t508, t514, t515, t518, t520, t523, t525;
  double t527, t529, t532, t533, t536, t537, t540, t541;
  double t542, t543, t546, t547, t548, t549, t556, t557;
  double t560, t567, t568, t572, t573, t574, t585, t586;
  double t588, t589, t593, t594, t595, t596, t601, t606;
  double t607, t608, t611, t614, t618, t619, t623, t625;
  double t627, t630, t632, tv2rho20, t635, t639, t643, t644;
  double t648, t650, t658, t659, t663, t667, t668, t672;
  double t674, t681, t684, tv2rho21, t689, t694, t698, t699;
  double t705, t706, t711, t715, t716, t726, t728, t730;
  double t732, t735, t736, t739, t740, t743, t744, t745;
  double t746, t749, t750, t751, t758, t759, t762, t769;
  double t770, t774, t775, t786, t787, t789, t790, t794;
  double t795, t796, t801, t806, tv2rho22, t814, t817, t821;
  double t822, t823, t824, t825, t826, t829, t830, t831;
  double t835, t838, t839, t842, t843, t844, t845, t851;
  double t858, t859, t862, t863, t864, t865, t868, t869;
  double t876, t881, tv2rhosigma0, tv2rhosigma1, t888, t890, tv2rhosigma2, t896;
  double tv2rhosigma3, tv2rhosigma4, t903, t907, t908, t909, t910, t911;
  double t915, t916, t920, t923, t924, t927, t928, t929;
  double t930, t936, t943, t944, t947, t948, t949, t952;
  double t953, t960, t965, tv2rhosigma5, t972, t977, t978, t979;
  double t980, t983, t984, t989, t993, t996, t997, t998;
  double t999, t1000, t1004, t1005, t1009, t1019, t1020, t1031;
  double t1036, tv2rholapl0, t1043, t1045, tv2rholapl1, t1051, tv2rholapl2, t1060;
  double t1061, t1062, t1063, t1066, t1071, t1075, t1078, t1079;
  double t1080, t1081, t1082, t1086, t1087, t1091, t1101, t1112;
  double t1117, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t1119, t1120;
  double t1123, t1124, t1126, t1127, t1128, t1129, t1130, t1132;
  double t1133, t1134, t1137, t1138, t1139, t1140, t1143, t1144;
  double t1148, t1149, t1154, t1155, t1159, t1164, t1165, t1170;
  double t1175, t1176, t1180, t1184, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, t1185, t1186, t1189, t1190, t1191, t1192, t1194;
  double t1195, t1196, t1199, t1200, t1201, t1204, t1212, t1213;
  double t1217, t1222, t1230, t1234, t1238, tv2sigma25, t1239, t1240;
  double t1242, t1243, t1244, t1245, t1248, t1250, t1253, t1254;
  double t1255, t1256, t1257, t1261, t1262, t1263, t1264, t1270;
  double t1271, t1272, t1275, t1279, t1283, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1284, t1285, t1287, t1288, t1289, t1290;
  double t1293, t1295, t1298, t1299, t1300, t1301, t1302, t1306;
  double t1307, t1308, t1309, t1315, t1316, t1322, t1326, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1327, t1331;
  double t1332, t1333, t1335, t1336, t1340, t1341, t1348, t1349;
  double t1350, t1351, t1352, t1357, t1362, t1365, t1372, t1373;
  double t1374, t1378, t1379, t1382, t1386, tv2lapl20, tv2lapl21, t1387;
  double t1392, t1393, t1397, t1404, t1405, t1410, t1415, t1427;
  double t1430, t1434, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t1438, t1439, t1442, t1445, t1446, t1447, t1450, t1454;
  double t1455, t1459, t1461, t1466, t1468, t1471, t1477, t1478;
  double t1481, t1483, t1486, t1489, t1492, t1493, t1496, t1497;
  double t1501, t1503, t1505, t1506, t1507, t1508, t1512, t1517;
  double t1518, t1519, t1526, t1530, t1531, t1532, t1538, t1539;
  double t1540, t1553, t1556, t1557, t1558, t1559, t1562, t1563;
  double t1566, t1567, t1570, t1574, t1578, t1579, t1585, t1592;
  double t1594, t1595, t1596, t1597, t1601, t1602, t1607, t1609;
  double t1610, t1613, t1616, t1619, t1623, t1624, t1628, t1630;
  double t1632, t1634, t1636, t1639, t1641, tv3rho30, t1644, t1645;
  double t1646, t1649, t1654, t1655, t1657, t1661, t1662, t1666;
  double t1669, t1673, t1675, t1679, t1688, t1689, t1690, t1693;
  double t1698, t1700, t1704, t1705, t1709, t1712, t1713, t1715;
  double t1724, t1726, t1729, tv3rho31, t1732, t1737, t1741, t1745;
  double t1746, t1750, t1752, t1761, t1762, t1767, t1771, t1775;
  double t1776, t1780, t1782, t1789, t1797, t1799, t1800, tv3rho32;
  double t1805, t1812, t1816, t1817, t1824, t1825, t1832, t1836;
  double t1837, t1853, t1856, t1857, t1860, t1861, t1865, t1867;
  double t1872, t1873, t1877, t1878, t1884, t1885, t1891, t1892;
  double t1893, t1894, t1898, t1903, t1904, t1912, t1913, t1914;
  double t1920, t1921, t1930, t1931, t1935, t1936, t1937, t1940;
  double t1941, t1944, t1948, t1952, t1956, t1957, t1958, t1962;
  double t1963, t1968, tv3rho33, t1976, t1983, t1985, t1987, t1988;
  double t1995, t2001, t2005, t2006, t2014, t2023, t2024, t2028;
  double t2029, t2048, t2049, t2054, t2058, t2062, t2063, t2064;
  double t2068, t2073, t2074, t2077, t2081, t2082, t2086, t2087;
  double t2094, t2098, t2106, t2107, t2112, tv3rho2sigma0, tv3rho2sigma1, t2119;
  double t2123, t2125, tv3rho2sigma2, t2131, t2139, tv3rho2sigma3, tv3rho2sigma4, t2145;
  double t2152, t2155, tv3rho2sigma5, t2163, tv3rho2sigma6, tv3rho2sigma7, t2174, t2187;
  double t2192, t2193, t2197, t2206, t2210, t2214, t2215, t2216;
  double t2220, t2226, t2230, t2234, t2235, t2238, t2239, t2240;
  double t2244, t2245, t2250, t2251, t2254, t2260, t2265, t2277;
  double t2281, t2282, t2292, t2293, t2298, tv3rho2sigma8, t2305, t2312;
  double t2314, t2317, t2321, t2329, t2330, t2335, t2336, t2339;
  double t2342, t2343, t2346, t2347, t2348, t2350, t2354, t2355;
  double t2363, t2374, t2378, t2386, t2387, t2406, t2409, t2420;
  double t2421, t2424, t2427, t2428, t2433, tv3rho2lapl0, t2440, t2444;
  double t2446, tv3rho2lapl1, t2452, t2460, tv3rho2lapl2, t2466, t2473, t2476;
  double tv3rho2lapl3, t2484, tv3rho2lapl4, t2500, t2505, t2508, t2509, t2512;
  double t2514, t2518, t2519, t2523, t2527, t2528, t2531, t2534;
  double t2535, t2543, t2544, t2550, t2557, t2562, t2583, t2588;
  double t2589, t2601, t2604, t2605, t2610, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1;
  double tv3rho2tau2, tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2617, t2618, t2619, t2622;
  double t2624, t2625, t2626, t2632, t2646, t2647, t2650, t2651;
  double t2655, t2656, t2657, t2658, t2662, t2663, t2664, t2665;
  double t2666, t2669, t2673, t2684, t2688, t2692, t2693, t2712;
  double t2715, t2716, t2721, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2728, t2730, tv3rhosigma25, t2736, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2741, t2747, t2757, t2759, t2760, t2767, t2773;
  double t2783, t2788, t2789, t2792, t2793, t2794, t2797, t2798;
  double t2799, t2803, t2804, t2805, t2806, t2807, t2810, t2824;
  double t2828, t2832, t2833, t2837, t2838, t2843, tv3rhosigma211, t2850;
  double t2851, t2853, t2854, t2855, t2858, t2859, t2860, t2861;
  double t2865, t2866, t2867, t2871, t2872, t2873, t2874, t2875;
  double t2879, t2881, t2885, t2888, t2889, t2890, t2891, t2894;
  double t2895, t2896, t2897, t2898, t2903, t2907, t2908, t2914;
  double t2917, t2918, t2919, t2922, t2929, t2934, tv3rhosigmalapl0, tv3rhosigmalapl1;
  double tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2941, t2943, tv3rhosigmalapl5, t2949, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2954, t2956, t2957, t2958;
  double t2961, t2962, t2963, t2964, t2968, t2969, t2970, t2974;
  double t2975, t2976, t2977, t2981, t2983, t2987, t2990, t2991;
  double t2992, t2993, t2996, t2997, t2998, t3003, t3007, t3008;
  double t3014, t3017, t3018, t3021, t3028, t3033, tv3rhosigmalapl11, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t3040, t3041, t3042, t3043, t3044;
  double t3045, t3049, t3050, t3051, t3052, t3056, t3057, t3066;
  double t3067, t3079, t3080, t3084, t3093, t3096, t3103, t3113;
  double t3114, t3121, t3130, t3131, t3132, t3136, t3140, t3141;
  double t3146, tv3rholapl20, tv3rholapl21, t3153, t3155, tv3rholapl22, t3161, tv3rholapl23;
  double tv3rholapl24, t3166, t3167, t3168, t3169, t3173, t3174, t3183;
  double t3184, t3196, t3197, t3201, t3205, t3206, t3207, t3218;
  double t3223, t3227, t3236, t3251, t3252, t3253, t3257, t3261;
  double t3262, t3267, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24;
  double tv3rhotau25, t3269, t3270, t3271, t3274, t3275, t3276, t3277;
  double t3278, t3279, t3280, t3289, t3290, t3291, t3295, t3296;
  double t3302, t3303, t3305, t3308, t3309, t3316, t3317, t3323;
  double t3324, t3325, t3327, t3330, t3331, t3335, t3339, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t3340, t3341, t3342, t3345, t3346, t3347, t3348, t3357;
  double t3358, t3359, t3363, t3364, t3370, t3372, t3375, t3376;
  double t3383, t3389, t3391, t3394, t3398, t3402, tv3sigma39, t3403;
  double t3404, t3406, t3407, t3408, t3412, t3413, t3417, t3421;
  double t3422, t3432, t3435, t3438, t3439, t3440, t3441, t3456;
  double t3457, t3459, t3462, t3463, t3467, t3471, tv3sigma2lapl0, tv3sigma2lapl1;
  double tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9;
  double tv3sigma2lapl10, t3472, t3473, t3475, t3476, t3477, t3481, t3482;
  double t3489, t3490, t3500, t3503, t3506, t3507, t3508, t3523;
  double t3525, t3528, t3532, t3536, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2;
  double tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10;
  double tv3sigma2tau11, t3539, t3540, t3541, t3542, t3543, t3544, t3548;
  double t3549, t3553, t3554, t3555, t3562, t3563, t3564, t3565;
  double t3568, t3569, t3570, t3587, t3588, t3590, t3593, t3594;
  double t3598, t3602, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25;
  double tv3sigmalapl26, tv3sigmalapl27, t3605, t3606, t3607, t3608, t3609, t3610;
  double t3614, t3615, t3619, t3620, t3621, t3628, t3629, t3630;
  double t3631, t3634, t3635, t3652, t3654, t3657, t3661, t3665;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3666, t3670;
  double t3671, t3672, t3673, t3674, t3675, t3676, t3680, t3684;
  double t3685, t3686, t3690, t3697, t3698, t3699, t3700, t3701;
  double t3704, t3705, t3713, t3714, t3722, t3723, t3724, t3725;
  double t3730, t3735, t3739, tv3lapl30, tv3lapl31, tv3lapl32, t3740, t3744;
  double t3745, t3746, t3747, t3748, t3752, t3756, t3757, t3761;
  double t3768, t3769, t3770, t3773, t3774, t3782, t3790, t3799;
  double t3803, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31;
  double tv3tau32, tv3tau33;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t47 = t33 * t33;
  t49 = 0.1e1 / t35 / t34;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t39 * t39;
  t53 = t52 * rho[0];
  t55 = 0.1e1 / t40 / t53;
  t57 = t50 * t51 * t55;
  t58 = params->a * t47;
  t59 = lapl[0] * lapl[0];
  t60 = t49 * t59;
  t61 = t39 * rho[0];
  t63 = 0.1e1 / t40 / t61;
  t64 = t60 * t63;
  t66 = t58 * t64 + t57;
  t68 = sqrt(t66);
  t71 = 0.1e1 + params->beta1 * t68 / 0.24e2;
  t72 = t71 * t71;
  t73 = 0.1e1 / t72;
  t76 = params->b * t47;
  t78 = t76 * t64 + t57;
  t79 = t78 * t78;
  t81 = sqrt(t78);
  t84 = 0.1e1 + params->beta2 * t81 / 0.24e2;
  t85 = t84 * t84;
  t86 = t85 * t85;
  t87 = 0.1e1 / t86;
  t90 = params->c * t33;
  t91 = t37 * lapl[0];
  t93 = 0.1e1 / t41 / rho[0];
  t97 = t90 * t91 * t93 / 0.24e2 + t45 / 0.24e2;
  t98 = params->A3 * t97;
  t100 = params->beta3 * t97 + 0.1e1;
  t101 = 0.1e1 / t100;
  t103 = 0.5e1 / 0.72e2 * t45 + params->A0 + params->A1 * t66 * t73 / 0.576e3 + params->A2 * t79 * t87 / 0.331776e6 + t98 * t101;
  t107 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t103);
  t108 = rho[1] <= p->dens_threshold;
  t109 = -t18;
  t111 = my_piecewise5(t16, t13, t12, t17, t109 * t9);
  t112 = 0.1e1 + t111;
  t113 = t112 <= p->zeta_threshold;
  t114 = POW_1_3(t112);
  t115 = t114 * t114;
  t117 = my_piecewise3(t113, t25, t115 * t112);
  t118 = t117 * t31;
  t119 = rho[1] * rho[1];
  t120 = POW_1_3(rho[1]);
  t121 = t120 * t120;
  t123 = 0.1e1 / t121 / t119;
  t125 = t38 * sigma[2] * t123;
  t127 = sigma[2] * sigma[2];
  t128 = t119 * t119;
  t129 = t128 * rho[1];
  t131 = 0.1e1 / t120 / t129;
  t133 = t50 * t127 * t131;
  t134 = lapl[1] * lapl[1];
  t135 = t49 * t134;
  t136 = t119 * rho[1];
  t138 = 0.1e1 / t120 / t136;
  t139 = t135 * t138;
  t141 = t58 * t139 + t133;
  t143 = sqrt(t141);
  t146 = 0.1e1 + params->beta1 * t143 / 0.24e2;
  t147 = t146 * t146;
  t148 = 0.1e1 / t147;
  t152 = t76 * t139 + t133;
  t153 = t152 * t152;
  t155 = sqrt(t152);
  t158 = 0.1e1 + params->beta2 * t155 / 0.24e2;
  t159 = t158 * t158;
  t160 = t159 * t159;
  t161 = 0.1e1 / t160;
  t164 = t37 * lapl[1];
  t166 = 0.1e1 / t121 / rho[1];
  t170 = t90 * t164 * t166 / 0.24e2 + t125 / 0.24e2;
  t171 = params->A3 * t170;
  t173 = params->beta3 * t170 + 0.1e1;
  t174 = 0.1e1 / t173;
  t176 = 0.5e1 / 0.72e2 * t125 + params->A0 + params->A1 * t141 * t148 / 0.576e3 + params->A2 * t153 * t161 / 0.331776e6 + t171 * t174;
  t180 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t176);
  tzk0 = t107 + t180;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t181 = t8 * t8;
  t182 = 0.1e1 / t181;
  t183 = t18 * t182;
  t185 = my_piecewise5(t12, 0, t16, 0, t9 - t183);
  t188 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t185);
  t189 = t188 * t31;
  t193 = 0.1e1 / t30;
  t194 = t29 * t193;
  t197 = t7 * t194 * t103 / 0.1e2;
  t199 = 0.1e1 / t41 / t61;
  t201 = t38 * sigma[0] * t199;
  t203 = t52 * t39;
  t205 = 0.1e1 / t40 / t203;
  t208 = 0.16e2 / 0.3e1 * t50 * t51 * t205;
  t210 = 0.1e1 / t40 / t52;
  t211 = t60 * t210;
  t214 = -t208 - 0.1e2 / 0.3e1 * t58 * t211;
  t218 = params->A1 * t68;
  t220 = 0.1e1 / t72 / t71;
  t221 = t220 * params->beta1;
  t225 = params->A2 * t78;
  t228 = -t208 - 0.1e2 / 0.3e1 * t76 * t211;
  t232 = t81 * t78;
  t233 = params->A2 * t232;
  t235 = 0.1e1 / t86 / t84;
  t236 = t235 * params->beta2;
  t244 = -t201 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t91 * t43;
  t245 = params->A3 * t244;
  t247 = t100 * t100;
  t248 = 0.1e1 / t247;
  t249 = t248 * params->beta3;
  t250 = t249 * t244;
  t252 = -0.5e1 / 0.27e2 * t201 + params->A1 * t214 * t73 / 0.576e3 - t218 * t221 * t214 / 0.13824e5 + t225 * t87 * t228 / 0.165888e6 - t233 * t236 * t228 / 0.3981312e7 + t245 * t101 - t98 * t250;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t103 + t197 + 0.3e1 / 0.2e2 * t7 * t32 * t252);
  t258 = t109 * t182;
  t260 = my_piecewise5(t16, 0, t12, 0, -t9 - t258);
  t263 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t260);
  t264 = t263 * t31;
  t268 = t117 * t193;
  t271 = t7 * t268 * t176 / 0.1e2;
  t273 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t176 + t271);
  tvrho0 = t107 + t180 + t8 * (t257 + t273);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t277 = my_piecewise5(t12, 0, t16, 0, -t9 - t183);
  t280 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t277);
  t281 = t280 * t31;
  t286 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t103 + t197);
  t288 = my_piecewise5(t16, 0, t12, 0, t9 - t258);
  t291 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t288);
  t292 = t291 * t31;
  t297 = 0.1e1 / t121 / t136;
  t299 = t38 * sigma[2] * t297;
  t301 = t128 * t119;
  t303 = 0.1e1 / t120 / t301;
  t306 = 0.16e2 / 0.3e1 * t50 * t127 * t303;
  t308 = 0.1e1 / t120 / t128;
  t309 = t135 * t308;
  t312 = -t306 - 0.1e2 / 0.3e1 * t58 * t309;
  t316 = params->A1 * t143;
  t318 = 0.1e1 / t147 / t146;
  t319 = t318 * params->beta1;
  t323 = params->A2 * t152;
  t326 = -t306 - 0.1e2 / 0.3e1 * t76 * t309;
  t330 = t155 * t152;
  t331 = params->A2 * t330;
  t333 = 0.1e1 / t160 / t158;
  t334 = t333 * params->beta2;
  t342 = -t299 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t164 * t123;
  t343 = params->A3 * t342;
  t345 = t173 * t173;
  t346 = 0.1e1 / t345;
  t347 = t346 * params->beta3;
  t348 = t347 * t342;
  t350 = -0.5e1 / 0.27e2 * t299 + params->A1 * t312 * t148 / 0.576e3 - t316 * t319 * t312 / 0.13824e5 + t323 * t161 * t326 / 0.165888e6 - t331 * t334 * t326 / 0.3981312e7 + t343 * t174 - t171 * t348;
  t355 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t176 + t271 + 0.3e1 / 0.2e2 * t7 * t118 * t350);
  tvrho1 = t107 + t180 + t8 * (t286 + t355);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t360 = params->A1 * t47;
  t361 = t360 * t49;
  t362 = sigma[0] * t55;
  t366 = t218 * t221;
  t367 = t50 * t362;
  t370 = t225 * t87;
  t373 = t233 * t236;
  t376 = params->A3 * t33;
  t377 = t37 * t43;
  t378 = t377 * t101;
  t381 = t98 * t248;
  t382 = params->beta3 * t33;
  t386 = 0.5e1 / 0.72e2 * t38 * t43 + t361 * t362 * t73 / 0.288e3 - t366 * t367 / 0.6912e4 + t370 * t367 / 0.82944e5 - t373 * t367 / 0.1990656e7 + t376 * t378 / 0.24e2 - t381 * t382 * t377 / 0.24e2;
  t390 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t386);
  tvsigma0 = t8 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t393 = sigma[2] * t131;
  t397 = t316 * t319;
  t398 = t50 * t393;
  t401 = t323 * t161;
  t404 = t331 * t334;
  t407 = t37 * t123;
  t408 = t407 * t174;
  t411 = t171 * t346;
  t415 = 0.5e1 / 0.72e2 * t38 * t123 + t361 * t393 * t148 / 0.288e3 - t397 * t398 / 0.6912e4 + t401 * t398 / 0.82944e5 - t404 * t398 / 0.1990656e7 + t376 * t408 / 0.24e2 - t411 * t382 * t407 / 0.24e2;
  t419 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t415);
  tvsigma2 = t8 * t419;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t420 = params->A1 * params->a;
  t421 = t420 * t47;
  t422 = t49 * lapl[0];
  t427 = t422 * t63;
  t431 = t87 * params->b;
  t432 = t225 * t431;
  t433 = lapl[0] * t63;
  t434 = t50 * t433;
  t440 = params->A3 * params->c;
  t441 = t440 * t33;
  t442 = t37 * t93;
  t446 = t98 * t249;
  t447 = t90 * t442;
  t450 = t421 * t422 * t63 * t73 / 0.288e3 - t366 * t58 * t427 / 0.6912e4 + t432 * t434 / 0.82944e5 - t373 * t76 * t427 / 0.1990656e7 + t441 * t442 * t101 / 0.24e2 - t446 * t447 / 0.24e2;
  t454 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t450);
  tvlapl0 = t8 * t454;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t455 = t49 * lapl[1];
  t460 = t455 * t138;
  t464 = t161 * params->b;
  t465 = t323 * t464;
  t466 = lapl[1] * t138;
  t467 = t50 * t466;
  t473 = t37 * t166;
  t477 = t171 * t347;
  t478 = t90 * t473;
  t481 = t421 * t455 * t138 * t148 / 0.288e3 - t397 * t58 * t460 / 0.6912e4 + t465 * t467 / 0.82944e5 - t404 * t76 * t460 / 0.1990656e7 + t441 * t473 * t174 / 0.24e2 - t477 * t478 / 0.24e2;
  t485 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t481);
  tvlapl1 = t8 * t485;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t488 = 0.1e1 / t26;
  t489 = t185 * t185;
  t492 = t181 * t8;
  t493 = 0.1e1 / t492;
  t494 = t18 * t493;
  t497 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t182 + 0.2e1 * t494);
  t501 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t488 * t489 + 0.5e1 / 0.3e1 * t27 * t497);
  t502 = t501 * t31;
  t506 = t188 * t193;
  t508 = t7 * t506 * t103;
  t514 = 0.1e1 / t30 / t8;
  t515 = t29 * t514;
  t518 = t7 * t515 * t103 / 0.3e2;
  t520 = t7 * t194 * t252;
  t523 = 0.1e1 / t41 / t52;
  t525 = t38 * sigma[0] * t523;
  t527 = t52 * t61;
  t529 = 0.1e1 / t40 / t527;
  t532 = 0.304e3 / 0.9e1 * t50 * t51 * t529;
  t533 = t60 * t55;
  t536 = t532 + 0.13e3 / 0.9e1 * t58 * t533;
  t537 = params->A1 * t536;
  t540 = t214 * t214;
  t541 = params->A1 * t540;
  t542 = 0.1e1 / t68;
  t543 = t221 * t542;
  t546 = t72 * t72;
  t547 = 0.1e1 / t546;
  t548 = params->A1 * t547;
  t549 = params->beta1 * params->beta1;
  t556 = t228 * t228;
  t557 = params->A2 * t556;
  t560 = params->A2 * t81;
  t567 = t532 + 0.13e3 / 0.9e1 * t76 * t533;
  t568 = t87 * t567;
  t572 = 0.1e1 / t86 / t85;
  t573 = params->beta2 * params->beta2;
  t574 = t572 * t573;
  t585 = 0.11e2 / 0.27e2 * t525 + 0.5e1 / 0.27e2 * t90 * t91 * t199;
  t586 = params->A3 * t585;
  t588 = t244 * t244;
  t589 = params->A3 * t588;
  t593 = 0.1e1 / t247 / t100;
  t594 = params->beta3 * params->beta3;
  t595 = t593 * t594;
  t596 = t595 * t588;
  t601 = 0.55e2 / 0.81e2 * t525 + t537 * t73 / 0.576e3 - t541 * t543 / 0.9216e4 + t548 * t549 * t540 / 0.221184e6 - t218 * t221 * t536 / 0.13824e5 + t557 * t87 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t560 * t235 * t556 * params->beta2 + t225 * t568 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t225 * t574 * t556 - t233 * t236 * t567 / 0.3981312e7 + t586 * t101 - 0.2e1 * t589 * t249 + 0.2e1 * t98 * t596 - t98 * t249 * t585;
  t606 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t103 + t508 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t252 - t518 + t520 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t601);
  t607 = 0.1e1 / t114;
  t608 = t260 * t260;
  t611 = t109 * t493;
  t614 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t182 + 0.2e1 * t611);
  t618 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t607 * t608 + 0.5e1 / 0.3e1 * t115 * t614);
  t619 = t618 * t31;
  t623 = t263 * t193;
  t625 = t7 * t623 * t176;
  t627 = t117 * t514;
  t630 = t7 * t627 * t176 / 0.3e2;
  t632 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t176 + t625 / 0.5e1 - t630);
  tv2rho20 = 0.2e1 * t257 + 0.2e1 * t273 + t8 * (t606 + t632);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t635 = t488 * t277;
  t639 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t494);
  t643 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t635 * t185 + 0.5e1 / 0.3e1 * t27 * t639);
  t644 = t643 * t31;
  t648 = t280 * t193;
  t650 = t7 * t648 * t103;
  t658 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t103 + t650 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t252 + t508 / 0.1e2 - t518 + t520 / 0.1e2);
  t659 = t607 * t288;
  t663 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t611);
  t667 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t659 * t260 + 0.5e1 / 0.3e1 * t115 * t663);
  t668 = t667 * t31;
  t672 = t291 * t193;
  t674 = t7 * t672 * t176;
  t681 = t7 * t268 * t350;
  t684 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t176 + t674 / 0.1e2 + t625 / 0.1e2 - t630 + 0.3e1 / 0.2e2 * t7 * t264 * t350 + t681 / 0.1e2);
  tv2rho21 = t257 + t273 + t286 + t355 + t8 * (t658 + t684);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t689 = t277 * t277;
  t694 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t182 + 0.2e1 * t494);
  t698 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t488 * t689 + 0.5e1 / 0.3e1 * t27 * t694);
  t699 = t698 * t31;
  t705 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t103 + t650 / 0.5e1 - t518);
  t706 = t288 * t288;
  t711 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t182 + 0.2e1 * t611);
  t715 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t607 * t706 + 0.5e1 / 0.3e1 * t115 * t711);
  t716 = t715 * t31;
  t726 = 0.1e1 / t121 / t128;
  t728 = t38 * sigma[2] * t726;
  t730 = t128 * t136;
  t732 = 0.1e1 / t120 / t730;
  t735 = 0.304e3 / 0.9e1 * t50 * t127 * t732;
  t736 = t135 * t131;
  t739 = t735 + 0.13e3 / 0.9e1 * t58 * t736;
  t740 = params->A1 * t739;
  t743 = t312 * t312;
  t744 = params->A1 * t743;
  t745 = 0.1e1 / t143;
  t746 = t319 * t745;
  t749 = t147 * t147;
  t750 = 0.1e1 / t749;
  t751 = params->A1 * t750;
  t758 = t326 * t326;
  t759 = params->A2 * t758;
  t762 = params->A2 * t155;
  t769 = t735 + 0.13e3 / 0.9e1 * t76 * t736;
  t770 = t161 * t769;
  t774 = 0.1e1 / t160 / t159;
  t775 = t774 * t573;
  t786 = 0.11e2 / 0.27e2 * t728 + 0.5e1 / 0.27e2 * t90 * t164 * t297;
  t787 = params->A3 * t786;
  t789 = t342 * t342;
  t790 = params->A3 * t789;
  t794 = 0.1e1 / t345 / t173;
  t795 = t794 * t594;
  t796 = t795 * t789;
  t801 = 0.55e2 / 0.81e2 * t728 + t740 * t148 / 0.576e3 - t744 * t746 / 0.9216e4 + t751 * t549 * t743 / 0.221184e6 - t316 * t319 * t739 / 0.13824e5 + t759 * t161 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t762 * t333 * t758 * params->beta2 + t323 * t770 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t323 * t775 * t758 - t331 * t334 * t769 / 0.3981312e7 + t787 * t174 - 0.2e1 * t790 * t347 + 0.2e1 * t171 * t796 - t171 * t347 * t786;
  t806 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t176 + t674 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t350 - t630 + t681 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * t801);
  tv2rho22 = 0.2e1 * t286 + 0.2e1 * t355 + t8 * (t705 + t806);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t814 = t7 * t194 * t386 / 0.1e2;
  t817 = sigma[0] * t205;
  t821 = t49 * sigma[0];
  t822 = t360 * t821;
  t823 = t55 * t220;
  t824 = params->beta1 * t542;
  t825 = t824 * t214;
  t826 = t823 * t825;
  t829 = t549 * t47;
  t830 = t548 * t829;
  t831 = t55 * t214;
  t835 = t50 * t817;
  t838 = params->A2 * t228;
  t839 = t838 * t87;
  t842 = t235 * t47;
  t843 = t560 * t842;
  t844 = t55 * params->beta2;
  t845 = t844 * t228;
  t851 = t225 * t574;
  t858 = t37 * t199;
  t859 = t858 * t101;
  t862 = t376 * t37;
  t863 = t43 * t248;
  t864 = params->beta3 * t244;
  t865 = t863 * t864;
  t868 = t98 * t595;
  t869 = t43 * t244;
  t876 = -0.5e1 / 0.27e2 * t38 * t199 - t361 * t817 * t73 / 0.54e2 - t822 * t826 / 0.4608e4 + t830 * t821 * t831 / 0.110592e6 + t366 * t835 / 0.1296e4 + t839 * t367 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t843 * t821 * t845 - t370 * t835 / 0.15552e5 + 0.5e1 / 0.95551488e8 * t851 * t50 * t362 * t228 + t373 * t835 / 0.373248e6 - t376 * t859 / 0.9e1 - t862 * t865 / 0.12e2 + t868 * t38 * t869 / 0.12e2 + t381 * t382 * t858 / 0.9e1;
  t881 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t386 + t814 + 0.3e1 / 0.2e2 * t7 * t32 * t876);
  tv2rhosigma0 = t8 * t881 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t888 = t7 * t268 * t415 / 0.1e2;
  t890 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t415 + t888);
  tv2rhosigma2 = t8 * t890 + t419;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t896 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t386 + t814);
  tv2rhosigma3 = t8 * t896 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t903 = sigma[2] * t303;
  t907 = t49 * sigma[2];
  t908 = t360 * t907;
  t909 = t131 * t318;
  t910 = params->beta1 * t745;
  t911 = t910 * t312;
  t915 = t751 * t829;
  t916 = t131 * t312;
  t920 = t50 * t903;
  t923 = params->A2 * t326;
  t924 = t923 * t161;
  t927 = t333 * t47;
  t928 = t762 * t927;
  t929 = t131 * params->beta2;
  t930 = t929 * t326;
  t936 = t323 * t775;
  t943 = t37 * t297;
  t944 = t943 * t174;
  t947 = t123 * t346;
  t948 = params->beta3 * t342;
  t949 = t947 * t948;
  t952 = t171 * t795;
  t953 = t123 * t342;
  t960 = -0.5e1 / 0.27e2 * t38 * t297 - t361 * t903 * t148 / 0.54e2 - t908 * t909 * t911 / 0.4608e4 + t915 * t907 * t916 / 0.110592e6 + t397 * t920 / 0.1296e4 + t924 * t398 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t928 * t907 * t930 - t401 * t920 / 0.15552e5 + 0.5e1 / 0.95551488e8 * t936 * t50 * t393 * t326 + t404 * t920 / 0.373248e6 - t376 * t944 / 0.9e1 - t862 * t949 / 0.12e2 + t952 * t38 * t953 / 0.12e2 + t411 * t382 * t943 / 0.9e1;
  t965 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t415 + t888 + 0.3e1 / 0.2e2 * t7 * t118 * t960);
  tv2rhosigma5 = t8 * t965 + t419;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t972 = t7 * t194 * t450 / 0.1e2;
  t977 = t50 * lapl[0];
  t978 = t420 * t977;
  t979 = t63 * t220;
  t980 = t979 * t825;
  t983 = t549 * params->a;
  t984 = t548 * t983;
  t989 = t422 * t210;
  t993 = t838 * t431;
  t996 = t235 * params->b;
  t997 = t996 * t47;
  t998 = t560 * t997;
  t999 = t63 * params->beta2;
  t1000 = t999 * t228;
  t1004 = lapl[0] * t210;
  t1005 = t50 * t1004;
  t1009 = t225 * t574 * params->b;
  t1019 = t440 * t38;
  t1020 = t93 * t248;
  t1031 = -0.5e1 / 0.432e3 * t421 * t422 * t210 * t73 - t978 * t980 / 0.4608e4 + t984 * t50 * t433 * t214 / 0.110592e6 + 0.5e1 / 0.10368e5 * t366 * t58 * t989 + t993 * t434 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t998 * t422 * t1000 - 0.5e1 / 0.124416e6 * t432 * t1005 + 0.5e1 / 0.95551488e8 * t1009 * t50 * t433 * t228 + 0.5e1 / 0.2985984e7 * t373 * t76 * t989 - 0.5e1 / 0.72e2 * t441 * t378 - t1019 * t1020 * t864 / 0.12e2 + t868 * t90 * t442 * t244 / 0.12e2 + 0.5e1 / 0.72e2 * t446 * t90 * t377;
  t1036 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t450 + t972 + 0.3e1 / 0.2e2 * t7 * t32 * t1031);
  tv2rholapl0 = t8 * t1036 + t454;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t1043 = t7 * t268 * t481 / 0.1e2;
  t1045 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t481 + t1043);
  tv2rholapl1 = t8 * t1045 + t485;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t1051 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t450 + t972);
  tv2rholapl2 = t8 * t1051 + t454;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t1060 = t50 * lapl[1];
  t1061 = t420 * t1060;
  t1062 = t138 * t318;
  t1063 = t1062 * t911;
  t1066 = t751 * t983;
  t1071 = t455 * t308;
  t1075 = t923 * t464;
  t1078 = t333 * params->b;
  t1079 = t1078 * t47;
  t1080 = t762 * t1079;
  t1081 = t138 * params->beta2;
  t1082 = t1081 * t326;
  t1086 = lapl[1] * t308;
  t1087 = t50 * t1086;
  t1091 = t323 * t775 * params->b;
  t1101 = t166 * t346;
  t1112 = -0.5e1 / 0.432e3 * t421 * t455 * t308 * t148 - t1061 * t1063 / 0.4608e4 + t1066 * t50 * t466 * t312 / 0.110592e6 + 0.5e1 / 0.10368e5 * t397 * t58 * t1071 + t1075 * t467 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t1080 * t455 * t1082 - 0.5e1 / 0.124416e6 * t465 * t1087 + 0.5e1 / 0.95551488e8 * t1091 * t50 * t466 * t326 + 0.5e1 / 0.2985984e7 * t404 * t76 * t1071 - 0.5e1 / 0.72e2 * t441 * t408 - t1019 * t1101 * t948 / 0.12e2 + t952 * t90 * t473 * t342 / 0.12e2 + 0.5e1 / 0.72e2 * t477 * t90 * t407;
  t1117 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t481 + t1043 + 0.3e1 / 0.2e2 * t7 * t118 * t1112);
  tv2rholapl3 = t8 * t1117 + t485;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1119 = t49 * t55;
  t1120 = t1119 * t73;
  t1123 = params->A1 * t33;
  t1124 = t34 * t34;
  t1126 = 0.1e1 / t36 / t1124;
  t1127 = t1126 * t51;
  t1128 = t1123 * t1127;
  t1129 = t52 * t52;
  t1130 = t1129 * t39;
  t1132 = 0.1e1 / t41 / t1130;
  t1133 = t1132 * t220;
  t1134 = t1133 * t824;
  t1137 = t548 * t549;
  t1138 = t33 * t1126;
  t1139 = t51 * t1132;
  t1140 = t1138 * t1139;
  t1143 = t218 * t220;
  t1144 = params->beta1 * t47;
  t1148 = params->A2 * t33;
  t1149 = t1148 * t1126;
  t1154 = t560 * t235 * t33;
  t1155 = t1132 * params->beta2;
  t1159 = t50 * t55;
  t1164 = t233 * t235;
  t1165 = params->beta2 * t47;
  t1170 = params->A3 * t47 * t49;
  t1175 = t98 * t593;
  t1176 = t594 * t47;
  t1180 = t360 * t1120 / 0.288e3 - t1128 * t1134 / 0.384e3 + t1137 * t1140 / 0.9216e4 - t1143 * t1144 * t1119 / 0.6912e4 + t1149 * t1139 * t87 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1154 * t1127 * t1155 + t370 * t1159 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t851 * t1140 - t1164 * t1165 * t1119 / 0.1990656e7 - t1170 * t55 * t248 * params->beta3 / 0.288e3 + t1175 * t1176 * t1119 / 0.288e3;
  t1184 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1180);
  tv2sigma20 = t8 * t1184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1185 = t49 * t131;
  t1186 = t1185 * t148;
  t1189 = t1126 * t127;
  t1190 = t1123 * t1189;
  t1191 = t128 * t128;
  t1192 = t1191 * t119;
  t1194 = 0.1e1 / t121 / t1192;
  t1195 = t1194 * t318;
  t1196 = t1195 * t910;
  t1199 = t751 * t549;
  t1200 = t127 * t1194;
  t1201 = t1138 * t1200;
  t1204 = t316 * t318;
  t1212 = t762 * t333 * t33;
  t1213 = t1194 * params->beta2;
  t1217 = t50 * t131;
  t1222 = t331 * t333;
  t1230 = t171 * t794;
  t1234 = t360 * t1186 / 0.288e3 - t1190 * t1196 / 0.384e3 + t1199 * t1201 / 0.9216e4 - t1204 * t1144 * t1185 / 0.6912e4 + t1149 * t1200 * t161 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1212 * t1189 * t1213 + t401 * t1217 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t936 * t1201 - t1222 * t1165 * t1185 / 0.1990656e7 - t1170 * t131 * t346 * params->beta3 / 0.288e3 + t1230 * t1176 * t1185 / 0.288e3;
  t1238 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1234);
  tv2sigma25 = t8 * t1238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1239 = t1138 * lapl[0];
  t1240 = t420 * t1239;
  t1242 = 0.1e1 / t41 / t1129;
  t1243 = t1242 * t220;
  t1244 = t824 * sigma[0];
  t1245 = t1243 * t1244;
  t1248 = lapl[0] * t1242;
  t1250 = t1138 * t1248 * sigma[0];
  t1253 = t1126 * sigma[0];
  t1254 = t1148 * t1253;
  t1255 = t1242 * t87;
  t1256 = params->b * lapl[0];
  t1257 = t1255 * t1256;
  t1261 = t560 * t996 * t33;
  t1262 = t1126 * lapl[0];
  t1263 = t1242 * params->beta2;
  t1264 = t1263 * sigma[0];
  t1270 = t440 * t47;
  t1271 = t49 * t210;
  t1272 = t1271 * t249;
  t1275 = params->c * t47;
  t1279 = -t1240 * t1245 / 0.384e3 + t984 * t1250 / 0.9216e4 + t1254 * t1257 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1261 * t1262 * t1264 + 0.5e1 / 0.7962624e7 * t1009 * t1250 - t1270 * t1272 / 0.288e3 + t868 * t1275 * t1271 / 0.288e3;
  t1283 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1279);
  tv2sigmalapl0 = t8 * t1283;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1284 = t1138 * lapl[1];
  t1285 = t420 * t1284;
  t1287 = 0.1e1 / t121 / t1191;
  t1288 = t1287 * t318;
  t1289 = t910 * sigma[2];
  t1290 = t1288 * t1289;
  t1293 = lapl[1] * t1287;
  t1295 = t1138 * t1293 * sigma[2];
  t1298 = t1126 * sigma[2];
  t1299 = t1148 * t1298;
  t1300 = t1287 * t161;
  t1301 = params->b * lapl[1];
  t1302 = t1300 * t1301;
  t1306 = t762 * t1078 * t33;
  t1307 = t1126 * lapl[1];
  t1308 = t1287 * params->beta2;
  t1309 = t1308 * sigma[2];
  t1315 = t49 * t308;
  t1316 = t1315 * t347;
  t1322 = -t1285 * t1290 / 0.384e3 + t1066 * t1295 / 0.9216e4 + t1299 * t1302 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1306 * t1307 * t1309 + 0.5e1 / 0.7962624e7 * t1091 * t1295 - t1270 * t1316 / 0.288e3 + t952 * t1275 * t1315 / 0.288e3;
  t1326 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1322);
  tv2sigmalapl5 = t8 * t1326;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1327 = t49 * t63;
  t1331 = params->a * params->a;
  t1332 = params->A1 * t1331;
  t1333 = t1332 * t1138;
  t1335 = 0.1e1 / t41 / t203;
  t1336 = t59 * t1335;
  t1340 = t549 * t1331;
  t1341 = t548 * t1340;
  t1348 = params->b * params->b;
  t1349 = params->A2 * t1348;
  t1350 = t1349 * t33;
  t1351 = t1126 * t59;
  t1352 = t1335 * t87;
  t1357 = t560 * t235 * t1348;
  t1362 = t76 * t1327;
  t1365 = t1348 * t33;
  t1372 = params->c * params->c;
  t1373 = params->A3 * t1372;
  t1374 = t1373 * t47;
  t1378 = t1372 * t47;
  t1379 = t1378 * t1327;
  t1382 = t421 * t1327 * t73 / 0.288e3 - t1333 * t1336 * t543 / 0.384e3 + t1341 * t1138 * t1336 / 0.9216e4 - t366 * t58 * t1327 / 0.6912e4 + t1350 * t1351 * t1352 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1357 * t1138 * t1336 * params->beta2 + t370 * t1362 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t851 * t1365 * t1351 * t1335 - t373 * t1362 / 0.1990656e7 - t1374 * t1327 * t249 / 0.288e3 + t868 * t1379 / 0.288e3;
  t1386 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1382);
  tv2lapl20 = t8 * t1386;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1387 = t49 * t138;
  t1392 = 0.1e1 / t121 / t301;
  t1393 = t134 * t1392;
  t1397 = t751 * t1340;
  t1404 = t1126 * t134;
  t1405 = t1392 * t161;
  t1410 = t762 * t333 * t1348;
  t1415 = t76 * t1387;
  t1427 = t1378 * t1387;
  t1430 = t421 * t1387 * t148 / 0.288e3 - t1333 * t1393 * t746 / 0.384e3 + t1397 * t1138 * t1393 / 0.9216e4 - t397 * t58 * t1387 / 0.6912e4 + t1350 * t1404 * t1405 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1410 * t1138 * t1393 * params->beta2 + t401 * t1415 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t936 * t1365 * t1404 * t1392 - t404 * t1415 / 0.1990656e7 - t1374 * t1387 * t347 / 0.288e3 + t952 * t1427 / 0.288e3;
  t1434 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1430);
  tv2lapl22 = t8 * t1434;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1438 = 0.1e1 / t26 / t21;
  t1439 = t489 * t185;
  t1442 = t488 * t185;
  t1445 = t181 * t181;
  t1446 = 0.1e1 / t1445;
  t1447 = t18 * t1446;
  t1450 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t493 - 0.6e1 * t1447);
  t1454 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1438 * t1439 + 0.1e2 / 0.3e1 * t1442 * t497 + 0.5e1 / 0.3e1 * t27 * t1450);
  t1455 = t1454 * t31;
  t1459 = t501 * t193;
  t1461 = t7 * t1459 * t103;
  t1466 = t188 * t514;
  t1468 = t7 * t1466 * t103;
  t1471 = t7 * t506 * t252;
  t1477 = 0.1e1 / t30 / t181;
  t1478 = t29 * t1477;
  t1481 = 0.2e1 / 0.45e2 * t7 * t1478 * t103;
  t1483 = t7 * t515 * t252;
  t1486 = t7 * t194 * t601;
  t1489 = 0.1e1 / t40 / t1129;
  t1492 = 0.6688e4 / 0.27e2 * t50 * t51 * t1489;
  t1493 = t60 * t205;
  t1496 = -t1492 - 0.208e4 / 0.27e2 * t76 * t1493;
  t1497 = t87 * t1496;
  t1501 = 0.1e1 / t41 / t53;
  t1503 = t38 * sigma[0] * t1501;
  t1505 = t540 * t214;
  t1506 = params->A1 * t1505;
  t1507 = t547 * t549;
  t1508 = 0.1e1 / t66;
  t1512 = t549 * t214;
  t1517 = 0.1e1 / t546 / t71;
  t1518 = params->A1 * t1517;
  t1519 = t549 * params->beta1;
  t1526 = -t1492 - 0.208e4 / 0.27e2 * t58 * t1493;
  t1530 = t556 * t228;
  t1531 = params->A2 * t1530;
  t1532 = 0.1e1 / t81;
  t1538 = 0.1e1 / t86 / t85 / t84;
  t1539 = t573 * params->beta2;
  t1540 = t1538 * t1539;
  t1553 = -0.154e3 / 0.81e2 * t1503 - 0.55e2 / 0.81e2 * t90 * t91 * t523;
  t1556 = t225 * t1497 / 0.165888e6 - 0.77e3 / 0.243e3 * t1503 + t1506 * t1507 * t1508 / 0.147456e6 + t548 * t1512 * t536 / 0.73728e5 - t1518 * t1519 * t1505 * t542 / 0.2654208e7 - t218 * t221 * t1526 / 0.13824e5 - 0.5e1 / 0.5308416e7 * t1531 * t236 * t1532 - 0.5e1 / 0.1528823808e10 * t560 * t1540 * t1530 - t233 * t236 * t1496 / 0.3981312e7 - 0.6e1 * t586 * t250 - t98 * t249 * t1553;
  t1557 = t225 * t572;
  t1558 = t573 * t228;
  t1559 = t1558 * t567;
  t1562 = t588 * t244;
  t1563 = params->A3 * t1562;
  t1566 = t594 * t244;
  t1567 = t1566 * t585;
  t1570 = t537 * t220;
  t1574 = 0.1e1 / t68 / t66;
  t1578 = t560 * t235;
  t1579 = t228 * params->beta2;
  t1585 = params->A2 * t572;
  t1592 = params->A3 * t1553;
  t1594 = t247 * t247;
  t1595 = 0.1e1 / t1594;
  t1596 = t594 * params->beta3;
  t1597 = t1595 * t1596;
  t1601 = 0.5e1 / 0.63700992e8 * t1557 * t1559 + 0.6e1 * t1563 * t595 + 0.6e1 * t1175 * t1567 - t1570 * t825 / 0.3072e4 + t1506 * t221 * t1574 / 0.18432e5 - 0.7e1 / 0.2654208e7 * t1578 * t1579 * t567 + t838 * t568 / 0.55296e5 + 0.5e1 / 0.42467328e8 * t1585 * t1530 * t573 + params->A1 * t1526 * t73 / 0.576e3 + t1592 * t101 - 0.6e1 * t98 * t1597 * t1562;
  t1602 = t1556 + t1601;
  t1607 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1455 * t103 + 0.3e1 / 0.1e2 * t1461 + 0.9e1 / 0.2e2 * t7 * t502 * t252 - t1468 / 0.1e2 + 0.3e1 / 0.5e1 * t1471 + 0.9e1 / 0.2e2 * t7 * t189 * t601 + t1481 - t1483 / 0.1e2 + 0.3e1 / 0.1e2 * t1486 + 0.3e1 / 0.2e2 * t7 * t32 * t1602);
  t1609 = 0.1e1 / t114 / t112;
  t1610 = t608 * t260;
  t1613 = t607 * t260;
  t1616 = t109 * t1446;
  t1619 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t493 - 0.6e1 * t1616);
  t1623 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1609 * t1610 + 0.1e2 / 0.3e1 * t1613 * t614 + 0.5e1 / 0.3e1 * t115 * t1619);
  t1624 = t1623 * t31;
  t1628 = t618 * t193;
  t1630 = t7 * t1628 * t176;
  t1632 = t263 * t514;
  t1634 = t7 * t1632 * t176;
  t1636 = t117 * t1477;
  t1639 = 0.2e1 / 0.45e2 * t7 * t1636 * t176;
  t1641 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1624 * t176 + 0.3e1 / 0.1e2 * t1630 - t1634 / 0.1e2 + t1639);
  tv3rho30 = 0.3e1 * t606 + 0.3e1 * t632 + t8 * (t1607 + t1641);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1644 = 0.2e1 * t658;
  t1645 = 0.2e1 * t684;
  t1646 = t1438 * t277;
  t1649 = t488 * t639;
  t1654 = 0.2e1 * t493;
  t1655 = 0.6e1 * t1447;
  t1657 = my_piecewise5(t12, 0, t16, 0, t1654 - t1655);
  t1661 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1646 * t489 + 0.2e2 / 0.9e1 * t1649 * t185 + 0.1e2 / 0.9e1 * t635 * t497 + 0.5e1 / 0.3e1 * t27 * t1657);
  t1662 = t1661 * t31;
  t1666 = t643 * t193;
  t1669 = t7 * t1666 * t103 / 0.5e1;
  t1673 = t280 * t514;
  t1675 = t7 * t1673 * t103;
  t1679 = t7 * t648 * t252 / 0.5e1;
  t1688 = 0.3e1 / 0.2e2 * t7 * t1662 * t103 + t1669 + 0.3e1 / 0.1e2 * t7 * t644 * t252 - t1675 / 0.3e2 + t1679 + 0.3e1 / 0.2e2 * t7 * t281 * t601 + t1461 / 0.1e2 - t1468 / 0.15e2 + t1471 / 0.5e1 + t1481 - t1483 / 0.15e2 + t1486 / 0.1e2;
  t1689 = my_piecewise3(t2, 0, t1688);
  t1690 = t1609 * t288;
  t1693 = t607 * t663;
  t1698 = 0.6e1 * t1616;
  t1700 = my_piecewise5(t16, 0, t12, 0, -t1654 - t1698);
  t1704 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1690 * t608 + 0.2e2 / 0.9e1 * t1693 * t260 + 0.1e2 / 0.9e1 * t659 * t614 + 0.5e1 / 0.3e1 * t115 * t1700);
  t1705 = t1704 * t31;
  t1709 = t667 * t193;
  t1712 = t7 * t1709 * t176 / 0.5e1;
  t1713 = t291 * t514;
  t1715 = t7 * t1713 * t176;
  t1724 = t7 * t623 * t350 / 0.5e1;
  t1726 = t7 * t627 * t350;
  t1729 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1705 * t176 + t1712 - t1715 / 0.3e2 + t1630 / 0.1e2 - t1634 / 0.15e2 + t1639 + 0.3e1 / 0.2e2 * t7 * t619 * t350 + t1724 - t1726 / 0.3e2);
  tv3rho31 = t606 + t632 + t1644 + t1645 + t8 * (t1689 + t1729);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1732 = t1438 * t689;
  t1737 = t488 * t694;
  t1741 = my_piecewise5(t12, 0, t16, 0, -t1654 - t1655);
  t1745 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1732 * t185 + 0.2e2 / 0.9e1 * t635 * t639 + 0.1e2 / 0.9e1 * t1737 * t185 + 0.5e1 / 0.3e1 * t27 * t1741);
  t1746 = t1745 * t31;
  t1750 = t698 * t193;
  t1752 = t7 * t1750 * t103;
  t1761 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1746 * t103 + t1752 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t699 * t252 + t1669 - t1675 / 0.15e2 + t1679 - t1468 / 0.3e2 + t1481 - t1483 / 0.3e2);
  t1762 = t1609 * t706;
  t1767 = t607 * t711;
  t1771 = my_piecewise5(t16, 0, t12, 0, t1654 - t1698);
  t1775 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1762 * t260 + 0.2e2 / 0.9e1 * t659 * t663 + 0.1e2 / 0.9e1 * t1767 * t260 + 0.5e1 / 0.3e1 * t115 * t1771);
  t1776 = t1775 * t31;
  t1780 = t715 * t193;
  t1782 = t7 * t1780 * t176;
  t1789 = t7 * t672 * t350;
  t1797 = t7 * t268 * t801;
  t1799 = 0.3e1 / 0.2e2 * t7 * t1776 * t176 + t1782 / 0.1e2 + t1712 - t1715 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t668 * t350 + t1789 / 0.5e1 - t1634 / 0.3e2 + t1639 + t1724 - t1726 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t264 * t801 + t1797 / 0.1e2;
  t1800 = my_piecewise3(t108, 0, t1799);
  tv3rho32 = t1644 + t1645 + t705 + t806 + t8 * (t1761 + t1800);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1805 = t689 * t277;
  t1812 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t493 - 0.6e1 * t1447);
  t1816 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1438 * t1805 + 0.1e2 / 0.3e1 * t635 * t694 + 0.5e1 / 0.3e1 * t27 * t1812);
  t1817 = t1816 * t31;
  t1824 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1817 * t103 + 0.3e1 / 0.1e2 * t1752 - t1675 / 0.1e2 + t1481);
  t1825 = t706 * t288;
  t1832 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t493 - 0.6e1 * t1616);
  t1836 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1609 * t1825 + 0.1e2 / 0.3e1 * t659 * t711 + 0.5e1 / 0.3e1 * t115 * t1832);
  t1837 = t1836 * t31;
  t1853 = 0.1e1 / t120 / t1191;
  t1856 = 0.6688e4 / 0.27e2 * t50 * t127 * t1853;
  t1857 = t135 * t303;
  t1860 = -t1856 - 0.208e4 / 0.27e2 * t58 * t1857;
  t1861 = params->A1 * t1860;
  t1865 = 0.1e1 / t121 / t129;
  t1867 = t38 * sigma[2] * t1865;
  t1872 = -0.154e3 / 0.81e2 * t1867 - 0.55e2 / 0.81e2 * t90 * t164 * t726;
  t1873 = params->A3 * t1872;
  t1877 = params->A2 * t774;
  t1878 = t758 * t326;
  t1884 = -t1856 - 0.208e4 / 0.27e2 * t76 * t1857;
  t1885 = t161 * t1884;
  t1891 = t743 * t312;
  t1892 = params->A1 * t1891;
  t1893 = t750 * t549;
  t1894 = 0.1e1 / t141;
  t1898 = t549 * t312;
  t1903 = 0.1e1 / t749 / t146;
  t1904 = params->A1 * t1903;
  t1912 = t1861 * t148 / 0.576e3 + t1873 * t174 + t923 * t770 / 0.55296e5 + 0.5e1 / 0.42467328e8 * t1877 * t1878 * t573 + t323 * t1885 / 0.165888e6 - 0.77e3 / 0.243e3 * t1867 - t171 * t347 * t1872 + t1892 * t1893 * t1894 / 0.147456e6 + t751 * t1898 * t739 / 0.73728e5 - t1904 * t1519 * t1891 * t745 / 0.2654208e7 - t316 * t319 * t1860 / 0.13824e5;
  t1913 = params->A2 * t1878;
  t1914 = 0.1e1 / t155;
  t1920 = 0.1e1 / t160 / t159 / t158;
  t1921 = t1920 * t1539;
  t1930 = t762 * t333;
  t1931 = t326 * params->beta2;
  t1935 = t323 * t774;
  t1936 = t573 * t326;
  t1937 = t1936 * t769;
  t1940 = t789 * t342;
  t1941 = params->A3 * t1940;
  t1944 = t594 * t342;
  t1948 = t740 * t318;
  t1952 = 0.1e1 / t143 / t141;
  t1956 = t345 * t345;
  t1957 = 0.1e1 / t1956;
  t1958 = t1957 * t1596;
  t1962 = -0.5e1 / 0.5308416e7 * t1913 * t334 * t1914 - 0.5e1 / 0.1528823808e10 * t762 * t1921 * t1878 - t331 * t334 * t1884 / 0.3981312e7 - 0.6e1 * t787 * t348 - 0.7e1 / 0.2654208e7 * t1930 * t1931 * t769 + 0.5e1 / 0.63700992e8 * t1935 * t1937 + 0.6e1 * t1941 * t795 + 0.6e1 * t1230 * t1944 * t786 - t1948 * t911 / 0.3072e4 + t1892 * t319 * t1952 / 0.18432e5 - 0.6e1 * t171 * t1958 * t1940;
  t1963 = t1912 + t1962;
  t1968 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1837 * t176 + 0.3e1 / 0.1e2 * t1782 + 0.9e1 / 0.2e2 * t7 * t716 * t350 - t1715 / 0.1e2 + 0.3e1 / 0.5e1 * t1789 + 0.9e1 / 0.2e2 * t7 * t292 * t801 + t1639 - t1726 / 0.1e2 + 0.3e1 / 0.1e2 * t1797 + 0.3e1 / 0.2e2 * t7 * t118 * t1963);
  tv3rho33 = 0.3e1 * t705 + 0.3e1 * t806 + t8 * (t1824 + t1968);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1976 = t7 * t506 * t386;
  t1983 = t7 * t515 * t386 / 0.3e2;
  t1985 = t7 * t194 * t876;
  t1987 = sigma[0] * t529;
  t1988 = t50 * t1987;
  t1995 = t205 * t214;
  t2001 = t55 * t536;
  t2005 = t1585 * t50;
  t2006 = t573 * t556;
  t2014 = t98 * t1597;
  t2023 = params->beta1 * t1574;
  t2024 = t2023 * t540;
  t2028 = t1519 * t47;
  t2029 = t1518 * t2028;
  t2048 = -0.19e2 / 0.1119744e7 * t373 * t1988 - 0.4e1 / 0.9e1 * t868 * t38 * t199 * t244 - t830 * t821 * t1995 / 0.10368e5 - 0.19e2 / 0.3888e4 * t366 * t1988 + t830 * t821 * t2001 / 0.110592e6 + 0.5e1 / 0.21233664e8 * t2005 * t362 * t2006 + t868 * t38 * t43 * t585 / 0.12e2 - t2014 * t38 * t43 * t588 / 0.4e1 - 0.5e1 / 0.8957952e7 * t851 * t50 * t817 * t228 + t822 * t823 * t2024 / 0.9216e4 - t2029 * t821 * t55 * t540 * t542 / 0.1327104e7 - 0.5e1 / 0.2654208e7 * t557 * t842 * t821 * t844 * t1532 - 0.7e1 / 0.3981312e7 * t843 * t821 * t844 * t567 + 0.5e1 / 0.95551488e8 * t851 * t50 * t362 * t567;
  t2049 = t560 * t1540;
  t2054 = t205 * t220;
  t2058 = t824 * t536;
  t2062 = t55 * t547;
  t2063 = t549 * t1508;
  t2064 = t2063 * t540;
  t2068 = t205 * params->beta2;
  t2073 = params->A2 * t567;
  t2074 = t2073 * t87;
  t2077 = t199 * t248;
  t2081 = params->beta3 * t585;
  t2082 = t863 * t2081;
  t2086 = t594 * t588;
  t2087 = t43 * t593 * t2086;
  t2094 = t37 * t523;
  t2098 = t2094 * t101;
  t2106 = -0.5e1 / 0.764411904e9 * t2049 * t50 * t362 * t556 + t822 * t2054 * t825 / 0.432e3 - t822 * t823 * t2058 / 0.4608e4 + t822 * t2062 * t2064 / 0.73728e5 + 0.7e1 / 0.373248e6 * t843 * t821 * t2068 * t228 + t2074 * t367 / 0.82944e5 + 0.4e1 / 0.9e1 * t862 * t2077 * t864 - t862 * t2082 / 0.12e2 + t862 * t2087 / 0.4e1 - t839 * t835 / 0.7776e4 + 0.19e2 / 0.46656e5 * t370 * t1988 - 0.11e2 / 0.27e2 * t381 * t382 * t2094 + 0.11e2 / 0.27e2 * t376 * t2098 + 0.19e2 / 0.162e3 * t361 * t1987 * t73 + 0.55e2 / 0.81e2 * t38 * t523;
  t2107 = t2048 + t2106;
  t2112 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t386 + t1976 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t876 - t1983 + t1985 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2107);
  tv3rho2sigma0 = t8 * t2112 + 0.2e1 * t881;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2119 = t7 * t623 * t415;
  t2123 = t7 * t627 * t415 / 0.3e2;
  t2125 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t415 + t2119 / 0.5e1 - t2123);
  tv3rho2sigma2 = t8 * t2125 + 0.2e1 * t890;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2131 = t7 * t648 * t386;
  t2139 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t386 + t2131 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t876 + t1976 / 0.1e2 - t1983 + t1985 / 0.1e2);
  tv3rho2sigma3 = t8 * t2139 + t881 + t896;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2145 = t7 * t672 * t415;
  t2152 = t7 * t268 * t960;
  t2155 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t415 + t2145 / 0.1e2 + t2119 / 0.1e2 - t2123 + 0.3e1 / 0.2e2 * t7 * t264 * t960 + t2152 / 0.1e2);
  tv3rho2sigma5 = t8 * t2155 + t890 + t965;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2163 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t386 + t2131 / 0.5e1 - t1983);
  tv3rho2sigma6 = t8 * t2163 + 0.2e1 * t896;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2174 = t759 * t927;
  t2187 = t762 * t1921;
  t2192 = params->beta1 * t1952;
  t2193 = t2192 * t743;
  t2197 = t303 * params->beta2;
  t2206 = t303 * t318;
  t2210 = t910 * t739;
  t2214 = t131 * t750;
  t2215 = t549 * t1894;
  t2216 = t2215 * t743;
  t2220 = t1904 * t2028;
  t2226 = t37 * t726;
  t2230 = t297 * t346;
  t2234 = params->beta3 * t786;
  t2235 = t947 * t2234;
  t2238 = -0.5e1 / 0.2654208e7 * t2174 * t907 * t929 * t1914 - 0.7e1 / 0.3981312e7 * t928 * t907 * t929 * t769 + 0.5e1 / 0.95551488e8 * t936 * t50 * t393 * t769 - 0.5e1 / 0.764411904e9 * t2187 * t50 * t393 * t758 + t908 * t909 * t2193 / 0.9216e4 + 0.7e1 / 0.373248e6 * t928 * t907 * t2197 * t326 - 0.5e1 / 0.8957952e7 * t936 * t50 * t903 * t326 + t908 * t2206 * t911 / 0.432e3 - t908 * t909 * t2210 / 0.4608e4 + t908 * t2214 * t2216 / 0.73728e5 - t2220 * t907 * t131 * t743 * t745 / 0.1327104e7 - 0.11e2 / 0.27e2 * t411 * t382 * t2226 + 0.4e1 / 0.9e1 * t862 * t2230 * t948 - t862 * t2235 / 0.12e2;
  t2239 = params->A2 * t769;
  t2240 = t2239 * t161;
  t2244 = t594 * t789;
  t2245 = t123 * t794 * t2244;
  t2250 = sigma[2] * t732;
  t2251 = t50 * t2250;
  t2254 = t2226 * t174;
  t2260 = t171 * t1958;
  t2265 = t303 * t312;
  t2277 = t131 * t739;
  t2281 = t1877 * t50;
  t2282 = t573 * t758;
  t2292 = t2240 * t398 / 0.82944e5 + t862 * t2245 / 0.4e1 - t924 * t920 / 0.7776e4 + 0.19e2 / 0.46656e5 * t401 * t2251 + 0.11e2 / 0.27e2 * t376 * t2254 + 0.19e2 / 0.162e3 * t361 * t2250 * t148 - t2260 * t38 * t123 * t789 / 0.4e1 - t915 * t907 * t2265 / 0.10368e5 - 0.19e2 / 0.3888e4 * t397 * t2251 - 0.4e1 / 0.9e1 * t952 * t38 * t297 * t342 - 0.19e2 / 0.1119744e7 * t404 * t2251 + t915 * t907 * t2277 / 0.110592e6 + 0.5e1 / 0.21233664e8 * t2281 * t393 * t2282 + t952 * t38 * t123 * t786 / 0.12e2 + 0.55e2 / 0.81e2 * t38 * t726;
  t2293 = t2238 + t2292;
  t2298 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t415 + t2145 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t960 - t2123 + t2152 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * t2293);
  tv3rho2sigma8 = t8 * t2298 + 0.2e1 * t965;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t2305 = t7 * t506 * t450;
  t2312 = t7 * t515 * t450 / 0.3e2;
  t2314 = t7 * t194 * t1031;
  t2317 = t999 * t1532;
  t2321 = t999 * t567;
  t2329 = t1540 * params->b;
  t2330 = t560 * t2329;
  t2335 = t210 * t220;
  t2336 = t2335 * t825;
  t2339 = t979 * t2058;
  t2342 = t63 * t547;
  t2343 = t2342 * t2064;
  t2346 = t1519 * params->a;
  t2347 = t2346 * t47;
  t2348 = t1518 * t2347;
  t2350 = t63 * t540 * t542;
  t2354 = t210 * params->beta2;
  t2355 = t2354 * t228;
  t2363 = t979 * t2024;
  t2374 = t422 * t55;
  t2378 = -0.5e1 / 0.2654208e7 * t557 * t997 * t422 * t2317 - 0.7e1 / 0.3981312e7 * t998 * t422 * t2321 + 0.5e1 / 0.95551488e8 * t1009 * t50 * t433 * t567 - 0.5e1 / 0.764411904e9 * t2330 * t50 * t433 * t556 + 0.5e1 / 0.3456e4 * t978 * t2336 - t978 * t2339 / 0.4608e4 + t978 * t2343 / 0.73728e5 - t2348 * t422 * t2350 / 0.1327104e7 + 0.35e2 / 0.2985984e7 * t998 * t422 * t2355 - 0.25e2 / 0.71663616e8 * t1009 * t50 * t1004 * t228 + t978 * t2363 / 0.9216e4 - t2014 * t90 * t442 * t588 / 0.4e1 - 0.5e1 / 0.18e2 * t868 * t90 * t377 * t244 - 0.65e2 / 0.8957952e7 * t373 * t76 * t2374;
  t2386 = t1585 * t76;
  t2387 = t63 * t573;
  t2406 = t90 * t858;
  t2409 = t93 * t593;
  t2420 = lapl[0] * t55;
  t2421 = t50 * t2420;
  t2424 = t2073 * t431;
  t2427 = -0.5e1 / 0.82944e5 * t984 * t50 * t1004 * t214 - 0.65e2 / 0.31104e5 * t366 * t58 * t2374 + 0.5e1 / 0.21233664e8 * t2386 * t422 * t2387 * t556 + t868 * t90 * t442 * t585 / 0.12e2 + t984 * t50 * t433 * t536 / 0.110592e6 + 0.65e2 / 0.1296e4 * t421 * t422 * t55 * t73 + 0.5e1 / 0.27e2 * t441 * t859 - 0.5e1 / 0.27e2 * t446 * t2406 + t1019 * t2409 * t2086 / 0.4e1 + 0.5e1 / 0.18e2 * t1019 * t865 - t1019 * t1020 * t2081 / 0.12e2 - 0.5e1 / 0.62208e5 * t993 * t1005 + 0.65e2 / 0.373248e6 * t432 * t2421 + t2424 * t434 / 0.82944e5;
  t2428 = t2378 + t2427;
  t2433 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t450 + t2305 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t1031 - t2312 + t2314 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2428);
  tv3rho2lapl0 = t8 * t2433 + 0.2e1 * t1036;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2440 = t7 * t623 * t481;
  t2444 = t7 * t627 * t481 / 0.3e2;
  t2446 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t481 + t2440 / 0.5e1 - t2444);
  tv3rho2lapl1 = t8 * t2446 + 0.2e1 * t1045;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2452 = t7 * t648 * t450;
  t2460 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t450 + t2452 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t1031 + t2305 / 0.1e2 - t2312 + t2314 / 0.1e2);
  tv3rho2lapl2 = t8 * t2460 + t1036 + t1051;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2466 = t7 * t672 * t481;
  t2473 = t7 * t268 * t1112;
  t2476 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t481 + t2466 / 0.1e2 + t2440 / 0.1e2 - t2444 + 0.3e1 / 0.2e2 * t7 * t264 * t1112 + t2473 / 0.1e2);
  tv3rho2lapl3 = t8 * t2476 + t1045 + t1117;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2484 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t450 + t2452 / 0.5e1 - t2312);
  tv3rho2lapl4 = t8 * t2484 + 0.2e1 * t1051;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2500 = t762 * t1921 * params->b;
  t2505 = t1062 * t2210;
  t2508 = t138 * t750;
  t2509 = t2508 * t2216;
  t2512 = t1904 * t2347;
  t2514 = t138 * t743 * t745;
  t2518 = t759 * t1079;
  t2519 = t1081 * t1914;
  t2523 = t1081 * t769;
  t2527 = t308 * t318;
  t2528 = t2527 * t911;
  t2531 = t1062 * t2193;
  t2534 = t308 * params->beta2;
  t2535 = t2534 * t326;
  t2543 = t1877 * t76;
  t2544 = t138 * t573;
  t2550 = t90 * t473 * t786;
  t2557 = 0.5e1 / 0.95551488e8 * t1091 * t50 * t466 * t769 - 0.5e1 / 0.764411904e9 * t2500 * t50 * t466 * t758 - t1061 * t2505 / 0.4608e4 + t1061 * t2509 / 0.73728e5 - t2512 * t455 * t2514 / 0.1327104e7 - 0.5e1 / 0.2654208e7 * t2518 * t455 * t2519 - 0.7e1 / 0.3981312e7 * t1080 * t455 * t2523 + 0.5e1 / 0.3456e4 * t1061 * t2528 + t1061 * t2531 / 0.9216e4 + 0.35e2 / 0.2985984e7 * t1080 * t455 * t2535 - 0.25e2 / 0.71663616e8 * t1091 * t50 * t1086 * t326 + 0.5e1 / 0.21233664e8 * t2543 * t455 * t2544 * t758 + t952 * t2550 / 0.12e2 + t1066 * t50 * t466 * t739 / 0.110592e6;
  t2562 = t455 * t131;
  t2583 = t90 * t943;
  t2588 = lapl[1] * t131;
  t2589 = t50 * t2588;
  t2601 = t2239 * t464;
  t2604 = -t2260 * t90 * t473 * t789 / 0.4e1 - 0.65e2 / 0.8957952e7 * t404 * t76 * t2562 - 0.5e1 / 0.18e2 * t952 * t90 * t407 * t342 - 0.5e1 / 0.82944e5 * t1066 * t50 * t1086 * t312 - 0.65e2 / 0.31104e5 * t397 * t58 * t2562 + 0.65e2 / 0.1296e4 * t421 * t455 * t131 * t148 + 0.5e1 / 0.27e2 * t441 * t944 - 0.5e1 / 0.27e2 * t477 * t2583 - 0.5e1 / 0.62208e5 * t1075 * t1087 + 0.65e2 / 0.373248e6 * t465 * t2589 + t1019 * t166 * t794 * t2244 / 0.4e1 + 0.5e1 / 0.18e2 * t1019 * t949 - t1019 * t1101 * t2234 / 0.12e2 + t2601 * t467 / 0.82944e5;
  t2605 = t2557 + t2604;
  t2610 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t481 + t2466 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t1112 - t2444 + t2473 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * t2605);
  tv3rho2lapl5 = t8 * t2610 + 0.2e1 * t1117;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2617 = t7 * t194 * t1180 / 0.1e2;
  t2618 = t49 * t205;
  t2619 = t1176 * t2618;
  t2622 = t1129 * t61;
  t2624 = 0.1e1 / t41 / t2622;
  t2625 = t51 * t2624;
  t2626 = t1138 * t2625;
  t2632 = t1585 * t1138;
  t2646 = t55 * t593;
  t2647 = t2646 * t1566;
  t2650 = t360 * t1119;
  t2651 = t542 * t214;
  t2655 = t1519 * t33;
  t2656 = t1518 * t2655;
  t2657 = t1132 * t542;
  t2658 = t2657 * t214;
  t2662 = t1148 * t1127;
  t2663 = t1132 * t235;
  t2664 = params->beta2 * t1532;
  t2665 = t2664 * t228;
  t2666 = t2663 * t2665;
  t2669 = t2624 * params->beta2;
  t2673 = -t1175 * t2619 / 0.54e2 - t1137 * t2626 / 0.864e3 + t1143 * t1144 * t2618 / 0.1296e4 + 0.5e1 / 0.1769472e7 * t2632 * t1139 * t1558 - 0.7e1 / 0.3981312e7 * t843 * t1119 * t1579 + t1164 * t1165 * t2618 / 0.373248e6 + 0.5e1 / 0.95551488e8 * t851 * t50 * t55 * t228 + t1170 * t2647 / 0.96e2 - t2650 * t221 * t2651 / 0.4608e4 - t2656 * t1127 * t2658 / 0.110592e6 - 0.5e1 / 0.221184e6 * t2662 * t2666 + 0.7e1 / 0.31104e5 * t1154 * t1127 * t2669;
  t2684 = t2624 * t220;
  t2688 = t2023 * t214;
  t2692 = t1132 * t547;
  t2693 = t2063 * t214;
  t2712 = t50 * t205;
  t2715 = -0.5e1 / 0.746496e6 * t851 * t2626 - 0.5e1 / 0.63700992e8 * t2049 * t1138 * t1139 * t228 - t2014 * t50 * t55 * t244 / 0.96e2 + t1128 * t2684 * t824 / 0.36e2 + t1128 * t1133 * t2688 / 0.768e3 + t1128 * t2692 * t2693 / 0.6144e4 - t360 * t2618 * t73 / 0.54e2 + t839 * t1159 / 0.82944e5 + t1170 * t205 * t248 * params->beta3 / 0.54e2 + t1137 * t50 * t831 / 0.110592e6 - t1149 * t2625 * t87 / 0.648e3 - t370 * t2712 / 0.15552e5;
  t2716 = t2673 + t2715;
  t2721 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t1180 + t2617 + 0.3e1 / 0.2e2 * t7 * t32 * t2716);
  tv3rhosigma20 = t8 * t2721 + t1184;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2728 = t7 * t268 * t1234 / 0.1e2;
  t2730 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t1234 + t2728);
  tv3rhosigma25 = t8 * t2730 + t1238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t1180 + t2617);
  tv3rhosigma26 = t8 * t2736 + t1184;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2741 = t49 * t303;
  t2747 = t50 * t303;
  t2757 = t1191 * t136;
  t2759 = 0.1e1 / t121 / t2757;
  t2760 = t127 * t2759;
  t2767 = t1138 * t2760;
  t2773 = t1877 * t1138;
  t2783 = -t360 * t2741 * t148 / 0.54e2 + t924 * t1217 / 0.82944e5 - t401 * t2747 / 0.15552e5 + t1170 * t303 * t346 * params->beta3 / 0.54e2 + t1199 * t50 * t916 / 0.110592e6 - t1149 * t2760 * t161 / 0.648e3 - t1230 * t1176 * t2741 / 0.54e2 - t1199 * t2767 / 0.864e3 + t1204 * t1144 * t2741 / 0.1296e4 + 0.5e1 / 0.1769472e7 * t2773 * t1200 * t1936 - 0.7e1 / 0.3981312e7 * t928 * t1185 * t1931 + t1222 * t1165 * t2741 / 0.373248e6;
  t2788 = t131 * t794;
  t2789 = t2788 * t1944;
  t2792 = t360 * t1185;
  t2793 = t745 * t312;
  t2794 = t319 * t2793;
  t2797 = t1904 * t2655;
  t2798 = t1194 * t745;
  t2799 = t2798 * t312;
  t2803 = t1148 * t1189;
  t2804 = t1194 * t333;
  t2805 = params->beta2 * t1914;
  t2806 = t2805 * t326;
  t2807 = t2804 * t2806;
  t2810 = t2759 * params->beta2;
  t2824 = t2759 * t318;
  t2828 = t2192 * t312;
  t2832 = t1194 * t750;
  t2833 = t2215 * t312;
  t2837 = 0.5e1 / 0.95551488e8 * t936 * t50 * t131 * t326 + t1170 * t2789 / 0.96e2 - t2792 * t2794 / 0.4608e4 - t2797 * t1189 * t2799 / 0.110592e6 - 0.5e1 / 0.221184e6 * t2803 * t2807 + 0.7e1 / 0.31104e5 * t1212 * t1189 * t2810 - 0.5e1 / 0.746496e6 * t936 * t2767 - 0.5e1 / 0.63700992e8 * t2187 * t1138 * t1200 * t326 - t2260 * t50 * t131 * t342 / 0.96e2 + t1190 * t2824 * t910 / 0.36e2 + t1190 * t1195 * t2828 / 0.768e3 + t1190 * t2832 * t2833 / 0.6144e4;
  t2838 = t2783 + t2837;
  t2843 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t1234 + t2728 + 0.3e1 / 0.2e2 * t7 * t118 * t2838);
  tv3rhosigma211 = t8 * t2843 + t1238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2850 = t7 * t194 * t1279 / 0.1e2;
  t2851 = t1129 * rho[0];
  t2853 = 0.1e1 / t41 / t2851;
  t2854 = t2853 * t220;
  t2855 = t2854 * t1244;
  t2858 = t1242 * t547;
  t2859 = t2858 * t549;
  t2860 = t1508 * sigma[0];
  t2861 = t2860 * t214;
  t2865 = t1243 * params->beta1;
  t2866 = t1574 * sigma[0];
  t2867 = t2866 * t214;
  t2871 = t2346 * t33;
  t2872 = t1518 * t2871;
  t2873 = t1262 * t1242;
  t2874 = sigma[0] * t542;
  t2875 = t2874 * t214;
  t2879 = lapl[0] * t2853;
  t2881 = t1138 * t2879 * sigma[0];
  t2885 = t2853 * t87 * t1256;
  t2888 = t1253 * t1242;
  t2889 = t1148 * t2888;
  t2890 = t996 * lapl[0];
  t2891 = t2890 * t2665;
  t2894 = params->b * t33;
  t2895 = t2894 * t1126;
  t2896 = t1585 * t2895;
  t2897 = t573 * sigma[0];
  t2898 = t2897 * t228;
  t2903 = t2853 * params->beta2 * sigma[0];
  t2907 = t1242 * sigma[0];
  t2908 = t2907 * t228;
  t2914 = t1119 * t249;
  t2917 = t440 * t50;
  t2918 = t210 * t593;
  t2919 = t2918 * t1566;
  t2922 = t1271 * t244;
  t2929 = 0.13e2 / 0.576e3 * t1240 * t2855 + t1240 * t2859 * t2861 / 0.6144e4 + t1240 * t2865 * t2867 / 0.768e3 - t2872 * t2873 * t2875 / 0.110592e6 - 0.13e2 / 0.13824e5 * t984 * t2881 - 0.13e2 / 0.10368e5 * t1254 * t2885 - 0.5e1 / 0.221184e6 * t2889 * t2891 + 0.5e1 / 0.1769472e7 * t2896 * t1248 * t2898 + 0.91e2 / 0.497664e6 * t1261 * t1262 * t2903 - 0.5e1 / 0.63700992e8 * t2330 * t1239 * t2908 - 0.65e2 / 0.11943936e8 * t1009 * t2881 + 0.13e2 / 0.864e3 * t1270 * t2914 + t2917 * t2919 / 0.96e2 - t2014 * t1275 * t2922 / 0.96e2 - 0.13e2 / 0.864e3 * t868 * t1275 * t1119;
  t2934 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t1279 + t2850 + 0.3e1 / 0.2e2 * t7 * t32 * t2929);
  tv3rhosigmalapl0 = t8 * t2934 + t1283;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2941 = t7 * t268 * t1322 / 0.1e2;
  t2943 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t1322 + t2941);
  tv3rhosigmalapl5 = t8 * t2943 + t1326;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2949 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t1279 + t2850);
  tv3rhosigmalapl6 = t8 * t2949 + t1283;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2954 = t1191 * rho[1];
  t2956 = 0.1e1 / t121 / t2954;
  t2957 = t2956 * t318;
  t2958 = t2957 * t1289;
  t2961 = t1287 * t750;
  t2962 = t2961 * t549;
  t2963 = t1894 * sigma[2];
  t2964 = t2963 * t312;
  t2968 = t1288 * params->beta1;
  t2969 = t1952 * sigma[2];
  t2970 = t2969 * t312;
  t2974 = t1904 * t2871;
  t2975 = t1307 * t1287;
  t2976 = sigma[2] * t745;
  t2977 = t2976 * t312;
  t2981 = lapl[1] * t2956;
  t2983 = t1138 * t2981 * sigma[2];
  t2987 = t2956 * t161 * t1301;
  t2990 = t1298 * t1287;
  t2991 = t1148 * t2990;
  t2992 = t1078 * lapl[1];
  t2993 = t2992 * t2806;
  t2996 = t1877 * t2895;
  t2997 = t573 * sigma[2];
  t2998 = t2997 * t326;
  t3003 = t2956 * params->beta2 * sigma[2];
  t3007 = t1287 * sigma[2];
  t3008 = t3007 * t326;
  t3014 = t1185 * t347;
  t3017 = t308 * t794;
  t3018 = t3017 * t1944;
  t3021 = t1315 * t342;
  t3028 = 0.13e2 / 0.576e3 * t1285 * t2958 + t1285 * t2962 * t2964 / 0.6144e4 + t1285 * t2968 * t2970 / 0.768e3 - t2974 * t2975 * t2977 / 0.110592e6 - 0.13e2 / 0.13824e5 * t1066 * t2983 - 0.13e2 / 0.10368e5 * t1299 * t2987 - 0.5e1 / 0.221184e6 * t2991 * t2993 + 0.5e1 / 0.1769472e7 * t2996 * t1293 * t2998 + 0.91e2 / 0.497664e6 * t1306 * t1307 * t3003 - 0.5e1 / 0.63700992e8 * t2500 * t1284 * t3008 - 0.65e2 / 0.11943936e8 * t1091 * t2983 + 0.13e2 / 0.864e3 * t1270 * t3014 + t2917 * t3018 / 0.96e2 - t2260 * t1275 * t3021 / 0.96e2 - 0.13e2 / 0.864e3 * t952 * t1275 * t1185;
  t3033 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t1322 + t2941 + 0.3e1 / 0.2e2 * t7 * t118 * t3028);
  tv3rhosigmalapl11 = t8 * t3033 + t1326;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t3040 = t7 * t194 * t1382 / 0.1e2;
  t3041 = t1519 * t1331;
  t3042 = t3041 * t33;
  t3043 = t1518 * t3042;
  t3044 = t1335 * t542;
  t3045 = t3044 * t214;
  t3049 = t1138 * t59;
  t3050 = t1349 * t3049;
  t3051 = t1335 * t235;
  t3052 = t3051 * t2665;
  t3056 = 0.1e1 / t41 / t527;
  t3057 = t59 * t3056;
  t3066 = t1540 * t1348;
  t3067 = t560 * t3066;
  t3079 = t1332 * t3049;
  t3080 = t1335 * t220;
  t3084 = t1335 * t547;
  t3093 = t76 * t1271;
  t3096 = -t3043 * t1351 * t3045 / 0.110592e6 - 0.5e1 / 0.221184e6 * t3050 * t3052 + 0.35e2 / 0.248832e6 * t1357 * t1138 * t3057 * params->beta2 - 0.25e2 / 0.5971968e7 * t851 * t1365 * t1351 * t3056 - 0.5e1 / 0.63700992e8 * t3067 * t1138 * t1336 * t228 - t2014 * t1378 * t1327 * t244 / 0.96e2 + 0.5e1 / 0.288e3 * t1333 * t3057 * t543 + t3079 * t3080 * t2688 / 0.768e3 + t3079 * t3084 * t2693 / 0.6144e4 - 0.5e1 / 0.432e3 * t421 * t1271 * t73 + t839 * t1362 / 0.82944e5 - 0.5e1 / 0.124416e6 * t370 * t3093;
  t3103 = t3056 * t87;
  t3113 = t1373 * t50;
  t3114 = t63 * t593;
  t3121 = t420 * t50;
  t3130 = t1585 * t1365;
  t3131 = t1335 * t573;
  t3132 = t3131 * t228;
  t3136 = t560 * t996;
  t3140 = 0.5e1 / 0.432e3 * t1374 * t1272 + t984 * t50 * t63 * t214 / 0.110592e6 - 0.5e1 / 0.5184e4 * t1350 * t1351 * t3103 + 0.5e1 / 0.2985984e7 * t373 * t3093 + 0.5e1 / 0.95551488e8 * t851 * t76 * t1327 * t228 + t3113 * t3114 * t1566 / 0.96e2 - 0.5e1 / 0.432e3 * t868 * t1378 * t1271 - t3121 * t980 / 0.4608e4 - 0.5e1 / 0.6912e4 * t1341 * t1138 * t3057 + 0.5e1 / 0.10368e5 * t366 * t58 * t1271 + 0.5e1 / 0.1769472e7 * t3130 * t1351 * t3132 - 0.7e1 / 0.3981312e7 * t3136 * t50 * t1000;
  t3141 = t3096 + t3140;
  t3146 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t1382 + t3040 + 0.3e1 / 0.2e2 * t7 * t32 * t3141);
  tv3rholapl20 = t8 * t3146 + t1386;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t3153 = t7 * t268 * t1430 / 0.1e2;
  t3155 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t1430 + t3153);
  tv3rholapl22 = t8 * t3155 + t1434;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t3161 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t1382 + t3040);
  tv3rholapl23 = t8 * t3161 + t1386;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t3166 = t1138 * t134;
  t3167 = t1349 * t3166;
  t3168 = t1392 * t333;
  t3169 = t3168 * t2806;
  t3173 = 0.1e1 / t121 / t730;
  t3174 = t134 * t3173;
  t3183 = t1921 * t1348;
  t3184 = t762 * t3183;
  t3196 = t1332 * t3166;
  t3197 = t1392 * t318;
  t3201 = t1392 * t750;
  t3205 = t1904 * t3042;
  t3206 = t1392 * t745;
  t3207 = t3206 * t312;
  t3218 = -0.5e1 / 0.221184e6 * t3167 * t3169 + 0.35e2 / 0.248832e6 * t1410 * t1138 * t3174 * params->beta2 - 0.25e2 / 0.5971968e7 * t936 * t1365 * t1404 * t3173 - 0.5e1 / 0.63700992e8 * t3184 * t1138 * t1393 * t326 - t2260 * t1378 * t1387 * t342 / 0.96e2 + 0.5e1 / 0.288e3 * t1333 * t3174 * t746 + t3196 * t3197 * t2828 / 0.768e3 + t3196 * t3201 * t2833 / 0.6144e4 - t3205 * t1404 * t3207 / 0.110592e6 - 0.5e1 / 0.432e3 * t421 * t1315 * t148 + t924 * t1415 / 0.82944e5 + 0.5e1 / 0.432e3 * t1374 * t1316;
  t3223 = t3173 * t161;
  t3227 = t76 * t1315;
  t3236 = t138 * t794;
  t3251 = t1877 * t1365;
  t3252 = t1392 * t573;
  t3253 = t3252 * t326;
  t3257 = t762 * t1078;
  t3261 = t1066 * t50 * t138 * t312 / 0.110592e6 - 0.5e1 / 0.5184e4 * t1350 * t1404 * t3223 - 0.5e1 / 0.124416e6 * t401 * t3227 + 0.5e1 / 0.2985984e7 * t404 * t3227 + 0.5e1 / 0.95551488e8 * t936 * t76 * t1387 * t326 + t3113 * t3236 * t1944 / 0.96e2 - 0.5e1 / 0.432e3 * t952 * t1378 * t1315 - t3121 * t1063 / 0.4608e4 - 0.5e1 / 0.6912e4 * t1397 * t1138 * t3174 + 0.5e1 / 0.10368e5 * t397 * t58 * t1315 + 0.5e1 / 0.1769472e7 * t3251 * t1404 * t3253 - 0.7e1 / 0.3981312e7 * t3257 * t50 * t1082;
  t3262 = t3218 + t3261;
  t3267 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t1430 + t3153 + 0.3e1 / 0.2e2 * t7 * t118 * t3262);
  tv3rholapl25 = t8 * t3267 + t1434;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3269 = t1126 * t1132;
  t3270 = t1123 * t3269;
  t3271 = t221 * t2874;
  t3274 = t1124 * t1124;
  t3275 = 0.1e1 / t3274;
  t3276 = params->A1 * t3275;
  t3277 = t51 * sigma[0];
  t3278 = t3276 * t3277;
  t3279 = t1129 * t1129;
  t3280 = 0.1e1 / t3279;
  t3289 = t1518 * t1519;
  t3290 = t3275 * t3277;
  t3291 = t3280 * t542;
  t3295 = sigma[0] * t1132;
  t3296 = t1138 * t3295;
  t3302 = params->A2 * t3275;
  t3303 = t3302 * t3277;
  t3305 = t3280 * t235 * t2664;
  t3308 = t1585 * t3275;
  t3309 = t3277 * t3280;
  t3316 = t560 * t1538;
  t3317 = t1539 * t3275;
  t3323 = 0.1e1 / t1124;
  t3324 = params->A3 * t3323;
  t3325 = 0.1e1 / t1129;
  t3327 = t3325 * t593 * t594;
  t3330 = t98 * t1595;
  t3331 = t1596 * t3323;
  t3335 = -t3270 * t3271 / 0.128e3 + t3278 * t3280 * t547 * t2063 / 0.512e3 + t3278 * t3280 * t220 * t2023 / 0.64e2 - t3289 * t3290 * t3291 / 0.9216e4 + t1137 * t3296 / 0.3072e4 + t1149 * t3295 * t87 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3303 * t3305 + 0.5e1 / 0.147456e6 * t3308 * t3309 * t573 - 0.7e1 / 0.110592e6 * t1154 * t1253 * t1155 - 0.5e1 / 0.5308416e7 * t3316 * t3317 * t3309 + 0.5e1 / 0.2654208e7 * t851 * t3296 + t3324 * t3327 / 0.384e3 - t3330 * t3331 * t3325 / 0.384e3;
  t3339 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3335);
  tv3sigma30 = t8 * t3339;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3340 = t1126 * t1194;
  t3341 = t1123 * t3340;
  t3342 = t319 * t2976;
  t3345 = t127 * sigma[2];
  t3346 = t3276 * t3345;
  t3347 = t1191 * t1191;
  t3348 = 0.1e1 / t3347;
  t3357 = t1904 * t1519;
  t3358 = t3275 * t3345;
  t3359 = t3348 * t745;
  t3363 = sigma[2] * t1194;
  t3364 = t1138 * t3363;
  t3370 = t3302 * t3345;
  t3372 = t3348 * t333 * t2805;
  t3375 = t1877 * t3275;
  t3376 = t3345 * t3348;
  t3383 = t762 * t1920;
  t3389 = 0.1e1 / t1191;
  t3391 = t3389 * t794 * t594;
  t3394 = t171 * t1957;
  t3398 = -t3341 * t3342 / 0.128e3 + t3346 * t3348 * t750 * t2215 / 0.512e3 + t3346 * t3348 * t318 * t2192 / 0.64e2 - t3357 * t3358 * t3359 / 0.9216e4 + t1199 * t3364 / 0.3072e4 + t1149 * t3363 * t161 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3370 * t3372 + 0.5e1 / 0.147456e6 * t3375 * t3376 * t573 - 0.7e1 / 0.110592e6 * t1212 * t1298 * t1213 - 0.5e1 / 0.5308416e7 * t3383 * t3317 * t3376 + 0.5e1 / 0.2654208e7 * t936 * t3364 + t3324 * t3391 / 0.384e3 - t3394 * t3331 * t3389 / 0.384e3;
  t3402 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3398);
  tv3sigma39 = t8 * t3402;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3403 = t3275 * lapl[0];
  t3404 = t420 * t3403;
  t3406 = 0.1e1 / t1129 / t203;
  t3407 = t3406 * t547;
  t3408 = t2063 * t51;
  t3412 = t3406 * t220;
  t3413 = t2023 * t51;
  t3417 = t420 * t1138;
  t3421 = t1518 * t2346;
  t3422 = t3406 * t51;
  t3432 = t3302 * t3422;
  t3435 = t996 * lapl[0] * params->beta2 * t1532;
  t3438 = params->b * t3275;
  t3439 = t1585 * t3438;
  t3440 = lapl[0] * t3406;
  t3441 = t573 * t51;
  t3456 = t440 * t3323;
  t3457 = 0.1e1 / t527;
  t3459 = t3457 * t593 * t594;
  t3462 = t1596 * params->c;
  t3463 = t3323 * t3457;
  t3467 = t3404 * t3407 * t3408 / 0.512e3 + t3404 * t3412 * t3413 / 0.64e2 - t3417 * t1248 * t543 / 0.384e3 - t3421 * t3403 * t3422 * t542 / 0.9216e4 + t984 * t1138 * t1248 / 0.9216e4 + t1149 * t1257 / 0.6912e4 - 0.5e1 / 0.18432e5 * t3432 * t3435 + 0.5e1 / 0.147456e6 * t3439 * t3440 * t3441 - 0.7e1 / 0.331776e6 * t3136 * t1138 * t1248 * params->beta2 - 0.5e1 / 0.5308416e7 * t2049 * t3438 * t3440 * t51 + 0.5e1 / 0.7962624e7 * t851 * t2894 * t2873 + t3456 * t3459 / 0.384e3 - t3330 * t3462 * t3463 / 0.384e3;
  t3471 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3467);
  tv3sigma2lapl0 = t8 * t3471;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3472 = t3275 * lapl[1];
  t3473 = t420 * t3472;
  t3475 = 0.1e1 / t1191 / t301;
  t3476 = t3475 * t750;
  t3477 = t2215 * t127;
  t3481 = t3475 * t318;
  t3482 = t2192 * t127;
  t3489 = t1904 * t2346;
  t3490 = t3475 * t127;
  t3500 = t3302 * t3490;
  t3503 = t1078 * lapl[1] * params->beta2 * t1914;
  t3506 = t1877 * t3438;
  t3507 = lapl[1] * t3475;
  t3508 = t573 * t127;
  t3523 = 0.1e1 / t730;
  t3525 = t3523 * t794 * t594;
  t3528 = t3323 * t3523;
  t3532 = t3473 * t3476 * t3477 / 0.512e3 + t3473 * t3481 * t3482 / 0.64e2 - t3417 * t1293 * t746 / 0.384e3 - t3489 * t3472 * t3490 * t745 / 0.9216e4 + t1066 * t1138 * t1293 / 0.9216e4 + t1149 * t1302 / 0.6912e4 - 0.5e1 / 0.18432e5 * t3500 * t3503 + 0.5e1 / 0.147456e6 * t3506 * t3507 * t3508 - 0.7e1 / 0.331776e6 * t3257 * t1138 * t1293 * params->beta2 - 0.5e1 / 0.5308416e7 * t2187 * t3438 * t3507 * t127 + 0.5e1 / 0.7962624e7 * t936 * t2894 * t2975 + t3456 * t3525 / 0.384e3 - t3394 * t3462 * t3528 / 0.384e3;
  t3536 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3532);
  tv3sigma2lapl11 = t8 * t3536;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3539 = t3275 * t59;
  t3540 = t1332 * t3539;
  t3541 = t1129 * t52;
  t3542 = 0.1e1 / t3541;
  t3543 = t3542 * t547;
  t3544 = t2063 * sigma[0];
  t3548 = t3542 * t220;
  t3549 = t2023 * sigma[0];
  t3553 = t1518 * t3041;
  t3554 = t3542 * t542;
  t3555 = t3554 * sigma[0];
  t3562 = t1349 * t3539;
  t3563 = t3542 * t235;
  t3564 = t2664 * sigma[0];
  t3565 = t3563 * t3564;
  t3568 = t1348 * t3275;
  t3569 = t1585 * t3568;
  t3570 = t59 * t3542;
  t3587 = t1373 * t3323;
  t3588 = 0.1e1 / t203;
  t3590 = t3588 * t593 * t594;
  t3593 = t1596 * t1372;
  t3594 = t3323 * t3588;
  t3598 = -t3417 * t1245 / 0.384e3 + t3540 * t3543 * t3544 / 0.512e3 + t3540 * t3548 * t3549 / 0.64e2 - t3553 * t3539 * t3555 / 0.9216e4 + t984 * t1138 * t2907 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3562 * t3565 + 0.5e1 / 0.147456e6 * t3569 * t3570 * t2897 + t1149 * t2907 * t431 / 0.6912e4 - 0.7e1 / 0.331776e6 * t3136 * t1138 * t1264 - 0.5e1 / 0.5308416e7 * t2049 * t3568 * t3570 * sigma[0] + 0.5e1 / 0.7962624e7 * t851 * t2894 * t2888 + t3587 * t3590 / 0.384e3 - t3330 * t3593 * t3594 / 0.384e3;
  t3602 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3598);
  tv3sigmalapl20 = t8 * t3602;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3605 = t3275 * t134;
  t3606 = t1332 * t3605;
  t3607 = t1191 * t128;
  t3608 = 0.1e1 / t3607;
  t3609 = t3608 * t750;
  t3610 = t2215 * sigma[2];
  t3614 = t3608 * t318;
  t3615 = t2192 * sigma[2];
  t3619 = t1904 * t3041;
  t3620 = t3608 * t745;
  t3621 = t3620 * sigma[2];
  t3628 = t1349 * t3605;
  t3629 = t3608 * t333;
  t3630 = t2805 * sigma[2];
  t3631 = t3629 * t3630;
  t3634 = t1877 * t3568;
  t3635 = t134 * t3608;
  t3652 = 0.1e1 / t301;
  t3654 = t3652 * t794 * t594;
  t3657 = t3323 * t3652;
  t3661 = -t3417 * t1290 / 0.384e3 + t3606 * t3609 * t3610 / 0.512e3 + t3606 * t3614 * t3615 / 0.64e2 - t3619 * t3605 * t3621 / 0.9216e4 + t1066 * t1138 * t3007 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3628 * t3631 + 0.5e1 / 0.147456e6 * t3634 * t3635 * t2997 + t1149 * t3007 * t464 / 0.6912e4 - 0.7e1 / 0.331776e6 * t3257 * t1138 * t1309 - 0.5e1 / 0.5308416e7 * t2187 * t3568 * t3635 * sigma[2] + 0.5e1 / 0.7962624e7 * t936 * t2894 * t2990 + t3587 * t3654 / 0.384e3 - t3394 * t3593 * t3657 / 0.384e3;
  t3665 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3661);
  tv3sigmalapl28 = t8 * t3665;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3666 = t824 * lapl[0];
  t3670 = t1331 * params->a;
  t3671 = params->A1 * t3670;
  t3672 = t59 * lapl[0];
  t3673 = t3275 * t3672;
  t3674 = t3671 * t3673;
  t3675 = 0.1e1 / t1130;
  t3676 = t3675 * t547;
  t3680 = t3675 * t220;
  t3684 = t1519 * t3670;
  t3685 = t1518 * t3684;
  t3686 = t3675 * t542;
  t3690 = lapl[0] * t1335;
  t3697 = t1348 * params->b;
  t3698 = params->A2 * t3697;
  t3699 = t3698 * t3673;
  t3700 = t3675 * t235;
  t3701 = t3700 * t2664;
  t3704 = t1585 * t3697;
  t3705 = t3675 * t573;
  t3713 = t3697 * t3275;
  t3714 = t3672 * t3675;
  t3722 = t1372 * params->c;
  t3723 = params->A3 * t3722;
  t3724 = t3723 * t3323;
  t3725 = 0.1e1 / t53;
  t3730 = t1596 * t3722;
  t3735 = -t1333 * t3080 * t3666 / 0.128e3 + t3674 * t3676 * t2063 / 0.512e3 + t3674 * t3680 * t2023 / 0.64e2 - t3685 * t3673 * t3686 / 0.9216e4 + t1341 * t1138 * t3690 / 0.3072e4 + t1350 * t1262 * t1352 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3699 * t3701 + 0.5e1 / 0.147456e6 * t3704 * t3673 * t3705 - 0.7e1 / 0.110592e6 * t1357 * t1138 * t3690 * params->beta2 - 0.5e1 / 0.5308416e7 * t2049 * t3713 * t3714 + 0.5e1 / 0.2654208e7 * t851 * t1365 * t1262 * t1335 + t3724 * t3725 * t593 * t594 / 0.384e3 - t3330 * t3730 * t3323 * t3725 / 0.384e3;
  t3739 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3735);
  tv3lapl30 = t8 * t3739;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3740 = t910 * lapl[1];
  t3744 = t134 * lapl[1];
  t3745 = t3275 * t3744;
  t3746 = t3671 * t3745;
  t3747 = 0.1e1 / t1192;
  t3748 = t3747 * t750;
  t3752 = t3747 * t318;
  t3756 = t1904 * t3684;
  t3757 = t3747 * t745;
  t3761 = lapl[1] * t1392;
  t3768 = t3698 * t3745;
  t3769 = t3747 * t333;
  t3770 = t3769 * t2805;
  t3773 = t1877 * t3697;
  t3774 = t3747 * t573;
  t3782 = t3744 * t3747;
  t3790 = 0.1e1 / t129;
  t3799 = -t1333 * t3197 * t3740 / 0.128e3 + t3746 * t3748 * t2215 / 0.512e3 + t3746 * t3752 * t2192 / 0.64e2 - t3756 * t3745 * t3757 / 0.9216e4 + t1397 * t1138 * t3761 / 0.3072e4 + t1350 * t1307 * t1405 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3768 * t3770 + 0.5e1 / 0.147456e6 * t3773 * t3745 * t3774 - 0.7e1 / 0.110592e6 * t1410 * t1138 * t3761 * params->beta2 - 0.5e1 / 0.5308416e7 * t2187 * t3713 * t3782 + 0.5e1 / 0.2654208e7 * t936 * t1365 * t1307 * t1392 + t3724 * t3790 * t794 * t594 / 0.384e3 - t3394 * t3730 * t3323 * t3790 / 0.384e3;
  t3803 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3799);
  tv3lapl33 = t8 * t3803;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t45, t47, t49, t50, t51, t52;
  double t53, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t71, t72, t73, t76, t78;
  double t79, t81, t84, t85, t86, t87, t90, t91;
  double t93, t97, t98, t100, t101, t103, t107, t108;
  double t109, t111, t112, t113, t114, t115, t117, t118;
  double t119, t120, t121, t123, t125, t127, t128, t129;
  double t131, t133, t134, t135, t136, t138, t139, t141;
  double t143, t146, t147, t148, t152, t153, t155, t158;
  double t159, t160, t161, t164, t166, t170, t171, t173;
  double t174, t176, t180, tzk0;

  double t181, t182, t183, t185, t188, t189, t193, t194;
  double t197, t199, t201, t203, t205, t208, t210, t211;
  double t214, t218, t220, t221, t225, t228, t232, t233;
  double t235, t236, t244, t245, t247, t248, t249, t250;
  double t252, t257, t258, t260, t263, t264, t268, t271;
  double t273, tvrho0, t277, t280, t281, t286, t288, t291;
  double t292, t297, t299, t301, t303, t306, t308, t309;
  double t312, t316, t318, t319, t323, t326, t330, t331;
  double t333, t334, t342, t343, t345, t346, t347, t348;
  double t350, t355, tvrho1, t360, t361, t362, t366, t367;
  double t370, t373, t376, t377, t378, t381, t382, t386;
  double t390, tvsigma0, tvsigma1, t393, t397, t398, t401, t404;
  double t407, t408, t411, t415, t419, tvsigma2, t420, t421;
  double t422, t427, t431, t432, t433, t434, t440, t441;
  double t442, t446, t447, t450, t454, tvlapl0, t455, t460;
  double t464, t465, t466, t467, t473, t477, t478, t481;
  double t485, tvlapl1, tvtau0, tvtau1;

  double t488, t489, t492, t493, t494, t497, t501, t502;
  double t506, t508, t514, t515, t518, t520, t523, t525;
  double t527, t529, t532, t533, t536, t537, t540, t541;
  double t542, t543, t546, t547, t548, t549, t556, t557;
  double t560, t567, t568, t572, t573, t574, t585, t586;
  double t588, t589, t593, t594, t595, t596, t601, t606;
  double t607, t608, t611, t614, t618, t619, t623, t625;
  double t627, t630, t632, tv2rho20, t635, t639, t643, t644;
  double t648, t650, t658, t659, t663, t667, t668, t672;
  double t674, t681, t684, tv2rho21, t689, t694, t698, t699;
  double t705, t706, t711, t715, t716, t726, t728, t730;
  double t732, t735, t736, t739, t740, t743, t744, t745;
  double t746, t749, t750, t751, t758, t759, t762, t769;
  double t770, t774, t775, t786, t787, t789, t790, t794;
  double t795, t796, t801, t806, tv2rho22, t814, t817, t821;
  double t822, t823, t824, t825, t826, t829, t830, t831;
  double t835, t838, t839, t842, t843, t844, t845, t851;
  double t858, t859, t862, t863, t864, t865, t868, t869;
  double t876, t881, tv2rhosigma0, tv2rhosigma1, t888, t890, tv2rhosigma2, t896;
  double tv2rhosigma3, tv2rhosigma4, t903, t907, t908, t909, t910, t911;
  double t915, t916, t920, t923, t924, t927, t928, t929;
  double t930, t936, t943, t944, t947, t948, t949, t952;
  double t953, t960, t965, tv2rhosigma5, t972, t977, t978, t979;
  double t980, t983, t984, t989, t993, t996, t997, t998;
  double t999, t1000, t1004, t1005, t1009, t1019, t1020, t1031;
  double t1036, tv2rholapl0, t1043, t1045, tv2rholapl1, t1051, tv2rholapl2, t1060;
  double t1061, t1062, t1063, t1066, t1071, t1075, t1078, t1079;
  double t1080, t1081, t1082, t1086, t1087, t1091, t1101, t1112;
  double t1117, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t1119, t1120;
  double t1123, t1124, t1126, t1127, t1128, t1129, t1130, t1132;
  double t1133, t1134, t1137, t1138, t1139, t1140, t1143, t1144;
  double t1148, t1149, t1154, t1155, t1159, t1164, t1165, t1170;
  double t1175, t1176, t1180, t1184, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23;
  double tv2sigma24, t1185, t1186, t1189, t1190, t1191, t1192, t1194;
  double t1195, t1196, t1199, t1200, t1201, t1204, t1212, t1213;
  double t1217, t1222, t1230, t1234, t1238, tv2sigma25, t1239, t1240;
  double t1242, t1243, t1244, t1245, t1248, t1250, t1253, t1254;
  double t1255, t1256, t1257, t1261, t1262, t1263, t1264, t1270;
  double t1271, t1272, t1275, t1279, t1283, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1284, t1285, t1287, t1288, t1289, t1290;
  double t1293, t1295, t1298, t1299, t1300, t1301, t1302, t1306;
  double t1307, t1308, t1309, t1315, t1316, t1322, t1326, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1327, t1331;
  double t1332, t1333, t1335, t1336, t1340, t1341, t1348, t1349;
  double t1350, t1351, t1352, t1357, t1362, t1365, t1372, t1373;
  double t1374, t1378, t1379, t1382, t1386, tv2lapl20, tv2lapl21, t1387;
  double t1392, t1393, t1397, t1404, t1405, t1410, t1415, t1427;
  double t1430, t1434, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t1438, t1439, t1442, t1445, t1446, t1447, t1450, t1454;
  double t1455, t1459, t1461, t1466, t1468, t1471, t1477, t1478;
  double t1481, t1483, t1486, t1489, t1492, t1493, t1496, t1497;
  double t1501, t1503, t1505, t1506, t1507, t1508, t1512, t1517;
  double t1518, t1519, t1526, t1530, t1531, t1532, t1538, t1539;
  double t1540, t1553, t1556, t1557, t1558, t1559, t1562, t1563;
  double t1566, t1567, t1570, t1574, t1578, t1579, t1585, t1592;
  double t1594, t1595, t1596, t1597, t1601, t1602, t1607, t1609;
  double t1610, t1613, t1616, t1619, t1623, t1624, t1628, t1630;
  double t1632, t1634, t1636, t1639, t1641, tv3rho30, t1644, t1645;
  double t1646, t1649, t1654, t1655, t1657, t1661, t1662, t1666;
  double t1669, t1673, t1675, t1679, t1688, t1689, t1690, t1693;
  double t1698, t1700, t1704, t1705, t1709, t1712, t1713, t1715;
  double t1724, t1726, t1729, tv3rho31, t1732, t1737, t1741, t1745;
  double t1746, t1750, t1752, t1761, t1762, t1767, t1771, t1775;
  double t1776, t1780, t1782, t1789, t1797, t1799, t1800, tv3rho32;
  double t1805, t1812, t1816, t1817, t1824, t1825, t1832, t1836;
  double t1837, t1853, t1856, t1857, t1860, t1861, t1865, t1867;
  double t1872, t1873, t1877, t1878, t1884, t1885, t1891, t1892;
  double t1893, t1894, t1898, t1903, t1904, t1912, t1913, t1914;
  double t1920, t1921, t1930, t1931, t1935, t1936, t1937, t1940;
  double t1941, t1944, t1948, t1952, t1956, t1957, t1958, t1962;
  double t1963, t1968, tv3rho33, t1976, t1983, t1985, t1987, t1988;
  double t1995, t2001, t2005, t2006, t2014, t2023, t2024, t2028;
  double t2029, t2048, t2049, t2054, t2058, t2062, t2063, t2064;
  double t2068, t2073, t2074, t2077, t2081, t2082, t2086, t2087;
  double t2094, t2098, t2106, t2107, t2112, tv3rho2sigma0, tv3rho2sigma1, t2119;
  double t2123, t2125, tv3rho2sigma2, t2131, t2139, tv3rho2sigma3, tv3rho2sigma4, t2145;
  double t2152, t2155, tv3rho2sigma5, t2163, tv3rho2sigma6, tv3rho2sigma7, t2174, t2187;
  double t2192, t2193, t2197, t2206, t2210, t2214, t2215, t2216;
  double t2220, t2226, t2230, t2234, t2235, t2238, t2239, t2240;
  double t2244, t2245, t2250, t2251, t2254, t2260, t2265, t2277;
  double t2281, t2282, t2292, t2293, t2298, tv3rho2sigma8, t2305, t2312;
  double t2314, t2317, t2321, t2329, t2330, t2335, t2336, t2339;
  double t2342, t2343, t2346, t2347, t2348, t2350, t2354, t2355;
  double t2363, t2374, t2378, t2386, t2387, t2406, t2409, t2420;
  double t2421, t2424, t2427, t2428, t2433, tv3rho2lapl0, t2440, t2444;
  double t2446, tv3rho2lapl1, t2452, t2460, tv3rho2lapl2, t2466, t2473, t2476;
  double tv3rho2lapl3, t2484, tv3rho2lapl4, t2500, t2505, t2508, t2509, t2512;
  double t2514, t2518, t2519, t2523, t2527, t2528, t2531, t2534;
  double t2535, t2543, t2544, t2550, t2557, t2562, t2583, t2588;
  double t2589, t2601, t2604, t2605, t2610, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1;
  double tv3rho2tau2, tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2617, t2618, t2619, t2622;
  double t2624, t2625, t2626, t2632, t2646, t2647, t2650, t2651;
  double t2655, t2656, t2657, t2658, t2662, t2663, t2664, t2665;
  double t2666, t2669, t2673, t2684, t2688, t2692, t2693, t2712;
  double t2715, t2716, t2721, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2728, t2730, tv3rhosigma25, t2736, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2741, t2747, t2757, t2759, t2760, t2767, t2773;
  double t2783, t2788, t2789, t2792, t2793, t2794, t2797, t2798;
  double t2799, t2803, t2804, t2805, t2806, t2807, t2810, t2824;
  double t2828, t2832, t2833, t2837, t2838, t2843, tv3rhosigma211, t2850;
  double t2851, t2853, t2854, t2855, t2858, t2859, t2860, t2861;
  double t2865, t2866, t2867, t2871, t2872, t2873, t2874, t2875;
  double t2879, t2881, t2885, t2888, t2889, t2890, t2891, t2894;
  double t2895, t2896, t2897, t2898, t2903, t2907, t2908, t2914;
  double t2917, t2918, t2919, t2922, t2929, t2934, tv3rhosigmalapl0, tv3rhosigmalapl1;
  double tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2941, t2943, tv3rhosigmalapl5, t2949, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2954, t2956, t2957, t2958;
  double t2961, t2962, t2963, t2964, t2968, t2969, t2970, t2974;
  double t2975, t2976, t2977, t2981, t2983, t2987, t2990, t2991;
  double t2992, t2993, t2996, t2997, t2998, t3003, t3007, t3008;
  double t3014, t3017, t3018, t3021, t3028, t3033, tv3rhosigmalapl11, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t3040, t3041, t3042, t3043, t3044;
  double t3045, t3049, t3050, t3051, t3052, t3056, t3057, t3066;
  double t3067, t3079, t3080, t3084, t3093, t3096, t3103, t3113;
  double t3114, t3121, t3130, t3131, t3132, t3136, t3140, t3141;
  double t3146, tv3rholapl20, tv3rholapl21, t3153, t3155, tv3rholapl22, t3161, tv3rholapl23;
  double tv3rholapl24, t3166, t3167, t3168, t3169, t3173, t3174, t3183;
  double t3184, t3196, t3197, t3201, t3205, t3206, t3207, t3218;
  double t3223, t3227, t3236, t3251, t3252, t3253, t3257, t3261;
  double t3262, t3267, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24;
  double tv3rhotau25, t3269, t3270, t3271, t3274, t3275, t3276, t3277;
  double t3278, t3279, t3280, t3289, t3290, t3291, t3295, t3296;
  double t3302, t3303, t3305, t3308, t3309, t3316, t3317, t3323;
  double t3324, t3325, t3327, t3330, t3331, t3335, t3339, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t3340, t3341, t3342, t3345, t3346, t3347, t3348, t3357;
  double t3358, t3359, t3363, t3364, t3370, t3372, t3375, t3376;
  double t3383, t3389, t3391, t3394, t3398, t3402, tv3sigma39, t3403;
  double t3404, t3406, t3407, t3408, t3412, t3413, t3417, t3421;
  double t3422, t3432, t3435, t3438, t3439, t3440, t3441, t3456;
  double t3457, t3459, t3462, t3463, t3467, t3471, tv3sigma2lapl0, tv3sigma2lapl1;
  double tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9;
  double tv3sigma2lapl10, t3472, t3473, t3475, t3476, t3477, t3481, t3482;
  double t3489, t3490, t3500, t3503, t3506, t3507, t3508, t3523;
  double t3525, t3528, t3532, t3536, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2;
  double tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10;
  double tv3sigma2tau11, t3539, t3540, t3541, t3542, t3543, t3544, t3548;
  double t3549, t3553, t3554, t3555, t3562, t3563, t3564, t3565;
  double t3568, t3569, t3570, t3587, t3588, t3590, t3593, t3594;
  double t3598, t3602, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25;
  double tv3sigmalapl26, tv3sigmalapl27, t3605, t3606, t3607, t3608, t3609, t3610;
  double t3614, t3615, t3619, t3620, t3621, t3628, t3629, t3630;
  double t3631, t3634, t3635, t3652, t3654, t3657, t3661, t3665;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t3666, t3670;
  double t3671, t3672, t3673, t3674, t3675, t3676, t3680, t3684;
  double t3685, t3686, t3690, t3697, t3698, t3699, t3700, t3701;
  double t3704, t3705, t3713, t3714, t3722, t3723, t3724, t3725;
  double t3730, t3735, t3739, tv3lapl30, tv3lapl31, tv3lapl32, t3740, t3744;
  double t3745, t3746, t3747, t3748, t3752, t3756, t3757, t3761;
  double t3768, t3769, t3770, t3773, t3774, t3782, t3790, t3799;
  double t3803, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5;
  double tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31;
  double tv3tau32, tv3tau33;

  double t3810, t3816, t3819, t3825, t3828, t3831, t3833, t3840;
  double t3841, t3842, t3843, t3846, t3850, t3851, t3852, t3853;
  double t3854, t3862, t3863, t3867, t3872, t3875, t3876, t3884;
  double t3885, t3894, t3895, t3898, t3902, t3906, t3910, t3911;
  double t3916, t3922, t3929, t3939, t3941, t3942, t3947, t3950;
  double t3969, t3976, t3982, t3989, t3990, t3991, t4003, t4008;
  double t4010, t4011, t4017, t4023, t4024, t4027, t4031, t4038;
  double t4042, t4046, t4049, t4053, t4054, t4055, t4056, t4058;
  double t4059, t4065, t4070, t4073, t4077, t4084, t4088, t4092;
  double t4097, t4099, tv4rho40, t4120, t4121, t4123, t4127, t4136;
  double t4142, t4143, t4145, t4158, t4162, t4163, t4166, t4171;
  double t4172, t4189, t4191, t4195, t4202, t4206, t4207, t4210;
  double t4219, t4222, t4223, t4225, t4227, t4228, tv4rho41, t4237;
  double t4241, t4251, t4264, t4268, t4277, t4293, t4294, t4303;
  double t4316, t4320, t4327, t4331, t4340, t4343, t4354, t4357;
  double t4359, t4360, tv4rho42, t4381, t4385, t4392, t4403, t4404;
  double t4421, t4425, t4432, t4440, t4449, t4459, t4461, t4462;
  double tv4rho43, t4467, t4472, t4479, t4483, t4492, t4497, t4498;
  double t4499, t4503, t4504, t4505, t4506, t4511, t4512, t4513;
  double t4515, t4516, t4519, t4520, t4528, t4533, t4541, t4545;
  double t4554, t4560, t4565, t4568, t4569, t4576, t4577, t4580;
  double t4584, t4585, t4590, t4594, t4610, t4612, t4630, t4638;
  double t4639, t4647, t4654, t4662, t4667, t4672, t4679, t4683;
  double t4703, t4704, tv4rho44, t4712, t4718, t4721, t4728, t4730;
  double t4733, t4736, t4737, t4738, t4748, t4752, t4754, t4760;
  double t4765, t4769, t4785, t4798, t4799, t4811, t4829, t4836;
  double t4847, t4850, t4885, t4886, t4890, t4900, t4919, t4928;
  double t4930, t4946, t4947, t4964, t4971, tv4rho3sigma0, tv4rho3sigma1, t4978;
  double t4981, t4985, t4987, tv4rho3sigma2, t4989, t4995, t5000, t5004;
  double t5013, t5014, tv4rho3sigma3, tv4rho3sigma4, t5016, t5022, t5024, t5033;
  double t5035, t5038, tv4rho3sigma5, t5044, t5053, tv4rho3sigma6, tv4rho3sigma7, t5059;
  double t5066, t5074, t5076, t5077, tv4rho3sigma8, t5086, tv4rho3sigma9, tv4rho3sigma10;
  double t5103, t5107, t5148, t5152, t5155, t5162, t5163, t5183;
  double t5197, t5198, t5216, t5243, t5248, t5249, t5272, t5277;
  double t5279, t5289, t5291, t5295, t5296, t5311, t5315, t5331;
  double t5338, tv4rho3sigma11, t5345, t5351, t5354, t5361, t5363, t5366;
  double t5409, t5439, t5440, t5442, t5458, t5460, t5512, t5527;
  double t5537, t5538, t5559, t5570, t5575, t5582, tv4rho3lapl0, t5589;
  double t5592, t5596, t5598, tv4rho3lapl1, t5600, t5606, t5611, t5615;
  double t5624, t5625, tv4rho3lapl2, t5627, t5633, t5635, t5644, t5646;
  double t5649, tv4rho3lapl3, t5655, t5664, tv4rho3lapl4, t5670, t5677, t5685;
  double t5687, t5688, tv4rho3lapl5, t5697, tv4rho3lapl6, t5737, t5740, t5744;
  double t5763, t5806, t5859, t5902, t5920, t5927, tv4rho3lapl7, tv4rho3tau0;
  double tv4rho3tau1, tv4rho3tau2, tv4rho3tau3, tv4rho3tau4, tv4rho3tau5, tv4rho3tau6, tv4rho3tau7, t5934;
  double t5941, t5943, t5945, t5956, t5957, t5981, t5992, t5993;
  double t5997, t6003, t6009, t6022, t6023, t6031, t6035, t6053;
  double t6081, t6092, t6107, t6116, t6136, t6154, t6161, tv4rho2sigma20;
  double tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t6168, t6172, t6174, tv4rho2sigma25;
  double t6180, t6188, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t6194;
  double t6201, t6204, tv4rho2sigma211, t6212, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215;
  double tv4rho2sigma216, t6233, t6234, t6240, t6241, t6260, t6264, t6272;
  double t6283, t6284, t6305, t6327, t6352, t6377, t6394, t6421;
  double t6428, t6435, tv4rho2sigma217, t6442, t6449, t6451, t6479, t6484;
  double t6489, t6494, t6506, t6512, t6523, t6545, t6568, t6589;
  double t6595, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, t6602, t6606;
  double t6608, tv4rho2sigmalapl5, t6614, t6622, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9;
  double tv4rho2sigmalapl10, t6628, t6635, t6638, tv4rho2sigmalapl11, t6646, tv4rho2sigmalapl12, tv4rho2sigmalapl13;
  double tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, t6671, t6714, t6715, t6729, t6770;
  double t6775, t6780, t6791, t6797, tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2;
  double tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5, tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10;
  double tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t6804;
  double t6811, t6813, t6841, t6856, t6881, t6882, t6884, t6905;
  double t6911, t6920, t6932, t6933, t6960, t7001, t7008, tv4rho2lapl20;
  double tv4rho2lapl21, t7015, t7019, t7021, tv4rho2lapl22, t7027, t7035, tv4rho2lapl23;
  double tv4rho2lapl24, t7041, t7048, t7051, tv4rho2lapl25, t7059, tv4rho2lapl26, tv4rho2lapl27;
  double t7081, t7113, t7118, t7120, t7147, t7159, t7200, t7207;
  double t7253, t7260, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4;
  double tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20;
  double tv4rho2tau21, tv4rho2tau22, tv4rho2tau23, tv4rho2tau24, tv4rho2tau25, tv4rho2tau26, tv4rho2tau27, tv4rho2tau28;
  double t7267, t7277, t7280, t7283, t7291, t7292, t7299, t7300;
  double t7305, t7323, t7331, t7332, t7343, t7356, t7366, t7384;
  double t7390, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36;
  double tv4rhosigma37, tv4rhosigma38, t7397, t7399, tv4rhosigma39, t7405, tv4rhosigma310, tv4rhosigma311;
  double tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t7414;
  double t7417, t7428, t7436, t7441, t7460, t7461, t7464, t7474;
  double t7475, t7489, t7506, t7524, t7530, tv4rhosigma319, t7537, t7546;
  double t7547, t7548, t7556, t7575, t7581, t7596, t7603, t7604;
  double t7605, t7615, t7623, t7629, t7634, t7642, t7648, t7659;
  double t7671, t7677, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5;
  double tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, t7684, t7686, tv4rhosigma2lapl11;
  double t7692, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18;
  double tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, t7701, t7702, t7703, t7714;
  double t7738, t7751, t7757, t7758, t7770, t7775, t7792, t7793;
  double t7803, t7811, t7818, t7828, t7834, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1;
  double tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9;
  double tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17;
  double tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, t7841, t7842;
  double t7843, t7844, t7848, t7896, t7897, t7898, t7905, t7906;
  double t7918, t7929, t7934, t7958, t7964, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22;
  double tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, t7971, t7973, tv4rhosigmalapl28;
  double t7979, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215;
  double tv4rhosigmalapl216, t7984, t7985, t8001, t8034, t8035, t8041, t8043;
  double t8054, t8059, t8074, t8098, t8104, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1;
  double tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9;
  double tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17;
  double tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20, tv4rhosigmatau21;
  double tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28, tv4rhosigmatau29;
  double tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217;
  double t8111, t8119, t8127, t8160, t8166, t8171, t8176, t8197;
  double t8198, t8213, t8234, t8240, tv4rholapl30, tv4rholapl31, tv4rholapl32, t8247;
  double t8249, tv4rholapl33, t8255, tv4rholapl34, tv4rholapl35, tv4rholapl36, t8272, t8307;
  double t8320, t8352, t8353, t8358, t8379, t8385, tv4rholapl37, tv4rholapl2tau0;
  double tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8;
  double tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24;
  double tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, tv4rhotau30;
  double tv4rhotau31, tv4rhotau32, tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36, tv4rhotau37, t8390;
  double t8395, t8401, t8404, t8405, t8406, t8409, t8414, t8419;
  double t8423, t8427, t8429, t8430, t8434, t8435, t8443, t8453;
  double t8458, t8470, t8473, t8474, t8477, t8483, t8488, tv4sigma40;
  double tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48;
  double tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t8499, t8504, t8507;
  double t8508, t8511, t8520, t8523, t8524, t8525, t8528, t8533;
  double t8537, t8539, t8540, t8544, t8545, t8552, t8558, t8563;
  double t8582, t8587, tv4sigma414, t8609, t8613, t8614, t8616, t8635;
  double t8654, t8664, t8668, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4;
  double tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12;
  double tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, t8689, t8690;
  double t8692, t8712, t8723, t8744, t8748, tv4sigma3lapl19, tv4sigma3tau0, tv4sigma3tau1;
  double tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9;
  double tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17;
  double tv4sigma3tau18, tv4sigma3tau19, t8778, t8779, t8791, t8799, t8802, t8803;
  double t8805, t8809, t8829, t8830, t8842, t8852, t8857, tv4sigma2lapl20;
  double tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28;
  double tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216;
  double t8867, t8868, t8899, t8910, t8911, t8913, t8936, t8937;
  double t8949, t8959, t8964, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3;
  double tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11;
  double tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19;
  double tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23;
  double tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211;
  double tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, t8966, t8976;
  double t8977, t8978, t8979, t8989, t8991, t9002, t9016, t9020;
  double t9038, t9042, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35;
  double tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, t9044, t9054, t9055;
  double t9056, t9057, t9068, t9079, t9093, t9114, t9118, tv4sigmalapl311;
  double tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7;
  double tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15;
  double tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25;
  double tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213;
  double tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33;
  double tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311;
  double t9122, t9123, t9129, t9138, t9139, t9150, t9151, t9153;
  double t9154, t9156, t9165, t9182, t9183, t9184, t9189, t9196;
  double t9197, t9198, t9206, t9215, t9220, tv4lapl40, tv4lapl41, tv4lapl42;
  double tv4lapl43, t9226, t9235, t9254, t9255, t9257, t9283, t9284;
  double t9295, t9305, t9310, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3;
  double tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23;
  double tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32;
  double tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37, tv4tau40, tv4tau41, tv4tau42;
  double tv4tau43, tv4tau44;

  mgga_k_rda_params *params;

  assert(p->params != NULL);
  params = (mgga_k_rda_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t47 = t33 * t33;
  t49 = 0.1e1 / t35 / t34;
  t50 = t47 * t49;
  t51 = sigma[0] * sigma[0];
  t52 = t39 * t39;
  t53 = t52 * rho[0];
  t55 = 0.1e1 / t40 / t53;
  t57 = t50 * t51 * t55;
  t58 = params->a * t47;
  t59 = lapl[0] * lapl[0];
  t60 = t49 * t59;
  t61 = t39 * rho[0];
  t63 = 0.1e1 / t40 / t61;
  t64 = t60 * t63;
  t66 = t58 * t64 + t57;
  t68 = sqrt(t66);
  t71 = 0.1e1 + params->beta1 * t68 / 0.24e2;
  t72 = t71 * t71;
  t73 = 0.1e1 / t72;
  t76 = params->b * t47;
  t78 = t76 * t64 + t57;
  t79 = t78 * t78;
  t81 = sqrt(t78);
  t84 = 0.1e1 + params->beta2 * t81 / 0.24e2;
  t85 = t84 * t84;
  t86 = t85 * t85;
  t87 = 0.1e1 / t86;
  t90 = params->c * t33;
  t91 = t37 * lapl[0];
  t93 = 0.1e1 / t41 / rho[0];
  t97 = t90 * t91 * t93 / 0.24e2 + t45 / 0.24e2;
  t98 = params->A3 * t97;
  t100 = params->beta3 * t97 + 0.1e1;
  t101 = 0.1e1 / t100;
  t103 = 0.5e1 / 0.72e2 * t45 + params->A0 + params->A1 * t66 * t73 / 0.576e3 + params->A2 * t79 * t87 / 0.331776e6 + t98 * t101;
  t107 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t103);
  t108 = rho[1] <= p->dens_threshold;
  t109 = -t18;
  t111 = my_piecewise5(t16, t13, t12, t17, t109 * t9);
  t112 = 0.1e1 + t111;
  t113 = t112 <= p->zeta_threshold;
  t114 = POW_1_3(t112);
  t115 = t114 * t114;
  t117 = my_piecewise3(t113, t25, t115 * t112);
  t118 = t117 * t31;
  t119 = rho[1] * rho[1];
  t120 = POW_1_3(rho[1]);
  t121 = t120 * t120;
  t123 = 0.1e1 / t121 / t119;
  t125 = t38 * sigma[2] * t123;
  t127 = sigma[2] * sigma[2];
  t128 = t119 * t119;
  t129 = t128 * rho[1];
  t131 = 0.1e1 / t120 / t129;
  t133 = t50 * t127 * t131;
  t134 = lapl[1] * lapl[1];
  t135 = t49 * t134;
  t136 = t119 * rho[1];
  t138 = 0.1e1 / t120 / t136;
  t139 = t135 * t138;
  t141 = t58 * t139 + t133;
  t143 = sqrt(t141);
  t146 = 0.1e1 + params->beta1 * t143 / 0.24e2;
  t147 = t146 * t146;
  t148 = 0.1e1 / t147;
  t152 = t76 * t139 + t133;
  t153 = t152 * t152;
  t155 = sqrt(t152);
  t158 = 0.1e1 + params->beta2 * t155 / 0.24e2;
  t159 = t158 * t158;
  t160 = t159 * t159;
  t161 = 0.1e1 / t160;
  t164 = t37 * lapl[1];
  t166 = 0.1e1 / t121 / rho[1];
  t170 = t90 * t164 * t166 / 0.24e2 + t125 / 0.24e2;
  t171 = params->A3 * t170;
  t173 = params->beta3 * t170 + 0.1e1;
  t174 = 0.1e1 / t173;
  t176 = 0.5e1 / 0.72e2 * t125 + params->A0 + params->A1 * t141 * t148 / 0.576e3 + params->A2 * t153 * t161 / 0.331776e6 + t171 * t174;
  t180 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t176);
  tzk0 = t107 + t180;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t181 = t8 * t8;
  t182 = 0.1e1 / t181;
  t183 = t18 * t182;
  t185 = my_piecewise5(t12, 0, t16, 0, t9 - t183);
  t188 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t185);
  t189 = t188 * t31;
  t193 = 0.1e1 / t30;
  t194 = t29 * t193;
  t197 = t7 * t194 * t103 / 0.1e2;
  t199 = 0.1e1 / t41 / t61;
  t201 = t38 * sigma[0] * t199;
  t203 = t52 * t39;
  t205 = 0.1e1 / t40 / t203;
  t208 = 0.16e2 / 0.3e1 * t50 * t51 * t205;
  t210 = 0.1e1 / t40 / t52;
  t211 = t60 * t210;
  t214 = -t208 - 0.1e2 / 0.3e1 * t58 * t211;
  t218 = params->A1 * t68;
  t220 = 0.1e1 / t72 / t71;
  t221 = t220 * params->beta1;
  t225 = params->A2 * t78;
  t228 = -t208 - 0.1e2 / 0.3e1 * t76 * t211;
  t232 = t81 * t78;
  t233 = params->A2 * t232;
  t235 = 0.1e1 / t86 / t84;
  t236 = t235 * params->beta2;
  t244 = -t201 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t91 * t43;
  t245 = params->A3 * t244;
  t247 = t100 * t100;
  t248 = 0.1e1 / t247;
  t249 = t248 * params->beta3;
  t250 = t249 * t244;
  t252 = -0.5e1 / 0.27e2 * t201 + params->A1 * t214 * t73 / 0.576e3 - t218 * t221 * t214 / 0.13824e5 + t225 * t87 * t228 / 0.165888e6 - t233 * t236 * t228 / 0.3981312e7 + t245 * t101 - t98 * t250;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t103 + t197 + 0.3e1 / 0.2e2 * t7 * t32 * t252);
  t258 = t109 * t182;
  t260 = my_piecewise5(t16, 0, t12, 0, -t9 - t258);
  t263 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t260);
  t264 = t263 * t31;
  t268 = t117 * t193;
  t271 = t7 * t268 * t176 / 0.1e2;
  t273 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t176 + t271);
  tvrho0 = t107 + t180 + t8 * (t257 + t273);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t277 = my_piecewise5(t12, 0, t16, 0, -t9 - t183);
  t280 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t277);
  t281 = t280 * t31;
  t286 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t103 + t197);
  t288 = my_piecewise5(t16, 0, t12, 0, t9 - t258);
  t291 = my_piecewise3(t113, 0, 0.5e1 / 0.3e1 * t115 * t288);
  t292 = t291 * t31;
  t297 = 0.1e1 / t121 / t136;
  t299 = t38 * sigma[2] * t297;
  t301 = t128 * t119;
  t303 = 0.1e1 / t120 / t301;
  t306 = 0.16e2 / 0.3e1 * t50 * t127 * t303;
  t308 = 0.1e1 / t120 / t128;
  t309 = t135 * t308;
  t312 = -t306 - 0.1e2 / 0.3e1 * t58 * t309;
  t316 = params->A1 * t143;
  t318 = 0.1e1 / t147 / t146;
  t319 = t318 * params->beta1;
  t323 = params->A2 * t152;
  t326 = -t306 - 0.1e2 / 0.3e1 * t76 * t309;
  t330 = t155 * t152;
  t331 = params->A2 * t330;
  t333 = 0.1e1 / t160 / t158;
  t334 = t333 * params->beta2;
  t342 = -t299 / 0.9e1 - 0.5e1 / 0.72e2 * t90 * t164 * t123;
  t343 = params->A3 * t342;
  t345 = t173 * t173;
  t346 = 0.1e1 / t345;
  t347 = t346 * params->beta3;
  t348 = t347 * t342;
  t350 = -0.5e1 / 0.27e2 * t299 + params->A1 * t312 * t148 / 0.576e3 - t316 * t319 * t312 / 0.13824e5 + t323 * t161 * t326 / 0.165888e6 - t331 * t334 * t326 / 0.3981312e7 + t343 * t174 - t171 * t348;
  t355 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t176 + t271 + 0.3e1 / 0.2e2 * t7 * t118 * t350);
  tvrho1 = t107 + t180 + t8 * (t286 + t355);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t360 = params->A1 * t47;
  t361 = t360 * t49;
  t362 = sigma[0] * t55;
  t366 = t218 * t221;
  t367 = t50 * t362;
  t370 = t225 * t87;
  t373 = t233 * t236;
  t376 = params->A3 * t33;
  t377 = t37 * t43;
  t378 = t377 * t101;
  t381 = t98 * t248;
  t382 = params->beta3 * t33;
  t386 = 0.5e1 / 0.72e2 * t38 * t43 + t361 * t362 * t73 / 0.288e3 - t366 * t367 / 0.6912e4 + t370 * t367 / 0.82944e5 - t373 * t367 / 0.1990656e7 + t376 * t378 / 0.24e2 - t381 * t382 * t377 / 0.24e2;
  t390 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t386);
  tvsigma0 = t8 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t393 = sigma[2] * t131;
  t397 = t316 * t319;
  t398 = t50 * t393;
  t401 = t323 * t161;
  t404 = t331 * t334;
  t407 = t37 * t123;
  t408 = t407 * t174;
  t411 = t171 * t346;
  t415 = 0.5e1 / 0.72e2 * t38 * t123 + t361 * t393 * t148 / 0.288e3 - t397 * t398 / 0.6912e4 + t401 * t398 / 0.82944e5 - t404 * t398 / 0.1990656e7 + t376 * t408 / 0.24e2 - t411 * t382 * t407 / 0.24e2;
  t419 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t415);
  tvsigma2 = t8 * t419;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t420 = params->A1 * params->a;
  t421 = t420 * t47;
  t422 = t49 * lapl[0];
  t427 = t422 * t63;
  t431 = t87 * params->b;
  t432 = t225 * t431;
  t433 = lapl[0] * t63;
  t434 = t50 * t433;
  t440 = params->A3 * params->c;
  t441 = t440 * t33;
  t442 = t37 * t93;
  t446 = t98 * t249;
  t447 = t90 * t442;
  t450 = t421 * t422 * t63 * t73 / 0.288e3 - t366 * t58 * t427 / 0.6912e4 + t432 * t434 / 0.82944e5 - t373 * t76 * t427 / 0.1990656e7 + t441 * t442 * t101 / 0.24e2 - t446 * t447 / 0.24e2;
  t454 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t450);
  tvlapl0 = t8 * t454;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t455 = t49 * lapl[1];
  t460 = t455 * t138;
  t464 = t161 * params->b;
  t465 = t323 * t464;
  t466 = lapl[1] * t138;
  t467 = t50 * t466;
  t473 = t37 * t166;
  t477 = t171 * t347;
  t478 = t90 * t473;
  t481 = t421 * t455 * t138 * t148 / 0.288e3 - t397 * t58 * t460 / 0.6912e4 + t465 * t467 / 0.82944e5 - t404 * t76 * t460 / 0.1990656e7 + t441 * t473 * t174 / 0.24e2 - t477 * t478 / 0.24e2;
  t485 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t481);
  tvlapl1 = t8 * t485;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t488 = 0.1e1 / t26;
  t489 = t185 * t185;
  t492 = t181 * t8;
  t493 = 0.1e1 / t492;
  t494 = t18 * t493;
  t497 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t182 + 0.2e1 * t494);
  t501 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t488 * t489 + 0.5e1 / 0.3e1 * t27 * t497);
  t502 = t501 * t31;
  t506 = t188 * t193;
  t508 = t7 * t506 * t103;
  t514 = 0.1e1 / t30 / t8;
  t515 = t29 * t514;
  t518 = t7 * t515 * t103 / 0.3e2;
  t520 = t7 * t194 * t252;
  t523 = 0.1e1 / t41 / t52;
  t525 = t38 * sigma[0] * t523;
  t527 = t52 * t61;
  t529 = 0.1e1 / t40 / t527;
  t532 = 0.304e3 / 0.9e1 * t50 * t51 * t529;
  t533 = t60 * t55;
  t536 = t532 + 0.13e3 / 0.9e1 * t58 * t533;
  t537 = params->A1 * t536;
  t540 = t214 * t214;
  t541 = params->A1 * t540;
  t542 = 0.1e1 / t68;
  t543 = t221 * t542;
  t546 = t72 * t72;
  t547 = 0.1e1 / t546;
  t548 = params->A1 * t547;
  t549 = params->beta1 * params->beta1;
  t556 = t228 * t228;
  t557 = params->A2 * t556;
  t560 = params->A2 * t81;
  t567 = t532 + 0.13e3 / 0.9e1 * t76 * t533;
  t568 = t87 * t567;
  t572 = 0.1e1 / t86 / t85;
  t573 = params->beta2 * params->beta2;
  t574 = t572 * t573;
  t585 = 0.11e2 / 0.27e2 * t525 + 0.5e1 / 0.27e2 * t90 * t91 * t199;
  t586 = params->A3 * t585;
  t588 = t244 * t244;
  t589 = params->A3 * t588;
  t593 = 0.1e1 / t247 / t100;
  t594 = params->beta3 * params->beta3;
  t595 = t593 * t594;
  t596 = t595 * t588;
  t601 = 0.55e2 / 0.81e2 * t525 + t537 * t73 / 0.576e3 - t541 * t543 / 0.9216e4 + t548 * t549 * t540 / 0.221184e6 - t218 * t221 * t536 / 0.13824e5 + t557 * t87 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t560 * t235 * t556 * params->beta2 + t225 * t568 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t225 * t574 * t556 - t233 * t236 * t567 / 0.3981312e7 + t586 * t101 - 0.2e1 * t589 * t249 + 0.2e1 * t98 * t596 - t98 * t249 * t585;
  t606 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t103 + t508 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t252 - t518 + t520 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t601);
  t607 = 0.1e1 / t114;
  t608 = t260 * t260;
  t611 = t109 * t493;
  t614 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t182 + 0.2e1 * t611);
  t618 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t607 * t608 + 0.5e1 / 0.3e1 * t115 * t614);
  t619 = t618 * t31;
  t623 = t263 * t193;
  t625 = t7 * t623 * t176;
  t627 = t117 * t514;
  t630 = t7 * t627 * t176 / 0.3e2;
  t632 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t176 + t625 / 0.5e1 - t630);
  tv2rho20 = 0.2e1 * t257 + 0.2e1 * t273 + t8 * (t606 + t632);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t635 = t488 * t277;
  t639 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t494);
  t643 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t635 * t185 + 0.5e1 / 0.3e1 * t27 * t639);
  t644 = t643 * t31;
  t648 = t280 * t193;
  t650 = t7 * t648 * t103;
  t658 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t103 + t650 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t252 + t508 / 0.1e2 - t518 + t520 / 0.1e2);
  t659 = t607 * t288;
  t663 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t611);
  t667 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t659 * t260 + 0.5e1 / 0.3e1 * t115 * t663);
  t668 = t667 * t31;
  t672 = t291 * t193;
  t674 = t7 * t672 * t176;
  t681 = t7 * t268 * t350;
  t684 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t176 + t674 / 0.1e2 + t625 / 0.1e2 - t630 + 0.3e1 / 0.2e2 * t7 * t264 * t350 + t681 / 0.1e2);
  tv2rho21 = t257 + t273 + t286 + t355 + t8 * (t658 + t684);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t689 = t277 * t277;
  t694 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t182 + 0.2e1 * t494);
  t698 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t488 * t689 + 0.5e1 / 0.3e1 * t27 * t694);
  t699 = t698 * t31;
  t705 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t103 + t650 / 0.5e1 - t518);
  t706 = t288 * t288;
  t711 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t182 + 0.2e1 * t611);
  t715 = my_piecewise3(t113, 0, 0.1e2 / 0.9e1 * t607 * t706 + 0.5e1 / 0.3e1 * t115 * t711);
  t716 = t715 * t31;
  t726 = 0.1e1 / t121 / t128;
  t728 = t38 * sigma[2] * t726;
  t730 = t128 * t136;
  t732 = 0.1e1 / t120 / t730;
  t735 = 0.304e3 / 0.9e1 * t50 * t127 * t732;
  t736 = t135 * t131;
  t739 = t735 + 0.13e3 / 0.9e1 * t58 * t736;
  t740 = params->A1 * t739;
  t743 = t312 * t312;
  t744 = params->A1 * t743;
  t745 = 0.1e1 / t143;
  t746 = t319 * t745;
  t749 = t147 * t147;
  t750 = 0.1e1 / t749;
  t751 = params->A1 * t750;
  t758 = t326 * t326;
  t759 = params->A2 * t758;
  t762 = params->A2 * t155;
  t769 = t735 + 0.13e3 / 0.9e1 * t76 * t736;
  t770 = t161 * t769;
  t774 = 0.1e1 / t160 / t159;
  t775 = t774 * t573;
  t786 = 0.11e2 / 0.27e2 * t728 + 0.5e1 / 0.27e2 * t90 * t164 * t297;
  t787 = params->A3 * t786;
  t789 = t342 * t342;
  t790 = params->A3 * t789;
  t794 = 0.1e1 / t345 / t173;
  t795 = t794 * t594;
  t796 = t795 * t789;
  t801 = 0.55e2 / 0.81e2 * t728 + t740 * t148 / 0.576e3 - t744 * t746 / 0.9216e4 + t751 * t549 * t743 / 0.221184e6 - t316 * t319 * t739 / 0.13824e5 + t759 * t161 / 0.165888e6 - 0.7e1 / 0.7962624e7 * t762 * t333 * t758 * params->beta2 + t323 * t770 / 0.165888e6 + 0.5e1 / 0.191102976e9 * t323 * t775 * t758 - t331 * t334 * t769 / 0.3981312e7 + t787 * t174 - 0.2e1 * t790 * t347 + 0.2e1 * t171 * t796 - t171 * t347 * t786;
  t806 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t176 + t674 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t350 - t630 + t681 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * t801);
  tv2rho22 = 0.2e1 * t286 + 0.2e1 * t355 + t8 * (t705 + t806);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t814 = t7 * t194 * t386 / 0.1e2;
  t817 = sigma[0] * t205;
  t821 = t49 * sigma[0];
  t822 = t360 * t821;
  t823 = t55 * t220;
  t824 = params->beta1 * t542;
  t825 = t824 * t214;
  t826 = t823 * t825;
  t829 = t549 * t47;
  t830 = t548 * t829;
  t831 = t55 * t214;
  t835 = t50 * t817;
  t838 = params->A2 * t228;
  t839 = t838 * t87;
  t842 = t235 * t47;
  t843 = t560 * t842;
  t844 = t55 * params->beta2;
  t845 = t844 * t228;
  t851 = t225 * t574;
  t858 = t37 * t199;
  t859 = t858 * t101;
  t862 = t376 * t37;
  t863 = t43 * t248;
  t864 = params->beta3 * t244;
  t865 = t863 * t864;
  t868 = t98 * t595;
  t869 = t43 * t244;
  t876 = -0.5e1 / 0.27e2 * t38 * t199 - t361 * t817 * t73 / 0.54e2 - t822 * t826 / 0.4608e4 + t830 * t821 * t831 / 0.110592e6 + t366 * t835 / 0.1296e4 + t839 * t367 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t843 * t821 * t845 - t370 * t835 / 0.15552e5 + 0.5e1 / 0.95551488e8 * t851 * t50 * t362 * t228 + t373 * t835 / 0.373248e6 - t376 * t859 / 0.9e1 - t862 * t865 / 0.12e2 + t868 * t38 * t869 / 0.12e2 + t381 * t382 * t858 / 0.9e1;
  t881 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t386 + t814 + 0.3e1 / 0.2e2 * t7 * t32 * t876);
  tv2rhosigma0 = t8 * t881 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t888 = t7 * t268 * t415 / 0.1e2;
  t890 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t415 + t888);
  tv2rhosigma2 = t8 * t890 + t419;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t896 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t386 + t814);
  tv2rhosigma3 = t8 * t896 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t903 = sigma[2] * t303;
  t907 = t49 * sigma[2];
  t908 = t360 * t907;
  t909 = t131 * t318;
  t910 = params->beta1 * t745;
  t911 = t910 * t312;
  t915 = t751 * t829;
  t916 = t131 * t312;
  t920 = t50 * t903;
  t923 = params->A2 * t326;
  t924 = t923 * t161;
  t927 = t333 * t47;
  t928 = t762 * t927;
  t929 = t131 * params->beta2;
  t930 = t929 * t326;
  t936 = t323 * t775;
  t943 = t37 * t297;
  t944 = t943 * t174;
  t947 = t123 * t346;
  t948 = params->beta3 * t342;
  t949 = t947 * t948;
  t952 = t171 * t795;
  t953 = t123 * t342;
  t960 = -0.5e1 / 0.27e2 * t38 * t297 - t361 * t903 * t148 / 0.54e2 - t908 * t909 * t911 / 0.4608e4 + t915 * t907 * t916 / 0.110592e6 + t397 * t920 / 0.1296e4 + t924 * t398 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t928 * t907 * t930 - t401 * t920 / 0.15552e5 + 0.5e1 / 0.95551488e8 * t936 * t50 * t393 * t326 + t404 * t920 / 0.373248e6 - t376 * t944 / 0.9e1 - t862 * t949 / 0.12e2 + t952 * t38 * t953 / 0.12e2 + t411 * t382 * t943 / 0.9e1;
  t965 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t415 + t888 + 0.3e1 / 0.2e2 * t7 * t118 * t960);
  tv2rhosigma5 = t8 * t965 + t419;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t972 = t7 * t194 * t450 / 0.1e2;
  t977 = t50 * lapl[0];
  t978 = t420 * t977;
  t979 = t63 * t220;
  t980 = t979 * t825;
  t983 = t549 * params->a;
  t984 = t548 * t983;
  t989 = t422 * t210;
  t993 = t838 * t431;
  t996 = t235 * params->b;
  t997 = t996 * t47;
  t998 = t560 * t997;
  t999 = t63 * params->beta2;
  t1000 = t999 * t228;
  t1004 = lapl[0] * t210;
  t1005 = t50 * t1004;
  t1009 = t225 * t574 * params->b;
  t1019 = t440 * t38;
  t1020 = t93 * t248;
  t1031 = -0.5e1 / 0.432e3 * t421 * t422 * t210 * t73 - t978 * t980 / 0.4608e4 + t984 * t50 * t433 * t214 / 0.110592e6 + 0.5e1 / 0.10368e5 * t366 * t58 * t989 + t993 * t434 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t998 * t422 * t1000 - 0.5e1 / 0.124416e6 * t432 * t1005 + 0.5e1 / 0.95551488e8 * t1009 * t50 * t433 * t228 + 0.5e1 / 0.2985984e7 * t373 * t76 * t989 - 0.5e1 / 0.72e2 * t441 * t378 - t1019 * t1020 * t864 / 0.12e2 + t868 * t90 * t442 * t244 / 0.12e2 + 0.5e1 / 0.72e2 * t446 * t90 * t377;
  t1036 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t450 + t972 + 0.3e1 / 0.2e2 * t7 * t32 * t1031);
  tv2rholapl0 = t8 * t1036 + t454;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t1043 = t7 * t268 * t481 / 0.1e2;
  t1045 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t481 + t1043);
  tv2rholapl1 = t8 * t1045 + t485;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t1051 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t450 + t972);
  tv2rholapl2 = t8 * t1051 + t454;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t1060 = t50 * lapl[1];
  t1061 = t420 * t1060;
  t1062 = t138 * t318;
  t1063 = t1062 * t911;
  t1066 = t751 * t983;
  t1071 = t455 * t308;
  t1075 = t923 * t464;
  t1078 = t333 * params->b;
  t1079 = t1078 * t47;
  t1080 = t762 * t1079;
  t1081 = t138 * params->beta2;
  t1082 = t1081 * t326;
  t1086 = lapl[1] * t308;
  t1087 = t50 * t1086;
  t1091 = t323 * t775 * params->b;
  t1101 = t166 * t346;
  t1112 = -0.5e1 / 0.432e3 * t421 * t455 * t308 * t148 - t1061 * t1063 / 0.4608e4 + t1066 * t50 * t466 * t312 / 0.110592e6 + 0.5e1 / 0.10368e5 * t397 * t58 * t1071 + t1075 * t467 / 0.82944e5 - 0.7e1 / 0.3981312e7 * t1080 * t455 * t1082 - 0.5e1 / 0.124416e6 * t465 * t1087 + 0.5e1 / 0.95551488e8 * t1091 * t50 * t466 * t326 + 0.5e1 / 0.2985984e7 * t404 * t76 * t1071 - 0.5e1 / 0.72e2 * t441 * t408 - t1019 * t1101 * t948 / 0.12e2 + t952 * t90 * t473 * t342 / 0.12e2 + 0.5e1 / 0.72e2 * t477 * t90 * t407;
  t1117 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t481 + t1043 + 0.3e1 / 0.2e2 * t7 * t118 * t1112);
  tv2rholapl3 = t8 * t1117 + t485;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1119 = t49 * t55;
  t1120 = t1119 * t73;
  t1123 = params->A1 * t33;
  t1124 = t34 * t34;
  t1126 = 0.1e1 / t36 / t1124;
  t1127 = t1126 * t51;
  t1128 = t1123 * t1127;
  t1129 = t52 * t52;
  t1130 = t1129 * t39;
  t1132 = 0.1e1 / t41 / t1130;
  t1133 = t1132 * t220;
  t1134 = t1133 * t824;
  t1137 = t548 * t549;
  t1138 = t33 * t1126;
  t1139 = t51 * t1132;
  t1140 = t1138 * t1139;
  t1143 = t218 * t220;
  t1144 = params->beta1 * t47;
  t1148 = params->A2 * t33;
  t1149 = t1148 * t1126;
  t1154 = t560 * t235 * t33;
  t1155 = t1132 * params->beta2;
  t1159 = t50 * t55;
  t1164 = t233 * t235;
  t1165 = params->beta2 * t47;
  t1170 = params->A3 * t47 * t49;
  t1175 = t98 * t593;
  t1176 = t594 * t47;
  t1180 = t360 * t1120 / 0.288e3 - t1128 * t1134 / 0.384e3 + t1137 * t1140 / 0.9216e4 - t1143 * t1144 * t1119 / 0.6912e4 + t1149 * t1139 * t87 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1154 * t1127 * t1155 + t370 * t1159 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t851 * t1140 - t1164 * t1165 * t1119 / 0.1990656e7 - t1170 * t55 * t248 * params->beta3 / 0.288e3 + t1175 * t1176 * t1119 / 0.288e3;
  t1184 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1180);
  tv2sigma20 = t8 * t1184;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1185 = t49 * t131;
  t1186 = t1185 * t148;
  t1189 = t1126 * t127;
  t1190 = t1123 * t1189;
  t1191 = t128 * t128;
  t1192 = t1191 * t119;
  t1194 = 0.1e1 / t121 / t1192;
  t1195 = t1194 * t318;
  t1196 = t1195 * t910;
  t1199 = t751 * t549;
  t1200 = t127 * t1194;
  t1201 = t1138 * t1200;
  t1204 = t316 * t318;
  t1212 = t762 * t333 * t33;
  t1213 = t1194 * params->beta2;
  t1217 = t50 * t131;
  t1222 = t331 * t333;
  t1230 = t171 * t794;
  t1234 = t360 * t1186 / 0.288e3 - t1190 * t1196 / 0.384e3 + t1199 * t1201 / 0.9216e4 - t1204 * t1144 * t1185 / 0.6912e4 + t1149 * t1200 * t161 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1212 * t1189 * t1213 + t401 * t1217 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t936 * t1201 - t1222 * t1165 * t1185 / 0.1990656e7 - t1170 * t131 * t346 * params->beta3 / 0.288e3 + t1230 * t1176 * t1185 / 0.288e3;
  t1238 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1234);
  tv2sigma25 = t8 * t1238;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1239 = t1138 * lapl[0];
  t1240 = t420 * t1239;
  t1242 = 0.1e1 / t41 / t1129;
  t1243 = t1242 * t220;
  t1244 = t824 * sigma[0];
  t1245 = t1243 * t1244;
  t1248 = lapl[0] * t1242;
  t1250 = t1138 * t1248 * sigma[0];
  t1253 = t1126 * sigma[0];
  t1254 = t1148 * t1253;
  t1255 = t1242 * t87;
  t1256 = params->b * lapl[0];
  t1257 = t1255 * t1256;
  t1261 = t560 * t996 * t33;
  t1262 = t1126 * lapl[0];
  t1263 = t1242 * params->beta2;
  t1264 = t1263 * sigma[0];
  t1270 = t440 * t47;
  t1271 = t49 * t210;
  t1272 = t1271 * t249;
  t1275 = params->c * t47;
  t1279 = -t1240 * t1245 / 0.384e3 + t984 * t1250 / 0.9216e4 + t1254 * t1257 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1261 * t1262 * t1264 + 0.5e1 / 0.7962624e7 * t1009 * t1250 - t1270 * t1272 / 0.288e3 + t868 * t1275 * t1271 / 0.288e3;
  t1283 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1279);
  tv2sigmalapl0 = t8 * t1283;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1284 = t1138 * lapl[1];
  t1285 = t420 * t1284;
  t1287 = 0.1e1 / t121 / t1191;
  t1288 = t1287 * t318;
  t1289 = t910 * sigma[2];
  t1290 = t1288 * t1289;
  t1293 = lapl[1] * t1287;
  t1295 = t1138 * t1293 * sigma[2];
  t1298 = t1126 * sigma[2];
  t1299 = t1148 * t1298;
  t1300 = t1287 * t161;
  t1301 = params->b * lapl[1];
  t1302 = t1300 * t1301;
  t1306 = t762 * t1078 * t33;
  t1307 = t1126 * lapl[1];
  t1308 = t1287 * params->beta2;
  t1309 = t1308 * sigma[2];
  t1315 = t49 * t308;
  t1316 = t1315 * t347;
  t1322 = -t1285 * t1290 / 0.384e3 + t1066 * t1295 / 0.9216e4 + t1299 * t1302 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1306 * t1307 * t1309 + 0.5e1 / 0.7962624e7 * t1091 * t1295 - t1270 * t1316 / 0.288e3 + t952 * t1275 * t1315 / 0.288e3;
  t1326 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1322);
  tv2sigmalapl5 = t8 * t1326;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1327 = t49 * t63;
  t1331 = params->a * params->a;
  t1332 = params->A1 * t1331;
  t1333 = t1332 * t1138;
  t1335 = 0.1e1 / t41 / t203;
  t1336 = t59 * t1335;
  t1340 = t549 * t1331;
  t1341 = t548 * t1340;
  t1348 = params->b * params->b;
  t1349 = params->A2 * t1348;
  t1350 = t1349 * t33;
  t1351 = t1126 * t59;
  t1352 = t1335 * t87;
  t1357 = t560 * t235 * t1348;
  t1362 = t76 * t1327;
  t1365 = t1348 * t33;
  t1372 = params->c * params->c;
  t1373 = params->A3 * t1372;
  t1374 = t1373 * t47;
  t1378 = t1372 * t47;
  t1379 = t1378 * t1327;
  t1382 = t421 * t1327 * t73 / 0.288e3 - t1333 * t1336 * t543 / 0.384e3 + t1341 * t1138 * t1336 / 0.9216e4 - t366 * t58 * t1327 / 0.6912e4 + t1350 * t1351 * t1352 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1357 * t1138 * t1336 * params->beta2 + t370 * t1362 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t851 * t1365 * t1351 * t1335 - t373 * t1362 / 0.1990656e7 - t1374 * t1327 * t249 / 0.288e3 + t868 * t1379 / 0.288e3;
  t1386 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t1382);
  tv2lapl20 = t8 * t1386;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1387 = t49 * t138;
  t1392 = 0.1e1 / t121 / t301;
  t1393 = t134 * t1392;
  t1397 = t751 * t1340;
  t1404 = t1126 * t134;
  t1405 = t1392 * t161;
  t1410 = t762 * t333 * t1348;
  t1415 = t76 * t1387;
  t1427 = t1378 * t1387;
  t1430 = t421 * t1387 * t148 / 0.288e3 - t1333 * t1393 * t746 / 0.384e3 + t1397 * t1138 * t1393 / 0.9216e4 - t397 * t58 * t1387 / 0.6912e4 + t1350 * t1404 * t1405 / 0.6912e4 - 0.7e1 / 0.331776e6 * t1410 * t1138 * t1393 * params->beta2 + t401 * t1415 / 0.82944e5 + 0.5e1 / 0.7962624e7 * t936 * t1365 * t1404 * t1392 - t404 * t1415 / 0.1990656e7 - t1374 * t1387 * t347 / 0.288e3 + t952 * t1427 / 0.288e3;
  t1434 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t1430);
  tv2lapl22 = t8 * t1434;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1438 = 0.1e1 / t26 / t21;
  t1439 = t489 * t185;
  t1442 = t488 * t185;
  t1445 = t181 * t181;
  t1446 = 0.1e1 / t1445;
  t1447 = t18 * t1446;
  t1450 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t493 - 0.6e1 * t1447);
  t1454 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1438 * t1439 + 0.1e2 / 0.3e1 * t1442 * t497 + 0.5e1 / 0.3e1 * t27 * t1450);
  t1455 = t1454 * t31;
  t1459 = t501 * t193;
  t1461 = t7 * t1459 * t103;
  t1466 = t188 * t514;
  t1468 = t7 * t1466 * t103;
  t1471 = t7 * t506 * t252;
  t1477 = 0.1e1 / t30 / t181;
  t1478 = t29 * t1477;
  t1481 = 0.2e1 / 0.45e2 * t7 * t1478 * t103;
  t1483 = t7 * t515 * t252;
  t1486 = t7 * t194 * t601;
  t1489 = 0.1e1 / t40 / t1129;
  t1492 = 0.6688e4 / 0.27e2 * t50 * t51 * t1489;
  t1493 = t60 * t205;
  t1496 = -t1492 - 0.208e4 / 0.27e2 * t76 * t1493;
  t1497 = t87 * t1496;
  t1501 = 0.1e1 / t41 / t53;
  t1503 = t38 * sigma[0] * t1501;
  t1505 = t540 * t214;
  t1506 = params->A1 * t1505;
  t1507 = t547 * t549;
  t1508 = 0.1e1 / t66;
  t1512 = t549 * t214;
  t1517 = 0.1e1 / t546 / t71;
  t1518 = params->A1 * t1517;
  t1519 = t549 * params->beta1;
  t1526 = -t1492 - 0.208e4 / 0.27e2 * t58 * t1493;
  t1530 = t556 * t228;
  t1531 = params->A2 * t1530;
  t1532 = 0.1e1 / t81;
  t1538 = 0.1e1 / t86 / t85 / t84;
  t1539 = t573 * params->beta2;
  t1540 = t1538 * t1539;
  t1553 = -0.154e3 / 0.81e2 * t1503 - 0.55e2 / 0.81e2 * t90 * t91 * t523;
  t1556 = t225 * t1497 / 0.165888e6 - 0.77e3 / 0.243e3 * t1503 + t1506 * t1507 * t1508 / 0.147456e6 + t548 * t1512 * t536 / 0.73728e5 - t1518 * t1519 * t1505 * t542 / 0.2654208e7 - t218 * t221 * t1526 / 0.13824e5 - 0.5e1 / 0.5308416e7 * t1531 * t236 * t1532 - 0.5e1 / 0.1528823808e10 * t560 * t1540 * t1530 - t233 * t236 * t1496 / 0.3981312e7 - 0.6e1 * t586 * t250 - t98 * t249 * t1553;
  t1557 = t225 * t572;
  t1558 = t573 * t228;
  t1559 = t1558 * t567;
  t1562 = t588 * t244;
  t1563 = params->A3 * t1562;
  t1566 = t594 * t244;
  t1567 = t1566 * t585;
  t1570 = t537 * t220;
  t1574 = 0.1e1 / t68 / t66;
  t1578 = t560 * t235;
  t1579 = t228 * params->beta2;
  t1585 = params->A2 * t572;
  t1592 = params->A3 * t1553;
  t1594 = t247 * t247;
  t1595 = 0.1e1 / t1594;
  t1596 = t594 * params->beta3;
  t1597 = t1595 * t1596;
  t1601 = 0.5e1 / 0.63700992e8 * t1557 * t1559 + 0.6e1 * t1563 * t595 + 0.6e1 * t1175 * t1567 - t1570 * t825 / 0.3072e4 + t1506 * t221 * t1574 / 0.18432e5 - 0.7e1 / 0.2654208e7 * t1578 * t1579 * t567 + t838 * t568 / 0.55296e5 + 0.5e1 / 0.42467328e8 * t1585 * t1530 * t573 + params->A1 * t1526 * t73 / 0.576e3 + t1592 * t101 - 0.6e1 * t98 * t1597 * t1562;
  t1602 = t1556 + t1601;
  t1607 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1455 * t103 + 0.3e1 / 0.1e2 * t1461 + 0.9e1 / 0.2e2 * t7 * t502 * t252 - t1468 / 0.1e2 + 0.3e1 / 0.5e1 * t1471 + 0.9e1 / 0.2e2 * t7 * t189 * t601 + t1481 - t1483 / 0.1e2 + 0.3e1 / 0.1e2 * t1486 + 0.3e1 / 0.2e2 * t7 * t32 * t1602);
  t1609 = 0.1e1 / t114 / t112;
  t1610 = t608 * t260;
  t1613 = t607 * t260;
  t1616 = t109 * t1446;
  t1619 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t493 - 0.6e1 * t1616);
  t1623 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1609 * t1610 + 0.1e2 / 0.3e1 * t1613 * t614 + 0.5e1 / 0.3e1 * t115 * t1619);
  t1624 = t1623 * t31;
  t1628 = t618 * t193;
  t1630 = t7 * t1628 * t176;
  t1632 = t263 * t514;
  t1634 = t7 * t1632 * t176;
  t1636 = t117 * t1477;
  t1639 = 0.2e1 / 0.45e2 * t7 * t1636 * t176;
  t1641 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1624 * t176 + 0.3e1 / 0.1e2 * t1630 - t1634 / 0.1e2 + t1639);
  tv3rho30 = 0.3e1 * t606 + 0.3e1 * t632 + t8 * (t1607 + t1641);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1644 = 0.2e1 * t658;
  t1645 = 0.2e1 * t684;
  t1646 = t1438 * t277;
  t1649 = t488 * t639;
  t1654 = 0.2e1 * t493;
  t1655 = 0.6e1 * t1447;
  t1657 = my_piecewise5(t12, 0, t16, 0, t1654 - t1655);
  t1661 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1646 * t489 + 0.2e2 / 0.9e1 * t1649 * t185 + 0.1e2 / 0.9e1 * t635 * t497 + 0.5e1 / 0.3e1 * t27 * t1657);
  t1662 = t1661 * t31;
  t1666 = t643 * t193;
  t1669 = t7 * t1666 * t103 / 0.5e1;
  t1673 = t280 * t514;
  t1675 = t7 * t1673 * t103;
  t1679 = t7 * t648 * t252 / 0.5e1;
  t1688 = 0.3e1 / 0.2e2 * t7 * t1662 * t103 + t1669 + 0.3e1 / 0.1e2 * t7 * t644 * t252 - t1675 / 0.3e2 + t1679 + 0.3e1 / 0.2e2 * t7 * t281 * t601 + t1461 / 0.1e2 - t1468 / 0.15e2 + t1471 / 0.5e1 + t1481 - t1483 / 0.15e2 + t1486 / 0.1e2;
  t1689 = my_piecewise3(t2, 0, t1688);
  t1690 = t1609 * t288;
  t1693 = t607 * t663;
  t1698 = 0.6e1 * t1616;
  t1700 = my_piecewise5(t16, 0, t12, 0, -t1654 - t1698);
  t1704 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1690 * t608 + 0.2e2 / 0.9e1 * t1693 * t260 + 0.1e2 / 0.9e1 * t659 * t614 + 0.5e1 / 0.3e1 * t115 * t1700);
  t1705 = t1704 * t31;
  t1709 = t667 * t193;
  t1712 = t7 * t1709 * t176 / 0.5e1;
  t1713 = t291 * t514;
  t1715 = t7 * t1713 * t176;
  t1724 = t7 * t623 * t350 / 0.5e1;
  t1726 = t7 * t627 * t350;
  t1729 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1705 * t176 + t1712 - t1715 / 0.3e2 + t1630 / 0.1e2 - t1634 / 0.15e2 + t1639 + 0.3e1 / 0.2e2 * t7 * t619 * t350 + t1724 - t1726 / 0.3e2);
  tv3rho31 = t606 + t632 + t1644 + t1645 + t8 * (t1689 + t1729);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1732 = t1438 * t689;
  t1737 = t488 * t694;
  t1741 = my_piecewise5(t12, 0, t16, 0, -t1654 - t1655);
  t1745 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1732 * t185 + 0.2e2 / 0.9e1 * t635 * t639 + 0.1e2 / 0.9e1 * t1737 * t185 + 0.5e1 / 0.3e1 * t27 * t1741);
  t1746 = t1745 * t31;
  t1750 = t698 * t193;
  t1752 = t7 * t1750 * t103;
  t1761 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1746 * t103 + t1752 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t699 * t252 + t1669 - t1675 / 0.15e2 + t1679 - t1468 / 0.3e2 + t1481 - t1483 / 0.3e2);
  t1762 = t1609 * t706;
  t1767 = t607 * t711;
  t1771 = my_piecewise5(t16, 0, t12, 0, t1654 - t1698);
  t1775 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1762 * t260 + 0.2e2 / 0.9e1 * t659 * t663 + 0.1e2 / 0.9e1 * t1767 * t260 + 0.5e1 / 0.3e1 * t115 * t1771);
  t1776 = t1775 * t31;
  t1780 = t715 * t193;
  t1782 = t7 * t1780 * t176;
  t1789 = t7 * t672 * t350;
  t1797 = t7 * t268 * t801;
  t1799 = 0.3e1 / 0.2e2 * t7 * t1776 * t176 + t1782 / 0.1e2 + t1712 - t1715 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t668 * t350 + t1789 / 0.5e1 - t1634 / 0.3e2 + t1639 + t1724 - t1726 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t264 * t801 + t1797 / 0.1e2;
  t1800 = my_piecewise3(t108, 0, t1799);
  tv3rho32 = t1644 + t1645 + t705 + t806 + t8 * (t1761 + t1800);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1805 = t689 * t277;
  t1812 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t493 - 0.6e1 * t1447);
  t1816 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1438 * t1805 + 0.1e2 / 0.3e1 * t635 * t694 + 0.5e1 / 0.3e1 * t27 * t1812);
  t1817 = t1816 * t31;
  t1824 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1817 * t103 + 0.3e1 / 0.1e2 * t1752 - t1675 / 0.1e2 + t1481);
  t1825 = t706 * t288;
  t1832 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t493 - 0.6e1 * t1616);
  t1836 = my_piecewise3(t113, 0, -0.1e2 / 0.27e2 * t1609 * t1825 + 0.1e2 / 0.3e1 * t659 * t711 + 0.5e1 / 0.3e1 * t115 * t1832);
  t1837 = t1836 * t31;
  t1853 = 0.1e1 / t120 / t1191;
  t1856 = 0.6688e4 / 0.27e2 * t50 * t127 * t1853;
  t1857 = t135 * t303;
  t1860 = -t1856 - 0.208e4 / 0.27e2 * t58 * t1857;
  t1861 = params->A1 * t1860;
  t1865 = 0.1e1 / t121 / t129;
  t1867 = t38 * sigma[2] * t1865;
  t1872 = -0.154e3 / 0.81e2 * t1867 - 0.55e2 / 0.81e2 * t90 * t164 * t726;
  t1873 = params->A3 * t1872;
  t1877 = params->A2 * t774;
  t1878 = t758 * t326;
  t1884 = -t1856 - 0.208e4 / 0.27e2 * t76 * t1857;
  t1885 = t161 * t1884;
  t1891 = t743 * t312;
  t1892 = params->A1 * t1891;
  t1893 = t750 * t549;
  t1894 = 0.1e1 / t141;
  t1898 = t549 * t312;
  t1903 = 0.1e1 / t749 / t146;
  t1904 = params->A1 * t1903;
  t1912 = t1861 * t148 / 0.576e3 + t1873 * t174 + t923 * t770 / 0.55296e5 + 0.5e1 / 0.42467328e8 * t1877 * t1878 * t573 + t323 * t1885 / 0.165888e6 - 0.77e3 / 0.243e3 * t1867 - t171 * t347 * t1872 + t1892 * t1893 * t1894 / 0.147456e6 + t751 * t1898 * t739 / 0.73728e5 - t1904 * t1519 * t1891 * t745 / 0.2654208e7 - t316 * t319 * t1860 / 0.13824e5;
  t1913 = params->A2 * t1878;
  t1914 = 0.1e1 / t155;
  t1920 = 0.1e1 / t160 / t159 / t158;
  t1921 = t1920 * t1539;
  t1930 = t762 * t333;
  t1931 = t326 * params->beta2;
  t1935 = t323 * t774;
  t1936 = t573 * t326;
  t1937 = t1936 * t769;
  t1940 = t789 * t342;
  t1941 = params->A3 * t1940;
  t1944 = t594 * t342;
  t1948 = t740 * t318;
  t1952 = 0.1e1 / t143 / t141;
  t1956 = t345 * t345;
  t1957 = 0.1e1 / t1956;
  t1958 = t1957 * t1596;
  t1962 = -0.5e1 / 0.5308416e7 * t1913 * t334 * t1914 - 0.5e1 / 0.1528823808e10 * t762 * t1921 * t1878 - t331 * t334 * t1884 / 0.3981312e7 - 0.6e1 * t787 * t348 - 0.7e1 / 0.2654208e7 * t1930 * t1931 * t769 + 0.5e1 / 0.63700992e8 * t1935 * t1937 + 0.6e1 * t1941 * t795 + 0.6e1 * t1230 * t1944 * t786 - t1948 * t911 / 0.3072e4 + t1892 * t319 * t1952 / 0.18432e5 - 0.6e1 * t171 * t1958 * t1940;
  t1963 = t1912 + t1962;
  t1968 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1837 * t176 + 0.3e1 / 0.1e2 * t1782 + 0.9e1 / 0.2e2 * t7 * t716 * t350 - t1715 / 0.1e2 + 0.3e1 / 0.5e1 * t1789 + 0.9e1 / 0.2e2 * t7 * t292 * t801 + t1639 - t1726 / 0.1e2 + 0.3e1 / 0.1e2 * t1797 + 0.3e1 / 0.2e2 * t7 * t118 * t1963);
  tv3rho33 = 0.3e1 * t705 + 0.3e1 * t806 + t8 * (t1824 + t1968);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1976 = t7 * t506 * t386;
  t1983 = t7 * t515 * t386 / 0.3e2;
  t1985 = t7 * t194 * t876;
  t1987 = sigma[0] * t529;
  t1988 = t50 * t1987;
  t1995 = t205 * t214;
  t2001 = t55 * t536;
  t2005 = t1585 * t50;
  t2006 = t573 * t556;
  t2014 = t98 * t1597;
  t2023 = params->beta1 * t1574;
  t2024 = t2023 * t540;
  t2028 = t1519 * t47;
  t2029 = t1518 * t2028;
  t2048 = -0.19e2 / 0.1119744e7 * t373 * t1988 - 0.4e1 / 0.9e1 * t868 * t38 * t199 * t244 - t830 * t821 * t1995 / 0.10368e5 - 0.19e2 / 0.3888e4 * t366 * t1988 + t830 * t821 * t2001 / 0.110592e6 + 0.5e1 / 0.21233664e8 * t2005 * t362 * t2006 + t868 * t38 * t43 * t585 / 0.12e2 - t2014 * t38 * t43 * t588 / 0.4e1 - 0.5e1 / 0.8957952e7 * t851 * t50 * t817 * t228 + t822 * t823 * t2024 / 0.9216e4 - t2029 * t821 * t55 * t540 * t542 / 0.1327104e7 - 0.5e1 / 0.2654208e7 * t557 * t842 * t821 * t844 * t1532 - 0.7e1 / 0.3981312e7 * t843 * t821 * t844 * t567 + 0.5e1 / 0.95551488e8 * t851 * t50 * t362 * t567;
  t2049 = t560 * t1540;
  t2054 = t205 * t220;
  t2058 = t824 * t536;
  t2062 = t55 * t547;
  t2063 = t549 * t1508;
  t2064 = t2063 * t540;
  t2068 = t205 * params->beta2;
  t2073 = params->A2 * t567;
  t2074 = t2073 * t87;
  t2077 = t199 * t248;
  t2081 = params->beta3 * t585;
  t2082 = t863 * t2081;
  t2086 = t594 * t588;
  t2087 = t43 * t593 * t2086;
  t2094 = t37 * t523;
  t2098 = t2094 * t101;
  t2106 = -0.5e1 / 0.764411904e9 * t2049 * t50 * t362 * t556 + t822 * t2054 * t825 / 0.432e3 - t822 * t823 * t2058 / 0.4608e4 + t822 * t2062 * t2064 / 0.73728e5 + 0.7e1 / 0.373248e6 * t843 * t821 * t2068 * t228 + t2074 * t367 / 0.82944e5 + 0.4e1 / 0.9e1 * t862 * t2077 * t864 - t862 * t2082 / 0.12e2 + t862 * t2087 / 0.4e1 - t839 * t835 / 0.7776e4 + 0.19e2 / 0.46656e5 * t370 * t1988 - 0.11e2 / 0.27e2 * t381 * t382 * t2094 + 0.11e2 / 0.27e2 * t376 * t2098 + 0.19e2 / 0.162e3 * t361 * t1987 * t73 + 0.55e2 / 0.81e2 * t38 * t523;
  t2107 = t2048 + t2106;
  t2112 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t386 + t1976 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t876 - t1983 + t1985 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2107);
  tv3rho2sigma0 = t8 * t2112 + 0.2e1 * t881;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2119 = t7 * t623 * t415;
  t2123 = t7 * t627 * t415 / 0.3e2;
  t2125 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t415 + t2119 / 0.5e1 - t2123);
  tv3rho2sigma2 = t8 * t2125 + 0.2e1 * t890;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2131 = t7 * t648 * t386;
  t2139 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t386 + t2131 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t876 + t1976 / 0.1e2 - t1983 + t1985 / 0.1e2);
  tv3rho2sigma3 = t8 * t2139 + t881 + t896;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2145 = t7 * t672 * t415;
  t2152 = t7 * t268 * t960;
  t2155 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t415 + t2145 / 0.1e2 + t2119 / 0.1e2 - t2123 + 0.3e1 / 0.2e2 * t7 * t264 * t960 + t2152 / 0.1e2);
  tv3rho2sigma5 = t8 * t2155 + t890 + t965;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2163 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t386 + t2131 / 0.5e1 - t1983);
  tv3rho2sigma6 = t8 * t2163 + 0.2e1 * t896;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2174 = t759 * t927;
  t2187 = t762 * t1921;
  t2192 = params->beta1 * t1952;
  t2193 = t2192 * t743;
  t2197 = t303 * params->beta2;
  t2206 = t303 * t318;
  t2210 = t910 * t739;
  t2214 = t131 * t750;
  t2215 = t549 * t1894;
  t2216 = t2215 * t743;
  t2220 = t1904 * t2028;
  t2226 = t37 * t726;
  t2230 = t297 * t346;
  t2234 = params->beta3 * t786;
  t2235 = t947 * t2234;
  t2238 = -0.5e1 / 0.2654208e7 * t2174 * t907 * t929 * t1914 - 0.7e1 / 0.3981312e7 * t928 * t907 * t929 * t769 + 0.5e1 / 0.95551488e8 * t936 * t50 * t393 * t769 - 0.5e1 / 0.764411904e9 * t2187 * t50 * t393 * t758 + t908 * t909 * t2193 / 0.9216e4 + 0.7e1 / 0.373248e6 * t928 * t907 * t2197 * t326 - 0.5e1 / 0.8957952e7 * t936 * t50 * t903 * t326 + t908 * t2206 * t911 / 0.432e3 - t908 * t909 * t2210 / 0.4608e4 + t908 * t2214 * t2216 / 0.73728e5 - t2220 * t907 * t131 * t743 * t745 / 0.1327104e7 - 0.11e2 / 0.27e2 * t411 * t382 * t2226 + 0.4e1 / 0.9e1 * t862 * t2230 * t948 - t862 * t2235 / 0.12e2;
  t2239 = params->A2 * t769;
  t2240 = t2239 * t161;
  t2244 = t594 * t789;
  t2245 = t123 * t794 * t2244;
  t2250 = sigma[2] * t732;
  t2251 = t50 * t2250;
  t2254 = t2226 * t174;
  t2260 = t171 * t1958;
  t2265 = t303 * t312;
  t2277 = t131 * t739;
  t2281 = t1877 * t50;
  t2282 = t573 * t758;
  t2292 = t2240 * t398 / 0.82944e5 + t862 * t2245 / 0.4e1 - t924 * t920 / 0.7776e4 + 0.19e2 / 0.46656e5 * t401 * t2251 + 0.11e2 / 0.27e2 * t376 * t2254 + 0.19e2 / 0.162e3 * t361 * t2250 * t148 - t2260 * t38 * t123 * t789 / 0.4e1 - t915 * t907 * t2265 / 0.10368e5 - 0.19e2 / 0.3888e4 * t397 * t2251 - 0.4e1 / 0.9e1 * t952 * t38 * t297 * t342 - 0.19e2 / 0.1119744e7 * t404 * t2251 + t915 * t907 * t2277 / 0.110592e6 + 0.5e1 / 0.21233664e8 * t2281 * t393 * t2282 + t952 * t38 * t123 * t786 / 0.12e2 + 0.55e2 / 0.81e2 * t38 * t726;
  t2293 = t2238 + t2292;
  t2298 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t415 + t2145 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t960 - t2123 + t2152 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * t2293);
  tv3rho2sigma8 = t8 * t2298 + 0.2e1 * t965;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t2305 = t7 * t506 * t450;
  t2312 = t7 * t515 * t450 / 0.3e2;
  t2314 = t7 * t194 * t1031;
  t2317 = t999 * t1532;
  t2321 = t999 * t567;
  t2329 = t1540 * params->b;
  t2330 = t560 * t2329;
  t2335 = t210 * t220;
  t2336 = t2335 * t825;
  t2339 = t979 * t2058;
  t2342 = t63 * t547;
  t2343 = t2342 * t2064;
  t2346 = t1519 * params->a;
  t2347 = t2346 * t47;
  t2348 = t1518 * t2347;
  t2350 = t63 * t540 * t542;
  t2354 = t210 * params->beta2;
  t2355 = t2354 * t228;
  t2363 = t979 * t2024;
  t2374 = t422 * t55;
  t2378 = -0.5e1 / 0.2654208e7 * t557 * t997 * t422 * t2317 - 0.7e1 / 0.3981312e7 * t998 * t422 * t2321 + 0.5e1 / 0.95551488e8 * t1009 * t50 * t433 * t567 - 0.5e1 / 0.764411904e9 * t2330 * t50 * t433 * t556 + 0.5e1 / 0.3456e4 * t978 * t2336 - t978 * t2339 / 0.4608e4 + t978 * t2343 / 0.73728e5 - t2348 * t422 * t2350 / 0.1327104e7 + 0.35e2 / 0.2985984e7 * t998 * t422 * t2355 - 0.25e2 / 0.71663616e8 * t1009 * t50 * t1004 * t228 + t978 * t2363 / 0.9216e4 - t2014 * t90 * t442 * t588 / 0.4e1 - 0.5e1 / 0.18e2 * t868 * t90 * t377 * t244 - 0.65e2 / 0.8957952e7 * t373 * t76 * t2374;
  t2386 = t1585 * t76;
  t2387 = t63 * t573;
  t2406 = t90 * t858;
  t2409 = t93 * t593;
  t2420 = lapl[0] * t55;
  t2421 = t50 * t2420;
  t2424 = t2073 * t431;
  t2427 = -0.5e1 / 0.82944e5 * t984 * t50 * t1004 * t214 - 0.65e2 / 0.31104e5 * t366 * t58 * t2374 + 0.5e1 / 0.21233664e8 * t2386 * t422 * t2387 * t556 + t868 * t90 * t442 * t585 / 0.12e2 + t984 * t50 * t433 * t536 / 0.110592e6 + 0.65e2 / 0.1296e4 * t421 * t422 * t55 * t73 + 0.5e1 / 0.27e2 * t441 * t859 - 0.5e1 / 0.27e2 * t446 * t2406 + t1019 * t2409 * t2086 / 0.4e1 + 0.5e1 / 0.18e2 * t1019 * t865 - t1019 * t1020 * t2081 / 0.12e2 - 0.5e1 / 0.62208e5 * t993 * t1005 + 0.65e2 / 0.373248e6 * t432 * t2421 + t2424 * t434 / 0.82944e5;
  t2428 = t2378 + t2427;
  t2433 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t450 + t2305 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t1031 - t2312 + t2314 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t2428);
  tv3rho2lapl0 = t8 * t2433 + 0.2e1 * t1036;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2440 = t7 * t623 * t481;
  t2444 = t7 * t627 * t481 / 0.3e2;
  t2446 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t481 + t2440 / 0.5e1 - t2444);
  tv3rho2lapl1 = t8 * t2446 + 0.2e1 * t1045;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2452 = t7 * t648 * t450;
  t2460 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t450 + t2452 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t1031 + t2305 / 0.1e2 - t2312 + t2314 / 0.1e2);
  tv3rho2lapl2 = t8 * t2460 + t1036 + t1051;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2466 = t7 * t672 * t481;
  t2473 = t7 * t268 * t1112;
  t2476 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t481 + t2466 / 0.1e2 + t2440 / 0.1e2 - t2444 + 0.3e1 / 0.2e2 * t7 * t264 * t1112 + t2473 / 0.1e2);
  tv3rho2lapl3 = t8 * t2476 + t1045 + t1117;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2484 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t450 + t2452 / 0.5e1 - t2312);
  tv3rho2lapl4 = t8 * t2484 + 0.2e1 * t1051;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2500 = t762 * t1921 * params->b;
  t2505 = t1062 * t2210;
  t2508 = t138 * t750;
  t2509 = t2508 * t2216;
  t2512 = t1904 * t2347;
  t2514 = t138 * t743 * t745;
  t2518 = t759 * t1079;
  t2519 = t1081 * t1914;
  t2523 = t1081 * t769;
  t2527 = t308 * t318;
  t2528 = t2527 * t911;
  t2531 = t1062 * t2193;
  t2534 = t308 * params->beta2;
  t2535 = t2534 * t326;
  t2543 = t1877 * t76;
  t2544 = t138 * t573;
  t2550 = t90 * t473 * t786;
  t2557 = 0.5e1 / 0.95551488e8 * t1091 * t50 * t466 * t769 - 0.5e1 / 0.764411904e9 * t2500 * t50 * t466 * t758 - t1061 * t2505 / 0.4608e4 + t1061 * t2509 / 0.73728e5 - t2512 * t455 * t2514 / 0.1327104e7 - 0.5e1 / 0.2654208e7 * t2518 * t455 * t2519 - 0.7e1 / 0.3981312e7 * t1080 * t455 * t2523 + 0.5e1 / 0.3456e4 * t1061 * t2528 + t1061 * t2531 / 0.9216e4 + 0.35e2 / 0.2985984e7 * t1080 * t455 * t2535 - 0.25e2 / 0.71663616e8 * t1091 * t50 * t1086 * t326 + 0.5e1 / 0.21233664e8 * t2543 * t455 * t2544 * t758 + t952 * t2550 / 0.12e2 + t1066 * t50 * t466 * t739 / 0.110592e6;
  t2562 = t455 * t131;
  t2583 = t90 * t943;
  t2588 = lapl[1] * t131;
  t2589 = t50 * t2588;
  t2601 = t2239 * t464;
  t2604 = -t2260 * t90 * t473 * t789 / 0.4e1 - 0.65e2 / 0.8957952e7 * t404 * t76 * t2562 - 0.5e1 / 0.18e2 * t952 * t90 * t407 * t342 - 0.5e1 / 0.82944e5 * t1066 * t50 * t1086 * t312 - 0.65e2 / 0.31104e5 * t397 * t58 * t2562 + 0.65e2 / 0.1296e4 * t421 * t455 * t131 * t148 + 0.5e1 / 0.27e2 * t441 * t944 - 0.5e1 / 0.27e2 * t477 * t2583 - 0.5e1 / 0.62208e5 * t1075 * t1087 + 0.65e2 / 0.373248e6 * t465 * t2589 + t1019 * t166 * t794 * t2244 / 0.4e1 + 0.5e1 / 0.18e2 * t1019 * t949 - t1019 * t1101 * t2234 / 0.12e2 + t2601 * t467 / 0.82944e5;
  t2605 = t2557 + t2604;
  t2610 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t481 + t2466 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t1112 - t2444 + t2473 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * t2605);
  tv3rho2lapl5 = t8 * t2610 + 0.2e1 * t1117;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2617 = t7 * t194 * t1180 / 0.1e2;
  t2618 = t49 * t205;
  t2619 = t1176 * t2618;
  t2622 = t1129 * t61;
  t2624 = 0.1e1 / t41 / t2622;
  t2625 = t51 * t2624;
  t2626 = t1138 * t2625;
  t2632 = t1585 * t1138;
  t2646 = t55 * t593;
  t2647 = t2646 * t1566;
  t2650 = t360 * t1119;
  t2651 = t542 * t214;
  t2655 = t1519 * t33;
  t2656 = t1518 * t2655;
  t2657 = t1132 * t542;
  t2658 = t2657 * t214;
  t2662 = t1148 * t1127;
  t2663 = t1132 * t235;
  t2664 = params->beta2 * t1532;
  t2665 = t2664 * t228;
  t2666 = t2663 * t2665;
  t2669 = t2624 * params->beta2;
  t2673 = -t1175 * t2619 / 0.54e2 - t1137 * t2626 / 0.864e3 + t1143 * t1144 * t2618 / 0.1296e4 + 0.5e1 / 0.1769472e7 * t2632 * t1139 * t1558 - 0.7e1 / 0.3981312e7 * t843 * t1119 * t1579 + t1164 * t1165 * t2618 / 0.373248e6 + 0.5e1 / 0.95551488e8 * t851 * t50 * t55 * t228 + t1170 * t2647 / 0.96e2 - t2650 * t221 * t2651 / 0.4608e4 - t2656 * t1127 * t2658 / 0.110592e6 - 0.5e1 / 0.221184e6 * t2662 * t2666 + 0.7e1 / 0.31104e5 * t1154 * t1127 * t2669;
  t2684 = t2624 * t220;
  t2688 = t2023 * t214;
  t2692 = t1132 * t547;
  t2693 = t2063 * t214;
  t2712 = t50 * t205;
  t2715 = -0.5e1 / 0.746496e6 * t851 * t2626 - 0.5e1 / 0.63700992e8 * t2049 * t1138 * t1139 * t228 - t2014 * t50 * t55 * t244 / 0.96e2 + t1128 * t2684 * t824 / 0.36e2 + t1128 * t1133 * t2688 / 0.768e3 + t1128 * t2692 * t2693 / 0.6144e4 - t360 * t2618 * t73 / 0.54e2 + t839 * t1159 / 0.82944e5 + t1170 * t205 * t248 * params->beta3 / 0.54e2 + t1137 * t50 * t831 / 0.110592e6 - t1149 * t2625 * t87 / 0.648e3 - t370 * t2712 / 0.15552e5;
  t2716 = t2673 + t2715;
  t2721 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t1180 + t2617 + 0.3e1 / 0.2e2 * t7 * t32 * t2716);
  tv3rhosigma20 = t8 * t2721 + t1184;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2728 = t7 * t268 * t1234 / 0.1e2;
  t2730 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t1234 + t2728);
  tv3rhosigma25 = t8 * t2730 + t1238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t1180 + t2617);
  tv3rhosigma26 = t8 * t2736 + t1184;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2741 = t49 * t303;
  t2747 = t50 * t303;
  t2757 = t1191 * t136;
  t2759 = 0.1e1 / t121 / t2757;
  t2760 = t127 * t2759;
  t2767 = t1138 * t2760;
  t2773 = t1877 * t1138;
  t2783 = -t360 * t2741 * t148 / 0.54e2 + t924 * t1217 / 0.82944e5 - t401 * t2747 / 0.15552e5 + t1170 * t303 * t346 * params->beta3 / 0.54e2 + t1199 * t50 * t916 / 0.110592e6 - t1149 * t2760 * t161 / 0.648e3 - t1230 * t1176 * t2741 / 0.54e2 - t1199 * t2767 / 0.864e3 + t1204 * t1144 * t2741 / 0.1296e4 + 0.5e1 / 0.1769472e7 * t2773 * t1200 * t1936 - 0.7e1 / 0.3981312e7 * t928 * t1185 * t1931 + t1222 * t1165 * t2741 / 0.373248e6;
  t2788 = t131 * t794;
  t2789 = t2788 * t1944;
  t2792 = t360 * t1185;
  t2793 = t745 * t312;
  t2794 = t319 * t2793;
  t2797 = t1904 * t2655;
  t2798 = t1194 * t745;
  t2799 = t2798 * t312;
  t2803 = t1148 * t1189;
  t2804 = t1194 * t333;
  t2805 = params->beta2 * t1914;
  t2806 = t2805 * t326;
  t2807 = t2804 * t2806;
  t2810 = t2759 * params->beta2;
  t2824 = t2759 * t318;
  t2828 = t2192 * t312;
  t2832 = t1194 * t750;
  t2833 = t2215 * t312;
  t2837 = 0.5e1 / 0.95551488e8 * t936 * t50 * t131 * t326 + t1170 * t2789 / 0.96e2 - t2792 * t2794 / 0.4608e4 - t2797 * t1189 * t2799 / 0.110592e6 - 0.5e1 / 0.221184e6 * t2803 * t2807 + 0.7e1 / 0.31104e5 * t1212 * t1189 * t2810 - 0.5e1 / 0.746496e6 * t936 * t2767 - 0.5e1 / 0.63700992e8 * t2187 * t1138 * t1200 * t326 - t2260 * t50 * t131 * t342 / 0.96e2 + t1190 * t2824 * t910 / 0.36e2 + t1190 * t1195 * t2828 / 0.768e3 + t1190 * t2832 * t2833 / 0.6144e4;
  t2838 = t2783 + t2837;
  t2843 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t1234 + t2728 + 0.3e1 / 0.2e2 * t7 * t118 * t2838);
  tv3rhosigma211 = t8 * t2843 + t1238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2850 = t7 * t194 * t1279 / 0.1e2;
  t2851 = t1129 * rho[0];
  t2853 = 0.1e1 / t41 / t2851;
  t2854 = t2853 * t220;
  t2855 = t2854 * t1244;
  t2858 = t1242 * t547;
  t2859 = t2858 * t549;
  t2860 = t1508 * sigma[0];
  t2861 = t2860 * t214;
  t2865 = t1243 * params->beta1;
  t2866 = t1574 * sigma[0];
  t2867 = t2866 * t214;
  t2871 = t2346 * t33;
  t2872 = t1518 * t2871;
  t2873 = t1262 * t1242;
  t2874 = sigma[0] * t542;
  t2875 = t2874 * t214;
  t2879 = lapl[0] * t2853;
  t2881 = t1138 * t2879 * sigma[0];
  t2885 = t2853 * t87 * t1256;
  t2888 = t1253 * t1242;
  t2889 = t1148 * t2888;
  t2890 = t996 * lapl[0];
  t2891 = t2890 * t2665;
  t2894 = params->b * t33;
  t2895 = t2894 * t1126;
  t2896 = t1585 * t2895;
  t2897 = t573 * sigma[0];
  t2898 = t2897 * t228;
  t2903 = t2853 * params->beta2 * sigma[0];
  t2907 = t1242 * sigma[0];
  t2908 = t2907 * t228;
  t2914 = t1119 * t249;
  t2917 = t440 * t50;
  t2918 = t210 * t593;
  t2919 = t2918 * t1566;
  t2922 = t1271 * t244;
  t2929 = 0.13e2 / 0.576e3 * t1240 * t2855 + t1240 * t2859 * t2861 / 0.6144e4 + t1240 * t2865 * t2867 / 0.768e3 - t2872 * t2873 * t2875 / 0.110592e6 - 0.13e2 / 0.13824e5 * t984 * t2881 - 0.13e2 / 0.10368e5 * t1254 * t2885 - 0.5e1 / 0.221184e6 * t2889 * t2891 + 0.5e1 / 0.1769472e7 * t2896 * t1248 * t2898 + 0.91e2 / 0.497664e6 * t1261 * t1262 * t2903 - 0.5e1 / 0.63700992e8 * t2330 * t1239 * t2908 - 0.65e2 / 0.11943936e8 * t1009 * t2881 + 0.13e2 / 0.864e3 * t1270 * t2914 + t2917 * t2919 / 0.96e2 - t2014 * t1275 * t2922 / 0.96e2 - 0.13e2 / 0.864e3 * t868 * t1275 * t1119;
  t2934 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t1279 + t2850 + 0.3e1 / 0.2e2 * t7 * t32 * t2929);
  tv3rhosigmalapl0 = t8 * t2934 + t1283;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2941 = t7 * t268 * t1322 / 0.1e2;
  t2943 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t1322 + t2941);
  tv3rhosigmalapl5 = t8 * t2943 + t1326;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2949 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t1279 + t2850);
  tv3rhosigmalapl6 = t8 * t2949 + t1283;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2954 = t1191 * rho[1];
  t2956 = 0.1e1 / t121 / t2954;
  t2957 = t2956 * t318;
  t2958 = t2957 * t1289;
  t2961 = t1287 * t750;
  t2962 = t2961 * t549;
  t2963 = t1894 * sigma[2];
  t2964 = t2963 * t312;
  t2968 = t1288 * params->beta1;
  t2969 = t1952 * sigma[2];
  t2970 = t2969 * t312;
  t2974 = t1904 * t2871;
  t2975 = t1307 * t1287;
  t2976 = sigma[2] * t745;
  t2977 = t2976 * t312;
  t2981 = lapl[1] * t2956;
  t2983 = t1138 * t2981 * sigma[2];
  t2987 = t2956 * t161 * t1301;
  t2990 = t1298 * t1287;
  t2991 = t1148 * t2990;
  t2992 = t1078 * lapl[1];
  t2993 = t2992 * t2806;
  t2996 = t1877 * t2895;
  t2997 = t573 * sigma[2];
  t2998 = t2997 * t326;
  t3003 = t2956 * params->beta2 * sigma[2];
  t3007 = t1287 * sigma[2];
  t3008 = t3007 * t326;
  t3014 = t1185 * t347;
  t3017 = t308 * t794;
  t3018 = t3017 * t1944;
  t3021 = t1315 * t342;
  t3028 = 0.13e2 / 0.576e3 * t1285 * t2958 + t1285 * t2962 * t2964 / 0.6144e4 + t1285 * t2968 * t2970 / 0.768e3 - t2974 * t2975 * t2977 / 0.110592e6 - 0.13e2 / 0.13824e5 * t1066 * t2983 - 0.13e2 / 0.10368e5 * t1299 * t2987 - 0.5e1 / 0.221184e6 * t2991 * t2993 + 0.5e1 / 0.1769472e7 * t2996 * t1293 * t2998 + 0.91e2 / 0.497664e6 * t1306 * t1307 * t3003 - 0.5e1 / 0.63700992e8 * t2500 * t1284 * t3008 - 0.65e2 / 0.11943936e8 * t1091 * t2983 + 0.13e2 / 0.864e3 * t1270 * t3014 + t2917 * t3018 / 0.96e2 - t2260 * t1275 * t3021 / 0.96e2 - 0.13e2 / 0.864e3 * t952 * t1275 * t1185;
  t3033 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t1322 + t2941 + 0.3e1 / 0.2e2 * t7 * t118 * t3028);
  tv3rhosigmalapl11 = t8 * t3033 + t1326;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t3040 = t7 * t194 * t1382 / 0.1e2;
  t3041 = t1519 * t1331;
  t3042 = t3041 * t33;
  t3043 = t1518 * t3042;
  t3044 = t1335 * t542;
  t3045 = t3044 * t214;
  t3049 = t1138 * t59;
  t3050 = t1349 * t3049;
  t3051 = t1335 * t235;
  t3052 = t3051 * t2665;
  t3056 = 0.1e1 / t41 / t527;
  t3057 = t59 * t3056;
  t3066 = t1540 * t1348;
  t3067 = t560 * t3066;
  t3079 = t1332 * t3049;
  t3080 = t1335 * t220;
  t3084 = t1335 * t547;
  t3093 = t76 * t1271;
  t3096 = -t3043 * t1351 * t3045 / 0.110592e6 - 0.5e1 / 0.221184e6 * t3050 * t3052 + 0.35e2 / 0.248832e6 * t1357 * t1138 * t3057 * params->beta2 - 0.25e2 / 0.5971968e7 * t851 * t1365 * t1351 * t3056 - 0.5e1 / 0.63700992e8 * t3067 * t1138 * t1336 * t228 - t2014 * t1378 * t1327 * t244 / 0.96e2 + 0.5e1 / 0.288e3 * t1333 * t3057 * t543 + t3079 * t3080 * t2688 / 0.768e3 + t3079 * t3084 * t2693 / 0.6144e4 - 0.5e1 / 0.432e3 * t421 * t1271 * t73 + t839 * t1362 / 0.82944e5 - 0.5e1 / 0.124416e6 * t370 * t3093;
  t3103 = t3056 * t87;
  t3113 = t1373 * t50;
  t3114 = t63 * t593;
  t3121 = t420 * t50;
  t3130 = t1585 * t1365;
  t3131 = t1335 * t573;
  t3132 = t3131 * t228;
  t3136 = t560 * t996;
  t3140 = 0.5e1 / 0.432e3 * t1374 * t1272 + t984 * t50 * t63 * t214 / 0.110592e6 - 0.5e1 / 0.5184e4 * t1350 * t1351 * t3103 + 0.5e1 / 0.2985984e7 * t373 * t3093 + 0.5e1 / 0.95551488e8 * t851 * t76 * t1327 * t228 + t3113 * t3114 * t1566 / 0.96e2 - 0.5e1 / 0.432e3 * t868 * t1378 * t1271 - t3121 * t980 / 0.4608e4 - 0.5e1 / 0.6912e4 * t1341 * t1138 * t3057 + 0.5e1 / 0.10368e5 * t366 * t58 * t1271 + 0.5e1 / 0.1769472e7 * t3130 * t1351 * t3132 - 0.7e1 / 0.3981312e7 * t3136 * t50 * t1000;
  t3141 = t3096 + t3140;
  t3146 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t1382 + t3040 + 0.3e1 / 0.2e2 * t7 * t32 * t3141);
  tv3rholapl20 = t8 * t3146 + t1386;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t3153 = t7 * t268 * t1430 / 0.1e2;
  t3155 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t1430 + t3153);
  tv3rholapl22 = t8 * t3155 + t1434;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t3161 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t1382 + t3040);
  tv3rholapl23 = t8 * t3161 + t1386;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t3166 = t1138 * t134;
  t3167 = t1349 * t3166;
  t3168 = t1392 * t333;
  t3169 = t3168 * t2806;
  t3173 = 0.1e1 / t121 / t730;
  t3174 = t134 * t3173;
  t3183 = t1921 * t1348;
  t3184 = t762 * t3183;
  t3196 = t1332 * t3166;
  t3197 = t1392 * t318;
  t3201 = t1392 * t750;
  t3205 = t1904 * t3042;
  t3206 = t1392 * t745;
  t3207 = t3206 * t312;
  t3218 = -0.5e1 / 0.221184e6 * t3167 * t3169 + 0.35e2 / 0.248832e6 * t1410 * t1138 * t3174 * params->beta2 - 0.25e2 / 0.5971968e7 * t936 * t1365 * t1404 * t3173 - 0.5e1 / 0.63700992e8 * t3184 * t1138 * t1393 * t326 - t2260 * t1378 * t1387 * t342 / 0.96e2 + 0.5e1 / 0.288e3 * t1333 * t3174 * t746 + t3196 * t3197 * t2828 / 0.768e3 + t3196 * t3201 * t2833 / 0.6144e4 - t3205 * t1404 * t3207 / 0.110592e6 - 0.5e1 / 0.432e3 * t421 * t1315 * t148 + t924 * t1415 / 0.82944e5 + 0.5e1 / 0.432e3 * t1374 * t1316;
  t3223 = t3173 * t161;
  t3227 = t76 * t1315;
  t3236 = t138 * t794;
  t3251 = t1877 * t1365;
  t3252 = t1392 * t573;
  t3253 = t3252 * t326;
  t3257 = t762 * t1078;
  t3261 = t1066 * t50 * t138 * t312 / 0.110592e6 - 0.5e1 / 0.5184e4 * t1350 * t1404 * t3223 - 0.5e1 / 0.124416e6 * t401 * t3227 + 0.5e1 / 0.2985984e7 * t404 * t3227 + 0.5e1 / 0.95551488e8 * t936 * t76 * t1387 * t326 + t3113 * t3236 * t1944 / 0.96e2 - 0.5e1 / 0.432e3 * t952 * t1378 * t1315 - t3121 * t1063 / 0.4608e4 - 0.5e1 / 0.6912e4 * t1397 * t1138 * t3174 + 0.5e1 / 0.10368e5 * t397 * t58 * t1315 + 0.5e1 / 0.1769472e7 * t3251 * t1404 * t3253 - 0.7e1 / 0.3981312e7 * t3257 * t50 * t1082;
  t3262 = t3218 + t3261;
  t3267 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t1430 + t3153 + 0.3e1 / 0.2e2 * t7 * t118 * t3262);
  tv3rholapl25 = t8 * t3267 + t1434;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3269 = t1126 * t1132;
  t3270 = t1123 * t3269;
  t3271 = t221 * t2874;
  t3274 = t1124 * t1124;
  t3275 = 0.1e1 / t3274;
  t3276 = params->A1 * t3275;
  t3277 = t51 * sigma[0];
  t3278 = t3276 * t3277;
  t3279 = t1129 * t1129;
  t3280 = 0.1e1 / t3279;
  t3289 = t1518 * t1519;
  t3290 = t3275 * t3277;
  t3291 = t3280 * t542;
  t3295 = sigma[0] * t1132;
  t3296 = t1138 * t3295;
  t3302 = params->A2 * t3275;
  t3303 = t3302 * t3277;
  t3305 = t3280 * t235 * t2664;
  t3308 = t1585 * t3275;
  t3309 = t3277 * t3280;
  t3316 = t560 * t1538;
  t3317 = t1539 * t3275;
  t3323 = 0.1e1 / t1124;
  t3324 = params->A3 * t3323;
  t3325 = 0.1e1 / t1129;
  t3327 = t3325 * t593 * t594;
  t3330 = t98 * t1595;
  t3331 = t1596 * t3323;
  t3335 = -t3270 * t3271 / 0.128e3 + t3278 * t3280 * t547 * t2063 / 0.512e3 + t3278 * t3280 * t220 * t2023 / 0.64e2 - t3289 * t3290 * t3291 / 0.9216e4 + t1137 * t3296 / 0.3072e4 + t1149 * t3295 * t87 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3303 * t3305 + 0.5e1 / 0.147456e6 * t3308 * t3309 * t573 - 0.7e1 / 0.110592e6 * t1154 * t1253 * t1155 - 0.5e1 / 0.5308416e7 * t3316 * t3317 * t3309 + 0.5e1 / 0.2654208e7 * t851 * t3296 + t3324 * t3327 / 0.384e3 - t3330 * t3331 * t3325 / 0.384e3;
  t3339 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3335);
  tv3sigma30 = t8 * t3339;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3340 = t1126 * t1194;
  t3341 = t1123 * t3340;
  t3342 = t319 * t2976;
  t3345 = t127 * sigma[2];
  t3346 = t3276 * t3345;
  t3347 = t1191 * t1191;
  t3348 = 0.1e1 / t3347;
  t3357 = t1904 * t1519;
  t3358 = t3275 * t3345;
  t3359 = t3348 * t745;
  t3363 = sigma[2] * t1194;
  t3364 = t1138 * t3363;
  t3370 = t3302 * t3345;
  t3372 = t3348 * t333 * t2805;
  t3375 = t1877 * t3275;
  t3376 = t3345 * t3348;
  t3383 = t762 * t1920;
  t3389 = 0.1e1 / t1191;
  t3391 = t3389 * t794 * t594;
  t3394 = t171 * t1957;
  t3398 = -t3341 * t3342 / 0.128e3 + t3346 * t3348 * t750 * t2215 / 0.512e3 + t3346 * t3348 * t318 * t2192 / 0.64e2 - t3357 * t3358 * t3359 / 0.9216e4 + t1199 * t3364 / 0.3072e4 + t1149 * t3363 * t161 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3370 * t3372 + 0.5e1 / 0.147456e6 * t3375 * t3376 * t573 - 0.7e1 / 0.110592e6 * t1212 * t1298 * t1213 - 0.5e1 / 0.5308416e7 * t3383 * t3317 * t3376 + 0.5e1 / 0.2654208e7 * t936 * t3364 + t3324 * t3391 / 0.384e3 - t3394 * t3331 * t3389 / 0.384e3;
  t3402 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3398);
  tv3sigma39 = t8 * t3402;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3403 = t3275 * lapl[0];
  t3404 = t420 * t3403;
  t3406 = 0.1e1 / t1129 / t203;
  t3407 = t3406 * t547;
  t3408 = t2063 * t51;
  t3412 = t3406 * t220;
  t3413 = t2023 * t51;
  t3417 = t420 * t1138;
  t3421 = t1518 * t2346;
  t3422 = t3406 * t51;
  t3432 = t3302 * t3422;
  t3435 = t996 * lapl[0] * params->beta2 * t1532;
  t3438 = params->b * t3275;
  t3439 = t1585 * t3438;
  t3440 = lapl[0] * t3406;
  t3441 = t573 * t51;
  t3456 = t440 * t3323;
  t3457 = 0.1e1 / t527;
  t3459 = t3457 * t593 * t594;
  t3462 = t1596 * params->c;
  t3463 = t3323 * t3457;
  t3467 = t3404 * t3407 * t3408 / 0.512e3 + t3404 * t3412 * t3413 / 0.64e2 - t3417 * t1248 * t543 / 0.384e3 - t3421 * t3403 * t3422 * t542 / 0.9216e4 + t984 * t1138 * t1248 / 0.9216e4 + t1149 * t1257 / 0.6912e4 - 0.5e1 / 0.18432e5 * t3432 * t3435 + 0.5e1 / 0.147456e6 * t3439 * t3440 * t3441 - 0.7e1 / 0.331776e6 * t3136 * t1138 * t1248 * params->beta2 - 0.5e1 / 0.5308416e7 * t2049 * t3438 * t3440 * t51 + 0.5e1 / 0.7962624e7 * t851 * t2894 * t2873 + t3456 * t3459 / 0.384e3 - t3330 * t3462 * t3463 / 0.384e3;
  t3471 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3467);
  tv3sigma2lapl0 = t8 * t3471;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3472 = t3275 * lapl[1];
  t3473 = t420 * t3472;
  t3475 = 0.1e1 / t1191 / t301;
  t3476 = t3475 * t750;
  t3477 = t2215 * t127;
  t3481 = t3475 * t318;
  t3482 = t2192 * t127;
  t3489 = t1904 * t2346;
  t3490 = t3475 * t127;
  t3500 = t3302 * t3490;
  t3503 = t1078 * lapl[1] * params->beta2 * t1914;
  t3506 = t1877 * t3438;
  t3507 = lapl[1] * t3475;
  t3508 = t573 * t127;
  t3523 = 0.1e1 / t730;
  t3525 = t3523 * t794 * t594;
  t3528 = t3323 * t3523;
  t3532 = t3473 * t3476 * t3477 / 0.512e3 + t3473 * t3481 * t3482 / 0.64e2 - t3417 * t1293 * t746 / 0.384e3 - t3489 * t3472 * t3490 * t745 / 0.9216e4 + t1066 * t1138 * t1293 / 0.9216e4 + t1149 * t1302 / 0.6912e4 - 0.5e1 / 0.18432e5 * t3500 * t3503 + 0.5e1 / 0.147456e6 * t3506 * t3507 * t3508 - 0.7e1 / 0.331776e6 * t3257 * t1138 * t1293 * params->beta2 - 0.5e1 / 0.5308416e7 * t2187 * t3438 * t3507 * t127 + 0.5e1 / 0.7962624e7 * t936 * t2894 * t2975 + t3456 * t3525 / 0.384e3 - t3394 * t3462 * t3528 / 0.384e3;
  t3536 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3532);
  tv3sigma2lapl11 = t8 * t3536;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3539 = t3275 * t59;
  t3540 = t1332 * t3539;
  t3541 = t1129 * t52;
  t3542 = 0.1e1 / t3541;
  t3543 = t3542 * t547;
  t3544 = t2063 * sigma[0];
  t3548 = t3542 * t220;
  t3549 = t2023 * sigma[0];
  t3553 = t1518 * t3041;
  t3554 = t3542 * t542;
  t3555 = t3554 * sigma[0];
  t3562 = t1349 * t3539;
  t3563 = t3542 * t235;
  t3564 = t2664 * sigma[0];
  t3565 = t3563 * t3564;
  t3568 = t1348 * t3275;
  t3569 = t1585 * t3568;
  t3570 = t59 * t3542;
  t3587 = t1373 * t3323;
  t3588 = 0.1e1 / t203;
  t3590 = t3588 * t593 * t594;
  t3593 = t1596 * t1372;
  t3594 = t3323 * t3588;
  t3598 = -t3417 * t1245 / 0.384e3 + t3540 * t3543 * t3544 / 0.512e3 + t3540 * t3548 * t3549 / 0.64e2 - t3553 * t3539 * t3555 / 0.9216e4 + t984 * t1138 * t2907 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3562 * t3565 + 0.5e1 / 0.147456e6 * t3569 * t3570 * t2897 + t1149 * t2907 * t431 / 0.6912e4 - 0.7e1 / 0.331776e6 * t3136 * t1138 * t1264 - 0.5e1 / 0.5308416e7 * t2049 * t3568 * t3570 * sigma[0] + 0.5e1 / 0.7962624e7 * t851 * t2894 * t2888 + t3587 * t3590 / 0.384e3 - t3330 * t3593 * t3594 / 0.384e3;
  t3602 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3598);
  tv3sigmalapl20 = t8 * t3602;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3605 = t3275 * t134;
  t3606 = t1332 * t3605;
  t3607 = t1191 * t128;
  t3608 = 0.1e1 / t3607;
  t3609 = t3608 * t750;
  t3610 = t2215 * sigma[2];
  t3614 = t3608 * t318;
  t3615 = t2192 * sigma[2];
  t3619 = t1904 * t3041;
  t3620 = t3608 * t745;
  t3621 = t3620 * sigma[2];
  t3628 = t1349 * t3605;
  t3629 = t3608 * t333;
  t3630 = t2805 * sigma[2];
  t3631 = t3629 * t3630;
  t3634 = t1877 * t3568;
  t3635 = t134 * t3608;
  t3652 = 0.1e1 / t301;
  t3654 = t3652 * t794 * t594;
  t3657 = t3323 * t3652;
  t3661 = -t3417 * t1290 / 0.384e3 + t3606 * t3609 * t3610 / 0.512e3 + t3606 * t3614 * t3615 / 0.64e2 - t3619 * t3605 * t3621 / 0.9216e4 + t1066 * t1138 * t3007 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3628 * t3631 + 0.5e1 / 0.147456e6 * t3634 * t3635 * t2997 + t1149 * t3007 * t464 / 0.6912e4 - 0.7e1 / 0.331776e6 * t3257 * t1138 * t1309 - 0.5e1 / 0.5308416e7 * t2187 * t3568 * t3635 * sigma[2] + 0.5e1 / 0.7962624e7 * t936 * t2894 * t2990 + t3587 * t3654 / 0.384e3 - t3394 * t3593 * t3657 / 0.384e3;
  t3665 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3661);
  tv3sigmalapl28 = t8 * t3665;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3666 = t824 * lapl[0];
  t3670 = t1331 * params->a;
  t3671 = params->A1 * t3670;
  t3672 = t59 * lapl[0];
  t3673 = t3275 * t3672;
  t3674 = t3671 * t3673;
  t3675 = 0.1e1 / t1130;
  t3676 = t3675 * t547;
  t3680 = t3675 * t220;
  t3684 = t1519 * t3670;
  t3685 = t1518 * t3684;
  t3686 = t3675 * t542;
  t3690 = lapl[0] * t1335;
  t3697 = t1348 * params->b;
  t3698 = params->A2 * t3697;
  t3699 = t3698 * t3673;
  t3700 = t3675 * t235;
  t3701 = t3700 * t2664;
  t3704 = t1585 * t3697;
  t3705 = t3675 * t573;
  t3713 = t3697 * t3275;
  t3714 = t3672 * t3675;
  t3722 = t1372 * params->c;
  t3723 = params->A3 * t3722;
  t3724 = t3723 * t3323;
  t3725 = 0.1e1 / t53;
  t3730 = t1596 * t3722;
  t3735 = -t1333 * t3080 * t3666 / 0.128e3 + t3674 * t3676 * t2063 / 0.512e3 + t3674 * t3680 * t2023 / 0.64e2 - t3685 * t3673 * t3686 / 0.9216e4 + t1341 * t1138 * t3690 / 0.3072e4 + t1350 * t1262 * t1352 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3699 * t3701 + 0.5e1 / 0.147456e6 * t3704 * t3673 * t3705 - 0.7e1 / 0.110592e6 * t1357 * t1138 * t3690 * params->beta2 - 0.5e1 / 0.5308416e7 * t2049 * t3713 * t3714 + 0.5e1 / 0.2654208e7 * t851 * t1365 * t1262 * t1335 + t3724 * t3725 * t593 * t594 / 0.384e3 - t3330 * t3730 * t3323 * t3725 / 0.384e3;
  t3739 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3735);
  tv3lapl30 = t8 * t3739;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3740 = t910 * lapl[1];
  t3744 = t134 * lapl[1];
  t3745 = t3275 * t3744;
  t3746 = t3671 * t3745;
  t3747 = 0.1e1 / t1192;
  t3748 = t3747 * t750;
  t3752 = t3747 * t318;
  t3756 = t1904 * t3684;
  t3757 = t3747 * t745;
  t3761 = lapl[1] * t1392;
  t3768 = t3698 * t3745;
  t3769 = t3747 * t333;
  t3770 = t3769 * t2805;
  t3773 = t1877 * t3697;
  t3774 = t3747 * t573;
  t3782 = t3744 * t3747;
  t3790 = 0.1e1 / t129;
  t3799 = -t1333 * t3197 * t3740 / 0.128e3 + t3746 * t3748 * t2215 / 0.512e3 + t3746 * t3752 * t2192 / 0.64e2 - t3756 * t3745 * t3757 / 0.9216e4 + t1397 * t1138 * t3761 / 0.3072e4 + t1350 * t1307 * t1405 / 0.2304e4 - 0.5e1 / 0.18432e5 * t3768 * t3770 + 0.5e1 / 0.147456e6 * t3773 * t3745 * t3774 - 0.7e1 / 0.110592e6 * t1410 * t1138 * t3761 * params->beta2 - 0.5e1 / 0.5308416e7 * t2187 * t3713 * t3782 + 0.5e1 / 0.2654208e7 * t936 * t1365 * t1307 * t1392 + t3724 * t3790 * t794 * t594 / 0.384e3 - t3394 * t3730 * t3323 * t3790 / 0.384e3;
  t3803 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t3799);
  tv3lapl33 = t8 * t3803;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t3810 = t7 * t1459 * t252;
  t3816 = t7 * t1466 * t252;
  t3819 = t7 * t506 * t601;
  t3825 = t7 * t1478 * t252;
  t3828 = t7 * t515 * t601;
  t3831 = t7 * t194 * t1602;
  t3833 = t567 * t567;
  t3840 = t556 * t556;
  t3841 = params->A2 * t3840;
  t3842 = 0.1e1 / t232;
  t3843 = t236 * t3842;
  t3846 = params->A2 * t1532;
  t3850 = t540 * t540;
  t3851 = params->A1 * t3850;
  t3852 = t66 * t66;
  t3853 = 0.1e1 / t3852;
  t3854 = t1507 * t3853;
  t3862 = 0.1e1 / t68 / t3852;
  t3863 = t221 * t3862;
  t3867 = t38 * sigma[0] * t1335;
  t3872 = 0.2618e4 / 0.243e3 * t3867 + 0.77e3 / 0.243e3 * t90 * t91 * t1501;
  t3875 = t1517 * t1519;
  t3876 = t3875 * t1574;
  t3884 = params->A1 / t546 / t72;
  t3885 = t549 * t549;
  t3894 = 0.1672e6 / 0.81e2 * t50 * t51 / t40 / t2851;
  t3895 = t60 * t529;
  t3898 = t3894 + 0.3952e5 / 0.81e2 * t58 * t3895;
  t3902 = t585 * t585;
  t3906 = t536 * t536;
  t3910 = 0.1e1 / t78;
  t3911 = t574 * t3910;
  t3916 = t3894 + 0.3952e5 / 0.81e2 * t76 * t3895;
  t3922 = t588 * t588;
  t3929 = 0.5e1 / 0.63700992e8 * t225 * t574 * t3833 + 0.5e1 / 0.7077888e7 * t557 * t574 * t567 + 0.5e1 / 0.10616832e8 * t3841 * t3843 - 0.25e2 / 0.1528823808e10 * t3846 * t1540 * t3840 - t3851 * t3854 / 0.98304e5 - 0.7e1 / 0.2654208e7 * t560 * t235 * t3833 * params->beta2 - t3851 * t3863 / 0.12288e5 - t98 * t249 * t3872 - t3851 * t3876 / 0.2654208e7 + t548 * t1512 * t1526 / 0.55296e5 + 0.5e1 / 0.127401984e9 * t3884 * t3885 * t3850 * t1508 - t218 * t221 * t3898 / 0.13824e5 + 0.6e1 * t98 * t595 * t3902 - params->A1 * t3906 * t543 / 0.3072e4 + 0.25e2 / 0.254803968e9 * t3841 * t3911 - t233 * t236 * t3916 / 0.3981312e7 - 0.8e1 * t1592 * t250 - 0.24e2 * params->A3 * t3922 * t1597 - 0.6e1 * params->A3 * t3902 * t249;
  t3939 = t86 * t86;
  t3941 = params->A2 / t3939;
  t3942 = t573 * t573;
  t3947 = t2664 * t567;
  t3950 = t1539 * t556;
  t3969 = t2063 * t536;
  t3976 = params->A1 * t542;
  t3982 = t1596 * t588;
  t3989 = 0.1e1 / t1594 / t100;
  t3990 = t594 * t594;
  t3991 = t3989 * t3990;
  t4003 = t548 * t549 * t3906 / 0.73728e5 + 0.1309e5 / 0.729e3 * t3867 + t838 * t1497 / 0.41472e5 + t225 * t87 * t3916 / 0.165888e6 + 0.35e2 / 0.73383542784e11 * t3941 * t3942 * t3840 - 0.5e1 / 0.884736e6 * t557 * t235 * t3947 - 0.5e1 / 0.254803968e9 * t3316 * t3950 * t567 + 0.5e1 / 0.47775744e8 * t1557 * t573 * t1496 * t228 + 0.8e1 * t1175 * t594 * t1553 * t244 + t1570 * t2024 / 0.3072e4 - 0.7e1 / 0.1990656e7 * t1578 * t1496 * params->beta2 * t228 + t541 * t547 * t3969 / 0.24576e5 - t3289 * t540 * t536 * t542 / 0.442368e6 - t3976 * t220 * params->beta1 * t1526 * t214 / 0.2304e4 - 0.36e2 * t3330 * t3982 * t585 + 0.36e2 * t586 * t596 + 0.24e2 * t98 * t3991 * t3922 + params->A1 * t3898 * t73 / 0.576e3 + params->A3 * t3872 * t101 + params->A2 * t3833 * t87 / 0.55296e5;
  t4008 = t21 * t21;
  t4010 = 0.1e1 / t26 / t4008;
  t4011 = t489 * t489;
  t4017 = t497 * t497;
  t4023 = 0.1e1 / t1445 / t8;
  t4024 = t18 * t4023;
  t4027 = my_piecewise5(t12, 0, t16, 0, -0.24e2 * t1446 + 0.24e2 * t4024);
  t4031 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t4010 * t4011 - 0.2e2 / 0.9e1 * t1438 * t489 * t497 + 0.1e2 / 0.3e1 * t488 * t4017 + 0.4e2 / 0.9e1 * t1442 * t1450 + 0.5e1 / 0.3e1 * t27 * t4027);
  t4038 = t7 * t1454 * t193 * t103;
  t4042 = t7 * t501 * t514 * t103;
  t4046 = t7 * t188 * t1477 * t103;
  t4049 = 0.1e1 / t30 / t492;
  t4053 = 0.14e2 / 0.135e3 * t7 * t29 * t4049 * t103;
  t4054 = 0.3e1 / 0.5e1 * t7 * t1455 * t252 + 0.6e1 / 0.5e1 * t3810 + 0.9e1 / 0.1e2 * t7 * t502 * t601 - 0.2e1 / 0.5e1 * t3816 + 0.6e1 / 0.5e1 * t3819 + 0.3e1 / 0.5e1 * t7 * t189 * t1602 + 0.8e1 / 0.45e2 * t3825 - t3828 / 0.5e1 + 0.2e1 / 0.5e1 * t3831 + 0.3e1 / 0.2e2 * t7 * t32 * (t3929 + t4003) + 0.3e1 / 0.2e2 * t7 * t4031 * t31 * t103 + 0.2e1 / 0.5e1 * t4038 - t4042 / 0.5e1 + 0.8e1 / 0.45e2 * t4046 - t4053;
  t4055 = my_piecewise3(t2, 0, t4054);
  t4056 = t112 * t112;
  t4058 = 0.1e1 / t114 / t4056;
  t4059 = t608 * t608;
  t4065 = t614 * t614;
  t4070 = t109 * t4023;
  t4073 = my_piecewise5(t16, 0, t12, 0, 0.24e2 * t1446 + 0.24e2 * t4070);
  t4077 = my_piecewise3(t113, 0, 0.4e2 / 0.81e2 * t4058 * t4059 - 0.2e2 / 0.9e1 * t1609 * t608 * t614 + 0.1e2 / 0.3e1 * t607 * t4065 + 0.4e2 / 0.9e1 * t1613 * t1619 + 0.5e1 / 0.3e1 * t115 * t4073);
  t4084 = t7 * t1623 * t193 * t176;
  t4088 = t7 * t618 * t514 * t176;
  t4092 = t7 * t263 * t1477 * t176;
  t4097 = 0.14e2 / 0.135e3 * t7 * t117 * t4049 * t176;
  t4099 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t4077 * t31 * t176 + 0.2e1 / 0.5e1 * t4084 - t4088 / 0.5e1 + 0.8e1 / 0.45e2 * t4092 - t4097);
  tv4rho40 = 0.4e1 * t1607 + 0.4e1 * t1641 + t8 * (t4055 + t4099);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t4120 = 0.12e2 * t1446;
  t4121 = 0.24e2 * t4024;
  t4123 = my_piecewise5(t12, 0, t16, 0, -t4120 + t4121);
  t4127 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t4010 * t277 * t1439 - 0.1e2 / 0.9e1 * t1438 * t639 * t489 - 0.1e2 / 0.9e1 * t1646 * t185 * t497 + 0.1e2 / 0.3e1 * t488 * t1657 * t185 + 0.1e2 / 0.3e1 * t1649 * t497 + 0.1e2 / 0.9e1 * t635 * t1450 + 0.5e1 / 0.3e1 * t27 * t4123);
  t4136 = t7 * t1666 * t252;
  t4142 = t7 * t1673 * t252;
  t4143 = t4142 / 0.1e2;
  t4145 = t7 * t648 * t601;
  t4158 = t7 * t1661 * t193 * t103;
  t4162 = t7 * t643 * t514 * t103;
  t4163 = t4162 / 0.1e2;
  t4166 = t7 * t280 * t1477 * t103;
  t4171 = 0.3e1 / 0.2e2 * t7 * t4127 * t31 * t103 + 0.9e1 / 0.2e2 * t7 * t1662 * t252 + 0.3e1 / 0.5e1 * t4136 + 0.9e1 / 0.2e2 * t7 * t644 * t601 - t4143 + 0.3e1 / 0.1e2 * t4145 + 0.3e1 / 0.2e2 * t7 * t281 * t1602 + 0.3e1 / 0.1e2 * t3810 - t3816 / 0.5e1 + 0.3e1 / 0.1e2 * t3819 + 0.2e1 / 0.15e2 * t3825 - t3828 / 0.1e2 + t3831 / 0.1e2 + 0.3e1 / 0.1e2 * t4158 - t4163 + 0.2e1 / 0.45e2 * t4166 + t4038 / 0.1e2 - t4042 / 0.1e2 + 0.2e1 / 0.15e2 * t4046 - t4053;
  t4172 = my_piecewise3(t2, 0, t4171);
  t4189 = 0.24e2 * t4070;
  t4191 = my_piecewise5(t16, 0, t12, 0, t4120 + t4189);
  t4195 = my_piecewise3(t113, 0, 0.4e2 / 0.81e2 * t4058 * t288 * t1610 - 0.1e2 / 0.9e1 * t1609 * t663 * t608 - 0.1e2 / 0.9e1 * t1690 * t260 * t614 + 0.1e2 / 0.3e1 * t607 * t1700 * t260 + 0.1e2 / 0.3e1 * t1693 * t614 + 0.1e2 / 0.9e1 * t659 * t1619 + 0.5e1 / 0.3e1 * t115 * t4191);
  t4202 = t7 * t1704 * t193 * t176;
  t4206 = t7 * t667 * t514 * t176;
  t4207 = t4206 / 0.1e2;
  t4210 = t7 * t291 * t1477 * t176;
  t4219 = t7 * t1628 * t350;
  t4222 = t7 * t1632 * t350;
  t4223 = t4222 / 0.1e2;
  t4225 = t7 * t1636 * t350;
  t4227 = 0.3e1 / 0.2e2 * t7 * t4195 * t31 * t176 + 0.3e1 / 0.1e2 * t4202 - t4207 + 0.2e1 / 0.45e2 * t4210 + t4084 / 0.1e2 - t4088 / 0.1e2 + 0.2e1 / 0.15e2 * t4092 - t4097 + 0.3e1 / 0.2e2 * t7 * t1624 * t350 + 0.3e1 / 0.1e2 * t4219 - t4223 + 0.2e1 / 0.45e2 * t4225;
  t4228 = my_piecewise3(t108, 0, t4227);
  tv4rho41 = t1607 + t1641 + 0.3e1 * t1689 + 0.3e1 * t1729 + t8 * (t4172 + t4228);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4237 = t7 * t1745 * t193 * t103;
  t4241 = t7 * t698 * t514 * t103;
  t4251 = t639 * t639;
  t4264 = my_piecewise5(t12, 0, t16, 0, t4121);
  t4268 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t4010 * t689 * t489 - 0.4e2 / 0.27e2 * t1646 * t185 * t639 - 0.1e2 / 0.27e2 * t1732 * t497 + 0.2e2 / 0.9e1 * t488 * t4251 + 0.2e2 / 0.9e1 * t635 * t1657 - 0.1e2 / 0.27e2 * t1438 * t694 * t489 + 0.2e2 / 0.9e1 * t488 * t1741 * t185 + 0.1e2 / 0.9e1 * t1737 * t497 + 0.5e1 / 0.3e1 * t27 * t4264);
  t4277 = t7 * t1750 * t252;
  t4293 = t4237 / 0.5e1 - t4241 / 0.3e2 + 0.3e1 / 0.2e2 * t7 * t4268 * t31 * t103 + 0.3e1 / 0.1e2 * t7 * t1746 * t252 + t4277 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t699 * t601 + 0.2e1 / 0.5e1 * t4136 - 0.2e1 / 0.15e2 * t4142 + t4145 / 0.5e1 - t3816 / 0.15e2 + 0.4e1 / 0.45e2 * t3825 - t3828 / 0.3e2 + t4158 / 0.5e1 - 0.2e1 / 0.15e2 * t4162 + 0.4e1 / 0.45e2 * t4166 - t4042 / 0.3e2 + 0.4e1 / 0.45e2 * t4046 - t4053;
  t4294 = my_piecewise3(t2, 0, t4293);
  t4303 = t663 * t663;
  t4316 = my_piecewise5(t16, 0, t12, 0, t4189);
  t4320 = my_piecewise3(t113, 0, 0.4e2 / 0.81e2 * t4058 * t706 * t608 - 0.4e2 / 0.27e2 * t1690 * t260 * t663 - 0.1e2 / 0.27e2 * t1762 * t614 + 0.2e2 / 0.9e1 * t607 * t4303 + 0.2e2 / 0.9e1 * t659 * t1700 - 0.1e2 / 0.27e2 * t1609 * t711 * t608 + 0.2e2 / 0.9e1 * t607 * t1771 * t260 + 0.1e2 / 0.9e1 * t1767 * t614 + 0.5e1 / 0.3e1 * t115 * t4316);
  t4327 = t7 * t1775 * t193 * t176;
  t4331 = t7 * t715 * t514 * t176;
  t4340 = t7 * t1709 * t350;
  t4343 = t7 * t1713 * t350;
  t4354 = t7 * t623 * t801;
  t4357 = t7 * t627 * t801;
  t4359 = 0.3e1 / 0.2e2 * t7 * t4320 * t31 * t176 + t4327 / 0.5e1 - t4331 / 0.3e2 + t4202 / 0.5e1 - 0.2e1 / 0.15e2 * t4206 + 0.4e1 / 0.45e2 * t4210 + 0.3e1 / 0.1e2 * t7 * t1705 * t350 + 0.2e1 / 0.5e1 * t4340 - t4343 / 0.15e2 - t4088 / 0.3e2 + 0.4e1 / 0.45e2 * t4092 - t4097 + t4219 / 0.5e1 - 0.2e1 / 0.15e2 * t4222 + 0.4e1 / 0.45e2 * t4225 + 0.3e1 / 0.2e2 * t7 * t619 * t801 + t4354 / 0.5e1 - t4357 / 0.3e2;
  t4360 = my_piecewise3(t108, 0, t4359);
  tv4rho42 = 0.2e1 * t1689 + 0.2e1 * t1729 + 0.2e1 * t1761 + 0.2e1 * t1800 + t8 * (t4294 + t4360);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4381 = my_piecewise5(t12, 0, t16, 0, t4120 + t4121);
  t4385 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t4010 * t1805 * t185 - 0.1e2 / 0.9e1 * t1732 * t639 - 0.1e2 / 0.9e1 * t1646 * t694 * t185 + 0.1e2 / 0.3e1 * t1649 * t694 + 0.1e2 / 0.3e1 * t635 * t1741 + 0.1e2 / 0.9e1 * t488 * t1812 * t185 + 0.5e1 / 0.3e1 * t27 * t4381);
  t4392 = t7 * t1816 * t193 * t103;
  t4403 = 0.3e1 / 0.2e2 * t7 * t4385 * t31 * t103 + t4392 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t1817 * t252 + 0.3e1 / 0.1e2 * t4237 - t4241 / 0.1e2 + 0.3e1 / 0.1e2 * t4277 - t4163 + 0.2e1 / 0.15e2 * t4166 - t4143 + 0.2e1 / 0.45e2 * t4046 - t4053 + 0.2e1 / 0.45e2 * t3825;
  t4404 = my_piecewise3(t2, 0, t4403);
  t4421 = my_piecewise5(t16, 0, t12, 0, -t4120 + t4189);
  t4425 = my_piecewise3(t113, 0, 0.4e2 / 0.81e2 * t4058 * t1825 * t260 - 0.1e2 / 0.9e1 * t1762 * t663 - 0.1e2 / 0.9e1 * t1690 * t711 * t260 + 0.1e2 / 0.3e1 * t1693 * t711 + 0.1e2 / 0.3e1 * t659 * t1771 + 0.1e2 / 0.9e1 * t607 * t1832 * t260 + 0.5e1 / 0.3e1 * t115 * t4421);
  t4432 = t7 * t1836 * t193 * t176;
  t4440 = t7 * t1780 * t350;
  t4449 = t7 * t672 * t801;
  t4459 = t7 * t268 * t1963;
  t4461 = 0.3e1 / 0.2e2 * t7 * t4425 * t31 * t176 + t4432 / 0.1e2 + 0.3e1 / 0.1e2 * t4327 - t4331 / 0.1e2 + 0.9e1 / 0.2e2 * t7 * t1776 * t350 + 0.3e1 / 0.1e2 * t4440 - t4207 + 0.2e1 / 0.15e2 * t4210 + 0.3e1 / 0.5e1 * t4340 - t4343 / 0.5e1 + 0.9e1 / 0.2e2 * t7 * t668 * t801 + 0.3e1 / 0.1e2 * t4449 + 0.2e1 / 0.45e2 * t4092 - t4097 - t4223 + 0.2e1 / 0.15e2 * t4225 + 0.3e1 / 0.1e2 * t4354 - t4357 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t264 * t1963 + t4459 / 0.1e2;
  t4462 = my_piecewise3(t108, 0, t4461);
  tv4rho43 = 0.3e1 * t1761 + 0.3e1 * t1800 + t1824 + t1968 + t8 * (t4404 + t4462);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4467 = t689 * t689;
  t4472 = t694 * t694;
  t4479 = my_piecewise5(t12, 0, t16, 0, 0.24e2 * t1446 + 0.24e2 * t4024);
  t4483 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t4010 * t4467 - 0.2e2 / 0.9e1 * t1732 * t694 + 0.1e2 / 0.3e1 * t488 * t4472 + 0.4e2 / 0.9e1 * t635 * t1812 + 0.5e1 / 0.3e1 * t27 * t4479);
  t4492 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t4483 * t31 * t103 + 0.2e1 / 0.5e1 * t4392 - t4241 / 0.5e1 + 0.8e1 / 0.45e2 * t4166 - t4053);
  t4497 = 0.1e1 / t1956 / t173;
  t4498 = t4497 * t3990;
  t4499 = t789 * t789;
  t4503 = t758 * t758;
  t4504 = params->A2 * t4503;
  t4505 = 0.1e1 / t330;
  t4506 = t334 * t4505;
  t4511 = t743 * t743;
  t4512 = params->A1 * t4511;
  t4513 = t141 * t141;
  t4515 = 0.1e1 / t143 / t4513;
  t4516 = t319 * t4515;
  t4519 = 0.1e1 / t4513;
  t4520 = t1893 * t4519;
  t4528 = params->A1 / t749 / t147;
  t4533 = t769 * t769;
  t4541 = t786 * t786;
  t4545 = t739 * t739;
  t4554 = params->A2 * t1920;
  t4560 = t38 * sigma[2] * t1392;
  t4565 = 0.2618e4 / 0.243e3 * t4560 + 0.77e3 / 0.243e3 * t90 * t164 * t1865;
  t4568 = t1903 * t1519;
  t4569 = t4568 * t1952;
  t4576 = 0.1672e6 / 0.81e2 * t50 * t127 / t120 / t2954;
  t4577 = t135 * t732;
  t4580 = t4576 + 0.3952e5 / 0.81e2 * t58 * t4577;
  t4584 = 0.1e1 / t152;
  t4585 = t775 * t4584;
  t4590 = t4576 + 0.3952e5 / 0.81e2 * t76 * t4577;
  t4594 = 0.24e2 * t171 * t4498 * t4499 + 0.5e1 / 0.10616832e8 * t4504 * t4506 + 0.36e2 * t787 * t796 - t4512 * t4516 / 0.12288e5 - t4512 * t4520 / 0.98304e5 + t751 * t1898 * t1860 / 0.55296e5 + 0.5e1 / 0.127401984e9 * t4528 * t3885 * t4511 * t1894 - 0.7e1 / 0.2654208e7 * t762 * t333 * t4533 * params->beta2 + 0.5e1 / 0.63700992e8 * t323 * t775 * t4533 + 0.6e1 * t171 * t795 * t4541 - params->A1 * t4545 * t746 / 0.3072e4 - 0.8e1 * t1873 * t348 + 0.5e1 / 0.7077888e7 * t1877 * t2282 * t769 - 0.25e2 / 0.1528823808e10 * t4554 * t4503 * t1539 * t1914 - t171 * t347 * t4565 - t4512 * t4569 / 0.2654208e7 - t316 * t319 * t4580 / 0.13824e5 + 0.25e2 / 0.254803968e9 * t4504 * t4585 - t331 * t334 * t4590 / 0.3981312e7;
  t4610 = t160 * t160;
  t4612 = params->A2 / t4610;
  t4630 = t1596 * t789;
  t4638 = t769 * params->beta2;
  t4639 = t4638 * t1914;
  t4647 = t2215 * t739;
  t4654 = t1539 * t758;
  t4662 = -0.6e1 * params->A3 * t4541 * t347 + 0.1309e5 / 0.729e3 * t4560 + t751 * t549 * t4545 / 0.73728e5 - 0.24e2 * params->A3 * t4499 * t1958 + t923 * t1885 / 0.41472e5 + t323 * t161 * t4590 / 0.165888e6 + 0.35e2 / 0.73383542784e11 * t4612 * t3942 * t4503 + params->A1 * t4580 * t148 / 0.576e3 + params->A3 * t4565 * t174 + params->A2 * t4533 * t161 / 0.55296e5 + 0.8e1 * t1230 * t594 * t1872 * t342 + t1948 * t2193 / 0.3072e4 - 0.36e2 * t3394 * t4630 * t786 - t1861 * t318 * t911 / 0.2304e4 - 0.5e1 / 0.884736e6 * t759 * t333 * t4639 - 0.7e1 / 0.1990656e7 * t1930 * t1884 * params->beta2 * t326 + t744 * t750 * t4647 / 0.24576e5 - t3357 * t743 * t739 * t745 / 0.442368e6 - 0.5e1 / 0.254803968e9 * t3383 * t4654 * t769 + 0.5e1 / 0.47775744e8 * t1935 * t573 * t1884 * t326;
  t4667 = t706 * t706;
  t4672 = t711 * t711;
  t4679 = my_piecewise5(t16, 0, t12, 0, -0.24e2 * t1446 + 0.24e2 * t4070);
  t4683 = my_piecewise3(t113, 0, 0.4e2 / 0.81e2 * t4058 * t4667 - 0.2e2 / 0.9e1 * t1762 * t711 + 0.1e2 / 0.3e1 * t607 * t4672 + 0.4e2 / 0.9e1 * t659 * t1832 + 0.5e1 / 0.3e1 * t115 * t4679);
  t4703 = 0.3e1 / 0.5e1 * t7 * t292 * t1963 + 0.3e1 / 0.2e2 * t7 * t118 * (t4594 + t4662) + 0.3e1 / 0.2e2 * t7 * t4683 * t31 * t176 + 0.3e1 / 0.5e1 * t7 * t1837 * t350 + 0.9e1 / 0.1e2 * t7 * t716 * t801 + 0.2e1 / 0.5e1 * t4432 + 0.6e1 / 0.5e1 * t4440 + 0.6e1 / 0.5e1 * t4449 + 0.2e1 / 0.5e1 * t4459 - t4331 / 0.5e1 - 0.2e1 / 0.5e1 * t4343 - t4357 / 0.5e1 + 0.8e1 / 0.45e2 * t4210 + 0.8e1 / 0.45e2 * t4225 - t4097;
  t4704 = my_piecewise3(t108, 0, t4703);
  tv4rho44 = 0.4e1 * t1824 + 0.4e1 * t1968 + t8 * (t4492 + t4704);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4712 = t7 * t1459 * t386;
  t4718 = t7 * t1466 * t386;
  t4721 = t7 * t506 * t876;
  t4728 = 0.2e1 / 0.45e2 * t7 * t1478 * t386;
  t4730 = t7 * t515 * t876;
  t4733 = t7 * t194 * t2107;
  t4736 = t360 * t821 * t55;
  t4737 = t1574 * t214;
  t4738 = t4737 * t536;
  t4748 = t1508 * t536 * t214;
  t4752 = t2028 * t49;
  t4754 = t2651 * t536;
  t4760 = t55 * t567;
  t4765 = t37 * t1501;
  t4769 = sigma[0] * t1489;
  t4785 = t3942 * t47;
  t4798 = t4736 * t221 * t4738 / 0.3072e4 - 0.5e1 / 0.884736e6 * t2073 * t842 * t49 * t362 * t2665 + t4736 * t1507 * t4748 / 0.24576e5 - t1518 * t4752 * t362 * t4754 / 0.442368e6 - 0.5e1 / 0.254803968e9 * t560 * t1540 * t47 * t821 * t4760 * t228 - 0.154e3 / 0.81e2 * t376 * t4765 * t101 - 0.209e3 / 0.243e3 * t361 * t4769 * t73 + t868 * t38 * t43 * t1553 / 0.12e2 - 0.2e1 / 0.3e1 * t868 * t38 * t199 * t585 - t830 * t821 * t205 * t536 / 0.6912e4 + 0.35e2 / 0.36691771392e11 * t3941 * t4785 * t821 * t55 * t1530 + t830 * t821 * t55 * t1526 / 0.110592e6 - 0.5e1 / 0.1327104e7 * t2005 * t817 * t2006;
  t4799 = t98 * t3991;
  t4811 = t50 * t4769;
  t4829 = params->A2 * t1496;
  t4836 = params->beta3 * t1553;
  t4847 = t4799 * t38 * t43 * t1562 + 0.22e2 / 0.9e1 * t868 * t38 * t523 * t244 + 0.19e2 / 0.20736e5 * t830 * t821 * t529 * t214 + 0.209e3 / 0.5832e4 * t366 * t4811 + 0.2e1 * t2014 * t38 * t199 * t588 + 0.3e1 / 0.4e1 * t376 * t377 * t595 * t585 * t244 + 0.209e3 / 0.1679616e7 * t373 * t4811 - 0.22e2 / 0.9e1 * t862 * t523 * t248 * t864 + t4829 * t87 * t367 / 0.82944e5 + 0.2e1 / 0.3e1 * t862 * t2077 * t2081 - t862 * t863 * t4836 / 0.12e2 - 0.209e3 / 0.69984e5 * t370 * t4811 + 0.154e3 / 0.81e2 * t381 * t382 * t4765 + 0.19e2 / 0.15552e5 * t839 * t1988;
  t4850 = t1596 * t33;
  t4885 = params->beta1 * t3862;
  t4886 = t4885 * t1505;
  t4890 = t3846 * t842;
  t4900 = -t1563 * t1595 * t4850 * t377 - t2074 * t835 / 0.5184e4 - 0.2e1 * t862 * t199 * t593 * t2086 - 0.77e3 / 0.243e3 * t38 * t1501 + 0.7e1 / 0.248832e6 * t843 * t821 * t2068 * t567 - 0.5e1 / 0.5971968e7 * t851 * t50 * t817 * t567 + 0.5e1 / 0.47775744e8 * t2049 * t50 * t817 * t556 - 0.25e2 / 0.764411904e9 * t3846 * t1540 * t50 * t362 * t1530 + 0.95e2 / 0.17915904e8 * t851 * t50 * t1987 * t228 - t822 * t2054 * t2024 / 0.576e3 - t822 * t823 * t4886 / 0.6144e4 + 0.5e1 / 0.165888e6 * t4890 * t821 * t2068 * t556 - 0.133e3 / 0.746496e6 * t843 * t821 * t529 * params->beta2 * t228;
  t4919 = t824 * t1526;
  t4928 = t3885 * t47;
  t4930 = t55 * t1505;
  t4946 = t549 * t3853;
  t4947 = t4946 * t1505;
  t4964 = -0.7e1 / 0.3981312e7 * t843 * t821 * t844 * t1496 + 0.5e1 / 0.7077888e7 * t2005 * t362 * t1559 + 0.5e1 / 0.95551488e8 * t851 * t50 * t362 * t1496 + t822 * t2054 * t2058 / 0.288e3 - t822 * t205 * t547 * t2064 / 0.4608e4 - t822 * t823 * t4919 / 0.4608e4 + t2029 * t821 * t205 * t540 * t542 / 0.82944e5 + 0.5e1 / 0.63700992e8 * t3884 * t4928 * t821 * t4930 * t1508 + 0.25e2 / 0.127401984e9 * t1531 * t572 * t47 * t821 * t55 * t573 * t3910 - 0.3e1 / 0.4e1 * t2014 * t38 * t869 * t585 - t822 * t2062 * t4947 / 0.49152e5 - 0.19e2 / 0.864e3 * t822 * t529 * t220 * t825 - t2029 * t821 * t4930 * t1574 / 0.1327104e7 + 0.5e1 / 0.5308416e7 * t1531 * t842 * t821 * t844 * t3842;
  t4971 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1455 * t386 + 0.3e1 / 0.1e2 * t4712 + 0.9e1 / 0.2e2 * t7 * t502 * t876 - t4718 / 0.1e2 + 0.3e1 / 0.5e1 * t4721 + 0.9e1 / 0.2e2 * t7 * t189 * t2107 + t4728 - t4730 / 0.1e2 + 0.3e1 / 0.1e2 * t4733 + 0.3e1 / 0.2e2 * t7 * t32 * (t4798 + t4847 + t4900 + t4964));
  tv4rho3sigma0 = t8 * t4971 + 0.3e1 * t2112;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t4978 = t7 * t1628 * t415;
  t4981 = t7 * t1632 * t415;
  t4985 = 0.2e1 / 0.45e2 * t7 * t1636 * t415;
  t4987 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1624 * t415 + 0.3e1 / 0.1e2 * t4978 - t4981 / 0.1e2 + t4985);
  tv4rho3sigma2 = t8 * t4987 + 0.3e1 * t2125;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t4989 = 0.2e1 * t2139;
  t4995 = t7 * t1666 * t386 / 0.5e1;
  t5000 = t7 * t1673 * t386;
  t5004 = t7 * t648 * t876 / 0.5e1;
  t5013 = 0.3e1 / 0.2e2 * t7 * t1662 * t386 + t4995 + 0.3e1 / 0.1e2 * t7 * t644 * t876 - t5000 / 0.3e2 + t5004 + 0.3e1 / 0.2e2 * t7 * t281 * t2107 + t4712 / 0.1e2 - t4718 / 0.15e2 + t4721 / 0.5e1 + t4728 - t4730 / 0.15e2 + t4733 / 0.1e2;
  t5014 = my_piecewise3(t2, 0, t5013);
  tv4rho3sigma3 = t8 * t5014 + t2112 + t4989;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5016 = 0.2e1 * t2155;
  t5022 = t7 * t1709 * t415 / 0.5e1;
  t5024 = t7 * t1713 * t415;
  t5033 = t7 * t623 * t960 / 0.5e1;
  t5035 = t7 * t627 * t960;
  t5038 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1705 * t415 + t5022 - t5024 / 0.3e2 + t4978 / 0.1e2 - t4981 / 0.15e2 + t4985 + 0.3e1 / 0.2e2 * t7 * t619 * t960 + t5033 - t5035 / 0.3e2);
  tv4rho3sigma5 = t8 * t5038 + t2125 + t5016;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5044 = t7 * t1750 * t386;
  t5053 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1746 * t386 + t5044 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t699 * t876 + t4995 - t5000 / 0.15e2 + t5004 - t4718 / 0.3e2 + t4728 - t4730 / 0.3e2);
  tv4rho3sigma6 = t8 * t5053 + t2163 + t4989;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t5059 = t7 * t1780 * t415;
  t5066 = t7 * t672 * t960;
  t5074 = t7 * t268 * t2293;
  t5076 = 0.3e1 / 0.2e2 * t7 * t1776 * t415 + t5059 / 0.1e2 + t5022 - t5024 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t668 * t960 + t5066 / 0.5e1 - t4981 / 0.3e2 + t4985 + t5033 - t5035 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t264 * t2293 + t5074 / 0.1e2;
  t5077 = my_piecewise3(t108, 0, t5076);
  tv4rho3sigma8 = t8 * t5077 + t2298 + t5016;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t5086 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1817 * t386 + 0.3e1 / 0.1e2 * t5044 - t5000 / 0.1e2 + t4728);
  tv4rho3sigma9 = t8 * t5086 + 0.3e1 * t2163;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t5103 = t37 * t1865;
  t5107 = sigma[2] * t1853;
  t5148 = t171 * t4498;
  t5152 = t50 * t5107;
  t5155 = -0.154e3 / 0.81e2 * t376 * t5103 * t174 - 0.209e3 / 0.243e3 * t361 * t5107 * t148 + 0.19e2 / 0.20736e5 * t915 * t907 * t732 * t312 + 0.2e1 * t2260 * t38 * t297 * t789 + 0.3e1 / 0.4e1 * t376 * t407 * t795 * t786 * t342 + 0.35e2 / 0.36691771392e11 * t4612 * t4785 * t907 * t131 * t1878 + t915 * t907 * t131 * t1860 / 0.110592e6 + t952 * t38 * t123 * t1872 / 0.12e2 - 0.5e1 / 0.1327104e7 * t2281 * t903 * t2282 - t915 * t907 * t303 * t739 / 0.6912e4 - 0.2e1 / 0.3e1 * t952 * t38 * t297 * t786 + t5148 * t38 * t123 * t1940 + 0.209e3 / 0.1679616e7 * t404 * t5152;
  t5162 = t549 * t4519;
  t5163 = t5162 * t1891;
  t5183 = params->A2 * t1914;
  t5197 = params->beta1 * t4515;
  t5198 = t5197 * t1891;
  t5216 = 0.209e3 / 0.5832e4 * t397 * t5152 + 0.22e2 / 0.9e1 * t952 * t38 * t726 * t342 - t908 * t2214 * t5163 / 0.49152e5 + 0.7e1 / 0.248832e6 * t928 * t907 * t2197 * t769 - 0.5e1 / 0.5971968e7 * t936 * t50 * t903 * t769 + 0.5e1 / 0.47775744e8 * t2187 * t50 * t903 * t758 - 0.19e2 / 0.864e3 * t908 * t732 * t318 * t911 - 0.25e2 / 0.764411904e9 * t5183 * t1921 * t50 * t393 * t1878 + 0.5e1 / 0.5308416e7 * t1913 * t927 * t907 * t929 * t4505 - t908 * t2206 * t2193 / 0.576e3 - t908 * t909 * t5198 / 0.6144e4 + 0.5e1 / 0.165888e6 * t5183 * t927 * t907 * t2197 * t758 - 0.133e3 / 0.746496e6 * t928 * t907 * t732 * params->beta2 * t326 + 0.95e2 / 0.17915904e8 * t936 * t50 * t2250 * t326;
  t5243 = t910 * t1860;
  t5248 = t1519 * t1952;
  t5249 = t5248 * t1891;
  t5272 = t131 * t769;
  t5277 = 0.25e2 / 0.127401984e9 * t1913 * t774 * t47 * t907 * t131 * t573 * t4584 - 0.7e1 / 0.3981312e7 * t928 * t907 * t929 * t1884 + 0.5e1 / 0.7077888e7 * t2281 * t393 * t1937 + 0.5e1 / 0.95551488e8 * t936 * t50 * t393 * t1884 + t908 * t2206 * t2210 / 0.288e3 - t908 * t303 * t750 * t2216 / 0.4608e4 - t908 * t909 * t5243 / 0.4608e4 - t908 * t131 * t1903 * t5249 / 0.1327104e7 + t2220 * t907 * t303 * t743 * t745 / 0.82944e5 + 0.5e1 / 0.63700992e8 * t4528 * t4928 * t907 * t131 * t1891 * t1894 - 0.3e1 / 0.4e1 * t2260 * t38 * t953 * t786 - 0.77e3 / 0.243e3 * t38 * t1865 - 0.5e1 / 0.254803968e9 * t762 * t1921 * t47 * t907 * t5272 * t326;
  t5279 = t2793 * t739;
  t5289 = t360 * t907 * t131;
  t5291 = t1894 * t739 * t312;
  t5295 = t1952 * t312;
  t5296 = t5295 * t739;
  t5311 = params->beta3 * t1872;
  t5315 = params->A2 * t1884;
  t5331 = -t1904 * t4752 * t393 * t5279 / 0.442368e6 - 0.5e1 / 0.884736e6 * t2239 * t927 * t49 * t393 * t2806 + t5289 * t1893 * t5291 / 0.24576e5 + t5289 * t319 * t5296 / 0.3072e4 - 0.2e1 * t862 * t297 * t794 * t2244 - 0.22e2 / 0.9e1 * t862 * t726 * t346 * t948 + 0.2e1 / 0.3e1 * t862 * t2230 * t2234 - t862 * t947 * t5311 / 0.12e2 + t5315 * t161 * t398 / 0.82944e5 + 0.154e3 / 0.81e2 * t411 * t382 * t5103 + 0.19e2 / 0.15552e5 * t924 * t2251 - 0.209e3 / 0.69984e5 * t401 * t5152 - t1941 * t1957 * t4850 * t407 - t2240 * t920 / 0.5184e4;
  t5338 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1837 * t415 + 0.3e1 / 0.1e2 * t5059 + 0.9e1 / 0.2e2 * t7 * t716 * t960 - t5024 / 0.1e2 + 0.3e1 / 0.5e1 * t5066 + 0.9e1 / 0.2e2 * t7 * t292 * t2293 + t4985 - t5035 / 0.1e2 + 0.3e1 / 0.1e2 * t5074 + 0.3e1 / 0.2e2 * t7 * t118 * (t5155 + t5216 + t5277 + t5331));
  tv4rho3sigma11 = t8 * t5338 + 0.3e1 * t2298;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t5345 = t7 * t1459 * t450;
  t5351 = t7 * t1466 * t450;
  t5354 = t7 * t506 * t1031;
  t5361 = 0.2e1 / 0.45e2 * t7 * t1478 * t450;
  t5363 = t7 * t515 * t1031;
  t5366 = t7 * t194 * t2428;
  t5409 = -t2348 * t427 * t4754 / 0.442368e6 + t978 * t2342 * t549 * t4748 / 0.24576e5 - 0.5e1 / 0.254803968e9 * t2330 * t977 * t63 * t567 * t228 + t978 * t979 * params->beta1 * t4738 / 0.3072e4 - 0.5e1 / 0.884736e6 * t838 * t997 * t427 * t3947 - 0.55e2 / 0.81e2 * t441 * t2098 - 0.65e2 / 0.243e3 * t421 * t422 * t205 * t73 + 0.65e2 / 0.124416e6 * t993 * t2421 - 0.65e2 / 0.69984e5 * t432 * t50 * lapl[0] * t205 + 0.55e2 / 0.81e2 * t446 * t90 * t2094 - t1563 * t1597 * t447 - 0.5e1 / 0.4e1 * t1019 * t2087 - 0.5e1 / 0.41472e5 * t2424 * t1005;
  t5439 = t3942 * params->b;
  t5440 = t3941 * t5439;
  t5442 = t50 * t433 * t1530;
  t5458 = t4829 * t431 * t434 / 0.82944e5 - 0.1e2 / 0.9e1 * t245 * t249 * t2406 + 0.5e1 / 0.12e2 * t1019 * t2082 - t1019 * t1020 * t4836 / 0.12e2 + t4799 * t90 * t442 * t1562 + t984 * t50 * t433 * t1526 / 0.110592e6 + t868 * t90 * t442 * t1553 / 0.12e2 + 0.3e1 / 0.4e1 * t1019 * t2409 * t1567 - 0.5e1 / 0.12e2 * t868 * t90 * t377 * t585 + 0.35e2 / 0.36691771392e11 * t5440 * t5442 - 0.5e1 / 0.55296e5 * t984 * t50 * t1004 * t536 - 0.25e2 / 0.10616832e8 * t2386 * t422 * t210 * t573 * t556 + 0.65e2 / 0.165888e6 * t984 * t50 * t2420 * t214;
  t5460 = t422 * t205;
  t5512 = 0.65e2 / 0.5832e4 * t366 * t58 * t5460 + 0.65e2 / 0.1679616e7 * t373 * t76 * t5460 + 0.5e1 / 0.4e1 * t2014 * t90 * t377 * t588 + 0.1e2 / 0.9e1 * t868 * t90 * t858 * t244 + 0.35e2 / 0.1990656e7 * t998 * t422 * t2354 * t567 - 0.25e2 / 0.47775744e8 * t1009 * t50 * t1004 * t567 + 0.25e2 / 0.382205952e9 * t2330 * t50 * t1004 * t556 - 0.3e1 / 0.4e1 * t98 * t1597 * params->c * t38 * t93 * t244 * t585 - t978 * t2342 * t4947 / 0.49152e5 - 0.65e2 / 0.6912e4 * t978 * t826 + 0.5e1 / 0.5308416e7 * t1531 * t997 * t422 * t999 * t3842 - 0.25e2 / 0.764411904e9 * t3846 * t2329 * t5442 + 0.25e2 / 0.1327104e7 * t3846 * t997 * t422 * t2354 * t556;
  t5527 = t1519 * t1574;
  t5537 = t3885 * params->a;
  t5538 = t5537 * t47;
  t5559 = t572 * params->b;
  t5570 = t76 * t49;
  t5575 = -0.455e3 / 0.5971968e7 * t998 * t422 * t845 + 0.325e3 / 0.143327232e9 * t1009 * t50 * t2420 * t228 - 0.5e1 / 0.4608e4 * t978 * t2335 * t2024 - t978 * t979 * t4886 / 0.6144e4 - t978 * t63 * t1517 * t5527 * t1505 / 0.1327104e7 + 0.5e1 / 0.663552e6 * t2348 * t422 * t210 * t540 * t542 + 0.5e1 / 0.63700992e8 * t3884 * t5538 * t422 * t63 * t1505 * t1508 + 0.5e1 / 0.95551488e8 * t1009 * t50 * t433 * t1496 + 0.5e1 / 0.2304e4 * t978 * t2335 * t2058 - 0.5e1 / 0.36864e5 * t978 * t210 * t547 * t2064 - t978 * t979 * t4919 / 0.4608e4 + 0.25e2 / 0.127401984e9 * t1531 * t5559 * t47 * t422 * t2387 * t3910 - 0.7e1 / 0.3981312e7 * t998 * t422 * t999 * t1496 + 0.5e1 / 0.7077888e7 * t1585 * t5570 * t433 * t1559;
  t5582 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1455 * t450 + 0.3e1 / 0.1e2 * t5345 + 0.9e1 / 0.2e2 * t7 * t502 * t1031 - t5351 / 0.1e2 + 0.3e1 / 0.5e1 * t5354 + 0.9e1 / 0.2e2 * t7 * t189 * t2428 + t5361 - t5363 / 0.1e2 + 0.3e1 / 0.1e2 * t5366 + 0.3e1 / 0.2e2 * t7 * t32 * (t5409 + t5458 + t5512 + t5575));
  tv4rho3lapl0 = t8 * t5582 + 0.3e1 * t2433;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t5589 = t7 * t1628 * t481;
  t5592 = t7 * t1632 * t481;
  t5596 = 0.2e1 / 0.45e2 * t7 * t1636 * t481;
  t5598 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1624 * t481 + 0.3e1 / 0.1e2 * t5589 - t5592 / 0.1e2 + t5596);
  tv4rho3lapl1 = t8 * t5598 + 0.3e1 * t2446;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t5600 = 0.2e1 * t2460;
  t5606 = t7 * t1666 * t450 / 0.5e1;
  t5611 = t7 * t1673 * t450;
  t5615 = t7 * t648 * t1031 / 0.5e1;
  t5624 = 0.3e1 / 0.2e2 * t7 * t1662 * t450 + t5606 + 0.3e1 / 0.1e2 * t7 * t644 * t1031 - t5611 / 0.3e2 + t5615 + 0.3e1 / 0.2e2 * t7 * t281 * t2428 + t5345 / 0.1e2 - t5351 / 0.15e2 + t5354 / 0.5e1 + t5361 - t5363 / 0.15e2 + t5366 / 0.1e2;
  t5625 = my_piecewise3(t2, 0, t5624);
  tv4rho3lapl2 = t8 * t5625 + t2433 + t5600;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t5627 = 0.2e1 * t2476;
  t5633 = t7 * t1709 * t481 / 0.5e1;
  t5635 = t7 * t1713 * t481;
  t5644 = t7 * t623 * t1112 / 0.5e1;
  t5646 = t7 * t627 * t1112;
  t5649 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1705 * t481 + t5633 - t5635 / 0.3e2 + t5589 / 0.1e2 - t5592 / 0.15e2 + t5596 + 0.3e1 / 0.2e2 * t7 * t619 * t1112 + t5644 - t5646 / 0.3e2);
  tv4rho3lapl3 = t8 * t5649 + t2446 + t5627;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t5655 = t7 * t1750 * t450;
  t5664 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1746 * t450 + t5655 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t699 * t1031 + t5606 - t5611 / 0.15e2 + t5615 - t5351 / 0.3e2 + t5361 - t5363 / 0.3e2);
  tv4rho3lapl4 = t8 * t5664 + t2484 + t5600;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t5670 = t7 * t1780 * t481;
  t5677 = t7 * t672 * t1112;
  t5685 = t7 * t268 * t2605;
  t5687 = 0.3e1 / 0.2e2 * t7 * t1776 * t481 + t5670 / 0.1e2 + t5633 - t5635 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t668 * t1112 + t5677 / 0.5e1 - t5592 / 0.3e2 + t5596 + t5644 - t5646 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t264 * t2605 + t5685 / 0.1e2;
  t5688 = my_piecewise3(t108, 0, t5687);
  tv4rho3lapl5 = t8 * t5688 + t2610 + t5627;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t5697 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1817 * t450 + 0.3e1 / 0.1e2 * t5655 - t5611 / 0.1e2 + t5361);
  tv4rho3lapl6 = t8 * t5697 + 0.3e1 * t2484;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t5737 = t50 * t2588 * t312;
  t5740 = t455 * t303;
  t5744 = t4612 * t5439;
  t5763 = t1061 * t1062 * params->beta1 * t5296 / 0.3072e4 - 0.5e1 / 0.884736e6 * t923 * t1079 * t460 * t4639 + t1061 * t2508 * t549 * t5291 / 0.24576e5 - 0.5e1 / 0.254803968e9 * t2500 * t1060 * t138 * t769 * t326 - t2512 * t460 * t5279 / 0.442368e6 - 0.55e2 / 0.81e2 * t441 * t2254 + 0.65e2 / 0.165888e6 * t1066 * t5737 + 0.65e2 / 0.5832e4 * t397 * t58 * t5740 + 0.35e2 / 0.36691771392e11 * t5744 * t50 * t466 * t1878 + 0.3e1 / 0.4e1 * t343 * t795 * t2550 + t952 * t90 * t473 * t1872 / 0.12e2 + t1066 * t50 * t466 * t1860 / 0.110592e6 + 0.65e2 / 0.1679616e7 * t404 * t76 * t5740;
  t5806 = 0.5e1 / 0.4e1 * t2260 * t90 * t407 * t789 - 0.25e2 / 0.10616832e8 * t2543 * t455 * t308 * t573 * t758 - 0.5e1 / 0.12e2 * t952 * t90 * t407 * t786 - 0.5e1 / 0.55296e5 * t1066 * t50 * t1086 * t739 + 0.1e2 / 0.9e1 * t952 * t90 * t943 * t342 + t5148 * t90 * t473 * t1940 - 0.5e1 / 0.4e1 * t1019 * t2245 + 0.65e2 / 0.124416e6 * t1075 * t2589 - 0.65e2 / 0.69984e5 * t465 * t50 * lapl[1] * t303 - t1941 * t1958 * t478 + 0.55e2 / 0.81e2 * t477 * t90 * t2226 + 0.5e1 / 0.12e2 * t1019 * t2235 - t1019 * t1101 * t5311 / 0.12e2;
  t5859 = t5315 * t464 * t467 / 0.82944e5 - 0.1e2 / 0.9e1 * t343 * t347 * t2583 - 0.5e1 / 0.41472e5 * t2601 * t1087 + 0.25e2 / 0.1327104e7 * t2518 * t455 * t2534 * t1914 + 0.5e1 / 0.2304e4 * t1061 * t2527 * t2210 - 0.5e1 / 0.4608e4 * t1061 * t2527 * t2193 - t1061 * t1062 * t5198 / 0.6144e4 + 0.325e3 / 0.143327232e9 * t1091 * t50 * t2588 * t326 - 0.3e1 / 0.4e1 * t171 * t1958 * params->c * t38 * t166 * t786 * t342 - 0.5e1 / 0.36864e5 * t1061 * t308 * t750 * t2216 - t1061 * t138 * t1903 * t5249 / 0.1327104e7 + 0.5e1 / 0.663552e6 * t2512 * t455 * t308 * t743 * t745 + 0.5e1 / 0.63700992e8 * t4528 * t5538 * t455 * t138 * t1891 * t1894;
  t5902 = t774 * params->b;
  t5920 = -0.65e2 / 0.6912e4 * params->A1 * t745 * t319 * params->a * t5737 + 0.5e1 / 0.95551488e8 * t1091 * t50 * t466 * t1884 - t1061 * t2508 * t5163 / 0.49152e5 + 0.35e2 / 0.1990656e7 * t1080 * t455 * t2534 * t769 - 0.25e2 / 0.47775744e8 * t1091 * t50 * t1086 * t769 + 0.25e2 / 0.382205952e9 * t2500 * t50 * t1086 * t758 + 0.5e1 / 0.7077888e7 * t1877 * t5570 * t466 * t1937 - 0.25e2 / 0.764411904e9 * t4554 * t5570 * t466 * t1539 * t1878 * t1914 - 0.455e3 / 0.5971968e7 * t1080 * t455 * t930 + 0.5e1 / 0.5308416e7 * t1913 * t1079 * t455 * t1081 * t4505 + 0.25e2 / 0.127401984e9 * t1913 * t5902 * t47 * t455 * t2544 * t4584 - 0.7e1 / 0.3981312e7 * t1080 * t455 * t1081 * t1884 - t1061 * t1062 * t5243 / 0.4608e4 - 0.65e2 / 0.243e3 * t421 * t455 * t303 * t148;
  t5927 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t1837 * t481 + 0.3e1 / 0.1e2 * t5670 + 0.9e1 / 0.2e2 * t7 * t716 * t1112 - t5635 / 0.1e2 + 0.3e1 / 0.5e1 * t5677 + 0.9e1 / 0.2e2 * t7 * t292 * t2605 + t5596 - t5646 / 0.1e2 + 0.3e1 / 0.1e2 * t5685 + 0.3e1 / 0.2e2 * t7 * t118 * (t5763 + t5806 + t5859 + t5920));
  tv4rho3lapl7 = t8 * t5927 + 0.3e1 * t2610;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t5934 = t7 * t506 * t1180;
  t5941 = t7 * t515 * t1180 / 0.3e2;
  t5943 = t7 * t194 * t2716;
  t5945 = t49 * t529;
  t5956 = 0.1e1 / t41 / t3541;
  t5957 = t51 * t5956;
  t5981 = t3885 * t33;
  t5992 = t573 * t3910;
  t5993 = t5992 * t556;
  t5997 = 0.19e2 / 0.162e3 * t360 * t5945 * t73 - t839 * t2712 / 0.7776e4 - 0.19e2 / 0.162e3 * t1170 * t529 * t248 * params->beta3 + 0.35e2 / 0.1944e4 * t1149 * t5957 * t87 + 0.19e2 / 0.46656e5 * t370 * t50 * t529 + t2074 * t1159 / 0.82944e5 + 0.5e1 / 0.2985984e7 * t2049 * t1138 * t2625 * t228 - 0.5e1 / 0.63700992e8 * t2049 * t1138 * t1139 * t567 - t1128 * t2684 * t2688 / 0.36e2 - t2656 * t1127 * t2657 * t536 / 0.110592e6 + 0.5e1 / 0.5308416e7 * t3884 * t5981 * t1127 * t1132 * t1508 * t540 - 0.5e1 / 0.221184e6 * t2662 * t2663 * t3947 + 0.25e2 / 0.10616832e8 * t2662 * t1132 * t572 * t5993;
  t6003 = params->A2 * t1538;
  t6009 = t4885 * t540;
  t6022 = params->beta2 * t3842;
  t6023 = t6022 * t556;
  t6031 = t2023 * t536;
  t6035 = t4946 * t540;
  t6053 = t2656 * t1127 * t2624 * t542 * t214 / 0.5184e4 - 0.25e2 / 0.63700992e8 * t6003 * t1138 * t1139 * t3950 * t1532 - t1128 * t1133 * t6009 / 0.512e3 - t2656 * t1127 * t1132 * t1574 * t540 / 0.110592e6 + 0.5e1 / 0.10368e5 * t2662 * t2624 * t235 * t2665 + 0.5e1 / 0.442368e6 * t2662 * t2663 * t6023 - t1128 * t2624 * t547 * t2693 / 0.288e3 + t1128 * t1133 * t6031 / 0.768e3 - t1128 * t2692 * t6035 / 0.4096e4 + t1128 * t2692 * t3969 / 0.6144e4 + 0.7e1 / 0.373248e6 * t843 * t2618 * t1579 + t2650 * t221 * t1574 * t540 / 0.9216e4 + t2014 * t50 * t205 * t244 / 0.9e1;
  t6081 = t3942 * t33;
  t6092 = t50 * t1995;
  t6107 = -0.5e1 / 0.82944e5 * t2632 * t2625 * t1558 - 0.5e1 / 0.2654208e7 * t4890 * t1119 * params->beta2 * t556 - t2029 * t1119 * t540 * t542 / 0.1327104e7 + 0.5e1 / 0.95551488e8 * t851 * t50 * t4760 - 0.5e1 / 0.764411904e9 * t2049 * t50 * t55 * t556 - t2650 * t221 * t542 * t536 / 0.4608e4 + t2650 * t1507 * t1508 * t540 / 0.73728e5 + 0.35e2 / 0.3057647616e10 * t3941 * t6081 * t1127 * t1132 * t556 - t2014 * t50 * t55 * t585 / 0.96e2 + t3976 * t221 * t6092 / 0.432e3 + 0.5e1 / 0.1769472e7 * t2632 * t1139 * t573 * t567 - 0.7e1 / 0.3981312e7 * t843 * t1119 * params->beta2 * t567 - 0.5e1 / 0.8957952e7 * t851 * t50 * t205 * t228;
  t6116 = t1138 * t5957;
  t6136 = t594 * t585;
  t6154 = t4799 * t50 * t55 * t588 / 0.24e2 - 0.245e3 / 0.93312e5 * t1154 * t1127 * t5956 * params->beta2 + 0.175e3 / 0.2239488e7 * t851 * t6116 - 0.35e2 / 0.108e3 * t1128 * t5956 * t220 * t824 - 0.19e2 / 0.1119744e7 * t1164 * t1165 * t5945 - t1170 * t55 * t1595 * t3982 / 0.24e2 - t1137 * t6092 / 0.10368e5 + 0.5e1 / 0.21233664e8 * t1585 * t47 * t1119 * t2006 + t1170 * t2646 * t6136 / 0.96e2 + t1137 * t50 * t2001 / 0.110592e6 - t245 * t593 * t2619 / 0.9e1 + 0.19e2 / 0.162e3 * t1175 * t1176 * t5945 + 0.35e2 / 0.2592e4 * t1137 * t6116 - 0.19e2 / 0.3888e4 * t1143 * t1144 * t5945;
  t6161 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t1180 + t5934 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t2716 - t5941 + t5943 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (t5997 + t6053 + t6107 + t6154));
  tv4rho2sigma20 = t8 * t6161 + 0.2e1 * t2721;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t6168 = t7 * t623 * t1234;
  t6172 = t7 * t627 * t1234 / 0.3e2;
  t6174 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t1234 + t6168 / 0.5e1 - t6172);
  tv4rho2sigma25 = t8 * t6174 + 0.2e1 * t2730;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t6180 = t7 * t648 * t1180;
  t6188 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t1180 + t6180 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t2716 + t5934 / 0.1e2 - t5941 + t5943 / 0.1e2);
  tv4rho2sigma26 = t8 * t6188 + t2721 + t2736;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t6194 = t7 * t672 * t1234;
  t6201 = t7 * t268 * t2838;
  t6204 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t1234 + t6194 / 0.1e2 + t6168 / 0.1e2 - t6172 + 0.3e1 / 0.2e2 * t7 * t264 * t2838 + t6201 / 0.1e2);
  tv4rho2sigma211 = t8 * t6204 + t2730 + t2843;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t6212 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t1180 + t6180 / 0.5e1 - t5941);
  tv4rho2sigma212 = t8 * t6212 + 0.2e1 * t2736;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t6233 = 0.1e1 / t121 / t3607;
  t6234 = t127 * t6233;
  t6240 = params->beta2 * t4505;
  t6241 = t6240 * t758;
  t6260 = t2192 * t739;
  t6264 = t5162 * t743;
  t6272 = -t924 * t2747 / 0.7776e4 + 0.19e2 / 0.46656e5 * t401 * t50 * t732 - 0.19e2 / 0.162e3 * t1170 * t732 * t346 * params->beta3 + 0.35e2 / 0.1944e4 * t1149 * t6234 * t161 + t2240 * t1217 / 0.82944e5 + 0.5e1 / 0.442368e6 * t2803 * t2804 * t6241 + 0.5e1 / 0.2985984e7 * t2187 * t1138 * t2760 * t326 - 0.5e1 / 0.63700992e8 * t2187 * t1138 * t1200 * t769 - t1190 * t2824 * t2828 / 0.36e2 - t1190 * t2759 * t750 * t2833 / 0.288e3 + t1190 * t1195 * t6260 / 0.768e3 - t1190 * t2832 * t6264 / 0.4096e4 - t2797 * t1189 * t2798 * t739 / 0.110592e6;
  t6283 = t573 * t4584;
  t6284 = t6283 * t758;
  t6305 = t5197 * t743;
  t6327 = 0.5e1 / 0.5308416e7 * t4528 * t5981 * t1189 * t1194 * t1894 * t743 - 0.5e1 / 0.221184e6 * t2803 * t2804 * t4639 + 0.25e2 / 0.10616832e8 * t2803 * t1194 * t774 * t6284 + 0.5e1 / 0.10368e5 * t2803 * t2759 * t333 * t2806 + t2797 * t1189 * t2759 * t745 * t312 / 0.5184e4 - 0.25e2 / 0.63700992e8 * t4554 * t1138 * t1200 * t4654 * t1914 + t1190 * t2832 * t4647 / 0.6144e4 - t1190 * t1195 * t6305 / 0.512e3 - t2797 * t1189 * t1194 * t1952 * t743 / 0.110592e6 - 0.5e1 / 0.2654208e7 * t2174 * t1185 * t2805 - 0.7e1 / 0.3981312e7 * t928 * t1185 * t4638 - 0.5e1 / 0.8957952e7 * t936 * t50 * t303 * t326 + 0.5e1 / 0.95551488e8 * t936 * t50 * t5272;
  t6352 = t1138 * t6234;
  t6377 = -0.5e1 / 0.764411904e9 * t2187 * t50 * t131 * t758 - t2792 * t319 * t745 * t739 / 0.4608e4 + t2792 * t1893 * t1894 * t743 / 0.73728e5 + 0.7e1 / 0.373248e6 * t928 * t2741 * t1931 - t2220 * t1185 * t743 * t745 / 0.1327104e7 + t5148 * t50 * t131 * t789 / 0.24e2 + 0.175e3 / 0.2239488e7 * t936 * t6352 - 0.35e2 / 0.108e3 * t1190 * t6233 * t318 * t910 + t2792 * t319 * t1952 * t743 / 0.9216e4 - 0.245e3 / 0.93312e5 * t1212 * t1189 * t6233 * params->beta2 + t2260 * t50 * t303 * t342 / 0.9e1 - 0.5e1 / 0.82944e5 * t2773 * t2760 * t1936 + t360 * t2741 * t2794 / 0.432e3;
  t6394 = t49 * t732;
  t6421 = t594 * t786;
  t6428 = 0.35e2 / 0.3057647616e10 * t4612 * t6081 * t1189 * t1194 * t758 - t2260 * t50 * t131 * t786 / 0.96e2 + 0.5e1 / 0.1769472e7 * t2773 * t1200 * t573 * t769 + t1199 * t50 * t2277 / 0.110592e6 - 0.19e2 / 0.1119744e7 * t1222 * t1165 * t6394 - t1170 * t303 * t794 * t1944 / 0.9e1 - t1199 * t50 * t2265 / 0.10368e5 + 0.19e2 / 0.162e3 * t1230 * t1176 * t6394 + 0.35e2 / 0.2592e4 * t1199 * t6352 - 0.19e2 / 0.3888e4 * t1204 * t1144 * t6394 - t1170 * t131 * t1957 * t4630 / 0.24e2 + 0.5e1 / 0.21233664e8 * t1877 * t47 * t1185 * t2282 + t1170 * t2788 * t6421 / 0.96e2 + 0.19e2 / 0.162e3 * t360 * t6394 * t148;
  t6435 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t1234 + t6194 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t2838 - t6172 + t6201 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * (t6272 + t6327 + t6377 + t6428));
  tv4rho2sigma217 = t8 * t6435 + 0.2e1 * t2843;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t6442 = t7 * t506 * t1279;
  t6449 = t7 * t515 * t1279 / 0.3e2;
  t6451 = t7 * t194 * t2929;
  t6479 = t2853 * sigma[0];
  t6484 = t3853 * sigma[0];
  t6489 = t3862 * sigma[0];
  t6494 = t1262 * t2853;
  t6506 = t5537 * t33;
  t6512 = t1253 * t2853;
  t6523 = -0.13e2 / 0.576e3 * t1240 * t2854 * params->beta1 * t2867 - 0.13e2 / 0.4608e4 * t1240 * t2853 * t547 * t549 * t2861 + t1240 * t2859 * t2860 * t536 / 0.6144e4 - t1240 * t1242 * t1517 * t1519 * t2866 * t540 / 0.110592e6 + t1240 * t2865 * t2866 * t536 / 0.768e3 + 0.5e1 / 0.442368e6 * t2889 * t2890 * t6023 + 0.65e2 / 0.47775744e8 * t2330 * t1239 * t6479 * t228 - t1240 * t2859 * t6484 * t540 / 0.4096e4 - t1240 * t2865 * t6489 * t540 / 0.512e3 + 0.13e2 / 0.82944e5 * t2872 * t6494 * t2875 - 0.5e1 / 0.63700992e8 * t2330 * t1239 * t2907 * t567 - t2872 * t2873 * t2874 * t536 / 0.110592e6 + 0.5e1 / 0.5308416e7 * t3884 * t6506 * t2873 * t2860 * t540 + 0.65e2 / 0.165888e6 * t1148 * t6512 * t2891 - 0.5e1 / 0.221184e6 * t2889 * t2890 * t3947 + 0.25e2 / 0.10616832e8 * t2889 * t5559 * lapl[0] * t5993;
  t6545 = t1138 * lapl[0] * t1132 * sigma[0];
  t6568 = t5439 * t33;
  t6589 = -0.25e2 / 0.63700992e8 * t6003 * t2895 * t1248 * t1539 * sigma[0] * t556 * t1532 - t2014 * t1275 * t1271 * t585 / 0.96e2 + t4799 * t1275 * t1271 * t588 / 0.24e2 + 0.13e2 / 0.144e3 * t2014 * t1275 * t1119 * t244 + 0.377e3 / 0.41472e5 * t984 * t6545 + 0.377e3 / 0.31104e5 * t1254 * t1132 * t87 * t1256 - 0.13e2 / 0.144e3 * t2917 * t2647 + t2917 * t2918 * t6136 / 0.96e2 - t2917 * t210 * t1595 * t3982 / 0.24e2 + 0.13e2 / 0.162e3 * t868 * t1275 * t2618 + 0.5e1 / 0.1769472e7 * t2896 * t1248 * t2897 * t567 + 0.35e2 / 0.3057647616e10 * t3941 * t6568 * t1262 * t2907 * t556 - 0.2639e4 / 0.1492992e7 * t1261 * t1262 * t1155 * sigma[0] + 0.1885e4 / 0.35831808e8 * t1009 * t6545 - 0.65e2 / 0.1327104e7 * t2896 * t2879 * t2898 - 0.377e3 / 0.1728e4 * t1240 * t1133 * t1244 - 0.13e2 / 0.162e3 * t1270 * t2618 * t249;
  t6595 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t1279 + t6442 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t2929 - t6449 + t6451 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (t6523 + t6589));
  tv4rho2sigmalapl0 = t8 * t6595 + 0.2e1 * t2934;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t6602 = t7 * t623 * t1322;
  t6606 = t7 * t627 * t1322 / 0.3e2;
  t6608 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t1322 + t6602 / 0.5e1 - t6606);
  tv4rho2sigmalapl5 = t8 * t6608 + 0.2e1 * t2943;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t6614 = t7 * t648 * t1279;
  t6622 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t1279 + t6614 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t2929 + t6442 / 0.1e2 - t6449 + t6451 / 0.1e2);
  tv4rho2sigmalapl6 = t8 * t6622 + t2934 + t2949;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t6628 = t7 * t672 * t1322;
  t6635 = t7 * t268 * t3028;
  t6638 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t1322 + t6628 / 0.1e2 + t6602 / 0.1e2 - t6606 + 0.3e1 / 0.2e2 * t7 * t264 * t3028 + t6635 / 0.1e2);
  tv4rho2sigmalapl11 = t8 * t6638 + t2943 + t3033;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t6646 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t1279 + t6614 / 0.5e1 - t6449);
  tv4rho2sigmalapl12 = t8 * t6646 + 0.2e1 * t2949;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t6671 = t1138 * lapl[1] * t1194 * sigma[2];
  t6714 = -t2260 * t1275 * t1315 * t786 / 0.96e2 + t5148 * t1275 * t1315 * t789 / 0.24e2 + 0.13e2 / 0.144e3 * t2260 * t1275 * t1185 * t342 + 0.377e3 / 0.41472e5 * t1066 * t6671 + 0.13e2 / 0.162e3 * t952 * t1275 * t2741 + 0.377e3 / 0.31104e5 * t1299 * t1194 * t161 * t1301 - 0.13e2 / 0.144e3 * t2917 * t2789 + t2917 * t3017 * t6421 / 0.96e2 - t2917 * t308 * t1957 * t4630 / 0.24e2 - 0.2639e4 / 0.1492992e7 * t1306 * t1307 * t1213 * sigma[2] + 0.1885e4 / 0.35831808e8 * t1091 * t6671 - 0.65e2 / 0.1327104e7 * t2996 * t2981 * t2998 - 0.377e3 / 0.1728e4 * t1285 * t1195 * t1289 + 0.5e1 / 0.1769472e7 * t2996 * t1293 * t2997 * t769 + 0.35e2 / 0.3057647616e10 * t4612 * t6568 * t1307 * t3007 * t758 - 0.13e2 / 0.162e3 * t1270 * t2741 * t347;
  t6715 = t4519 * sigma[2];
  t6729 = t1298 * t2956;
  t6770 = t2956 * sigma[2];
  t6775 = t4515 * sigma[2];
  t6780 = t1307 * t2956;
  t6791 = -t1285 * t2962 * t6715 * t743 / 0.4096e4 - t2974 * t2975 * t2976 * t739 / 0.110592e6 + 0.5e1 / 0.5308416e7 * t4528 * t6506 * t2975 * t2963 * t743 + 0.65e2 / 0.165888e6 * t1148 * t6729 * t2993 - 0.5e1 / 0.221184e6 * t2991 * t2992 * t4639 + 0.25e2 / 0.10616832e8 * t2991 * t5902 * lapl[1] * t6284 - 0.25e2 / 0.63700992e8 * t4554 * t2895 * t1293 * t1539 * sigma[2] * t758 * t1914 - 0.13e2 / 0.576e3 * t1285 * t2957 * params->beta1 * t2970 - 0.13e2 / 0.4608e4 * t1285 * t2956 * t750 * t549 * t2964 + t1285 * t2962 * t2963 * t739 / 0.6144e4 - t1285 * t1287 * t1903 * t1519 * t2969 * t743 / 0.110592e6 + t1285 * t2968 * t2969 * t739 / 0.768e3 + 0.65e2 / 0.47775744e8 * t2500 * t1284 * t6770 * t326 - t1285 * t2968 * t6775 * t743 / 0.512e3 + 0.13e2 / 0.82944e5 * t2974 * t6780 * t2977 + 0.5e1 / 0.442368e6 * t2991 * t2992 * t6241 - 0.5e1 / 0.63700992e8 * t2500 * t1284 * t3007 * t769;
  t6797 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t1322 + t6628 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t3028 - t6606 + t6635 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * (t6714 + t6791));
  tv4rho2sigmalapl17 = t8 * t6797 + 0.2e1 * t3033;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t6804 = t7 * t506 * t1382;
  t6811 = t7 * t515 * t1382 / 0.3e2;
  t6813 = t7 * t194 * t3141;
  t6841 = t59 * t1242;
  t6856 = -t2014 * t1378 * t1327 * t585 / 0.96e2 + 0.5e1 / 0.3456e4 * t3121 * t2336 - 0.5e1 / 0.2654208e7 * t557 * t996 * t50 * t2317 + 0.35e2 / 0.2985984e7 * t3136 * t50 * t2355 + t4799 * t1378 * t1327 * t588 / 0.24e2 + t3121 * t2363 / 0.9216e4 + 0.575e3 / 0.17915904e8 * t851 * t1365 * t1351 * t1242 + 0.5e1 / 0.72e2 * t2014 * t1378 * t2922 - 0.115e3 / 0.864e3 * t1333 * t6841 * t543 - 0.805e3 / 0.746496e6 * t1357 * t1138 * t6841 * params->beta2 - 0.7e1 / 0.3981312e7 * t3136 * t50 * t2321 - t3121 * t2339 / 0.4608e4 + t3121 * t2343 / 0.73728e5;
  t6881 = t3942 * t1348;
  t6882 = t3941 * t6881;
  t6884 = t1138 * t1336 * t556;
  t6905 = 0.5e1 / 0.1769472e7 * t3130 * t1351 * t3131 * t567 - t3421 * t50 * t2350 / 0.1327104e7 - 0.25e2 / 0.71663616e8 * t851 * t76 * t1271 * t228 + 0.5e1 / 0.95551488e8 * t851 * t76 * t1327 * t567 - 0.5e1 / 0.764411904e9 * t2049 * t76 * t1327 * t556 - 0.25e2 / 0.663552e6 * t3130 * t1351 * t3056 * t573 * t228 + 0.35e2 / 0.3057647616e10 * t6882 * t6884 - 0.5e1 / 0.72e2 * t3113 * t2919 + t984 * t50 * t63 * t536 / 0.110592e6 + t3113 * t3114 * t6136 / 0.96e2 + 0.65e2 / 0.1296e4 * t868 * t1378 * t1119 + 0.115e3 / 0.20736e5 * t1341 * t1138 * t6841 - 0.65e2 / 0.31104e5 * t366 * t58 * t1119;
  t6911 = t76 * t1119;
  t6920 = t3056 * t220;
  t6932 = t3885 * t1331;
  t6933 = t6932 * t33;
  t6960 = -0.5e1 / 0.82944e5 * t984 * t50 * t210 * t214 - 0.65e2 / 0.8957952e7 * t373 * t6911 + 0.5e1 / 0.21233664e8 * t557 * t574 * t1362 - t589 * t1597 * t1379 / 0.24e2 - 0.5e1 / 0.288e3 * t3079 * t6920 * t2688 - 0.5e1 / 0.2304e4 * t3079 * t3056 * t547 * t2693 - t3043 * t1351 * t3044 * t536 / 0.110592e6 + 0.5e1 / 0.5308416e7 * t3884 * t6933 * t1351 * t1335 * t1508 * t540 - 0.5e1 / 0.221184e6 * t3050 * t3051 * t3947 + 0.25e2 / 0.10616832e8 * t3050 * t1335 * t572 * t5993 - t3079 * t3080 * t6009 / 0.512e3 + 0.5e1 / 0.41472e5 * t3043 * t1351 * t3056 * t542 * t214 - t3043 * t1351 * t1335 * t1574 * t540 / 0.110592e6;
  t7001 = 0.25e2 / 0.82944e5 * t3050 * t3056 * t235 * t2665 + 0.5e1 / 0.442368e6 * t3050 * t3051 * t6023 - 0.25e2 / 0.63700992e8 * t3846 * t3066 * t6884 + t3079 * t3080 * t6031 / 0.768e3 - t3079 * t3084 * t6035 / 0.4096e4 + t3079 * t3084 * t3969 / 0.6144e4 + 0.25e2 / 0.23887872e8 * t3067 * t1138 * t3057 * t228 - 0.5e1 / 0.63700992e8 * t3067 * t1138 * t1336 * t567 + 0.115e3 / 0.15552e5 * t1350 * t1351 * t1255 - 0.5e1 / 0.62208e5 * t839 * t3093 + 0.65e2 / 0.373248e6 * t370 * t6911 - 0.65e2 / 0.1296e4 * t1374 * t2914 + t2074 * t1362 / 0.82944e5 + 0.65e2 / 0.1296e4 * t421 * t1120;
  t7008 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t502 * t1382 + t6804 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t189 * t3141 - t6811 + t6813 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (t6856 + t6905 + t6960 + t7001));
  tv4rho2lapl20 = t8 * t7008 + 0.2e1 * t3146;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t7015 = t7 * t623 * t1430;
  t7019 = t7 * t627 * t1430 / 0.3e2;
  t7021 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t619 * t1430 + t7015 / 0.5e1 - t7019);
  tv4rho2lapl22 = t8 * t7021 + 0.2e1 * t3155;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t7027 = t7 * t648 * t1382;
  t7035 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t644 * t1382 + t7027 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t281 * t3141 + t6804 / 0.1e2 - t6811 + t6813 / 0.1e2);
  tv4rho2lapl23 = t8 * t7035 + t3146 + t3161;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t7041 = t7 * t672 * t1430;
  t7048 = t7 * t268 * t3262;
  t7051 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t668 * t1430 + t7041 / 0.1e2 + t7015 / 0.1e2 - t7019 + 0.3e1 / 0.2e2 * t7 * t264 * t3262 + t7048 / 0.1e2);
  tv4rho2lapl25 = t8 * t7051 + t3155 + t3267;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t7059 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t699 * t1382 + t7027 / 0.5e1 - t6811);
  tv4rho2lapl26 = t8 * t7059 + 0.2e1 * t3161;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t7081 = t134 * t1287;
  t7113 = t5148 * t1378 * t1387 * t789 / 0.24e2 + 0.575e3 / 0.17915904e8 * t936 * t1365 * t1404 * t1287 + 0.5e1 / 0.72e2 * t2260 * t1378 * t3021 - 0.115e3 / 0.864e3 * t1333 * t7081 * t746 - 0.805e3 / 0.746496e6 * t1410 * t1138 * t7081 * params->beta2 + t3121 * t2531 / 0.9216e4 - t3121 * t2505 / 0.4608e4 + t3121 * t2509 / 0.73728e5 + 0.5e1 / 0.1769472e7 * t3251 * t1404 * t3252 * t769 - 0.7e1 / 0.3981312e7 * t3257 * t50 * t2523 + 0.35e2 / 0.2985984e7 * t3257 * t50 * t2535 - 0.25e2 / 0.71663616e8 * t936 * t76 * t1315 * t326 + 0.5e1 / 0.95551488e8 * t936 * t76 * t1387 * t769;
  t7118 = t4612 * t6881;
  t7120 = t1138 * t1393 * t758;
  t7147 = t76 * t1185;
  t7159 = -0.5e1 / 0.764411904e9 * t2187 * t76 * t1387 * t758 + 0.35e2 / 0.3057647616e10 * t7118 * t7120 - t2260 * t1378 * t1387 * t786 / 0.96e2 + 0.5e1 / 0.3456e4 * t3121 * t2528 - 0.5e1 / 0.2654208e7 * t759 * t1078 * t50 * t2519 - t3489 * t50 * t2514 / 0.1327104e7 - 0.25e2 / 0.663552e6 * t3251 * t1404 * t3173 * t573 * t326 + 0.115e3 / 0.20736e5 * t1397 * t1138 * t7081 - 0.65e2 / 0.31104e5 * t397 * t58 * t1185 - 0.65e2 / 0.8957952e7 * t404 * t7147 + 0.5e1 / 0.21233664e8 * t759 * t775 * t1415 + 0.65e2 / 0.1296e4 * t952 * t1378 * t1185 - t790 * t1958 * t1427 / 0.24e2;
  t7200 = t3173 * t318;
  t7207 = -0.5e1 / 0.72e2 * t3113 * t3018 - 0.5e1 / 0.82944e5 * t1066 * t50 * t308 * t312 + t1066 * t50 * t138 * t739 / 0.110592e6 + t3113 * t3236 * t6421 / 0.96e2 + 0.5e1 / 0.41472e5 * t3205 * t1404 * t3173 * t745 * t312 - t3196 * t3197 * t6305 / 0.512e3 + 0.25e2 / 0.82944e5 * t3167 * t3173 * t333 * t2806 + 0.5e1 / 0.442368e6 * t3167 * t3168 * t6241 - 0.25e2 / 0.63700992e8 * t5183 * t3183 * t7120 + 0.25e2 / 0.23887872e8 * t3184 * t1138 * t3174 * t326 - 0.5e1 / 0.63700992e8 * t3184 * t1138 * t1393 * t769 - 0.5e1 / 0.288e3 * t3196 * t7200 * t2828 - 0.5e1 / 0.221184e6 * t3167 * t3168 * t4639;
  t7253 = 0.25e2 / 0.10616832e8 * t3167 * t1392 * t774 * t6284 - 0.5e1 / 0.2304e4 * t3196 * t3173 * t750 * t2833 + t3196 * t3197 * t6260 / 0.768e3 - t3196 * t3201 * t6264 / 0.4096e4 + t3196 * t3201 * t4647 / 0.6144e4 - t3196 * t1392 * t1903 * t5248 * t743 / 0.110592e6 - t3205 * t1404 * t3206 * t739 / 0.110592e6 + 0.5e1 / 0.5308416e7 * t4528 * t6933 * t1404 * t1392 * t1894 * t743 - 0.5e1 / 0.62208e5 * t924 * t3227 - 0.65e2 / 0.1296e4 * t1374 * t3014 + 0.115e3 / 0.15552e5 * t1350 * t1404 * t1300 + 0.65e2 / 0.373248e6 * t401 * t7147 + t2240 * t1415 / 0.82944e5 + 0.65e2 / 0.1296e4 * t421 * t1186;
  t7260 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t716 * t1430 + t7041 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t292 * t3262 - t7019 + t7048 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t118 * (t7113 + t7159 + t7207 + t7253));
  tv4rho2lapl28 = t8 * t7260 + 0.2e1 * t3267;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t7267 = t7 * t194 * t3335 / 0.1e2;
  t7277 = t221 * t2867;
  t7280 = t1507 * t2861;
  t7283 = t3276 * t3309;
  t7291 = sigma[0] * t2624;
  t7292 = t1138 * t7291;
  t7299 = t3885 * t3275;
  t7300 = t3884 * t7299;
  t7305 = t3302 * t3309;
  t7323 = -t2656 * t1253 * t2658 / 0.36864e5 - 0.5e1 / 0.73728e5 * t1254 * t2666 - 0.5e1 / 0.21233664e8 * t2049 * t1138 * t3295 * t228 + t3270 * t7277 / 0.256e3 + t3270 * t7280 / 0.2048e4 - 0.3e1 / 0.128e3 * t7283 * t221 * t3862 * t214 + 0.7e1 / 0.10368e5 * t1154 * t1253 * t2669 - 0.5e1 / 0.248832e6 * t851 * t7292 + t1123 * t1126 * t2624 * t3271 / 0.12e2 + 0.5e1 / 0.442368e6 * t7300 * t3309 * t1508 * t214 + 0.5e1 / 0.36864e5 * t7305 * t236 * t3842 * t228 + 0.25e2 / 0.884736e6 * t7305 * t574 * t3910 * t228 - 0.25e2 / 0.5308416e7 * t6003 * t3290 * t3280 * t1539 * t1532 * t228 + 0.5e1 / 0.589824e6 * t2632 * t3295 * t1558;
  t7331 = t3279 * rho[0];
  t7332 = 0.1e1 / t7331;
  t7343 = t3277 * t7332;
  t7356 = t3990 * t3323;
  t7366 = 0.1e1 / t2851;
  t7384 = -0.3e1 / 0.1024e4 * t7283 * t1507 * t3853 * t214 - t7283 * t3875 * t4737 / 0.9216e4 + t3289 * t3290 * t7332 * t542 / 0.576e3 - t1137 * t7292 / 0.288e3 + 0.5e1 / 0.1152e4 * t3303 * t7332 * t235 * t2664 + 0.5e1 / 0.331776e6 * t3316 * t3317 * t7343 - t3278 * t7332 * t547 * t2063 / 0.32e2 - t3278 * t7332 * t220 * t2023 / 0.4e1 + t98 * t3989 * t7356 * t3325 * t244 / 0.96e2 + 0.35e2 / 0.254803968e9 * t3941 * t3942 * t3290 * t3280 * t228 - t3324 * t7366 * t593 * t594 / 0.48e2 - t3324 * t3325 * t1597 * t244 / 0.96e2 + t3330 * t3331 * t7366 / 0.48e2 - t1149 * t7291 * t87 / 0.216e3 - 0.5e1 / 0.9216e4 * t3308 * t7343 * t573;
  t7390 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t3335 + t7267 + 0.3e1 / 0.2e2 * t7 * t32 * (t7323 + t7384));
  tv4rhosigma30 = t8 * t7390 + t3339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t7397 = t7 * t268 * t3398 / 0.1e2;
  t7399 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t3398 + t7397);
  tv4rhosigma39 = t8 * t7399 + t3402;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t7405 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t3335 + t7267);
  tv4rhosigma310 = t8 * t7405 + t3339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t7414 = t319 * t2970;
  t7417 = t1893 * t2964;
  t7428 = t3276 * t3376;
  t7436 = t4528 * t7299;
  t7441 = t3302 * t3376;
  t7460 = sigma[2] * t2759;
  t7461 = t1138 * t7460;
  t7464 = -0.5e1 / 0.21233664e8 * t2187 * t1138 * t3363 * t326 + t3341 * t7414 / 0.256e3 + t3341 * t7417 / 0.2048e4 - t2797 * t1298 * t2799 / 0.36864e5 - 0.5e1 / 0.73728e5 * t1299 * t2807 + 0.5e1 / 0.589824e6 * t2773 * t3363 * t1936 - t7428 * t4568 * t5295 / 0.9216e4 - 0.3e1 / 0.128e3 * t7428 * t319 * t4515 * t312 + 0.5e1 / 0.442368e6 * t7436 * t3376 * t1894 * t312 + 0.5e1 / 0.36864e5 * t7441 * t334 * t4505 * t326 + 0.25e2 / 0.884736e6 * t7441 * t775 * t4584 * t326 - 0.25e2 / 0.5308416e7 * t4554 * t3358 * t3348 * t1539 * t1914 * t326 - 0.3e1 / 0.1024e4 * t7428 * t1893 * t4519 * t312 - 0.5e1 / 0.248832e6 * t936 * t7461;
  t7474 = t3347 * rho[1];
  t7475 = 0.1e1 / t7474;
  t7489 = t3345 * t7475;
  t7506 = 0.1e1 / t2954;
  t7524 = t1123 * t1126 * t2759 * t3342 / 0.12e2 + 0.7e1 / 0.10368e5 * t1212 * t1298 * t2810 - t1199 * t7461 / 0.288e3 + 0.5e1 / 0.1152e4 * t3370 * t7475 * t333 * t2805 - t3346 * t7475 * t750 * t2215 / 0.32e2 + 0.35e2 / 0.254803968e9 * t4612 * t3942 * t3358 * t3348 * t326 + 0.5e1 / 0.331776e6 * t3383 * t3317 * t7489 + t171 * t4497 * t7356 * t3389 * t342 / 0.96e2 - t3346 * t7475 * t318 * t2192 / 0.4e1 + t3357 * t3358 * t7475 * t745 / 0.576e3 - t3324 * t7506 * t794 * t594 / 0.48e2 - 0.5e1 / 0.9216e4 * t3375 * t7489 * t573 - t3324 * t3389 * t1958 * t342 / 0.96e2 + t3394 * t3331 * t7506 / 0.48e2 - t1149 * t7460 * t161 / 0.216e3;
  t7530 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t3398 + t7397 + 0.3e1 / 0.2e2 * t7 * t118 * (t7464 + t7524));
  tv4rhosigma319 = t8 * t7530 + t3402;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t7537 = t7 * t194 * t3467 / 0.1e2;
  t7546 = t1129 * t527;
  t7547 = 0.1e1 / t7546;
  t7548 = lapl[0] * t7547;
  t7556 = t7547 * t51;
  t7575 = t1585 * t2894;
  t7581 = params->c * t3323;
  t7596 = 0.35e2 / 0.254803968e9 * t5440 * t3403 * t3422 * t228 + 0.91e2 / 0.497664e6 * t3136 * t1138 * t2879 * params->beta2 + 0.35e2 / 0.2654208e7 * t2049 * t3438 * t7548 * t51 - 0.65e2 / 0.11943936e8 * t851 * t2894 * t6494 + 0.7e1 / 0.4608e4 * t3421 * t3403 * t7556 * t542 + 0.35e2 / 0.9216e4 * t3302 * t7556 * t3435 - 0.7e1 / 0.256e3 * t3404 * t7547 * t547 * t3408 - 0.7e1 / 0.32e2 * t3404 * t7547 * t220 * t3413 + 0.13e2 / 0.576e3 * t3417 * t2879 * t543 + 0.5e1 / 0.1769472e7 * t7575 * t1262 * t1242 * t573 * t228 + t4799 * t7581 * t3457 * t244 / 0.96e2 - 0.13e2 / 0.13824e5 * t984 * t1138 * t2879 - 0.35e2 / 0.73728e5 * t3439 * t7548 * t3441 - 0.5e1 / 0.63700992e8 * t2330 * t1138 * t1248 * t228;
  t7603 = t5537 * t3275;
  t7604 = t3884 * t7603;
  t7605 = t51 * t1508;
  t7615 = t1126 * t1242;
  t7623 = t6022 * t228;
  t7629 = t5992 * t228;
  t7634 = t6003 * t3438 * lapl[0];
  t7642 = t420 * t3403 * t3406;
  t7648 = t1574 * t51;
  t7659 = t1596 * t244;
  t7671 = t1240 * t1243 * t2688 / 0.768e3 + t1240 * t2858 * t2693 / 0.6144e4 + 0.5e1 / 0.442368e6 * t7604 * t3440 * t7605 * t214 - t2872 * t1262 * t1242 * t542 * t214 / 0.110592e6 - 0.5e1 / 0.221184e6 * t1148 * t7615 * t235 * t1256 * t2665 + 0.5e1 / 0.36864e5 * t3302 * t3422 * t235 * t1256 * t7623 + 0.25e2 / 0.884736e6 * t3302 * t3422 * t572 * t1256 * t7629 - 0.25e2 / 0.5308416e7 * t7634 * t3406 * t1539 * t51 * t1532 * t228 - 0.3e1 / 0.1024e4 * t7642 * t1507 * t3853 * t51 * t214 - t7642 * t3875 * t7648 * t214 / 0.9216e4 - 0.3e1 / 0.128e3 * t7642 * t221 * t3862 * t51 * t214 - t3456 * t3457 * t1595 * t7659 / 0.96e2 + 0.7e1 / 0.384e3 * t3330 * t3462 * t3323 * t3325 - 0.13e2 / 0.10368e5 * t1149 * t2885 - 0.7e1 / 0.384e3 * t3456 * t3327;
  t7677 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t3467 + t7537 + 0.3e1 / 0.2e2 * t7 * t32 * (t7596 + t7671));
  tv4rhosigma2lapl0 = t8 * t7677 + t3471;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t7684 = t7 * t268 * t3532 / 0.1e2;
  t7686 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t3532 + t7684);
  tv4rhosigma2lapl11 = t8 * t7686 + t3536;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t7692 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t3467 + t7537);
  tv4rhosigma2lapl12 = t8 * t7692 + t3471;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t7701 = t1191 * t730;
  t7702 = 0.1e1 / t7701;
  t7703 = lapl[1] * t7702;
  t7714 = t1877 * t2894;
  t7738 = t7702 * t127;
  t7751 = t420 * t3472 * t3475;
  t7757 = t5148 * t7581 * t3523 * t342 / 0.96e2 - 0.35e2 / 0.73728e5 * t3506 * t7703 * t3508 - 0.13e2 / 0.13824e5 * t1066 * t1138 * t2981 - 0.7e1 / 0.32e2 * t3473 * t7702 * t318 * t3482 + 0.5e1 / 0.1769472e7 * t7714 * t1307 * t1287 * t573 * t326 + 0.35e2 / 0.254803968e9 * t5744 * t3472 * t3490 * t326 + 0.91e2 / 0.497664e6 * t3257 * t1138 * t2981 * params->beta2 + 0.35e2 / 0.2654208e7 * t2187 * t3438 * t7703 * t127 - 0.65e2 / 0.11943936e8 * t936 * t2894 * t6780 + 0.13e2 / 0.576e3 * t3417 * t2981 * t746 + 0.7e1 / 0.4608e4 * t3489 * t3472 * t7738 * t745 + 0.35e2 / 0.9216e4 * t3302 * t7738 * t3503 - 0.7e1 / 0.256e3 * t3473 * t7702 * t750 * t3477 - 0.3e1 / 0.1024e4 * t7751 * t1893 * t4519 * t127 * t312;
  t7758 = t1952 * t127;
  t7770 = t6283 * t326;
  t7775 = t4554 * t3438 * lapl[1];
  t7792 = t4528 * t7603;
  t7793 = t127 * t1894;
  t7803 = t1126 * t1287;
  t7811 = t6240 * t326;
  t7818 = t1596 * t342;
  t7828 = -t7751 * t4568 * t7758 * t312 / 0.9216e4 - 0.3e1 / 0.128e3 * t7751 * t319 * t4515 * t127 * t312 + 0.25e2 / 0.884736e6 * t3302 * t3490 * t774 * t1301 * t7770 - 0.25e2 / 0.5308416e7 * t7775 * t3475 * t1539 * t127 * t1914 * t326 - 0.5e1 / 0.63700992e8 * t2500 * t1138 * t1293 * t326 + t1285 * t1288 * t2828 / 0.768e3 + t1285 * t2961 * t2833 / 0.6144e4 + 0.5e1 / 0.442368e6 * t7792 * t3507 * t7793 * t312 - t2974 * t1307 * t1287 * t745 * t312 / 0.110592e6 - 0.5e1 / 0.221184e6 * t1148 * t7803 * t333 * t1301 * t2806 + 0.5e1 / 0.36864e5 * t3302 * t3490 * t333 * t1301 * t7811 - 0.13e2 / 0.10368e5 * t1149 * t2987 - t3456 * t3523 * t1957 * t7818 / 0.96e2 + 0.7e1 / 0.384e3 * t3394 * t3462 * t3323 * t3389 - 0.7e1 / 0.384e3 * t3456 * t3391;
  t7834 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t3532 + t7684 + 0.3e1 / 0.2e2 * t7 * t118 * (t7757 + t7828));
  tv4rhosigma2lapl23 = t8 * t7834 + t3536;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t7841 = t7 * t194 * t3598 / 0.1e2;
  t7842 = t1129 * t53;
  t7843 = 0.1e1 / t7842;
  t7844 = t59 * t7843;
  t7848 = t1372 * t3323;
  t7896 = -0.5e1 / 0.12288e5 * t3569 * t7844 * t2897 + t4799 * t7848 * t3588 * t244 / 0.96e2 - 0.13e2 / 0.13824e5 * t984 * t1138 * t6479 + 0.5e1 / 0.1769472e7 * t7575 * t7615 * t2898 + 0.35e2 / 0.254803968e9 * t6882 * t3539 * t3542 * sigma[0] * t228 + 0.5e1 / 0.442368e6 * t2049 * t3568 * t7844 * sigma[0] - 0.65e2 / 0.11943936e8 * t851 * t2894 * t6512 + t3553 * t3539 * t7843 * t542 * sigma[0] / 0.768e3 + 0.5e1 / 0.1536e4 * t3562 * t7843 * t235 * t3564 + 0.91e2 / 0.497664e6 * t3136 * t1138 * t2903 + 0.13e2 / 0.576e3 * t3417 * t2855 - 0.3e1 / 0.128e3 * t3540 * t7843 * t547 * t3544 - 0.3e1 / 0.16e2 * t3540 * t7843 * t220 * t3549 - 0.5e1 / 0.63700992e8 * t2330 * t1138 * t2908;
  t7897 = t6932 * t3275;
  t7898 = t3884 * t7897;
  t7905 = t3539 * t3542;
  t7906 = t1349 * t7905;
  t7918 = t6003 * t3568 * t59;
  t7929 = t420 * t1138 * t1242;
  t7934 = t1332 * t7905;
  t7958 = 0.5e1 / 0.442368e6 * t7898 * t3570 * t2861 - t2872 * t7615 * t2875 / 0.110592e6 + 0.5e1 / 0.36864e5 * t7906 * t236 * t3842 * sigma[0] * t228 + 0.25e2 / 0.884736e6 * t7906 * t574 * t3910 * sigma[0] * t228 - 0.25e2 / 0.5308416e7 * t7918 * t3542 * t1539 * sigma[0] * t1532 * t228 - 0.5e1 / 0.221184e6 * t2889 * t996 * t2665 + t7929 * t7277 / 0.768e3 + t7929 * t7280 / 0.6144e4 - 0.3e1 / 0.1024e4 * t7934 * t1507 * t6484 * t214 - t7934 * t3875 * t2867 / 0.9216e4 - 0.3e1 / 0.128e3 * t7934 * t221 * t6489 * t214 - 0.13e2 / 0.10368e5 * t1149 * t6479 * t431 - t3587 * t3588 * t1595 * t7659 / 0.96e2 + t3330 * t3593 * t3463 / 0.64e2 - t3587 * t3459 / 0.64e2;
  t7964 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t3598 + t7841 + 0.3e1 / 0.2e2 * t7 * t32 * (t7896 + t7958));
  tv4rhosigmalapl20 = t8 * t7964 + t3602;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t7971 = t7 * t268 * t3661 / 0.1e2;
  t7973 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t3661 + t7971);
  tv4rhosigmalapl28 = t8 * t7973 + t3665;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t7979 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t3598 + t7841);
  tv4rhosigmalapl29 = t8 * t7979 + t3602;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t7984 = t1191 * t129;
  t7985 = 0.1e1 / t7984;
  t8001 = t134 * t7985;
  t8034 = t3605 * t3608;
  t8035 = t1349 * t8034;
  t8041 = -0.3e1 / 0.128e3 * t3606 * t7985 * t750 * t3610 - 0.3e1 / 0.16e2 * t3606 * t7985 * t318 * t3615 + t3619 * t3605 * t7985 * t745 * sigma[2] / 0.768e3 + 0.13e2 / 0.576e3 * t3417 * t2958 - 0.5e1 / 0.12288e5 * t3634 * t8001 * t2997 + t5148 * t7848 * t3652 * t342 / 0.96e2 - 0.13e2 / 0.13824e5 * t1066 * t1138 * t6770 + 0.5e1 / 0.442368e6 * t2187 * t3568 * t8001 * sigma[2] - 0.65e2 / 0.11943936e8 * t936 * t2894 * t6729 + 0.5e1 / 0.1769472e7 * t7714 * t7803 * t2998 + 0.35e2 / 0.254803968e9 * t7118 * t3605 * t3608 * sigma[2] * t326 + 0.5e1 / 0.1536e4 * t3628 * t7985 * t333 * t3630 + 0.91e2 / 0.497664e6 * t3257 * t1138 * t3003 + 0.25e2 / 0.884736e6 * t8035 * t775 * t4584 * sigma[2] * t326;
  t8043 = t4554 * t3568 * t134;
  t8054 = t420 * t1138 * t1287;
  t8059 = t1332 * t8034;
  t8074 = t4528 * t7897;
  t8098 = -0.25e2 / 0.5308416e7 * t8043 * t3608 * t1539 * sigma[2] * t1914 * t326 - 0.5e1 / 0.221184e6 * t2991 * t1078 * t2806 + t8054 * t7414 / 0.768e3 + t8054 * t7417 / 0.6144e4 - 0.3e1 / 0.1024e4 * t8059 * t1893 * t6715 * t312 - t8059 * t4568 * t2970 / 0.9216e4 - 0.3e1 / 0.128e3 * t8059 * t319 * t6775 * t312 - 0.5e1 / 0.63700992e8 * t2500 * t1138 * t3008 + 0.5e1 / 0.442368e6 * t8074 * t3635 * t2964 - t2974 * t7803 * t2977 / 0.110592e6 + 0.5e1 / 0.36864e5 * t8035 * t334 * t4505 * sigma[2] * t326 - 0.13e2 / 0.10368e5 * t1149 * t6770 * t464 - t3587 * t3652 * t1957 * t7818 / 0.96e2 + t3394 * t3593 * t3528 / 0.64e2 - t3587 * t3525 / 0.64e2;
  t8104 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t3661 + t7971 + 0.3e1 / 0.2e2 * t7 * t118 * (t8041 + t8098));
  tv4rhosigmalapl217 = t8 * t8104 + t3665;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t8111 = t7 * t194 * t3735 / 0.1e2;
  t8119 = lapl[0] * t3056;
  t8127 = t3885 * t3670;
  t8160 = t3942 * t3697;
  t8166 = 0.1e1 / t2622;
  t8171 = t3722 * t3323;
  t8176 = -0.25e2 / 0.1990656e7 * t851 * t1365 * t1262 * t3056 + 0.5e1 / 0.96e2 * t1333 * t6920 * t3666 + 0.35e2 / 0.82944e5 * t1357 * t1138 * t8119 * params->beta2 + 0.5e1 / 0.589824e6 * t3130 * t1262 * t3132 + 0.5e1 / 0.442368e6 * t3884 * t8127 * t3673 * t3675 * t1508 * t214 + 0.5e1 / 0.36864e5 * t3699 * t3700 * t7623 + 0.25e2 / 0.884736e6 * t3699 * t3675 * t572 * t7629 - 0.25e2 / 0.5308416e7 * t6003 * t3713 * t3714 * t1539 * t1532 * t228 - 0.3e1 / 0.1024e4 * t3674 * t3676 * t4946 * t214 - t3674 * t3675 * t1517 * t5527 * t214 / 0.9216e4 - 0.3e1 / 0.128e3 * t3674 * t3680 * t4885 * t214 + 0.35e2 / 0.254803968e9 * t3941 * t8160 * t3673 * t3675 * t228 + 0.25e2 / 0.2654208e7 * t2049 * t3713 * t3672 * t8166 + t4799 * t8171 * t3725 * t244 / 0.96e2;
  t8197 = t1332 * t1138 * t1335;
  t8198 = t1508 * lapl[0];
  t8213 = t1574 * lapl[0];
  t8234 = 0.5e1 / 0.4608e4 * t3685 * t3673 * t8166 * t542 - 0.5e1 / 0.2304e4 * t1341 * t1138 * t8119 + 0.25e2 / 0.9216e4 * t3699 * t8166 * t235 * t2664 - 0.5e1 / 0.256e3 * t3674 * t8166 * t547 * t2063 - 0.5e1 / 0.32e2 * t3674 * t8166 * t220 * t2023 + t8197 * t1507 * t8198 * t214 / 0.2048e4 - t3043 * t1262 * t3045 / 0.36864e5 - 0.5e1 / 0.73728e5 * t1349 * t1239 * t3052 - 0.5e1 / 0.21233664e8 * t3067 * t1138 * t3690 * t228 + t8197 * t221 * t8213 * t214 / 0.256e3 - 0.25e2 / 0.73728e5 * t3704 * t3673 * t8166 * t573 - t3724 * t3725 * t1595 * t7659 / 0.96e2 + 0.5e1 / 0.384e3 * t3330 * t3730 * t3594 - 0.5e1 / 0.1728e4 * t1350 * t1262 * t3103 - 0.5e1 / 0.384e3 * t3724 * t3590;
  t8240 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t189 * t3735 + t8111 + 0.3e1 / 0.2e2 * t7 * t32 * (t8176 + t8234));
  tv4rholapl30 = t8 * t8240 + t3739;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t8247 = t7 * t268 * t3799 / 0.1e2;
  t8249 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t264 * t3799 + t8247);
  tv4rholapl33 = t8 * t8249 + t3803;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t8255 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t281 * t3735 + t8111);
  tv4rholapl34 = t8 * t8255 + t3739;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t8272 = lapl[1] * t3173;
  t8307 = 0.1e1 / t2757;
  t8320 = -t3746 * t3747 * t1903 * t5248 * t312 / 0.9216e4 - 0.3e1 / 0.128e3 * t3746 * t3752 * t5197 * t312 + 0.5e1 / 0.589824e6 * t3251 * t1307 * t3253 + 0.35e2 / 0.82944e5 * t1410 * t1138 * t8272 * params->beta2 - 0.25e2 / 0.1990656e7 * t936 * t1365 * t1307 * t3173 + 0.5e1 / 0.96e2 * t1333 * t7200 * t3740 + 0.5e1 / 0.442368e6 * t4528 * t8127 * t3745 * t3747 * t1894 * t312 + 0.5e1 / 0.36864e5 * t3768 * t3769 * t7811 + 0.25e2 / 0.884736e6 * t3768 * t3747 * t774 * t7770 - 0.25e2 / 0.5308416e7 * t4554 * t3713 * t3782 * t1539 * t1914 * t326 - 0.3e1 / 0.1024e4 * t3746 * t3748 * t5162 * t312 + 0.25e2 / 0.9216e4 * t3768 * t8307 * t333 * t2805 - 0.5e1 / 0.256e3 * t3746 * t8307 * t750 * t2215 - 0.5e1 / 0.32e2 * t3746 * t8307 * t318 * t2192;
  t8352 = t1332 * t1138 * t1392;
  t8353 = t1952 * lapl[1];
  t8358 = t1894 * lapl[1];
  t8379 = 0.25e2 / 0.2654208e7 * t2187 * t3713 * t3744 * t8307 + t5148 * t8171 * t3790 * t342 / 0.96e2 + 0.35e2 / 0.254803968e9 * t4612 * t8160 * t3745 * t3747 * t326 + 0.5e1 / 0.4608e4 * t3756 * t3745 * t8307 * t745 - 0.5e1 / 0.2304e4 * t1397 * t1138 * t8272 - t3205 * t1307 * t3207 / 0.36864e5 - 0.5e1 / 0.73728e5 * t1349 * t1284 * t3169 - 0.5e1 / 0.21233664e8 * t3184 * t1138 * t3761 * t326 + t8352 * t319 * t8353 * t312 / 0.256e3 + t8352 * t1893 * t8358 * t312 / 0.2048e4 - 0.25e2 / 0.73728e5 * t3773 * t3745 * t8307 * t573 - t3724 * t3790 * t1957 * t7818 / 0.96e2 + 0.5e1 / 0.384e3 * t3394 * t3730 * t3657 - 0.5e1 / 0.1728e4 * t1350 * t1307 * t3223 - 0.5e1 / 0.384e3 * t3724 * t3654;
  t8385 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t292 * t3799 + t8247 + 0.3e1 / 0.2e2 * t7 * t118 * (t8320 + t8379));
  tv4rholapl37 = t8 * t8385 + t3803;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t8390 = t51 * t3280;
  t8395 = t1597 * t38;
  t8401 = t51 * t51;
  t8404 = 0.1e1 / t40 / t3279 / t53;
  t8405 = t8401 * t8404;
  t8406 = t3276 * t8405;
  t8409 = t3875 * t1574 * t47 * t49;
  t8414 = t1507 * t3853 * t47 * t49;
  t8419 = t221 * t3862 * t47 * t49;
  t8423 = t1508 * t47 * t49;
  t8427 = t3302 * t8405;
  t8429 = t3910 * t47 * t49;
  t8430 = t574 * t8429;
  t8434 = t3842 * t47 * t49;
  t8435 = t236 * t8434;
  t8443 = t1532 * t47 * t49;
  t8453 = t3942 * t3275;
  t8458 = t573 * t33;
  t8470 = t1123 * t1126;
  t8473 = t3276 * t3280;
  t8474 = t1507 * t7605;
  t8477 = t221 * t7648;
  t8483 = -0.25e2 / 0.2654208e7 * t6003 * t3275 * t8401 * t8404 * t1539 * t8443 - 0.7e1 / 0.110592e6 * t1578 * t1138 * t1155 - 0.5e1 / 0.884736e6 * t3316 * t3317 * t8390 + 0.35e2 / 0.127401984e9 * t3941 * t8453 * t8405 * t50 + 0.5e1 / 0.2654208e7 * t1557 * t8458 * t3269 + t4799 * t3323 * t1132 * t38 / 0.2304e4 - t3289 * t3275 * t51 * t3291 / 0.1536e4 - t8470 * t1134 / 0.128e3 + 0.3e1 / 0.256e3 * t8473 * t8474 + 0.3e1 / 0.32e2 * t8473 * t8477 + t1137 * t1138 * t1132 / 0.3072e4;
  t8488 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (-0.5e1 / 0.3072e4 * t3302 * t51 * t3305 + 0.5e1 / 0.24576e5 * t3308 * t8390 * t573 - t3324 * t1132 * t8395 / 0.2304e4 + t1148 * t3269 * t87 / 0.2304e4 - t8406 * t8409 / 0.4608e4 - 0.3e1 / 0.512e3 * t8406 * t8414 - 0.3e1 / 0.64e2 * t8406 * t8419 + 0.5e1 / 0.221184e6 * t7300 * t8405 * t8423 + 0.25e2 / 0.442368e6 * t8427 * t8430 + 0.5e1 / 0.18432e5 * t8427 * t8435 + t8483));
  tv4sigma40 = t8 * t8488;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t8499 = t127 * t3348;
  t8504 = t1958 * t38;
  t8507 = t3276 * t3348;
  t8508 = t1893 * t7793;
  t8511 = t319 * t7758;
  t8520 = t127 * t127;
  t8523 = 0.1e1 / t120 / t3347 / t129;
  t8524 = t8520 * t8523;
  t8525 = t3276 * t8524;
  t8528 = t319 * t4515 * t47 * t49;
  t8533 = t1894 * t47 * t49;
  t8537 = t3302 * t8524;
  t8539 = t4584 * t47 * t49;
  t8540 = t775 * t8539;
  t8544 = t4505 * t47 * t49;
  t8545 = t334 * t8544;
  t8552 = t1914 * t47 * t49;
  t8558 = t4568 * t1952 * t47 * t49;
  t8563 = t1893 * t4519 * t47 * t49;
  t8582 = 0.5e1 / 0.221184e6 * t7436 * t8524 * t8533 + 0.25e2 / 0.442368e6 * t8537 * t8540 + 0.5e1 / 0.18432e5 * t8537 * t8545 - 0.25e2 / 0.2654208e7 * t4554 * t3275 * t8520 * t8523 * t1539 * t8552 - t8525 * t8558 / 0.4608e4 - 0.3e1 / 0.512e3 * t8525 * t8563 - t3357 * t3275 * t127 * t3359 / 0.1536e4 - 0.7e1 / 0.110592e6 * t1930 * t1138 * t1213 - 0.5e1 / 0.884736e6 * t3383 * t3317 * t8499 + 0.35e2 / 0.127401984e9 * t4612 * t8453 * t8524 * t50 - t8470 * t1196 / 0.128e3;
  t8587 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * (0.5e1 / 0.2654208e7 * t1935 * t8458 * t3340 + t5148 * t3323 * t1194 * t38 / 0.2304e4 - 0.5e1 / 0.3072e4 * t3302 * t127 * t3372 + 0.5e1 / 0.24576e5 * t3375 * t8499 * t573 - t3324 * t1194 * t8504 / 0.2304e4 + 0.3e1 / 0.256e3 * t8507 * t8508 + 0.3e1 / 0.32e2 * t8507 * t8511 + t1199 * t1138 * t1194 / 0.3072e4 + t1148 * t3340 * t161 / 0.2304e4 - 0.3e1 / 0.64e2 * t8525 * t8528 + t8582));
  tv4sigma414 = t8 * t8587;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t8609 = t5439 * t3275;
  t8613 = 0.1e1 / t40 / t3279 / t61;
  t8614 = lapl[0] * t8613;
  t8616 = t3277 * t47 * t49;
  t8635 = t3277 * t8613;
  t8654 = t420 * t3403 * t8613;
  t8664 = -t440 * t3323 * t2853 * t8395 / 0.2304e4 + t4799 * t7581 * t2853 * t33 * t37 / 0.2304e4 - 0.5e1 / 0.6144e4 * t3302 * t3406 * t235 * t1256 * t3564 + 0.5e1 / 0.49152e5 * t3439 * t3440 * t2897 - 0.5e1 / 0.1769472e7 * t2049 * t3438 * t3440 * sigma[0] + 0.35e2 / 0.127401984e9 * t3941 * t8609 * t8614 * t8616 + 0.3e1 / 0.64e2 * t3404 * t3412 * t3549 - t3421 * t3403 * t3406 * sigma[0] * t542 / 0.3072e4 + 0.3e1 / 0.512e3 * t3404 * t3407 * t3544 + 0.5e1 / 0.221184e6 * t7604 * t8614 * t3277 * t8423 + 0.25e2 / 0.442368e6 * t3302 * t8635 * t572 * t1256 * t573 * t8429 + 0.5e1 / 0.18432e5 * t3302 * t8635 * t235 * t1256 * params->beta2 * t8434 - 0.25e2 / 0.2654208e7 * t7634 * t8613 * t1539 * t3277 * t8443 - t8654 * t3876 * t8616 / 0.4608e4 - 0.3e1 / 0.512e3 * t8654 * t3854 * t8616 - 0.3e1 / 0.64e2 * t8654 * t3863 * t8616;
  t8668 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t8664);
  tv4sigma3lapl0 = t8 * t8668;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t8689 = 0.1e1 / t120 / t3347 / t136;
  t8690 = lapl[1] * t8689;
  t8692 = t3345 * t47 * t49;
  t8712 = t420 * t3472 * t8689;
  t8723 = t3345 * t8689;
  t8744 = -t440 * t3323 * t2956 * t8504 / 0.2304e4 + t5148 * t7581 * t2956 * t33 * t37 / 0.2304e4 + 0.5e1 / 0.49152e5 * t3506 * t3507 * t2997 - 0.5e1 / 0.6144e4 * t3302 * t3475 * t333 * t1301 * t3630 + 0.35e2 / 0.127401984e9 * t4612 * t8609 * t8690 * t8692 - t3489 * t3472 * t3475 * sigma[2] * t745 / 0.3072e4 - 0.5e1 / 0.1769472e7 * t2187 * t3438 * t3507 * sigma[2] + 0.3e1 / 0.512e3 * t3473 * t3476 * t3610 + 0.3e1 / 0.64e2 * t3473 * t3481 * t3615 - 0.3e1 / 0.512e3 * t8712 * t4520 * t8692 - 0.3e1 / 0.64e2 * t8712 * t4516 * t8692 + 0.5e1 / 0.221184e6 * t7792 * t8690 * t3345 * t8533 + 0.25e2 / 0.442368e6 * t3302 * t8723 * t774 * t1301 * t573 * t8539 + 0.5e1 / 0.18432e5 * t3302 * t8723 * t333 * t1301 * params->beta2 * t8544 - 0.25e2 / 0.2654208e7 * t7775 * t8689 * t1539 * t3345 * t8552 - t8712 * t4569 * t8692 / 0.4608e4;
  t8748 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t8744);
  tv4sigma3lapl19 = t8 * t8748;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t8778 = t3275 * t3406;
  t8779 = t420 * t8778;
  t8791 = -0.7e1 / 0.331776e6 * t3136 * t1138 * t1263 - 0.5e1 / 0.5308416e7 * t2049 * t3568 * t3570 + 0.5e1 / 0.7962624e7 * t851 * t2894 * t7615 + t3540 * t3548 * t2023 / 0.64e2 - t3553 * t3539 * t3554 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3562 * t3563 * t2664 - t3417 * t1243 * t824 / 0.384e3 + t3540 * t3543 * t2063 / 0.512e3 + t4799 * t7848 * t1242 * t33 * t37 / 0.2304e4 + t8779 * t8474 / 0.512e3 + t8779 * t8477 / 0.64e2 - t3421 * t8778 * t51 * t542 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3432 * t996 * t2664;
  t8799 = t6881 * t3275;
  t8802 = 0.1e1 / t40 / t7331;
  t8803 = t59 * t8802;
  t8805 = t51 * t47 * t49;
  t8809 = params->a * t33;
  t8829 = t3539 * t8802;
  t8830 = t1349 * t8829;
  t8842 = t1332 * t8829;
  t8852 = -0.5e1 / 0.5308416e7 * t2049 * t3438 * t3422 - t1373 * t3323 * t1242 * t8395 / 0.2304e4 + 0.35e2 / 0.127401984e9 * t3941 * t8799 * t8803 * t8805 + t1137 * t8809 * t7615 / 0.9216e4 + 0.5e1 / 0.147456e6 * t1585 * t1348 * t3539 * t3542 * t573 + 0.5e1 / 0.147456e6 * t1585 * params->b * t8778 * t3441 + t1149 * t1255 * params->b / 0.6912e4 + 0.5e1 / 0.221184e6 * t7898 * t8803 * t1508 * t8805 + 0.25e2 / 0.442368e6 * t8830 * t3911 * t8805 + 0.5e1 / 0.18432e5 * t8830 * t3843 * t8805 - 0.25e2 / 0.2654208e7 * t7918 * t8802 * t1539 * t51 * t8443 - t8842 * t3876 * t8805 / 0.4608e4 - 0.3e1 / 0.512e3 * t8842 * t3854 * t8805 - 0.3e1 / 0.64e2 * t8842 * t3863 * t8805;
  t8857 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (t8791 + t8852));
  tv4sigma2lapl20 = t8 * t8857;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t8867 = t3275 * t3475;
  t8868 = t420 * t8867;
  t8899 = -0.7e1 / 0.331776e6 * t3257 * t1138 * t1308 - 0.5e1 / 0.5308416e7 * t2187 * t3568 * t3635 + 0.5e1 / 0.7962624e7 * t936 * t2894 * t7803 + t8868 * t8508 / 0.512e3 + t8868 * t8511 / 0.64e2 - t3489 * t8867 * t127 * t745 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3500 * t1078 * t2805 - 0.5e1 / 0.5308416e7 * t2187 * t3438 * t3490 - t1373 * t3323 * t1287 * t8504 / 0.2304e4 + t3606 * t3609 * t2215 / 0.512e3 + t3606 * t3614 * t2192 / 0.64e2 - t3619 * t3605 * t3620 / 0.9216e4 - 0.5e1 / 0.18432e5 * t3628 * t3629 * t2805;
  t8910 = 0.1e1 / t120 / t7474;
  t8911 = t134 * t8910;
  t8913 = t127 * t47 * t49;
  t8936 = t3605 * t8910;
  t8937 = t1349 * t8936;
  t8949 = t1332 * t8936;
  t8959 = -t3417 * t1288 * t910 / 0.384e3 + t5148 * t7848 * t1287 * t33 * t37 / 0.2304e4 + 0.35e2 / 0.127401984e9 * t4612 * t8799 * t8911 * t8913 + t1199 * t8809 * t7803 / 0.9216e4 + 0.5e1 / 0.147456e6 * t1877 * t1348 * t3605 * t3608 * t573 + 0.5e1 / 0.147456e6 * t1877 * params->b * t8867 * t3508 + t1149 * t1300 * params->b / 0.6912e4 + 0.5e1 / 0.221184e6 * t8074 * t8911 * t1894 * t8913 + 0.25e2 / 0.442368e6 * t8937 * t4585 * t8913 + 0.5e1 / 0.18432e5 * t8937 * t4506 * t8913 - 0.25e2 / 0.2654208e7 * t8043 * t8910 * t1539 * t127 * t8552 - t8949 * t4569 * t8913 / 0.4608e4 - 0.3e1 / 0.512e3 * t8949 * t4520 * t8913 - 0.3e1 / 0.64e2 * t8949 * t4516 * t8913;
  t8964 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * (t8899 + t8959));
  tv4sigma2lapl217 = t8 * t8964;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t8966 = t1332 * t3275 * t3542;
  t8976 = 0.1e1 / t40 / t7546;
  t8977 = t3673 * t8976;
  t8978 = t3671 * t8977;
  t8979 = t50 * sigma[0];
  t8989 = t8127 * t3275;
  t8991 = t3672 * t8976;
  t9002 = t3698 * t8977;
  t9016 = lapl[0] * t3542;
  t9020 = t8160 * t3275;
  t9038 = 0.3e1 / 0.512e3 * t8966 * t1507 * t8198 * sigma[0] + 0.3e1 / 0.64e2 * t8966 * t221 * t8213 * sigma[0] - t8978 * t3876 * t8979 / 0.4608e4 - 0.3e1 / 0.512e3 * t8978 * t3854 * t8979 - 0.3e1 / 0.64e2 * t8978 * t3863 * t8979 + 0.5e1 / 0.221184e6 * t3884 * t8989 * t8991 * t1508 * t8979 - t3553 * t3403 * t3555 / 0.3072e4 - 0.5e1 / 0.6144e4 * t1349 * t3403 * t3565 + 0.25e2 / 0.442368e6 * t9002 * t3911 * t8979 + 0.5e1 / 0.18432e5 * t9002 * t3843 * t8979 - 0.25e2 / 0.2654208e7 * t6003 * t3713 * t3672 * t8976 * t1539 * t1532 * t8979 + 0.5e1 / 0.49152e5 * t3569 * t9016 * t2897 + 0.35e2 / 0.127401984e9 * t3941 * t9020 * t8991 * t8979 - 0.5e1 / 0.1769472e7 * t2049 * t3568 * t9016 * sigma[0] - t3723 * t3323 * t3056 * t8395 / 0.2304e4 + t4799 * t8171 * t3056 * t33 * t37 / 0.2304e4;
  t9042 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t9038);
  tv4sigmalapl30 = t8 * t9042;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t9044 = t1332 * t3275 * t3608;
  t9054 = 0.1e1 / t120 / t7701;
  t9055 = t3745 * t9054;
  t9056 = t3671 * t9055;
  t9057 = t50 * sigma[2];
  t9068 = t3744 * t9054;
  t9079 = t3698 * t9055;
  t9093 = lapl[1] * t3608;
  t9114 = 0.3e1 / 0.512e3 * t9044 * t1893 * t8358 * sigma[2] + 0.3e1 / 0.64e2 * t9044 * t319 * t8353 * sigma[2] - t9056 * t4569 * t9057 / 0.4608e4 - 0.3e1 / 0.512e3 * t9056 * t4520 * t9057 - 0.3e1 / 0.64e2 * t9056 * t4516 * t9057 + 0.5e1 / 0.221184e6 * t4528 * t8989 * t9068 * t1894 * t9057 - t3619 * t3472 * t3621 / 0.3072e4 - 0.5e1 / 0.6144e4 * t1349 * t3472 * t3631 + 0.25e2 / 0.442368e6 * t9079 * t4585 * t9057 + 0.5e1 / 0.18432e5 * t9079 * t4506 * t9057 - 0.25e2 / 0.2654208e7 * t4554 * t3713 * t3744 * t9054 * t1539 * t1914 * t9057 + 0.5e1 / 0.49152e5 * t3634 * t9093 * t2997 + 0.35e2 / 0.127401984e9 * t4612 * t9020 * t9068 * t9057 - 0.5e1 / 0.1769472e7 * t2187 * t3568 * t9093 * sigma[2] - t3723 * t3323 * t3173 * t8504 / 0.2304e4 + t5148 * t8171 * t3173 * t33 * t37 / 0.2304e4;
  t9118 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * t9114);
  tv4sigmalapl311 = t8 * t9118;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t9122 = t1372 * t1372;
  t9123 = params->A3 * t9122;
  t9129 = t3671 * t3275 * t3675;
  t9138 = t1331 * t33;
  t9139 = t1126 * t1335;
  t9150 = t1348 * t1348;
  t9151 = t3942 * t9150;
  t9153 = t59 * t59;
  t9154 = t3275 * t9153;
  t9156 = 0.1e1 / t40 / t7842;
  t9165 = t9122 * t3323;
  t9182 = params->A2 * t9150;
  t9183 = t9154 * t9156;
  t9184 = t9182 * t9183;
  t9189 = t9150 * t3275;
  t9196 = t1331 * t1331;
  t9197 = params->A1 * t9196;
  t9198 = t9197 * t9183;
  t9206 = t3885 * t9196 * t3275;
  t9215 = -t3685 * t3539 * t3686 / 0.1536e4 - 0.7e1 / 0.110592e6 * t1357 * t1138 * t1335 * params->beta2 - t1333 * t3080 * t824 / 0.128e3 + 0.25e2 / 0.442368e6 * t9184 * t8430 + 0.5e1 / 0.18432e5 * t9184 * t8435 - 0.25e2 / 0.2654208e7 * t6003 * t9189 * t9153 * t9156 * t1539 * t8443 - t9198 * t8409 / 0.4608e4 - 0.3e1 / 0.512e3 * t9198 * t8414 - 0.3e1 / 0.64e2 * t9198 * t8419 + 0.5e1 / 0.221184e6 * t3884 * t9206 * t9153 * t9156 * t8423 + t1350 * t9139 * t87 / 0.2304e4;
  t9220 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.24576e5 * t3704 * t3539 * t3705 - t9123 * t3323 * t1335 * t8395 / 0.2304e4 + 0.3e1 / 0.256e3 * t9129 * t1507 * t1508 * t59 + 0.3e1 / 0.32e2 * t9129 * t221 * t1574 * t59 + t1137 * t9138 * t9139 / 0.3072e4 - 0.5e1 / 0.3072e4 * t3698 * t3539 * t3701 - 0.5e1 / 0.884736e6 * t2049 * t3713 * t59 * t3675 + 0.35e2 / 0.127401984e9 * t3941 * t9151 * t9154 * t9156 * t47 * t49 + 0.5e1 / 0.2654208e7 * t851 * t1365 * t9139 + t4799 * t9165 * t1335 * t33 * t37 / 0.2304e4 + t9215));
  tv4lapl40 = t8 * t9220;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t9226 = t3671 * t3275 * t3747;
  t9235 = t1126 * t1392;
  t9254 = t134 * t134;
  t9255 = t3275 * t9254;
  t9257 = 0.1e1 / t120 / t7984;
  t9283 = t9255 * t9257;
  t9284 = t9182 * t9283;
  t9295 = t9197 * t9283;
  t9305 = t5148 * t9165 * t1392 * t33 * t37 / 0.2304e4 - t3756 * t3605 * t3757 / 0.1536e4 - t1333 * t3197 * t910 / 0.128e3 + 0.5e1 / 0.221184e6 * t4528 * t9206 * t9254 * t9257 * t8533 + 0.25e2 / 0.442368e6 * t9284 * t8540 + 0.5e1 / 0.18432e5 * t9284 * t8545 - 0.25e2 / 0.2654208e7 * t4554 * t9189 * t9254 * t9257 * t1539 * t8552 - t9295 * t8558 / 0.4608e4 - 0.3e1 / 0.512e3 * t9295 * t8563 - 0.3e1 / 0.64e2 * t9295 * t8528 + t1350 * t9235 * t161 / 0.2304e4;
  t9310 = my_piecewise3(t108, 0, 0.3e1 / 0.2e2 * t7 * t118 * (-t9123 * t3323 * t1392 * t8504 / 0.2304e4 + 0.3e1 / 0.256e3 * t9226 * t1893 * t1894 * t134 + 0.3e1 / 0.32e2 * t9226 * t319 * t1952 * t134 + t1199 * t9138 * t9235 / 0.3072e4 - 0.5e1 / 0.3072e4 * t3698 * t3605 * t3770 + 0.5e1 / 0.24576e5 * t3773 * t3605 * t3774 - 0.7e1 / 0.110592e6 * t1410 * t1138 * t1392 * params->beta2 - 0.5e1 / 0.884736e6 * t2187 * t3713 * t134 * t3747 + 0.35e2 / 0.127401984e9 * t4612 * t9151 * t9255 * t9257 * t47 * t49 + 0.5e1 / 0.2654208e7 * t936 * t1365 * t9235 + t9305));
  tv4lapl44 = t8 * t9310;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

