/*
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_k_pgslb.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t36, t37, t41, t44, t45;
  double t46, t48, t49, t50, t51, t52, t54, t58;
  double t62;

#ifndef XC_DONT_COMPILE_VXC
  double t64, t69, t77, t83, t88, t91, t97, t101;
  double t104, t107, t110;

#ifndef XC_DONT_COMPILE_FXC
  double t115, t123, t131, t132, t133, t134, t135, t138;
  double t143, t149, t154, t160, t166, t168, t170, t174;
  double t179, t183, t186, t190, t191, t193, t196, t198;
  double t201;

#ifndef XC_DONT_COMPILE_KXC
  double t206, t217, t225, t227, t232, t233, t234, t235;
  double t236, t238, t246, t251, t261, t272, t277, t282;
  double t288, t292, t295, t298, t299, t300, t305, t310;
  double t317;

#ifndef XC_DONT_COMPILE_LXC
  double t334, t344, t350, t355, t356, t357, t364, t375;
  double t388, t414, t420, t437, t442, t448, t462, t471;
#endif

#endif

#endif

#endif

#endif


  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t29 = 0.1e1 / t28;
  t30 = t25 * t29;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t37 = t33 * t36;
  t41 = params->pgslb_mu * t25 * t29;
  t44 = exp(-t41 * t37 / 0.24e2);
  t45 = t25 * t25;
  t46 = params->pgslb_beta * t45;
  t48 = 0.1e1 / t27 / t26;
  t49 = t46 * t48;
  t50 = lapl[0] * lapl[0];
  t51 = t50 * t31;
  t52 = t34 * rho[0];
  t54 = 0.1e1 / t22 / t52;
  t58 = 0.5e1 / 0.72e2 * t30 * t37 + t44 + t49 * t51 * t54 / 0.288e3;
  t62 = my_piecewise3(t3, 0, 0.3e1 / 0.20e2 * t8 * t24 * t58);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t62;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t64 = t21 / t22;
  t69 = 0.1e1 / t23 / t52;
  t77 = t34 * t34;
  t83 = -0.5e1 / 0.27e2 * t30 * t33 * t69 + t41 * t33 * t69 * t44 / 0.9e1 - 0.5e1 / 0.432e3 * t49 * t51 / t22 / t77;
  t88 = my_piecewise3(t3, 0, t8 * t64 * t58 / 0.10e2 + 0.3e1 / 0.20e2 * t8 * t24 * t83);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t88 + 0.2e1 * t62;

  t91 = t32 * t36;
  t97 = 0.5e1 / 0.72e2 * t30 * t91 - t41 * t91 * t44 / 0.24e2;
  t101 = my_piecewise3(t3, 0, 0.3e1 / 0.20e2 * t8 * t24 * t97);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.2e1 * rho[0] * t101;

  t104 = t8 * t21 * t36;
  t107 = t46 * t48 * lapl[0] * t31;
  t110 = my_piecewise3(t3, 0, t104 * t107 / 0.960e3);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = 0.2e1 * rho[0] * t110;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t115 = t21 / t22 / rho[0];
  t123 = 0.1e1 / t23 / t77;
  t131 = params->pgslb_mu * params->pgslb_mu;
  t132 = t131 * t45;
  t133 = t132 * t48;
  t134 = sigma[0] * sigma[0];
  t135 = t134 * t31;
  t138 = 0.1e1 / t22 / t77 / t52;
  t143 = t77 * rho[0];
  t149 = 0.55e2 / 0.81e2 * t30 * t33 * t123 - 0.11e2 / 0.27e2 * t41 * t33 * t123 * t44 + 0.2e1 / 0.81e2 * t133 * t135 * t138 * t44 + 0.65e2 / 0.1296e4 * t49 * t51 / t22 / t143;
  t154 = my_piecewise3(t3, 0, -t8 * t115 * t58 / 0.30e2 + t8 * t64 * t83 / 0.5e1 + 0.3e1 / 0.20e2 * t8 * t24 * t149);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t154 + 0.4e1 * t88;

  t160 = t32 * t69;
  t166 = t77 * t34;
  t168 = 0.1e1 / t22 / t166;
  t170 = sigma[0] * t44;
  t174 = -0.5e1 / 0.27e2 * t30 * t160 + t41 * t160 * t44 / 0.9e1 - t133 * t31 * t168 * t170 / 0.108e3;
  t179 = my_piecewise3(t3, 0, t8 * t64 * t97 / 0.10e2 + 0.3e1 / 0.20e2 * t8 * t24 * t174);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.2e1 * rho[0] * t179 + 0.2e1 * t101;

  t183 = t8 * t21 * t69;
  t186 = my_piecewise3(t3, 0, -t183 * t107 / 0.360e3);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = 0.2e1 * rho[0] * t186 + 0.2e1 * t110;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = 0.0e0;

  t190 = t8 * t21 * t123;
  t191 = t48 * t31;
  t193 = t132 * t191 * t44;
  t196 = my_piecewise3(t3, 0, t190 * t193 / 0.1920e4);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.2e1 * rho[0] * t196;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  t198 = t46 * t191;
  t201 = my_piecewise3(t3, 0, t104 * t198 / 0.960e3);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = 0.2e1 * rho[0] * t201;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t206 = t21 / t22 / t34;
  t217 = 0.1e1 / t23 / t143;
  t225 = t77 * t77;
  t227 = 0.1e1 / t22 / t225;
  t232 = t131 * params->pgslb_mu;
  t233 = t26 * t26;
  t234 = 0.1e1 / t233;
  t235 = t232 * t234;
  t236 = t134 * sigma[0];
  t238 = 0.1e1 / t225 / t52;
  t246 = -0.770e3 / 0.243e3 * t30 * t33 * t217 + 0.154e3 / 0.81e2 * t41 * t33 * t217 * t44 - 0.22e2 / 0.81e2 * t133 * t135 * t227 * t44 + 0.8e1 / 0.243e3 * t235 * t236 * t238 * t44 - 0.65e2 / 0.243e3 * t49 * t51 * t168;
  t251 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t206 * t58 - t8 * t115 * t83 / 0.10e2 + 0.3e1 / 0.10e2 * t8 * t64 * t149 + 0.3e1 / 0.20e2 * t8 * t24 * t246);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t251 + 0.6e1 * t154;

  t261 = t32 * t123;
  t272 = 0.1e1 / t225 / t34;
  t277 = 0.55e2 / 0.81e2 * t30 * t261 - 0.11e2 / 0.27e2 * t41 * t261 * t44 + t133 * t31 * t138 * t170 / 0.12e2 - t235 * t272 * t134 * t44 / 0.81e2;
  t282 = my_piecewise3(t3, 0, -t8 * t115 * t97 / 0.30e2 + t8 * t64 * t174 / 0.5e1 + 0.3e1 / 0.20e2 * t8 * t24 * t277);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.2e1 * rho[0] * t282 + 0.4e1 * t179;

  t288 = my_piecewise3(t3, 0, 0.11e2 / 0.1080e4 * t190 * t107);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = 0.2e1 * rho[0] * t288 + 0.4e1 * t186;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = 0.0e0;

  t292 = t8 * t21 * t217;
  t295 = t6 * t6;
  t298 = t5 / t295 / t26;
  t299 = t298 * t21;
  t300 = t227 * t232;
  t305 = my_piecewise3(t3, 0, -0.7e1 / 0.2880e4 * t292 * t193 + t299 * t300 * t170 / 0.1440e4);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.2e1 * rho[0] * t305 + 0.2e1 * t196;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  t310 = my_piecewise3(t3, 0, -t183 * t198 / 0.360e3);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = 0.2e1 * rho[0] * t310 + 0.2e1 * t201;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = 0.0e0;

  t317 = my_piecewise3(t3, 0, -t299 * t138 * t232 * t44 / 0.3840e4);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.2e1 * rho[0] * t317;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t334 = 0.1e1 / t23 / t166;
  t344 = 0.1e1 / t22 / t225 / rho[0];
  t350 = 0.1e1 / t225 / t77;
  t355 = t131 * t131;
  t356 = t355 * t234;
  t357 = t134 * t134;
  t364 = t30 * t32 * t44;
  t375 = my_piecewise3(t3, 0, -0.14e2 / 0.135e3 * t8 * t21 * t54 * t58 + 0.8e1 / 0.45e2 * t8 * t206 * t83 - t8 * t115 * t149 / 0.5e1 + 0.2e1 / 0.5e1 * t8 * t64 * t246 + 0.3e1 / 0.20e2 * t8 * t24 * (0.13090e5 / 0.729e3 * t30 * t33 * t334 - 0.2618e4 / 0.243e3 * t41 * t33 * t334 * t44 + 0.1958e4 / 0.729e3 * t133 * t135 * t344 * t44 - 0.176e3 / 0.243e3 * t235 * t236 * t350 * t44 + 0.8e1 / 0.2187e4 * t356 * t357 / t23 / t225 / t166 * t364 + 0.1235e4 / 0.729e3 * t49 * t51 * t138));
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t375 + 0.8e1 * t251;

  t388 = t32 * t217;
  t414 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t206 * t97 - t8 * t115 * t174 / 0.10e2 + 0.3e1 / 0.10e2 * t8 * t64 * t277 + 0.3e1 / 0.20e2 * t8 * t24 * (-0.770e3 / 0.243e3 * t30 * t388 + 0.154e3 / 0.81e2 * t41 * t388 * t44 - 0.341e3 / 0.486e3 * t133 * t31 * t227 * t170 + 0.19e2 / 0.81e2 * t235 * t238 * t134 * t44 - t356 / t23 / t225 / t143 * t236 * t364 / 0.729e3));
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.2e1 * rho[0] * t414 + 0.6e1 * t282;

  t420 = my_piecewise3(t3, 0, -0.77e2 / 0.1620e4 * t292 * t107);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = 0.2e1 * rho[0] * t420 + 0.6e1 * t288;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = 0.0e0;

  t437 = t29 * t32 * t44;
  t442 = my_piecewise3(t3, 0, 0.119e3 / 0.8640e4 * t8 * t21 * t334 * t193 - 0.13e2 / 0.1440e4 * t299 * t344 * t232 * t170 + t298 * t21 * t350 * t355 * t134 * t25 * t437 / 0.12960e5);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.2e1 * rho[0] * t442 + 0.4e1 * t305;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  t448 = my_piecewise3(t3, 0, 0.11e2 / 0.1080e4 * t190 * t198);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = 0.2e1 * rho[0] * t448 + 0.4e1 * t310;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = 0.0e0;

  t462 = my_piecewise3(t3, 0, 0.11e2 / 0.5760e4 * t299 * t300 * t44 - t298 * t21 * t238 * t355 * t30 * t33 * t44 / 0.34560e5);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.2e1 * rho[0] * t462 + 0.2e1 * t317;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = 0.0e0;

  t471 = my_piecewise3(t3, 0, t298 * t21 * t272 * t355 * t25 * t437 / 0.92160e5);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.2e1 * rho[0] * t471;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t43, t47, t48, t52, t53, t54, t56;
  double t57, t58, t59, t61, t65, t69, t70, t71;
  double t73, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t85, t89, t93, t94, t95, t96;
  double t98, t102, t106;

#ifndef XC_DONT_COMPILE_VXC
  double t107, t108, t109, t111, t114, t115, t119, t120;
  double t123, t125, t126, t129, t133, t135, t139, t144;
  double t145, t147, t150, t151, t155, t158, t160, t164;
  double t167, t168, t173, t175, t178, t179, t184, t185;
  double t191, t193, t197, t202, t211, t215, t222, t226;
  double t227, t228, t230, t233, t234, t235, t237, t240;

#ifndef XC_DONT_COMPILE_FXC
  double t243, t244, t247, t248, t249, t252, t256, t257;
  double t261, t263, t269, t270, t273, t275, t278, t279;
  double t285, t286, t287, t288, t291, t296, t298, t302;
  double t307, t308, t309, t312, t315, t319, t320, t324;
  double t326, t328, t331, t333, t336, t340, t344, t345;
  double t349, t351, t359, t360, t364, t368, t369, t373;
  double t375, t382, t385, t390, t395, t399, t400, t406;
  double t407, t412, t416, t417, t427, t428, t434, t437;
  double t442, t444, t448, t453, t461, t468, t470, t475;
  double t480, t487, t489, t495, t506, t508, t513, t518;
  double t520, t523, t525, t527, t531, t533, t536, t538;
  double t540, t542, t546, t548, t552, t556, t558, t560;
  double t563, t564, t566, t569, t571, t574, t576, t579;

#ifndef XC_DONT_COMPILE_KXC
  double t583, t584, t587, t590, t591, t592, t595, t599;
  double t600, t604, t606, t611, t613, t616, t622, t623;
  double t626, t628, t631, t634, t635, t641, t643, t648;
  double t649, t650, t651, t652, t653, t654, t662, t667;
  double t669, t670, t673, t676, t679, t683, t684, t688;
  double t690, t692, t694, t696, t699, t701, t704, t705;
  double t706, t709, t714, t715, t717, t721, t722, t726;
  double t729, t733, t735, t739, t748, t749, t750, t753;
  double t758, t760, t764, t765, t769, t772, t773, t775;
  double t784, t786, t789, t792, t797, t801, t805, t806;
  double t810, t812, t821, t822, t827, t831, t835, t836;
  double t840, t842, t849, t857, t859, t860, t865, t872;
  double t876, t877, t884, t885, t892, t896, t897, t913;
  double t914, t920, t922, t927, t928, t929, t937, t942;
  double t950, t957, t959, t971, t972, t977, t982, t989;
  double t993, t995, t1001, t1009, t1015, t1022, t1025, t1033;
  double t1054, t1055, t1060, t1065, t1068, t1071, t1072, t1076;
  double t1078, t1079, t1082, t1086, t1089, t1092, t1093, t1095;
  double t1097, t1099, t1101, t1104, t1105, t1112, t1114, t1117;
  double t1118, t1123, t1126, t1129, t1134, t1137, t1145, t1149;
  double t1154, t1157, t1160, t1163, t1164, t1165, t1166, t1168;
  double t1169, t1173, t1178, t1180, t1185, t1191, t1194, t1195;
  double t1196, t1198, t1199, t1203, t1208, t1210, t1214, t1219;
  double t1221, t1226, t1231, t1235, t1237, t1238, t1240, t1241;
  double t1244, t1245, t1247, t1248, t1251;

#ifndef XC_DONT_COMPILE_LXC
  double t1254, t1256, t1257, t1263, t1269, t1270, t1273, t1277;
  double t1286, t1292, t1295, t1301, t1304, t1307, t1311, t1323;
  double t1329, t1330, t1331, t1337, t1350, t1353, t1357, t1360;
  double t1364, t1366, t1367, t1368, t1370, t1371, t1377, t1382;
  double t1385, t1389, t1396, t1400, t1404, t1409, t1411, t1435;
  double t1436, t1438, t1442, t1451, t1457, t1458, t1460, t1470;
  double t1474, t1475, t1478, t1483, t1484, t1501, t1503, t1507;
  double t1514, t1518, t1519, t1522, t1531, t1534, t1535, t1537;
  double t1539, t1540, t1558, t1571, t1575, t1584, t1594, t1598;
  double t1605, t1606, t1615, t1628, t1632, t1639, t1643, t1652;
  double t1655, t1666, t1669, t1671, t1672, t1693, t1697, t1704;
  double t1715, t1716, t1733, t1737, t1744, t1752, t1761, t1771;
  double t1773, t1774, t1779, t1784, t1791, t1795, t1804, t1813;
  double t1825, t1831, t1837, t1848, t1853, t1860, t1864, t1881;
  double t1882, t1890, t1896, t1899, t1906, t1908, t1911, t1940;
  double t1947, t1950, t1954, t1956, t1958, t1964, t1969, t1973;
  double t1982, t1983, t1985, t1991, t1993, t2002, t2004, t2007;
  double t2013, t2022, t2028, t2035, t2043, t2045, t2046, t2055;
  double t2099, t2106, t2111, t2113, t2119, t2120, t2122, t2129;
  double t2136, t2139, t2143, t2145, t2147, t2153, t2157, t2160;
  double t2168, t2169, t2171, t2177, t2179, t2186, t2187, t2190;
  double t2196, t2204, t2210, t2215, t2221, t2223, t2224, t2233;
  double t2253, t2258, t2266, t2267, t2270, t2282, t2286, t2291;
  double t2296, t2299, t2301, t2305, t2316, t2320, t2325, t2331;
  double t2334, t2341, t2364, t2368, t2373, t2378, t2383, t2384;
  double t2390, t2395, t2398, t2400, t2404, t2411, t2415, t2420;
  double t2423, t2430, t2443, t2448, t2451, t2464, t2471, t2473;
  double t2479, t2496, t2504, t2511;
#endif

#endif

#endif

#endif

#endif


  mgga_k_pgslb_params *params;

  assert(p->params != NULL);
  params = (mgga_k_pgslb_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = 0.1e1 / t36;
  t38 = t33 * t37;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t47 = params->pgslb_mu * t33;
  t48 = t37 * sigma[0];
  t52 = exp(-t47 * t48 * t43 / 0.24e2);
  t53 = t33 * t33;
  t54 = params->pgslb_beta * t53;
  t56 = 0.1e1 / t35 / t34;
  t57 = lapl[0] * lapl[0];
  t58 = t56 * t57;
  t59 = t39 * rho[0];
  t61 = 0.1e1 / t40 / t59;
  t65 = 0.5e1 / 0.72e2 * t38 * sigma[0] * t43 + t52 + t54 * t58 * t61 / 0.576e3;
  t69 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t32 * t65);
  t70 = rho[1] <= p->dens_threshold;
  t71 = -t18;
  t73 = my_piecewise5(t16, t13, t12, t17, t71 * t9);
  t74 = 0.1e1 + t73;
  t75 = t74 <= p->zeta_threshold;
  t76 = POW_1_3(t74);
  t77 = t76 * t76;
  t79 = my_piecewise3(t75, t25, t77 * t74);
  t80 = t79 * t31;
  t81 = rho[1] * rho[1];
  t82 = POW_1_3(rho[1]);
  t83 = t82 * t82;
  t85 = 0.1e1 / t83 / t81;
  t89 = t37 * sigma[2];
  t93 = exp(-t47 * t89 * t85 / 0.24e2);
  t94 = lapl[1] * lapl[1];
  t95 = t56 * t94;
  t96 = t81 * rho[1];
  t98 = 0.1e1 / t82 / t96;
  t102 = 0.5e1 / 0.72e2 * t38 * sigma[2] * t85 + t93 + t54 * t95 * t98 / 0.576e3;
  t106 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t80 * t102);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t69 + t106;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t107 = t8 * t8;
  t108 = 0.1e1 / t107;
  t109 = t18 * t108;
  t111 = my_piecewise5(t12, 0, t16, 0, t9 - t109);
  t114 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t111);
  t115 = t114 * t31;
  t119 = 0.1e1 / t30;
  t120 = t29 * t119;
  t123 = t7 * t120 * t65 / 0.10e2;
  t125 = 0.1e1 / t41 / t59;
  t126 = sigma[0] * t125;
  t129 = t47 * t37;
  t133 = t39 * t39;
  t135 = 0.1e1 / t40 / t133;
  t139 = -0.5e1 / 0.27e2 * t38 * t126 + t129 * t126 * t52 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t58 * t135;
  t144 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t115 * t65 + t123 + 0.3e1 / 0.20e2 * t7 * t32 * t139);
  t145 = t71 * t108;
  t147 = my_piecewise5(t16, 0, t12, 0, -t9 - t145);
  t150 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t147);
  t151 = t150 * t31;
  t155 = t79 * t119;
  t158 = t7 * t155 * t102 / 0.10e2;
  t160 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t151 * t102 + t158);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t69 + t106 + t8 * (t144 + t160);

  t164 = my_piecewise5(t12, 0, t16, 0, -t9 - t109);
  t167 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t164);
  t168 = t167 * t31;
  t173 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t168 * t65 + t123);
  t175 = my_piecewise5(t16, 0, t12, 0, t9 - t145);
  t178 = my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t175);
  t179 = t178 * t31;
  t184 = 0.1e1 / t83 / t96;
  t185 = sigma[2] * t184;
  t191 = t81 * t81;
  t193 = 0.1e1 / t82 / t191;
  t197 = -0.5e1 / 0.27e2 * t38 * t185 + t129 * t185 * t93 / 0.9e1 - 0.5e1 / 0.864e3 * t54 * t95 * t193;
  t202 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t179 * t102 + t158 + 0.3e1 / 0.20e2 * t7 * t80 * t197);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t69 + t106 + t8 * (t173 + t202);

  t211 = 0.5e1 / 0.72e2 * t38 * t43 - t47 * t37 * t43 * t52 / 0.24e2;
  t215 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t32 * t211);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = t8 * t215;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[1] = 0.0e0;

  t222 = 0.5e1 / 0.72e2 * t38 * t85 - t47 * t37 * t85 * t93 / 0.24e2;
  t226 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t80 * t222);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[2] = t8 * t226;

  t227 = t7 * t32;
  t228 = t56 * lapl[0];
  t230 = t54 * t228 * t61;
  t233 = my_piecewise3(t2, 0, t227 * t230 / 0.1920e4);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = t8 * t233;

  t234 = t7 * t80;
  t235 = t56 * lapl[1];
  t237 = t54 * t235 * t98;
  t240 = my_piecewise3(t70, 0, t234 * t237 / 0.1920e4);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[1] = t8 * t240;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[1] = 0.0e0;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t243 = 0.1e1 / t26;
  t244 = t111 * t111;
  t247 = t107 * t8;
  t248 = 0.1e1 / t247;
  t249 = t18 * t248;
  t252 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t108 + 0.2e1 * t249);
  t256 = my_piecewise3(t22, 0, 0.10e2 / 0.9e1 * t243 * t244 + 0.5e1 / 0.3e1 * t27 * t252);
  t257 = t256 * t31;
  t261 = t114 * t119;
  t263 = t7 * t261 * t65;
  t269 = 0.1e1 / t30 / t8;
  t270 = t29 * t269;
  t273 = t7 * t270 * t65 / 0.30e2;
  t275 = t7 * t120 * t139;
  t278 = 0.1e1 / t41 / t133;
  t279 = sigma[0] * t278;
  t285 = params->pgslb_mu * params->pgslb_mu;
  t286 = t285 * t53;
  t287 = t286 * t56;
  t288 = sigma[0] * sigma[0];
  t291 = 0.1e1 / t40 / t133 / t59;
  t296 = t133 * rho[0];
  t298 = 0.1e1 / t40 / t296;
  t302 = 0.55e2 / 0.81e2 * t38 * t279 - 0.11e2 / 0.27e2 * t129 * t279 * t52 + t287 * t288 * t291 * t52 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t58 * t298;
  t307 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t257 * t65 + t263 / 0.5e1 + 0.3e1 / 0.10e2 * t7 * t115 * t139 - t273 + t275 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t32 * t302);
  t308 = 0.1e1 / t76;
  t309 = t147 * t147;
  t312 = t71 * t248;
  t315 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t108 + 0.2e1 * t312);
  t319 = my_piecewise3(t75, 0, 0.10e2 / 0.9e1 * t308 * t309 + 0.5e1 / 0.3e1 * t77 * t315);
  t320 = t319 * t31;
  t324 = t150 * t119;
  t326 = t7 * t324 * t102;
  t328 = t79 * t269;
  t331 = t7 * t328 * t102 / 0.30e2;
  t333 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t320 * t102 + t326 / 0.5e1 - t331);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t144 + 0.2e1 * t160 + t8 * (t307 + t333);

  t336 = t243 * t164;
  t340 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t249);
  t344 = my_piecewise3(t22, 0, 0.10e2 / 0.9e1 * t336 * t111 + 0.5e1 / 0.3e1 * t27 * t340);
  t345 = t344 * t31;
  t349 = t167 * t119;
  t351 = t7 * t349 * t65;
  t359 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t345 * t65 + t351 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t168 * t139 + t263 / 0.10e2 - t273 + t275 / 0.10e2);
  t360 = t308 * t175;
  t364 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t312);
  t368 = my_piecewise3(t75, 0, 0.10e2 / 0.9e1 * t360 * t147 + 0.5e1 / 0.3e1 * t77 * t364);
  t369 = t368 * t31;
  t373 = t178 * t119;
  t375 = t7 * t373 * t102;
  t382 = t7 * t155 * t197;
  t385 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t369 * t102 + t375 / 0.10e2 + t326 / 0.10e2 - t331 + 0.3e1 / 0.20e2 * t7 * t151 * t197 + t382 / 0.10e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t144 + t160 + t173 + t202 + t8 * (t359 + t385);

  t390 = t164 * t164;
  t395 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t108 + 0.2e1 * t249);
  t399 = my_piecewise3(t22, 0, 0.10e2 / 0.9e1 * t243 * t390 + 0.5e1 / 0.3e1 * t27 * t395);
  t400 = t399 * t31;
  t406 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t400 * t65 + t351 / 0.5e1 - t273);
  t407 = t175 * t175;
  t412 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t108 + 0.2e1 * t312);
  t416 = my_piecewise3(t75, 0, 0.10e2 / 0.9e1 * t308 * t407 + 0.5e1 / 0.3e1 * t77 * t412);
  t417 = t416 * t31;
  t427 = 0.1e1 / t83 / t191;
  t428 = sigma[2] * t427;
  t434 = sigma[2] * sigma[2];
  t437 = 0.1e1 / t82 / t191 / t96;
  t442 = t191 * rho[1];
  t444 = 0.1e1 / t82 / t442;
  t448 = 0.55e2 / 0.81e2 * t38 * t428 - 0.11e2 / 0.27e2 * t129 * t428 * t93 + t287 * t434 * t437 * t93 / 0.81e2 + 0.65e2 / 0.2592e4 * t54 * t95 * t444;
  t453 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t417 * t102 + t375 / 0.5e1 + 0.3e1 / 0.10e2 * t7 * t179 * t197 - t331 + t382 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t80 * t448);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t173 + 0.2e1 * t202 + t8 * (t406 + t453);

  t461 = t7 * t120 * t211 / 0.10e2;
  t468 = t133 * t39;
  t470 = 0.1e1 / t40 / t468;
  t475 = -0.5e1 / 0.27e2 * t38 * t125 + t47 * t37 * t125 * t52 / 0.9e1 - t287 * t470 * sigma[0] * t52 / 0.216e3;
  t480 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t115 * t211 + t461 + 0.3e1 / 0.20e2 * t7 * t32 * t475);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = t8 * t480 + t215;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[1] = 0.0e0;

  t487 = t7 * t155 * t222 / 0.10e2;
  t489 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t151 * t222 + t487);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[2] = t8 * t489 + t226;

  t495 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t168 * t211 + t461);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[3] = t8 * t495 + t215;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[4] = 0.0e0;

  t506 = t191 * t81;
  t508 = 0.1e1 / t82 / t506;
  t513 = -0.5e1 / 0.27e2 * t38 * t184 + t47 * t37 * t184 * t93 / 0.9e1 - t287 * t508 * sigma[2] * t93 / 0.216e3;
  t518 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t179 * t222 + t487 + 0.3e1 / 0.20e2 * t7 * t80 * t513);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[5] = t8 * t518 + t226;

  t520 = t7 * t115;
  t523 = t7 * t120;
  t525 = t523 * t230 / 0.2880e4;
  t527 = t54 * t228 * t135;
  t531 = my_piecewise3(t2, 0, t520 * t230 / 0.1920e4 + t525 - t227 * t527 / 0.576e3);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = t8 * t531 + t233;

  t533 = t7 * t151;
  t536 = t7 * t155;
  t538 = t536 * t237 / 0.2880e4;
  t540 = my_piecewise3(t70, 0, t533 * t237 / 0.1920e4 + t538);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[1] = t8 * t540 + t240;

  t542 = t7 * t168;
  t546 = my_piecewise3(t2, 0, t542 * t230 / 0.1920e4 + t525);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[2] = t8 * t546 + t233;

  t548 = t7 * t179;
  t552 = t54 * t235 * t193;
  t556 = my_piecewise3(t70, 0, t548 * t237 / 0.1920e4 + t538 - t234 * t552 / 0.576e3);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[3] = t8 * t556 + t240;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[3] = 0.0e0;

  t558 = t56 * t298;
  t560 = t286 * t558 * t52;
  t563 = my_piecewise3(t2, 0, t227 * t560 / 0.3840e4);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = t8 * t563;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[4] = 0.0e0;

  t564 = t56 * t444;
  t566 = t286 * t564 * t93;
  t569 = my_piecewise3(t70, 0, t234 * t566 / 0.3840e4);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[5] = t8 * t569;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[5] = 0.0e0;

  t571 = t54 * t56 * t61;
  t574 = my_piecewise3(t2, 0, t227 * t571 / 0.1920e4);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = t8 * t574;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[1] = 0.0e0;

  t576 = t54 * t56 * t98;
  t579 = my_piecewise3(t70, 0, t234 * t576 / 0.1920e4);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[2] = t8 * t579;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[2] = 0.0e0;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t583 = 0.1e1 / t26 / t21;
  t584 = t244 * t111;
  t587 = t243 * t111;
  t590 = t107 * t107;
  t591 = 0.1e1 / t590;
  t592 = t18 * t591;
  t595 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t248 - 0.6e1 * t592);
  t599 = my_piecewise3(t22, 0, -0.10e2 / 0.27e2 * t583 * t584 + 0.10e2 / 0.3e1 * t587 * t252 + 0.5e1 / 0.3e1 * t27 * t595);
  t600 = t599 * t31;
  t604 = t256 * t119;
  t606 = t7 * t604 * t65;
  t611 = t114 * t269;
  t613 = t7 * t611 * t65;
  t616 = t7 * t261 * t139;
  t622 = 0.1e1 / t30 / t107;
  t623 = t29 * t622;
  t626 = 0.2e1 / 0.45e2 * t7 * t623 * t65;
  t628 = t7 * t270 * t139;
  t631 = t7 * t120 * t302;
  t634 = 0.1e1 / t41 / t296;
  t635 = sigma[0] * t634;
  t641 = t133 * t133;
  t643 = 0.1e1 / t40 / t641;
  t648 = t285 * params->pgslb_mu;
  t649 = t34 * t34;
  t650 = 0.1e1 / t649;
  t651 = t648 * t650;
  t652 = t288 * sigma[0];
  t653 = t641 * t59;
  t654 = 0.1e1 / t653;
  t662 = -0.770e3 / 0.243e3 * t38 * t635 + 0.154e3 / 0.81e2 * t129 * t635 * t52 - 0.11e2 / 0.81e2 * t287 * t288 * t643 * t52 + 0.2e1 / 0.243e3 * t651 * t652 * t654 * t52 - 0.65e2 / 0.486e3 * t54 * t58 * t470;
  t667 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t600 * t65 + 0.3e1 / 0.10e2 * t606 + 0.9e1 / 0.20e2 * t7 * t257 * t139 - t613 / 0.10e2 + 0.3e1 / 0.5e1 * t616 + 0.9e1 / 0.20e2 * t7 * t115 * t302 + t626 - t628 / 0.10e2 + 0.3e1 / 0.10e2 * t631 + 0.3e1 / 0.20e2 * t7 * t32 * t662);
  t669 = 0.1e1 / t76 / t74;
  t670 = t309 * t147;
  t673 = t308 * t147;
  t676 = t71 * t591;
  t679 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t248 - 0.6e1 * t676);
  t683 = my_piecewise3(t75, 0, -0.10e2 / 0.27e2 * t669 * t670 + 0.10e2 / 0.3e1 * t673 * t315 + 0.5e1 / 0.3e1 * t77 * t679);
  t684 = t683 * t31;
  t688 = t319 * t119;
  t690 = t7 * t688 * t102;
  t692 = t150 * t269;
  t694 = t7 * t692 * t102;
  t696 = t79 * t622;
  t699 = 0.2e1 / 0.45e2 * t7 * t696 * t102;
  t701 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t684 * t102 + 0.3e1 / 0.10e2 * t690 - t694 / 0.10e2 + t699);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t307 + 0.3e1 * t333 + t8 * (t667 + t701);

  t704 = 0.2e1 * t359;
  t705 = 0.2e1 * t385;
  t706 = t583 * t164;
  t709 = t243 * t340;
  t714 = 0.2e1 * t248;
  t715 = 0.6e1 * t592;
  t717 = my_piecewise5(t12, 0, t16, 0, t714 - t715);
  t721 = my_piecewise3(t22, 0, -0.10e2 / 0.27e2 * t706 * t244 + 0.20e2 / 0.9e1 * t709 * t111 + 0.10e2 / 0.9e1 * t336 * t252 + 0.5e1 / 0.3e1 * t27 * t717);
  t722 = t721 * t31;
  t726 = t344 * t119;
  t729 = t7 * t726 * t65 / 0.5e1;
  t733 = t167 * t269;
  t735 = t7 * t733 * t65;
  t739 = t7 * t349 * t139 / 0.5e1;
  t748 = 0.3e1 / 0.20e2 * t7 * t722 * t65 + t729 + 0.3e1 / 0.10e2 * t7 * t345 * t139 - t735 / 0.30e2 + t739 + 0.3e1 / 0.20e2 * t7 * t168 * t302 + t606 / 0.10e2 - t613 / 0.15e2 + t616 / 0.5e1 + t626 - t628 / 0.15e2 + t631 / 0.10e2;
  t749 = my_piecewise3(t2, 0, t748);
  t750 = t669 * t175;
  t753 = t308 * t364;
  t758 = 0.6e1 * t676;
  t760 = my_piecewise5(t16, 0, t12, 0, -t714 - t758);
  t764 = my_piecewise3(t75, 0, -0.10e2 / 0.27e2 * t750 * t309 + 0.20e2 / 0.9e1 * t753 * t147 + 0.10e2 / 0.9e1 * t360 * t315 + 0.5e1 / 0.3e1 * t77 * t760);
  t765 = t764 * t31;
  t769 = t368 * t119;
  t772 = t7 * t769 * t102 / 0.5e1;
  t773 = t178 * t269;
  t775 = t7 * t773 * t102;
  t784 = t7 * t324 * t197 / 0.5e1;
  t786 = t7 * t328 * t197;
  t789 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t765 * t102 + t772 - t775 / 0.30e2 + t690 / 0.10e2 - t694 / 0.15e2 + t699 + 0.3e1 / 0.20e2 * t7 * t320 * t197 + t784 - t786 / 0.30e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t307 + t333 + t704 + t705 + t8 * (t749 + t789);

  t792 = t583 * t390;
  t797 = t243 * t395;
  t801 = my_piecewise5(t12, 0, t16, 0, -t714 - t715);
  t805 = my_piecewise3(t22, 0, -0.10e2 / 0.27e2 * t792 * t111 + 0.20e2 / 0.9e1 * t336 * t340 + 0.10e2 / 0.9e1 * t797 * t111 + 0.5e1 / 0.3e1 * t27 * t801);
  t806 = t805 * t31;
  t810 = t399 * t119;
  t812 = t7 * t810 * t65;
  t821 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t806 * t65 + t812 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t400 * t139 + t729 - t735 / 0.15e2 + t739 - t613 / 0.30e2 + t626 - t628 / 0.30e2);
  t822 = t669 * t407;
  t827 = t308 * t412;
  t831 = my_piecewise5(t16, 0, t12, 0, t714 - t758);
  t835 = my_piecewise3(t75, 0, -0.10e2 / 0.27e2 * t822 * t147 + 0.20e2 / 0.9e1 * t360 * t364 + 0.10e2 / 0.9e1 * t827 * t147 + 0.5e1 / 0.3e1 * t77 * t831);
  t836 = t835 * t31;
  t840 = t416 * t119;
  t842 = t7 * t840 * t102;
  t849 = t7 * t373 * t197;
  t857 = t7 * t155 * t448;
  t859 = 0.3e1 / 0.20e2 * t7 * t836 * t102 + t842 / 0.10e2 + t772 - t775 / 0.15e2 + 0.3e1 / 0.10e2 * t7 * t369 * t197 + t849 / 0.5e1 - t694 / 0.30e2 + t699 + t784 - t786 / 0.15e2 + 0.3e1 / 0.20e2 * t7 * t151 * t448 + t857 / 0.10e2;
  t860 = my_piecewise3(t70, 0, t859);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t704 + t705 + t406 + t453 + t8 * (t821 + t860);

  t865 = t390 * t164;
  t872 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t248 - 0.6e1 * t592);
  t876 = my_piecewise3(t22, 0, -0.10e2 / 0.27e2 * t583 * t865 + 0.10e2 / 0.3e1 * t336 * t395 + 0.5e1 / 0.3e1 * t27 * t872);
  t877 = t876 * t31;
  t884 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t877 * t65 + 0.3e1 / 0.10e2 * t812 - t735 / 0.10e2 + t626);
  t885 = t407 * t175;
  t892 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t248 - 0.6e1 * t676);
  t896 = my_piecewise3(t75, 0, -0.10e2 / 0.27e2 * t669 * t885 + 0.10e2 / 0.3e1 * t360 * t412 + 0.5e1 / 0.3e1 * t77 * t892);
  t897 = t896 * t31;
  t913 = 0.1e1 / t83 / t442;
  t914 = sigma[2] * t913;
  t920 = t191 * t191;
  t922 = 0.1e1 / t82 / t920;
  t927 = t434 * sigma[2];
  t928 = t920 * t96;
  t929 = 0.1e1 / t928;
  t937 = -0.770e3 / 0.243e3 * t38 * t914 + 0.154e3 / 0.81e2 * t129 * t914 * t93 - 0.11e2 / 0.81e2 * t287 * t434 * t922 * t93 + 0.2e1 / 0.243e3 * t651 * t927 * t929 * t93 - 0.65e2 / 0.486e3 * t54 * t95 * t508;
  t942 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t897 * t102 + 0.3e1 / 0.10e2 * t842 + 0.9e1 / 0.20e2 * t7 * t417 * t197 - t775 / 0.10e2 + 0.3e1 / 0.5e1 * t849 + 0.9e1 / 0.20e2 * t7 * t179 * t448 + t699 - t786 / 0.10e2 + 0.3e1 / 0.10e2 * t857 + 0.3e1 / 0.20e2 * t7 * t80 * t937);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t406 + 0.3e1 * t453 + t8 * (t884 + t942);

  t950 = t7 * t261 * t211;
  t957 = t7 * t270 * t211 / 0.30e2;
  t959 = t7 * t120 * t475;
  t971 = t641 * t39;
  t972 = 0.1e1 / t971;
  t977 = 0.55e2 / 0.81e2 * t38 * t278 - 0.11e2 / 0.27e2 * t47 * t37 * t278 * t52 + t287 * t291 * sigma[0] * t52 / 0.24e2 - t651 * t972 * t288 * t52 / 0.324e3;
  t982 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t257 * t211 + t950 / 0.5e1 + 0.3e1 / 0.10e2 * t7 * t115 * t475 - t957 + t959 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t32 * t977);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = t8 * t982 + 0.2e1 * t480;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[1] = 0.0e0;

  t989 = t7 * t324 * t222;
  t993 = t7 * t328 * t222 / 0.30e2;
  t995 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t320 * t222 + t989 / 0.5e1 - t993);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[2] = t8 * t995 + 0.2e1 * t489;

  t1001 = t7 * t349 * t211;
  t1009 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t345 * t211 + t1001 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t168 * t475 + t950 / 0.10e2 - t957 + t959 / 0.10e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[3] = t8 * t1009 + t480 + t495;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[4] = 0.0e0;

  t1015 = t7 * t373 * t222;
  t1022 = t7 * t155 * t513;
  t1025 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t369 * t222 + t1015 / 0.10e2 + t989 / 0.10e2 - t993 + 0.3e1 / 0.20e2 * t7 * t151 * t513 + t1022 / 0.10e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[5] = t8 * t1025 + t489 + t518;

  t1033 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t400 * t211 + t1001 / 0.5e1 - t957);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[6] = t8 * t1033 + 0.2e1 * t495;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[7] = 0.0e0;

  t1054 = t920 * t81;
  t1055 = 0.1e1 / t1054;
  t1060 = 0.55e2 / 0.81e2 * t38 * t427 - 0.11e2 / 0.27e2 * t47 * t37 * t427 * t93 + t287 * t437 * sigma[2] * t93 / 0.24e2 - t651 * t1055 * t434 * t93 / 0.324e3;
  t1065 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t417 * t222 + t1015 / 0.5e1 + 0.3e1 / 0.10e2 * t7 * t179 * t513 - t993 + t1022 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t80 * t1060);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[8] = t8 * t1065 + 0.2e1 * t518;

  t1068 = t7 * t257;
  t1071 = t7 * t261;
  t1072 = t1071 * t230;
  t1076 = t7 * t270;
  t1078 = t1076 * t230 / 0.8640e4;
  t1079 = t523 * t527;
  t1082 = t54 * t228 * t298;
  t1086 = my_piecewise3(t2, 0, t1068 * t230 / 0.1920e4 + t1072 / 0.1440e4 - t520 * t527 / 0.288e3 - t1078 - t1079 / 0.432e3 + 0.13e2 / 0.1728e4 * t227 * t1082);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = t8 * t1086 + 0.2e1 * t531;

  t1089 = t7 * t320;
  t1092 = t7 * t324;
  t1093 = t1092 * t237;
  t1095 = t7 * t328;
  t1097 = t1095 * t237 / 0.8640e4;
  t1099 = my_piecewise3(t70, 0, t1089 * t237 / 0.1920e4 + t1093 / 0.1440e4 - t1097);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[1] = t8 * t1099 + 0.2e1 * t540;

  t1101 = t7 * t345;
  t1104 = t7 * t349;
  t1105 = t1104 * t230;
  t1112 = my_piecewise3(t2, 0, t1101 * t230 / 0.1920e4 + t1105 / 0.2880e4 - t542 * t527 / 0.576e3 + t1072 / 0.2880e4 - t1078 - t1079 / 0.864e3);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[2] = t8 * t1112 + t531 + t546;

  t1114 = t7 * t369;
  t1117 = t7 * t373;
  t1118 = t1117 * t237;
  t1123 = t536 * t552;
  t1126 = my_piecewise3(t70, 0, t1114 * t237 / 0.1920e4 + t1118 / 0.2880e4 + t1093 / 0.2880e4 - t1097 - t533 * t552 / 0.576e3 - t1123 / 0.864e3);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[3] = t8 * t1126 + t540 + t556;

  t1129 = t7 * t400;
  t1134 = my_piecewise3(t2, 0, t1129 * t230 / 0.1920e4 + t1105 / 0.1440e4 - t1078);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[4] = t8 * t1134 + 0.2e1 * t546;

  t1137 = t7 * t417;
  t1145 = t54 * t235 * t444;
  t1149 = my_piecewise3(t70, 0, t1137 * t237 / 0.1920e4 + t1118 / 0.1440e4 - t548 * t552 / 0.288e3 - t1097 - t1123 / 0.432e3 + 0.13e2 / 0.1728e4 * t234 * t1145);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[5] = t8 * t1149 + 0.2e1 * t556;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[5] = 0.0e0;

  t1154 = t523 * t560 / 0.5760e4;
  t1157 = t286 * t56 * t470 * t52;
  t1160 = t5 * t5;
  t1163 = t4 / t1160 / t34;
  t1164 = t1163 * t32;
  t1165 = t641 * rho[0];
  t1166 = 0.1e1 / t1165;
  t1168 = sigma[0] * t52;
  t1169 = t648 * t1166 * t1168;
  t1173 = my_piecewise3(t2, 0, t520 * t560 / 0.3840e4 + t1154 - t227 * t1157 / 0.720e3 + t1164 * t1169 / 0.5760e4);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = t8 * t1173 + t563;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[4] = 0.0e0;

  t1178 = t536 * t566 / 0.5760e4;
  t1180 = my_piecewise3(t70, 0, t533 * t566 / 0.3840e4 + t1178);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[5] = t8 * t1180 + t569;

  t1185 = my_piecewise3(t2, 0, t542 * t560 / 0.3840e4 + t1154);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[6] = t8 * t1185 + t563;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[10] = 0.0e0;

  t1191 = t286 * t56 * t508 * t93;
  t1194 = t1163 * t80;
  t1195 = t920 * rho[1];
  t1196 = 0.1e1 / t1195;
  t1198 = sigma[2] * t93;
  t1199 = t648 * t1196 * t1198;
  t1203 = my_piecewise3(t70, 0, t548 * t566 / 0.3840e4 + t1178 - t234 * t1191 / 0.720e3 + t1194 * t1199 / 0.5760e4);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[11] = t8 * t1203 + t569;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[11] = 0.0e0;

  t1208 = t523 * t571 / 0.2880e4;
  t1210 = t54 * t56 * t135;
  t1214 = my_piecewise3(t2, 0, t520 * t571 / 0.1920e4 + t1208 - t227 * t1210 / 0.576e3);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = t8 * t1214 + t574;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[1] = 0.0e0;

  t1219 = t536 * t576 / 0.2880e4;
  t1221 = my_piecewise3(t70, 0, t533 * t576 / 0.1920e4 + t1219);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[2] = t8 * t1221 + t579;

  t1226 = my_piecewise3(t2, 0, t542 * t571 / 0.1920e4 + t1208);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[3] = t8 * t1226 + t574;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[4] = 0.0e0;

  t1231 = t54 * t56 * t193;
  t1235 = my_piecewise3(t70, 0, t548 * t576 / 0.1920e4 + t1219 - t234 * t1231 / 0.576e3);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[5] = t8 * t1235 + t579;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[5] = 0.0e0;

  t1237 = t1163 * t29;
  t1238 = t31 * t648;
  t1240 = 0.1e1 / t641 * t52;
  t1241 = t1238 * t1240;
  t1244 = my_piecewise3(t2, 0, -t1237 * t1241 / 0.15360e5);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = t8 * t1244;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[8] = 0.0e0;

  t1245 = t1163 * t79;
  t1247 = 0.1e1 / t920 * t93;
  t1248 = t1238 * t1247;
  t1251 = my_piecewise3(t70, 0, -t1245 * t1248 / 0.15360e5);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[9] = t8 * t1251;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[3] = 0.0e0;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t1254 = t21 * t21;
  t1256 = 0.1e1 / t26 / t1254;
  t1257 = t244 * t244;
  t1263 = t252 * t252;
  t1269 = 0.1e1 / t590 / t8;
  t1270 = t18 * t1269;
  t1273 = my_piecewise5(t12, 0, t16, 0, -0.24e2 * t591 + 0.24e2 * t1270);
  t1277 = my_piecewise3(t22, 0, 0.40e2 / 0.81e2 * t1256 * t1257 - 0.20e2 / 0.9e1 * t583 * t244 * t252 + 0.10e2 / 0.3e1 * t243 * t1263 + 0.40e2 / 0.9e1 * t587 * t595 + 0.5e1 / 0.3e1 * t27 * t1273);
  t1286 = t7 * t604 * t139;
  t1292 = t7 * t611 * t139;
  t1295 = t7 * t261 * t302;
  t1301 = t7 * t623 * t139;
  t1304 = t7 * t270 * t302;
  t1307 = t7 * t120 * t662;
  t1311 = sigma[0] / t41 / t468;
  t1323 = t641 * t133;
  t1329 = t285 * t285;
  t1330 = t1329 * t650;
  t1331 = t288 * t288;
  t1337 = t37 * t52;
  t1350 = t7 * t114 * t622 * t65;
  t1353 = 0.1e1 / t30 / t247;
  t1357 = 0.14e2 / 0.135e3 * t7 * t29 * t1353 * t65;
  t1360 = t7 * t599 * t119 * t65;
  t1364 = t7 * t256 * t269 * t65;
  t1366 = 0.3e1 / 0.20e2 * t7 * t1277 * t31 * t65 + 0.3e1 / 0.5e1 * t7 * t600 * t139 + 0.6e1 / 0.5e1 * t1286 + 0.9e1 / 0.10e2 * t7 * t257 * t302 - 0.2e1 / 0.5e1 * t1292 + 0.6e1 / 0.5e1 * t1295 + 0.3e1 / 0.5e1 * t7 * t115 * t662 + 0.8e1 / 0.45e2 * t1301 - t1304 / 0.5e1 + 0.2e1 / 0.5e1 * t1307 + 0.3e1 / 0.20e2 * t7 * t32 * (0.13090e5 / 0.729e3 * t38 * t1311 - 0.2618e4 / 0.243e3 * t129 * t1311 * t52 + 0.979e3 / 0.729e3 * t287 * t288 / t40 / t1165 * t52 - 0.44e2 / 0.243e3 * t651 * t652 / t1323 * t52 + 0.2e1 / 0.2187e4 * t1330 * t1331 / t41 / t641 / t468 * t33 * t1337 + 0.1235e4 / 0.1458e4 * t54 * t58 * t291) + 0.8e1 / 0.45e2 * t1350 - t1357 + 0.2e1 / 0.5e1 * t1360 - t1364 / 0.5e1;
  t1367 = my_piecewise3(t2, 0, t1366);
  t1368 = t74 * t74;
  t1370 = 0.1e1 / t76 / t1368;
  t1371 = t309 * t309;
  t1377 = t315 * t315;
  t1382 = t71 * t1269;
  t1385 = my_piecewise5(t16, 0, t12, 0, 0.24e2 * t591 + 0.24e2 * t1382);
  t1389 = my_piecewise3(t75, 0, 0.40e2 / 0.81e2 * t1370 * t1371 - 0.20e2 / 0.9e1 * t669 * t309 * t315 + 0.10e2 / 0.3e1 * t308 * t1377 + 0.40e2 / 0.9e1 * t673 * t679 + 0.5e1 / 0.3e1 * t77 * t1385);
  t1396 = t7 * t683 * t119 * t102;
  t1400 = t7 * t319 * t269 * t102;
  t1404 = t7 * t150 * t622 * t102;
  t1409 = 0.14e2 / 0.135e3 * t7 * t79 * t1353 * t102;
  t1411 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t1389 * t31 * t102 + 0.2e1 / 0.5e1 * t1396 - t1400 / 0.5e1 + 0.8e1 / 0.45e2 * t1404 - t1409);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t667 + 0.4e1 * t701 + t8 * (t1367 + t1411);

  t1435 = 0.12e2 * t591;
  t1436 = 0.24e2 * t1270;
  t1438 = my_piecewise5(t12, 0, t16, 0, -t1435 + t1436);
  t1442 = my_piecewise3(t22, 0, 0.40e2 / 0.81e2 * t1256 * t164 * t584 - 0.10e2 / 0.9e1 * t583 * t340 * t244 - 0.10e2 / 0.9e1 * t706 * t111 * t252 + 0.10e2 / 0.3e1 * t243 * t717 * t111 + 0.10e2 / 0.3e1 * t709 * t252 + 0.10e2 / 0.9e1 * t336 * t595 + 0.5e1 / 0.3e1 * t27 * t1438);
  t1451 = t7 * t726 * t139;
  t1457 = t7 * t733 * t139;
  t1458 = t1457 / 0.10e2;
  t1460 = t7 * t349 * t302;
  t1470 = t7 * t721 * t119 * t65;
  t1474 = t7 * t344 * t269 * t65;
  t1475 = t1474 / 0.10e2;
  t1478 = t7 * t167 * t622 * t65;
  t1483 = 0.3e1 / 0.20e2 * t7 * t168 * t662 + 0.3e1 / 0.20e2 * t7 * t1442 * t31 * t65 + 0.9e1 / 0.20e2 * t7 * t722 * t139 + 0.3e1 / 0.5e1 * t1451 + 0.9e1 / 0.20e2 * t7 * t345 * t302 - t1458 + 0.3e1 / 0.10e2 * t1460 + 0.3e1 / 0.10e2 * t1286 - t1292 / 0.5e1 + 0.3e1 / 0.10e2 * t1295 + 0.2e1 / 0.15e2 * t1301 - t1304 / 0.10e2 + t1307 / 0.10e2 + 0.3e1 / 0.10e2 * t1470 - t1475 + 0.2e1 / 0.45e2 * t1478 + 0.2e1 / 0.15e2 * t1350 - t1357 + t1360 / 0.10e2 - t1364 / 0.10e2;
  t1484 = my_piecewise3(t2, 0, t1483);
  t1501 = 0.24e2 * t1382;
  t1503 = my_piecewise5(t16, 0, t12, 0, t1435 + t1501);
  t1507 = my_piecewise3(t75, 0, 0.40e2 / 0.81e2 * t1370 * t175 * t670 - 0.10e2 / 0.9e1 * t669 * t364 * t309 - 0.10e2 / 0.9e1 * t750 * t147 * t315 + 0.10e2 / 0.3e1 * t308 * t760 * t147 + 0.10e2 / 0.3e1 * t753 * t315 + 0.10e2 / 0.9e1 * t360 * t679 + 0.5e1 / 0.3e1 * t77 * t1503);
  t1514 = t7 * t764 * t119 * t102;
  t1518 = t7 * t368 * t269 * t102;
  t1519 = t1518 / 0.10e2;
  t1522 = t7 * t178 * t622 * t102;
  t1531 = t7 * t688 * t197;
  t1534 = t7 * t692 * t197;
  t1535 = t1534 / 0.10e2;
  t1537 = t7 * t696 * t197;
  t1539 = 0.3e1 / 0.20e2 * t7 * t1507 * t31 * t102 + 0.3e1 / 0.10e2 * t1514 - t1519 + 0.2e1 / 0.45e2 * t1522 + t1396 / 0.10e2 - t1400 / 0.10e2 + 0.2e1 / 0.15e2 * t1404 - t1409 + 0.3e1 / 0.20e2 * t7 * t684 * t197 + 0.3e1 / 0.10e2 * t1531 - t1535 + 0.2e1 / 0.45e2 * t1537;
  t1540 = my_piecewise3(t70, 0, t1539);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t667 + t701 + 0.3e1 * t749 + 0.3e1 * t789 + t8 * (t1484 + t1540);

  t1558 = t340 * t340;
  t1571 = my_piecewise5(t12, 0, t16, 0, t1436);
  t1575 = my_piecewise3(t22, 0, 0.40e2 / 0.81e2 * t1256 * t390 * t244 - 0.40e2 / 0.27e2 * t706 * t111 * t340 - 0.10e2 / 0.27e2 * t792 * t252 + 0.20e2 / 0.9e1 * t243 * t1558 + 0.20e2 / 0.9e1 * t336 * t717 - 0.10e2 / 0.27e2 * t583 * t395 * t244 + 0.20e2 / 0.9e1 * t243 * t801 * t111 + 0.10e2 / 0.9e1 * t797 * t252 + 0.5e1 / 0.3e1 * t27 * t1571);
  t1584 = t7 * t810 * t139;
  t1594 = t7 * t399 * t269 * t65;
  t1598 = t7 * t805 * t119 * t65;
  t1605 = 0.3e1 / 0.20e2 * t7 * t400 * t302 + 0.3e1 / 0.20e2 * t7 * t1575 * t31 * t65 + 0.3e1 / 0.10e2 * t7 * t806 * t139 + t1584 / 0.5e1 + 0.2e1 / 0.5e1 * t1451 - 0.2e1 / 0.15e2 * t1457 + t1460 / 0.5e1 - t1292 / 0.15e2 + 0.4e1 / 0.45e2 * t1301 - t1304 / 0.30e2 - t1594 / 0.30e2 + t1598 / 0.5e1 + t1470 / 0.5e1 - 0.2e1 / 0.15e2 * t1474 + 0.4e1 / 0.45e2 * t1478 + 0.4e1 / 0.45e2 * t1350 - t1357 - t1364 / 0.30e2;
  t1606 = my_piecewise3(t2, 0, t1605);
  t1615 = t364 * t364;
  t1628 = my_piecewise5(t16, 0, t12, 0, t1501);
  t1632 = my_piecewise3(t75, 0, 0.40e2 / 0.81e2 * t1370 * t407 * t309 - 0.40e2 / 0.27e2 * t750 * t147 * t364 - 0.10e2 / 0.27e2 * t822 * t315 + 0.20e2 / 0.9e1 * t308 * t1615 + 0.20e2 / 0.9e1 * t360 * t760 - 0.10e2 / 0.27e2 * t669 * t412 * t309 + 0.20e2 / 0.9e1 * t308 * t831 * t147 + 0.10e2 / 0.9e1 * t827 * t315 + 0.5e1 / 0.3e1 * t77 * t1628);
  t1639 = t7 * t835 * t119 * t102;
  t1643 = t7 * t416 * t269 * t102;
  t1652 = t7 * t769 * t197;
  t1655 = t7 * t773 * t197;
  t1666 = t7 * t324 * t448;
  t1669 = t7 * t328 * t448;
  t1671 = 0.3e1 / 0.20e2 * t7 * t1632 * t31 * t102 + t1639 / 0.5e1 - t1643 / 0.30e2 + t1514 / 0.5e1 - 0.2e1 / 0.15e2 * t1518 + 0.4e1 / 0.45e2 * t1522 + 0.3e1 / 0.10e2 * t7 * t765 * t197 + 0.2e1 / 0.5e1 * t1652 - t1655 / 0.15e2 - t1400 / 0.30e2 + 0.4e1 / 0.45e2 * t1404 - t1409 + t1531 / 0.5e1 - 0.2e1 / 0.15e2 * t1534 + 0.4e1 / 0.45e2 * t1537 + 0.3e1 / 0.20e2 * t7 * t320 * t448 + t1666 / 0.5e1 - t1669 / 0.30e2;
  t1672 = my_piecewise3(t70, 0, t1671);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t749 + 0.2e1 * t789 + 0.2e1 * t821 + 0.2e1 * t860 + t8 * (t1606 + t1672);

  t1693 = my_piecewise5(t12, 0, t16, 0, t1435 + t1436);
  t1697 = my_piecewise3(t22, 0, 0.40e2 / 0.81e2 * t1256 * t865 * t111 - 0.10e2 / 0.9e1 * t792 * t340 - 0.10e2 / 0.9e1 * t706 * t395 * t111 + 0.10e2 / 0.3e1 * t709 * t395 + 0.10e2 / 0.3e1 * t336 * t801 + 0.10e2 / 0.9e1 * t243 * t872 * t111 + 0.5e1 / 0.3e1 * t27 * t1693);
  t1704 = t7 * t876 * t119 * t65;
  t1715 = 0.3e1 / 0.20e2 * t7 * t1697 * t31 * t65 + t1704 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t877 * t139 + 0.3e1 / 0.10e2 * t1598 - t1594 / 0.10e2 + 0.3e1 / 0.10e2 * t1584 - t1475 + 0.2e1 / 0.15e2 * t1478 - t1458 + 0.2e1 / 0.45e2 * t1350 - t1357 + 0.2e1 / 0.45e2 * t1301;
  t1716 = my_piecewise3(t2, 0, t1715);
  t1733 = my_piecewise5(t16, 0, t12, 0, -t1435 + t1501);
  t1737 = my_piecewise3(t75, 0, 0.40e2 / 0.81e2 * t1370 * t885 * t147 - 0.10e2 / 0.9e1 * t822 * t364 - 0.10e2 / 0.9e1 * t750 * t412 * t147 + 0.10e2 / 0.3e1 * t753 * t412 + 0.10e2 / 0.3e1 * t360 * t831 + 0.10e2 / 0.9e1 * t308 * t892 * t147 + 0.5e1 / 0.3e1 * t77 * t1733);
  t1744 = t7 * t896 * t119 * t102;
  t1752 = t7 * t840 * t197;
  t1761 = t7 * t373 * t448;
  t1771 = t7 * t155 * t937;
  t1773 = 0.3e1 / 0.20e2 * t7 * t1737 * t31 * t102 + t1744 / 0.10e2 + 0.3e1 / 0.10e2 * t1639 - t1643 / 0.10e2 + 0.9e1 / 0.20e2 * t7 * t836 * t197 + 0.3e1 / 0.10e2 * t1752 - t1519 + 0.2e1 / 0.15e2 * t1522 + 0.3e1 / 0.5e1 * t1652 - t1655 / 0.5e1 + 0.9e1 / 0.20e2 * t7 * t369 * t448 + 0.3e1 / 0.10e2 * t1761 + 0.2e1 / 0.45e2 * t1404 - t1409 - t1535 + 0.2e1 / 0.15e2 * t1537 + 0.3e1 / 0.10e2 * t1666 - t1669 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t151 * t937 + t1771 / 0.10e2;
  t1774 = my_piecewise3(t70, 0, t1773);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t821 + 0.3e1 * t860 + t884 + t942 + t8 * (t1716 + t1774);

  t1779 = t390 * t390;
  t1784 = t395 * t395;
  t1791 = my_piecewise5(t12, 0, t16, 0, 0.24e2 * t591 + 0.24e2 * t1270);
  t1795 = my_piecewise3(t22, 0, 0.40e2 / 0.81e2 * t1256 * t1779 - 0.20e2 / 0.9e1 * t792 * t395 + 0.10e2 / 0.3e1 * t243 * t1784 + 0.40e2 / 0.9e1 * t336 * t872 + 0.5e1 / 0.3e1 * t27 * t1791);
  t1804 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t1795 * t31 * t65 + 0.2e1 / 0.5e1 * t1704 - t1594 / 0.5e1 + 0.8e1 / 0.45e2 * t1478 - t1357);
  t1813 = sigma[2] / t83 / t506;
  t1825 = t920 * t191;
  t1831 = t434 * t434;
  t1837 = t37 * t93;
  t1848 = t407 * t407;
  t1853 = t412 * t412;
  t1860 = my_piecewise5(t16, 0, t12, 0, -0.24e2 * t591 + 0.24e2 * t1382);
  t1864 = my_piecewise3(t75, 0, 0.40e2 / 0.81e2 * t1370 * t1848 - 0.20e2 / 0.9e1 * t822 * t412 + 0.10e2 / 0.3e1 * t308 * t1853 + 0.40e2 / 0.9e1 * t360 * t892 + 0.5e1 / 0.3e1 * t77 * t1860);
  t1881 = 0.9e1 / 0.10e2 * t7 * t417 * t448 + 0.3e1 / 0.5e1 * t7 * t179 * t937 + 0.3e1 / 0.20e2 * t7 * t80 * (0.13090e5 / 0.729e3 * t38 * t1813 - 0.2618e4 / 0.243e3 * t129 * t1813 * t93 + 0.979e3 / 0.729e3 * t287 * t434 / t82 / t1195 * t93 - 0.44e2 / 0.243e3 * t651 * t927 / t1825 * t93 + 0.2e1 / 0.2187e4 * t1330 * t1831 / t83 / t920 / t506 * t33 * t1837 + 0.1235e4 / 0.1458e4 * t54 * t95 * t437) + 0.3e1 / 0.20e2 * t7 * t1864 * t31 * t102 + 0.3e1 / 0.5e1 * t7 * t897 * t197 + 0.2e1 / 0.5e1 * t1744 + 0.6e1 / 0.5e1 * t1752 + 0.6e1 / 0.5e1 * t1761 + 0.2e1 / 0.5e1 * t1771 - t1643 / 0.5e1 - 0.2e1 / 0.5e1 * t1655 - t1669 / 0.5e1 + 0.8e1 / 0.45e2 * t1522 + 0.8e1 / 0.45e2 * t1537 - t1409;
  t1882 = my_piecewise3(t70, 0, t1881);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t884 + 0.4e1 * t942 + t8 * (t1804 + t1882);

  t1890 = t7 * t604 * t211;
  t1896 = t7 * t611 * t211;
  t1899 = t7 * t261 * t475;
  t1906 = 0.2e1 / 0.45e2 * t7 * t623 * t211;
  t1908 = t7 * t270 * t475;
  t1911 = t7 * t120 * t977;
  t1940 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t600 * t211 + 0.3e1 / 0.10e2 * t1890 + 0.9e1 / 0.20e2 * t7 * t257 * t475 - t1896 / 0.10e2 + 0.3e1 / 0.5e1 * t1899 + 0.9e1 / 0.20e2 * t7 * t115 * t977 + t1906 - t1908 / 0.10e2 + 0.3e1 / 0.10e2 * t1911 + 0.3e1 / 0.20e2 * t7 * t32 * (-0.770e3 / 0.243e3 * t38 * t634 + 0.154e3 / 0.81e2 * t47 * t37 * t634 * t52 - 0.341e3 / 0.972e3 * t287 * t643 * sigma[0] * t52 + 0.19e2 / 0.324e3 * t651 * t654 * t288 * t52 - t1330 / t41 / t641 / t296 * t652 * t33 * t1337 / 0.2916e4));
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = t8 * t1940 + 0.3e1 * t982;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[1] = 0.0e0;

  t1947 = t7 * t688 * t222;
  t1950 = t7 * t692 * t222;
  t1954 = 0.2e1 / 0.45e2 * t7 * t696 * t222;
  t1956 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t684 * t222 + 0.3e1 / 0.10e2 * t1947 - t1950 / 0.10e2 + t1954);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[2] = t8 * t1956 + 0.3e1 * t995;

  t1958 = 0.2e1 * t1009;
  t1964 = t7 * t726 * t211 / 0.5e1;
  t1969 = t7 * t733 * t211;
  t1973 = t7 * t349 * t475 / 0.5e1;
  t1982 = 0.3e1 / 0.20e2 * t7 * t722 * t211 + t1964 + 0.3e1 / 0.10e2 * t7 * t345 * t475 - t1969 / 0.30e2 + t1973 + 0.3e1 / 0.20e2 * t7 * t168 * t977 + t1890 / 0.10e2 - t1896 / 0.15e2 + t1899 / 0.5e1 + t1906 - t1908 / 0.15e2 + t1911 / 0.10e2;
  t1983 = my_piecewise3(t2, 0, t1982);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[3] = t8 * t1983 + t1958 + t982;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[4] = 0.0e0;

  t1985 = 0.2e1 * t1025;
  t1991 = t7 * t769 * t222 / 0.5e1;
  t1993 = t7 * t773 * t222;
  t2002 = t7 * t324 * t513 / 0.5e1;
  t2004 = t7 * t328 * t513;
  t2007 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t765 * t222 + t1991 - t1993 / 0.30e2 + t1947 / 0.10e2 - t1950 / 0.15e2 + t1954 + 0.3e1 / 0.20e2 * t7 * t320 * t513 + t2002 - t2004 / 0.30e2);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[5] = t8 * t2007 + t1985 + t995;

  t2013 = t7 * t810 * t211;
  t2022 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t806 * t211 + t2013 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t400 * t475 + t1964 - t1969 / 0.15e2 + t1973 - t1896 / 0.30e2 + t1906 - t1908 / 0.30e2);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[6] = t8 * t2022 + t1033 + t1958;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[7] = 0.0e0;

  t2028 = t7 * t840 * t222;
  t2035 = t7 * t373 * t513;
  t2043 = t7 * t155 * t1060;
  t2045 = 0.3e1 / 0.20e2 * t7 * t836 * t222 + t2028 / 0.10e2 + t1991 - t1993 / 0.15e2 + 0.3e1 / 0.10e2 * t7 * t369 * t513 + t2035 / 0.5e1 - t1950 / 0.30e2 + t1954 + t2002 - t2004 / 0.15e2 + 0.3e1 / 0.20e2 * t7 * t151 * t1060 + t2043 / 0.10e2;
  t2046 = my_piecewise3(t70, 0, t2045);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[8] = t8 * t2046 + t1065 + t1985;

  t2055 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t877 * t211 + 0.3e1 / 0.10e2 * t2013 - t1969 / 0.10e2 + t1906);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[9] = t8 * t2055 + 0.3e1 * t1033;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[10] = 0.0e0;

  t2099 = my_piecewise3(t70, 0, 0.3e1 / 0.20e2 * t7 * t897 * t222 + 0.3e1 / 0.10e2 * t2028 + 0.9e1 / 0.20e2 * t7 * t417 * t513 - t1993 / 0.10e2 + 0.3e1 / 0.5e1 * t2035 + 0.9e1 / 0.20e2 * t7 * t179 * t1060 + t1954 - t2004 / 0.10e2 + 0.3e1 / 0.10e2 * t2043 + 0.3e1 / 0.20e2 * t7 * t80 * (-0.770e3 / 0.243e3 * t38 * t913 + 0.154e3 / 0.81e2 * t47 * t37 * t913 * t93 - 0.341e3 / 0.972e3 * t287 * t922 * sigma[2] * t93 + 0.19e2 / 0.324e3 * t651 * t929 * t434 * t93 - t1330 / t83 / t920 / t442 * t927 * t33 * t1837 / 0.2916e4));
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[11] = t8 * t2099 + 0.3e1 * t1065;

  t2106 = t7 * t604 * t230;
  t2111 = t7 * t611 * t230;
  t2113 = t1071 * t527;
  t2119 = t7 * t623 * t230 / 0.6480e4;
  t2120 = t1076 * t527;
  t2122 = t523 * t1082;
  t2129 = my_piecewise3(t2, 0, t7 * t600 * t230 / 0.1920e4 + t2106 / 0.960e3 - t1068 * t527 / 0.192e3 - t2111 / 0.2880e4 - t2113 / 0.144e3 + 0.13e2 / 0.576e3 * t520 * t1082 + t2119 + t2120 / 0.864e3 + 0.13e2 / 0.864e3 * t2122 - 0.13e2 / 0.324e3 * t227 * t54 * t228 * t470);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = t8 * t2129 + 0.3e1 * t1086;

  t2136 = t7 * t688 * t237;
  t2139 = t7 * t692 * t237;
  t2143 = t7 * t696 * t237 / 0.6480e4;
  t2145 = my_piecewise3(t70, 0, t7 * t684 * t237 / 0.1920e4 + t2136 / 0.960e3 - t2139 / 0.2880e4 + t2143);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[1] = t8 * t2145 + 0.3e1 * t1099;

  t2147 = 0.2e1 * t1112;
  t2153 = t7 * t726 * t230 / 0.1440e4;
  t2157 = t7 * t733 * t230;
  t2160 = t1104 * t527 / 0.432e3;
  t2168 = t7 * t722 * t230 / 0.1920e4 + t2153 - t1101 * t527 / 0.288e3 - t2157 / 0.8640e4 - t2160 + 0.13e2 / 0.1728e4 * t542 * t1082 + t2106 / 0.2880e4 - t2111 / 0.4320e4 - t2113 / 0.432e3 + t2119 + t2120 / 0.1296e4 + 0.13e2 / 0.2592e4 * t2122;
  t2169 = my_piecewise3(t2, 0, t2168);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[2] = t8 * t2169 + t1086 + t2147;

  t2171 = 0.2e1 * t1126;
  t2177 = t7 * t769 * t237 / 0.1440e4;
  t2179 = t7 * t773 * t237;
  t2186 = t1092 * t552 / 0.432e3;
  t2187 = t1095 * t552;
  t2190 = my_piecewise3(t70, 0, t7 * t765 * t237 / 0.1920e4 + t2177 - t2179 / 0.8640e4 + t2136 / 0.2880e4 - t2139 / 0.4320e4 + t2143 - t1089 * t552 / 0.576e3 - t2186 + t2187 / 0.2592e4);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[3] = t8 * t2190 + t1099 + t2171;

  t2196 = t7 * t810 * t230;
  t2204 = my_piecewise3(t2, 0, t7 * t806 * t230 / 0.1920e4 + t2196 / 0.2880e4 - t1129 * t527 / 0.576e3 + t2153 - t2157 / 0.4320e4 - t2160 - t2111 / 0.8640e4 + t2119 + t2120 / 0.2592e4);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[4] = t8 * t2204 + t1134 + t2147;

  t2210 = t7 * t840 * t237;
  t2215 = t1117 * t552;
  t2221 = t536 * t1145;
  t2223 = t7 * t836 * t237 / 0.1920e4 + t2210 / 0.2880e4 + t2177 - t2179 / 0.4320e4 - t1114 * t552 / 0.288e3 - t2215 / 0.432e3 - t2139 / 0.8640e4 + t2143 - t2186 + t2187 / 0.1296e4 + 0.13e2 / 0.1728e4 * t533 * t1145 + 0.13e2 / 0.2592e4 * t2221;
  t2224 = my_piecewise3(t70, 0, t2223);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[5] = t8 * t2224 + t1149 + t2171;

  t2233 = my_piecewise3(t2, 0, t7 * t877 * t230 / 0.1920e4 + t2196 / 0.960e3 - t2157 / 0.2880e4 + t2119);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[6] = t8 * t2233 + 0.3e1 * t1134;

  t2253 = my_piecewise3(t70, 0, t7 * t897 * t237 / 0.1920e4 + t2210 / 0.960e3 - t1137 * t552 / 0.192e3 - t2179 / 0.2880e4 - t2215 / 0.144e3 + 0.13e2 / 0.576e3 * t548 * t1145 + t2143 + t2187 / 0.864e3 + 0.13e2 / 0.864e3 * t2221 - 0.13e2 / 0.324e3 * t234 * t54 * t235 * t508);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[7] = t8 * t2253 + 0.3e1 * t1149;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[7] = 0.0e0;

  t2258 = t1071 * t560;
  t2266 = t1076 * t560 / 0.17280e5;
  t2267 = t523 * t1157;
  t2270 = t1163 * t120 * t1169;
  t2282 = t1163 * t32 * t1329;
  t2286 = t38 * t52;
  t2291 = my_piecewise3(t2, 0, t1068 * t560 / 0.3840e4 + t2258 / 0.2880e4 - t520 * t1157 / 0.360e3 + t1163 * t115 * t1169 / 0.2880e4 - t2266 - t2267 / 0.540e3 + t2270 / 0.4320e4 + 0.19e2 / 0.2160e4 * t227 * t286 * t56 * t291 * t52 - 0.43e2 / 0.17280e5 * t1164 * t648 * t972 * t1168 + t2282 / t41 / t1323 * t288 * t2286 / 0.51840e5);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = t8 * t2291 + 0.2e1 * t1173;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[4] = 0.0e0;

  t2296 = t1092 * t566;
  t2299 = t1095 * t566 / 0.17280e5;
  t2301 = my_piecewise3(t70, 0, t1089 * t566 / 0.3840e4 + t2296 / 0.2880e4 - t2299);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[5] = t8 * t2301 + 0.2e1 * t1180;

  t2305 = t1104 * t560;
  t2316 = my_piecewise3(t2, 0, t1101 * t560 / 0.3840e4 + t2305 / 0.5760e4 - t542 * t1157 / 0.720e3 + t1163 * t168 * t1169 / 0.5760e4 + t2258 / 0.5760e4 - t2266 - t2267 / 0.1080e4 + t2270 / 0.8640e4);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[6] = t8 * t2316 + t1173 + t1185;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[10] = 0.0e0;

  t2320 = t1117 * t566;
  t2325 = t536 * t1191;
  t2331 = t1163 * t155 * t1199;
  t2334 = my_piecewise3(t70, 0, t1114 * t566 / 0.3840e4 + t2320 / 0.5760e4 + t2296 / 0.5760e4 - t2299 - t533 * t1191 / 0.720e3 - t2325 / 0.1080e4 + t1163 * t151 * t1199 / 0.5760e4 + t2331 / 0.8640e4);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[11] = t8 * t2334 + t1180 + t1203;

  t2341 = my_piecewise3(t2, 0, t1129 * t560 / 0.3840e4 + t2305 / 0.2880e4 - t2266);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[12] = t8 * t2341 + 0.2e1 * t1185;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[16] = 0.0e0;

  t2364 = t1163 * t80 * t1329;
  t2368 = t38 * t93;
  t2373 = my_piecewise3(t70, 0, t1137 * t566 / 0.3840e4 + t2320 / 0.2880e4 - t548 * t1191 / 0.360e3 + t1163 * t179 * t1199 / 0.2880e4 - t2299 - t2325 / 0.540e3 + t2331 / 0.4320e4 + 0.19e2 / 0.2160e4 * t234 * t286 * t56 * t437 * t93 - 0.43e2 / 0.17280e5 * t1194 * t648 * t1055 * t1198 + t2364 / t83 / t1825 * t434 * t2368 / 0.51840e5);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[17] = t8 * t2373 + 0.2e1 * t1203;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[17] = 0.0e0;

  t2378 = t1071 * t571;
  t2383 = t1076 * t571 / 0.8640e4;
  t2384 = t523 * t1210;
  t2390 = my_piecewise3(t2, 0, t1068 * t571 / 0.1920e4 + t2378 / 0.1440e4 - t520 * t1210 / 0.288e3 - t2383 - t2384 / 0.432e3 + 0.13e2 / 0.1728e4 * t227 * t54 * t558);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = t8 * t2390 + 0.2e1 * t1214;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[1] = 0.0e0;

  t2395 = t1092 * t576;
  t2398 = t1095 * t576 / 0.8640e4;
  t2400 = my_piecewise3(t70, 0, t1089 * t576 / 0.1920e4 + t2395 / 0.1440e4 - t2398);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[2] = t8 * t2400 + 0.2e1 * t1221;

  t2404 = t1104 * t571;
  t2411 = my_piecewise3(t2, 0, t1101 * t571 / 0.1920e4 + t2404 / 0.2880e4 - t542 * t1210 / 0.576e3 + t2378 / 0.2880e4 - t2383 - t2384 / 0.864e3);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[3] = t8 * t2411 + t1214 + t1226;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[4] = 0.0e0;

  t2415 = t1117 * t576;
  t2420 = t536 * t1231;
  t2423 = my_piecewise3(t70, 0, t1114 * t576 / 0.1920e4 + t2415 / 0.2880e4 + t2395 / 0.2880e4 - t2398 - t533 * t1231 / 0.576e3 - t2420 / 0.864e3);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[5] = t8 * t2423 + t1221 + t1235;

  t2430 = my_piecewise3(t2, 0, t1129 * t571 / 0.1920e4 + t2404 / 0.1440e4 - t2383);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[6] = t8 * t2430 + 0.2e1 * t1226;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[7] = 0.0e0;

  t2443 = my_piecewise3(t70, 0, t1137 * t576 / 0.1920e4 + t2415 / 0.1440e4 - t548 * t1231 / 0.288e3 - t2398 - t2420 / 0.432e3 + 0.13e2 / 0.1728e4 * t234 * t54 * t564);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[8] = t8 * t2443 + 0.2e1 * t1235;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[8] = 0.0e0;

  t2448 = t119 * t648;
  t2451 = t1237 * t2448 * t1240 / 0.23040e5;
  t2464 = my_piecewise3(t2, 0, -t1163 * t114 * t1241 / 0.15360e5 - t2451 + t1237 * t1238 * t1166 * t52 / 0.1920e4 - t2282 / t41 / t653 * t33 * t48 * t52 / 0.138240e6);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = t8 * t2464 + t1244;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[8] = 0.0e0;

  t2471 = t1245 * t2448 * t1247 / 0.23040e5;
  t2473 = my_piecewise3(t70, 0, -t1163 * t150 * t1248 / 0.15360e5 - t2471);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[9] = t8 * t2473 + t1251;

  t2479 = my_piecewise3(t2, 0, -t1163 * t167 * t1241 / 0.15360e5 - t2451);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[10] = t8 * t2479 + t1244;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[18] = 0.0e0;

  t2496 = my_piecewise3(t70, 0, -t1163 * t178 * t1248 / 0.15360e5 - t2471 + t1245 * t1238 * t1196 * t93 / 0.1920e4 - t2364 / t83 / t928 * t33 * t89 * t93 / 0.138240e6);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[19] = t8 * t2496 + t1251;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[7] = 0.0e0;

  t2504 = my_piecewise3(t2, 0, t1164 * t1329 / t41 / t971 * t2286 / 0.368640e6);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = t8 * t2504;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[13] = 0.0e0;

  t2511 = my_piecewise3(t70, 0, t1194 * t1329 / t83 / t1054 * t2368 / 0.368640e6);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[14] = t8 * t2511;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[4] = 0.0e0;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

