#include <stdlib.h>
#include "libut/ut.h"

int tmrtest_cb(char *name, unsigned msec, void *unused) {
    UT_LOG(Info, "Timer %s invoked", name);
    return 0; /* recur at same interval */
}

int tmradd_usage(int argc,char*argv[]) {
    UT_shlf("usage: tmradd <timername> <msec>\n");
}

int tmrdel_usage(int argc,char*argv[]) {
    UT_shlf("usage: tmrdel <timername>\n");
}

int tmradd_cmd(int argc, char *argv[]) {
    int msec;
    if (argc != 3) {
        UT_shle("usage: tmradd <timername> <msec>\n");
        return SHL_ERROR;
    }
    if (sscanf(argv[2],"%u", &msec) != 1) {
        UT_shle("usage: tmradd <timername> <msec>\n");
        return SHL_ERROR;
    }
    UT_tmr_set(argv[1], msec, tmrtest_cb, NULL);
    UT_shlf("timer %s established to expire in %d msec", argv[1], msec);
    return SHL_OK;
}

int tmrdel_cmd(int argc, char *argv[]) {
    if (argc != 2) {
        UT_shle("usage: tmrdel <timername>\n");
        return SHL_ERROR;
    }
    if (UT_tmr_clear(argv[1]) != 0) UT_shlf("unknown timer %s\n", argv[1]);
    else UT_shlf("timer %s deleted\n", argv[1]);
    return SHL_OK;
}

int main() {
    UT_init( INIT_END );
    UT_shl_cmd_create( "tmradd", "add a timer", tmradd_cmd, tmradd_usage);
    UT_shl_cmd_create( "tmrdel", "delete a timer", tmrdel_cmd, tmrdel_usage);
    UT_event_loop();
}
