/*******************************************************************************
* srvr.c                                                                       *
* This simple server listens on port 2222 to accept "uploads" from the upld    *
* program.  Troy Hanson, 25 Jul 2005.                                          *
*******************************************************************************/
#include <errno.h>
#include <unistd.h>
#include <signal.h>
#include "libut/ut.h"

int srvr_cb(int fd, char *name, int flags, int *count) {
    int rc;
    char buf[100];

    if (flags & UTFD_IS_NEWACCEPT) {
        /* count the bytes received on each conn */
        count = (int*)malloc(sizeof(int));
        *count = 0;
        UT_fd_cntl(fd, UTFD_SET_DATA, count);
        return 0;
    }
    /* socket is readable */
    while ( (rc = read(fd, buf, 100)) > 0 ) {
        *count += rc;
        UT_LOG(Info, "srvr read %d bytes [%d] (fd %d)", rc, *count, fd);
    }
    if (rc == 0 || (rc == -1 && errno != EINTR)) {
        free(count);
        UT_fd_unreg(fd);
        close(fd);
    }
}

int sig_cb(int signum) {
    UT_LOG(Info,"srvr got signal %d", signum);
}

int main(int argc, char **argv) {
    UT_init(INIT_SHL_IPPORT, "*:4446", INIT_ARGCV, argc, argv, 
            INIT_SIGNALS(SIGPIPE,SIGHUP), INIT_END);
    UT_signal_reg( sig_cb );
    UT_net_listen("srvr", "*:2222", (UT_fd_cb*)srvr_cb, NULL);
    UT_event_loop();
}
