#include <stdlib.h> 
#include "libut/ut.h"

#define MEM_TMR_INTERVAL 0
#define NUM_BUFS 100000

typedef struct ll_test_buf {
   int keycode;
   void *unused1,*unused2;

   UT_hash_handle hh;

   struct ll_test_buf *next;
} ll_test_buf;

ll_test_buf *head10=NULL,*head100=NULL,*head1000=NULL,*head10000=NULL,*head100000=NULL, *del10=NULL,*del100=NULL,*del1000=NULL, *del10000=NULL, *del100000=NULL;

int keycodes[NUM_BUFS];
int loop_count=0;


int ll_cb( char *name, unsigned msec, char *pool) {
 int i,j;
 int c;
 ll_test_buf *tmp,*del;


 /* lookup a random name in each of the three lists */
 j = (int)(10.0*rand()/(RAND_MAX+1.0));
 c = keycodes[j];
 UT_prf_bgn("ll_perf","lookup-10");
 HASH_LINEAR_FIND(head10, tmp,keycode, &c,sizeof(int));
 UT_prf_end("ll_perf","lookup-10");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-10");
 HASH_FIND_INT(head10, tmp,keycode, &c);
 UT_prf_end("ll_perf","fast-lookup-10");
 if (!tmp) UT_LOG(Error, "fast lookup failed");



 j = (int)(100.0*rand()/(RAND_MAX+1.0));
 c = keycodes[j];
 UT_prf_bgn("ll_perf","lookup-100");
 HASH_LINEAR_FIND(head100, tmp, keycode,&c,sizeof(int));
 UT_prf_end("ll_perf","lookup-100");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-100");
 HASH_FIND_INT(head100, tmp, keycode,&c);
 UT_prf_end("ll_perf","fast-lookup-100");
 if (!tmp) UT_LOG(Error, "fast lookup failed");



 j = (int)(1000.0*rand()/(RAND_MAX+1.0));
 c = keycodes[j];
 UT_prf_bgn("ll_perf","lookup-1000");
 HASH_LINEAR_FIND(head1000, tmp, keycode,&c,sizeof(int));
 UT_prf_end("ll_perf","lookup-1000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-1000");
 HASH_FIND_INT(head1000, tmp, keycode,&c);
 UT_prf_end("ll_perf","fast-lookup-1000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");



 j = (int)(10000.0*rand()/(RAND_MAX+1.0));
 c = keycodes[j];
 UT_prf_bgn("ll_perf","lookup-10000");
 HASH_LINEAR_FIND(head10000, tmp, keycode,&c,sizeof(int));
 UT_prf_end("ll_perf","lookup-10000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-10000");
 HASH_FIND_INT(head10000, tmp, keycode,&c);
 UT_prf_end("ll_perf","fast-lookup-10000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 /*
 j = (int)(100000.0*rand()/(RAND_MAX+1.0));
 c = keycodes[j];
 UT_prf_bgn("ll_perf","lookup-100000");
 HASH_LINEAR_FIND(head100000, tmp, keycode,c,sizeof(int));
 UT_prf_end("ll_perf","lookup-100000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");

 UT_prf_bgn("ll_perf","fast-lookup-100000");
 HASH_FIND_INT(head100000, tmp, keycode,c);
 UT_prf_end("ll_perf","fast-lookup-100000");
 if (!tmp) UT_LOG(Error, "ll lookup failed");
 */

 if (del10) {
    del = del10;
    i=0;
    while (del) {
      UT_LOG(Debug, "Delete-list[%d]:%d",i,del->keycode); 
      i++;
      del=del->next; 
    } 
    UT_LOG(Debug, "Delete-test list has %d elements", i); 

    j = (int)(i*1.0*rand()/(RAND_MAX+1.0)); 
    UT_LOG(Debug, "Deleting element %d", j); 
    del = del10; 
    while (j--) del=del->next;  

    UT_prf_bgn("ll_perf","hl-del10");
    HASH_DEL(del10,tmp,del); 
    UT_prf_end("ll_perf","hl-del10");
 }

 if (del100) {
    del = del100;
    i=0;
    while (del) {
      /* UT_LOG(Debug, "Delete-list[%d]:%s",i,del->name); */
      i++;
      del=del->next; 
    } 
    /* UT_LOG(Debug, "Delete-test list has %d elements", i); */

    j = (int)(i*1.0*rand()/(RAND_MAX+1.0)); 
    /* UT_LOG(Debug, "Deleting element %d", j); */
    del = del100; 
    while (j--) del=del->next;  

    UT_prf_bgn("ll_perf","hl-del100");
    HASH_DEL(del100,tmp,del); 
    UT_prf_end("ll_perf","hl-del100");
 }

 if (del1000) {
    del = del1000;
    i=0;
    while (del) {
      /* UT_LOG(Debug, "Delete-list[%d]:%s",i,del->name); */
      i++;
      del=del->next; 
    } 
    /* UT_LOG(Debug, "Delete-test list has %d elements", i); */

    j = (int)(i*1.0*rand()/(RAND_MAX+1.0)); 
    /* UT_LOG(Debug, "Deleting element %d", j); */
    del = del1000; 
    while (j--) del=del->next;  

    UT_prf_bgn("ll_perf","hl-del1000");
    HASH_DEL(del1000,tmp,del); 
    UT_prf_end("ll_perf","hl-del1000");
 }

 if (del10000) {
    del = del10000;
    i=0;
    while (del) {
      /* UT_LOG(Debug, "Delete-list[%d]:%s",i,del->name); */
      i++;
      del=del->next; 
    } 
    /* UT_LOG(Debug, "Delete-test list has %d elements", i); */

    j = (int)(i*1.0*rand()/(RAND_MAX+1.0)); 
    /* UT_LOG(Debug, "Deleting element %d", j); */
    del = del10000; 
    while (j--) del=del->next;  

    UT_prf_bgn("ll_perf","hl-del10000");
    HASH_DEL(del10000,tmp,del); 
    UT_prf_end("ll_perf","hl-del10000");
 }

 if (del100000) {
    del = del100000;
    i=0;
    while (del) {
      /* UT_LOG(Debug, "Delete-list[%d]:%s",i,del->name); */
      i++;
      del=del->next; 
    } 
    /* UT_LOG(Debug, "Delete-test list has %d elements", i); */

    j = (int)(i*1.0*rand()/(RAND_MAX+1.0)); 
    /* UT_LOG(Debug, "Deleting element %d", j); */
    del = del100000; 
    while (j--) del=del->next;  

    UT_prf_bgn("ll_perf","hl-del100000");
    HASH_DEL(del100000,tmp,del); 
    UT_prf_end("ll_perf","hl-del100000");
 }

 loop_count--;
 return (loop_count ? 0 : -1); /* auto-reschedule timer til done */
}

int run_test_shlcmd(int argc,char *argv[]) {
    int lc;
    if (argc == 2) {
        if (sscanf(argv[1], "%d", &lc) != 1) {
            UT_shlf("non-numeric count\n");
            return SHL_OK;
        }
    } else lc = 1;
    loop_count += lc;
	if (loop_count) UT_tmr_set("ll_test" ,MEM_TMR_INTERVAL,(UT_tmr_cb*)ll_cb, 
            NULL); 
    return SHL_OK;
}

int main(int argc, char **argv) {
	int i,j,r;
	ll_test_buf *tmp,*buf;

	UT_init(INIT_END);

	for(i=0;i<NUM_BUFS;i++) {
           keycodes[i] = 1+(int)(100000.0*rand()/(RAND_MAX+1.0));
	   UT_LOG(Info,"Generated keycode %d: %d", i, keycodes[i]);
	}

	UT_mem_pool_create( "ll", sizeof(ll_test_buf), 10 );
	UT_prf_create( "ll_perf", "Test of mod list key-lookup", 
	            te_log_1u_10s);

	/* Make five linked lists: sizes 10, 100, 1000, 10000 and 100000 */
	/* To avoid cache locality alloc more than we use */
	for (i=0;i<10;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
       UT_prf_bgn("ll_perf", "add-10");
	   HASH_ADD_INT( head10, tmp, keycode, buf );
       UT_prf_end("ll_perf", "add-10");
	}

	for (i=0;i<100;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
       UT_prf_bgn("ll_perf", "add-100");
	   HASH_ADD_INT( head100, tmp, keycode, buf );
       UT_prf_end("ll_perf", "add-100");
	}

	for (i=0;i<1000;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
       UT_prf_bgn("ll_perf", "add-1000");
	   HASH_ADD_INT( head1000, tmp, keycode, buf );
       UT_prf_end("ll_perf", "add-1000");
	}

	for (i=0;i<10000;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
       UT_prf_bgn("ll_perf", "add-10000");
	   HASH_ADD_INT( head10000, tmp, keycode, buf );
       UT_prf_end("ll_perf", "add-10000");
	}

	for (i=0;i<100000;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
       UT_prf_bgn("ll_perf", "add-100000");
	   HASH_ADD_INT( head100000, tmp, keycode, buf );
       UT_prf_end("ll_perf", "add-100000");
	}

	for (i=0;i<10;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
	   HASH_ADD_INT( del10, tmp, keycode, buf );
	}

	for (i=0;i<100;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
	   HASH_ADD_INT( del100, tmp, keycode, buf );
	}

	for (i=0;i<1000;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
	   HASH_ADD_INT( del1000, tmp, keycode, buf );
	}

	for (i=0;i<10000;i++) {
	   buf = (ll_test_buf*)UT_mem_alloc("ll", 7);
	   buf->keycode = keycodes[i];
	   buf->next = NULL;
	   HASH_ADD_INT( del10000, tmp, keycode, buf );
	}



    UT_shl_cmd_create("run-test", "run n iterations of the find/del fcn", 
            run_test_shlcmd, NULL);

	UT_event_loop();
}
