#include "libut/ut.h"
#include <stdlib.h>

#define MEM_TMR_INTERVAL 250
#define NUM_BUFS 1000

typedef struct mem_test_buf {
   int num;
   char pool[100];
} mem_test_buf;

mem_test_buf *bufs[NUM_BUFS];

int mem_cb( char *name, unsigned msec, char *pool) {
 int i,j,sz;

 char prf_name[100];


 /* should we allocate or free this time? */
 j = 1+(int)(10.0*rand()/(RAND_MAX+1.0));
 if (j & 1) {
    /* let's allocate */
    i=0;
    while(i < NUM_BUFS) if (bufs[i]) i++; else break;
    if (i != NUM_BUFS) {

      /* should we do a big alloc or a little one? */
      sz = (rand() & 1) ? 10 : 10000;

      sprintf(prf_name,"alloc_%d-%s",sz,pool);

      j = 1+(int)(1.0*sz*rand()/(RAND_MAX+1.0));

      UT_prf_bgn( "mem_perf", prf_name );
      bufs[i] = UT_mem_alloc( pool, j );
      UT_prf_end( "mem_perf", prf_name );

      bufs[i]->num = j;
      strcpy(bufs[i]->pool , pool);
      UT_LOG(Debug, "alloc'd %d bufs", bufs[i]->num);
    } else {
      UT_LOG( Debug, "no room to alloc");
    }
 } else {
    /* let's free something */
    i=0;
    while(i < NUM_BUFS) if (bufs[i] == NULL) i++; else break;
    if (i != NUM_BUFS) {
       UT_LOG(Debug, "freeing %d bufs", bufs[i]->num);

       sprintf(prf_name,"free-%s",bufs[i]->pool);
       UT_prf_bgn( "mem_perf", prf_name );
       UT_mem_free( bufs[i]->pool, bufs[i], bufs[i]->num );
       UT_prf_end( "mem_perf", prf_name );

       bufs[i] = NULL;
    } else {
      UT_LOG( Debug, "nothing to free");
    }
 }

 return 0; /* auto-reschedule timer */
}

int main(int argc, char **argv) {
	int i;
	for(i=0;i<NUM_BUFS;i++) bufs[i] = NULL;

	UT_init(INIT_END);
	UT_prf_create( "mem_perf", "Test of memory alloc/free", 
	            te_100u_1m);

	UT_mem_pool_create( "sm", sizeof(mem_test_buf), 10 );
	UT_mem_pool_create( "lg", sizeof(mem_test_buf), 100 );

	UT_tmr_set("mem_perf_test1" ,MEM_TMR_INTERVAL,(UT_tmr_cb*)mem_cb, 
	        	"sm");
	UT_tmr_set("mem_perf_test2" ,MEM_TMR_INTERVAL,(UT_tmr_cb*)mem_cb, 
	        	"lg");

	UT_event_loop();
}
