#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include "libut/ut.h"

int childFcn(char*name,void*data) {
  int i;

  for(i=0;i<20;i++) {
    fprintf(stderr,"child writing to stderr (%d)\n", i);
    fprintf(stdout,"child writing to stdout (%d)\n", i);
    sleep(1);
  }

  return i;
}

int exHdlr(pid_t pid, int sts, char*name, void*data) {
    UT_LOG(Info,"coproc %s (%d) exited with sts %d", name,pid,sts);
}

int run_test_cmd(int argc, char *argv[] ) {
    int num_to_fork = 1;

    if (argc == 2) {
        if (sscanf(argv[1], "%d", &num_to_fork) != 1) {
            UT_shlf("usage: %s [<number>]\n", argv[0]);
            return SHL_OK;
        }
    }

    while (num_to_fork--) 
        UT_fork_coprocess("test", childFcn, "testdata", exHdlr, NULL);

    return SHL_OK;
}

int main(int argc, char **argv) {
	UT_init(INIT_END);
    UT_shl_cmd_create("run-test", "fork [n] test coprocesses", run_test_cmd, NULL);
	UT_event_loop();
}
