/*
Copyright (c) 2003-2005, Troy Hanson
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the copyright holder nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdarg.h>  /* va_list */

#define UT_VAR_NAME_MAXLEN 30
#define UT_VAR_DESC_MAXLEN 50
#define UTSHL_VARS "ut_var"

/* values of 'flags' field in UT_var */
#define VAR_READONLY       (1 << 0)
#define VAR_IN_SHL_CONTEXT (1 << 1)

typedef struct UT_var {
        char name[UT_VAR_NAME_MAXLEN];
        char desc[UT_VAR_DESC_MAXLEN];
        UT_var_type type;
        union {
            double f;
            int i;
            char *s;
        } val;
        char flags;
        void *bound_cvar;
        UT_callback *cb;
        UT_hash_handle hh;
        struct UT_var *next;
} UT_var;


typedef struct UT_var_global_type {
        struct UT_var *vars;
} UT_var_global_type;

int UT_var_set2(UT_var *var, va_list ap);
int UT_var_restrict_cb(char *name,void *data);
int UT_var_set_cvar(UT_var *var);
int UT_var_set_shl(UT_var *var, ...);

