/*
Copyright (c) 2003-2005, Troy Hanson
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the copyright holder nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <signal.h>  /* sigset_t */

/******************************************************************************
 * loop.h                                                                     *
 * Copyright (c) 2005 Troy Hanson                                             *
 *****************************************************************************/

/* used in UT_main() as the value of the select() timeout.
 * Pending timers or I/O cause select to return before timeout * 
 * So there is no reason for this to be small- that only wastes CPU. */
#define UT_LOOP_SELECT_MSEC 60000  /* once a minute */

/* The pause (in usec) that's added to a select() timeout so that
 * if the max timeout is based on a timer awaiting expiration, that
 * it doesn't needlessly timeout just *before* timer would expire */
#define UT_MICROPAUSE 1000 

/* memory pools */
#define PER_LOOP_CB_POOL "ut_per_loop_cb"

/* function signature and struct for supporting per-loop callbacks */
typedef int UT_per_loop_cb(void); 
typedef struct UT_per_loop_cb_t {
    UT_per_loop_cb *cb;
    struct UT_per_loop_cb_t *next;
} UT_per_loop_cb_t;

/* A convenient data struct to wrap our globals into. */
typedef struct UT_loop_global_type {
        struct UT_tmr *tmrs;
        struct UT_fd *fds;
        struct UT_per_loop_cb_t *per_loop_cbs;
        struct timeval *tmr_first;  /* time of soonest timer */
        struct timeval TOD;         /* time of day */
        int sig_max;                /* the max signal number */
        int sig_flag;               /* nonzero if new signal received */
        UT_signal_cb *sig_cb;       /* app callback for signals */
        sigset_t sig_set;           /* set of received signals */
} UT_loop_global_type;

/* protos */
int UT_loop_init(void);
