/*
Copyright (c) 2003-2005, Troy Hanson
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the copyright holder nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*********************************************************
 *  log.h                                                *
 *  copyright (c) 2003-2005 Troy Hanson                  *
 *********************************************************/

#define LOGLEVEL_VARNAME "ut_log_level"
#define LOGFILE_VARNAME "ut_log_file" 
#define LOGLEVEL_DEFAULT Debugk
#define LOGFILE_DEFAULT "/dev/stdout"

/* These control the format of the log lines. The first is the datetime
 * string in strftime() format, and the latter is the format of the log
 * line as a whole (t=time,l=level,f=function,F=file,L=line,m=message) */
#define LOGFILE_DATETIME_FORMAT "%b %d %T" 
#define LOGFILE_LINE_FORMAT "%t %l (%F:%L) %m"

#define DATETIME_MAXLEN 50  
#define LOGLINE_MAXLEN 250
#define LINESTR_MAXLEN 10

#define LOG_CREATE_MODE (S_IWUSR|S_IRUSR|S_IRGRP|S_IROTH)

typedef struct UT_log_global_type {
        int fd;
        UT_loglevel loglevel;
        char *datetime_fmt;  /* strftime-format string, e.g. "%b %d %T" represents "Oct 22 15:33:22"  */
        char *log_line_fmt;  /* custom-format string supports %[tlfmFLM] for the fields of the log msg */
} UT_log_global_type;

/* Prototypes */
extern void UT_log_init(UT_loglevel level, char *logfile);
extern int UT_log_init_shl(void);

