# Contributing to libsql

Thank you for your interest in contributing to libsql! We welcome contributions from the community to make this project better.

Before you start, please take a moment to review the guidelines outlined below.

# Code of Conduct

Please note that we have a Code of Conduct in place to ensure a positive and inclusive environment for everyone involved.

Getting Started

Fork the repository.
Clone your forked repository to your local machine.
Create a new branch for your feature or bug fix: git checkout -b feature-name.
Make your changes and test thoroughly.
Commit your changes with descriptive commit messages.
Push your changes to your forked repository: git push origin feature-name.
Submit a pull request to the main branch of the original repository.
Contribution Guidelines

All contributions should be well-documented and follow the existing code style.
Include tests for any new functionality or bug fixes.
Update documentation as necessary, including any relevant README or usage guides.
Maintain backward compatibility whenever possible.
Follow the Git commit message guidelines for consistent commit messages.
Review the existing issues and pull requests to avoid duplicating efforts.
Pull Request Process

Ensure that your pull request addresses a specific issue. If there isn't an issue, consider creating one first.
Clearly describe the problem or feature in your pull request and reference the relevant issue.
Provide steps to reproduce and test your changes if applicable.
Ensure that your branch is up-to-date with the latest changes from the main branch.
All checks (tests, formatting, etc.) must pass before your pull request can be merged.
After addressing review comments, your pull request will be merged by a project maintainer.
Documentation

Help us improve the project's documentation by fixing typos, clarifying language, or adding missing information. Documentation improvements can be submitted as pull requests.

Reporting Issues

If you encounter a bug or have a suggestion for the project, please open an issue using the provided issue template. Include as much detail as possible to help us understand and address the problem.

Getting Help

If you need assistance, have questions, or want to discuss ideas, you can:

Join our Discord server and chat with the community.
Mention @maintainer in your issue or pull request for a faster response from project maintainers.
We appreciate your time and effort in contributing to libsql!

