dnl Copyright 2002, The libsigc++ Development Team
dnl
dnl This library is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU Lesser General Public
dnl License as published by the Free Software Foundation; either
dnl version 2.1 of the License, or (at your option) any later version.
dnl
dnl This library is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
dnl Lesser General Public License for more details.
dnl
dnl You should have received a copy of the GNU Lesser General Public
dnl License along with this library; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
dnl
divert(-1)
include(template.macros.m4)

dnl
dnl  How to call the darn thing!
define([LAMBDA_GROUP_FACTORY],[dnl
/** Alters an arbitrary functor by rebuilding its arguments from $1 lambda expressions.
 *
 * @deprecated Use C++11 lambda expressions or %std::bind() instead.
 *
 * @ingroup lambdas
 */
template <class T_functor, LOOP(class T_type%1, $1)>
lambda<lambda_group$1<T_functor, LOOP(typename unwrap_reference<T_type%1>::type, $1)> >
group(const T_functor& _A_func, LOOP(T_type%1 _A_%1, $1))
{
  typedef lambda_group$1<T_functor, LOOP(typename unwrap_reference<T_type%1>::type, $1)> T_lambda;
  return lambda<T_lambda>(T_lambda(_A_func, LOOP(_A_%1, $1)));
}

])
dnl
dnl  How to call the darn thing!
define([LAMBDA_GROUP_DO],[dnl
define([_L_],[LOOP(_A_%1, $2)])dnl
define([_T_],[LOOP(T_arg%1, $2)])dnl
dnl Please someone get a gun!
  template <LOOP(class T_arg%1, $2)>
  typename deduce_result_type<LOOP(T_arg%1,$2)>::type
  operator() (LOOP(T_arg%1 _A_%1, $2)) const
    { return this->func_.SIGC_WORKAROUND_OPERATOR_PARENTHESES<LOOP([
          typename value%1_type::template deduce_result_type<LOOP(T_arg%1,$2)>::type],$1)>(LOOP([
        this->value%1_.SIGC_WORKAROUND_OPERATOR_PARENTHESES<LOOP([
          _P_(T_arg%1)],$2)>(_L_)],$1)); }

  #ifndef SIGC_TEMPLATE_SPECIALIZATION_OPERATOR_OVERLOAD
  template <LOOP(class T_arg%1, $2)>
  typename deduce_result_type<LOOP(T_arg%1,$2)>::type
  sun_forte_workaround (LOOP(T_arg%1 _A_%1, $2)) const
    { return this->func_.SIGC_WORKAROUND_OPERATOR_PARENTHESES<LOOP([
          typename value%1_type::template deduce_result_type<LOOP(T_arg%1,$2)>::type],$1)>(LOOP([
        this->value%1_.SIGC_WORKAROUND_OPERATOR_PARENTHESES<LOOP([
          _P_(T_arg%1)],$2)>(_L_)],$1)); }
  #endif //SIGC_TEMPLATE_SPECIALIZATION_OPERATOR_OVERLOAD

])
dnl
dnl This really doesn't have much to do with lambda other than
dnl holding lambdas within itself.
define([LAMBDA_GROUP],[dnl
/** lambda_group$1 wraps a functor and rebuilds its arguments from $1 lambda expressions.
 * Use the convenience function group() to create an instance of lambda_group$1.
 *
 * @deprecated Use C++11 lambda expressions or %std::bind() instead.
 *
 * @ingroup lambdas
 */
template <class T_functor, LOOP(class T_type%1, $1)>
struct lambda_group$1 : public lambda_base
{
  typedef typename functor_trait<T_functor>::result_type result_type;dnl
FOR(1, $1,[
  typedef typename lambda<T_type%1>::lambda_type   value%1_type;])
  typedef typename adaptor_trait<T_functor>::adaptor_type functor_type;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  template <LOOP(class T_arg%1=void,$2)>
  struct deduce_result_type
    { typedef typename functor_type::template deduce_result_type<LOOP([
          typename value%1_type::template deduce_result_type<LOOP([
            _P_(T_arg%1)],$2)>::type],$1)
        >::type type; };
#endif

  result_type
  operator ()() const;

FOR(1,CALL_SIZE,[[LAMBDA_GROUP_DO($1,%1)]])dnl
  lambda_group$1(typename type_trait<T_functor>::take _A_func, LOOP(typename type_trait<T_type%1>::take _A_%1, $1))
    : LOOP(value%1_(_A_%1), $1), func_(_A_func) {}dnl

FOR(1, $1,[
  value%1_type value%1_;])
  mutable functor_type func_;
};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <class T_functor, LOOP(class T_type%1, $1)>
typename lambda_group$1<T_functor, LOOP(T_type%1, $1)>::result_type
lambda_group$1<T_functor, LOOP(T_type%1, $1)>::operator ()() const
  { return func_(LOOP(value%1_(), $1)); }

//template specialization of visitor<>::do_visit_each<>(action, functor):
template <class T_functor, LOOP(class T_type%1, $1)>
struct visitor<lambda_group$1<T_functor, LOOP(T_type%1, $1)> >
{
  template <class T_action>
  static void do_visit_each(const T_action& _A_action,
                            const lambda_group$1<T_functor, LOOP(T_type%1, $1)>& _A_target)
  {dnl
FOR(1, $1,[
    sigc::visit_each(_A_action, _A_target.value%1_);])
    sigc::visit_each(_A_action, _A_target.func_);
  }
};
#endif // DOXYGEN_SHOULD_SKIP_THIS

])
divert(0)dnl
_FIREWALL([LAMBDA_GROUP])
#include <sigc++/adaptors/lambda/base.h>

_DEPRECATE_IFDEF_START

/** @defgroup group_ group()
 * sigc::group() alters an arbitrary functor by rebuilding its arguments from one or more lambda expressions.
 * For each parameter that should be passed to the wrapped functor, one lambda expression
 * has to be passed into group(). Lambda selectors can be used as placeholders for the
 * arguments passed into the new functor. Arguments that don't have a placeholder in one
 * of the lambda expressions are dropped.
 *
 * If you have a C++11 compiler, a C++11 lambda expression and/or %std::bind() is
 * often a good alternative to sigc::group(). Such alternatives are shown in the
 * following examples, marked with the comment <tt>//C++11</tt>.
 *
 * @par Examples:
 * @code
 * void foo(int, int);
 * int bar(int);
 * // argument binding ...
 * sigc::group(&foo,10,sigc::_1)(20); //fixes the first argument and calls foo(10,20)
 * std::bind(&foo, 10, std::placeholders::_1)(20); //C++11
 * sigc::group(&foo,sigc::_1,30)(40); //fixes the second argument and calls foo(40,30)
 * std::bind(&foo, std::placeholders::_1, 30)(40); //C++11
 * // argument reordering ...
 * sigc::group(&foo,sigc::_2,sigc::_1)(1,2); //calls foo(2,1)
 * std::bind(&foo, std::placeholders::_2, std::placeholders::_1)(1,2); //C++11
 * // argument hiding ...
 * sigc::group(&foo,sigc::_1,sigc::_2)(1,2,3); //calls foo(1,2)
 * std::bind(&foo, std::placeholders::_1, std::placeholders::_2)(1,2,3); //C++11
 * // functor composition ...
 * sigc::group(&foo,sigc::_1,sigc::group(&bar,sigc::_2))(1,2); //calls foo(1,bar(2))
 * std::bind(&foo,  std::placeholders::_1, std::bind(&bar, std::placeholders::_2))(1,2); //C++11
 * // algebraic expressions ...
 * sigc::group(&foo,sigc::_1*sigc::_2,sigc::_1/sigc::_2)(6,3); //calls foo(6*3,6/3)
 * [[]] (int x, int y) { foo(x*y, x/y); }(6,3); //C++11
 * @endcode
 *
 * The functor sigc::group() returns can be passed into sigc::signal::connect() directly.
 * A C++11 lambda expression can be passed into sigc::signal::connect() directly,
 * if either it returns <tt>void</tt>, or you use #SIGC_FUNCTORS_DEDUCE_RESULT_TYPE_WITH_DECLTYPE.
 *
 * @par Example:
 * @code
 * sigc::signal<void,int,int> some_signal;
 * void foo(int);
 * some_signal.connect(sigc::group(&foo,sigc::_2));
 * some_signal.connect([[]](int, int y) { foo(y); }); //C++11
 * @endcode
 *
 * Like in sigc::bind(), you can bind references to functors by passing the objects
 * through the sigc::ref() helper function.
 *
 * @par Example:
 * @code
 * int some_int;
 * sigc::signal<void> some_signal;
 * void foo(int&);
 * some_signal.connect(sigc::group(&foo,sigc::ref(some_int)));
 * some_signal.connect([[&some_int]](){ foo(some_int); }); //C++11
 * @endcode
 *
 * If you bind an object of a sigc::trackable derived type to a functor
 * by reference, a slot assigned to the group adaptor is cleared automatically
 * when the object goes out of scope.
 *
 * If you bind an object of a sigc::trackable derived type to a C++11 lambda expression
 * by reference, a slot assigned to the lambda expression is cleared automatically
 * when the object goes out of scope only if you use sigc::track_obj().
 *
 * @par Example:
 * @code
 * struct bar : public sigc::trackable {} some_bar;
 * sigc::signal<void> some_signal;
 * void foo(bar&);
 * some_signal.connect(sigc::group(&foo,sigc::ref(some_bar)));
 *   // disconnected automatically if some_bar goes out of scope
 * some_signal.connect([[&some_bar]](){ foo(some_bar); }); //C++11
 *   // NOT disconnected automatically if some_bar goes out of scope
 * some_signal.connect(sigc::track_obj([[&some_bar]](){ foo(some_bar); }, some_bar)); //C++11
 *   // disconnected automatically if some_bar goes out of scope
 * @endcode
 *
 * @deprecated Use C++11 lambda expressions or %std::bind() instead.
 *
 * @ingroup adaptors lambdas
 */

namespace sigc {

FOR(1,3,[[LAMBDA_GROUP(%1, CALL_SIZE)]])
FOR(1,3,[[LAMBDA_GROUP_FACTORY(%1)]])

} /* namespace sigc */

_DEPRECATE_IFDEF_END
